/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.aggrtest;

import com.intellij.ui.jcef.JBCefBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\u0017H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/internal/jcef/test/aggrtest/JCEFAggressiveRouterTest;", "Ljavax/swing/JPanel;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "msgRouter", "Lorg/cef/browser/CefMessageRouter;", "msgRouter2", "msgHandler", "Lorg/cef/handler/CefMessageRouterHandlerAdapter;", "isDisposed", "", "queryCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "routerChurnTimer", "Ljavax/swing/Timer;", "browserRecreateTimer", "recreationCycles", "", "initializeBrowser", "", "registerMessageHandler", "startRouterChurn", "startBrowserRecreation", "disposeBrowserOnly", "createMassiveTestHTML", "", "generateMassiveCSS", "generateMassiveJavaScript", "generateMassiveDOMStructure", "close", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nJCEFAggressiveRouterTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JCEFAggressiveRouterTest.kt\ncom/intellij/internal/jcef/test/aggrtest/JCEFAggressiveRouterTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n1#2:439\n*E\n"})
public final class JCEFAggressiveRouterTest
extends JPanel
implements AutoCloseable {
    @Nullable
    private JBCefBrowser browser;
    @Nullable
    private CefMessageRouter msgRouter;
    @Nullable
    private CefMessageRouter msgRouter2;
    @Nullable
    private CefMessageRouterHandlerAdapter msgHandler;
    private boolean isDisposed;
    @NotNull
    private final AtomicInteger queryCounter = new AtomicInteger(0);
    @Nullable
    private Timer routerChurnTimer;
    @Nullable
    private Timer browserRecreateTimer;
    private int recreationCycles;

    public JCEFAggressiveRouterTest() {
        this.setLayout(new BorderLayout());
        this.initializeBrowser();
        this.startRouterChurn();
        this.startBrowserRecreation();
    }

    private final void initializeBrowser() {
        try {
            Object object;
            System.out.println((Object)"Creating JBCefBrowser...");
            JBCefBrowser jBCefBrowser = this.browser = new JBCefBrowser();
            if (jBCefBrowser != null) {
                jBCefBrowser.setProperty("JBCefBrowserBase.noContextMenu", (Object)true);
            }
            this.msgHandler = new CefMessageRouterHandlerAdapter(this){
                final /* synthetic */ JCEFAggressiveRouterTest this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onQuery(CefBrowser browser2, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                    block5: {
                        int count = JCEFAggressiveRouterTest.access$getQueryCounter$p(this.this$0).incrementAndGet();
                        String string = request;
                        System.out.println((Object)("Query #" + count + " received, size: " + (string != null ? string.length() : 0) + " bytes"));
                        try {
                            String string2;
                            long latency = 100L + Random.Default.nextLong(100L);
                            Thread.sleep(latency);
                            if (count % 5 == 0) {
                                String largeData = StringsKt.repeat((CharSequence)"X", (int)150000);
                                string2 = "{\"status\":\"success\",\"queryId\":" + queryId + ",\"count\":" + count + ",\"data\":\"" + largeData + "\"}";
                            } else {
                                string2 = "{\"status\":\"success\",\"queryId\":" + queryId + ",\"count\":" + count + "}";
                            }
                            String response = string2;
                            CefQueryCallback cefQueryCallback = callback;
                            if (cefQueryCallback != null) {
                                cefQueryCallback.success(response);
                            }
                            System.out.println((Object)("Query #" + count + " responded after " + latency + "ms, response size: " + response.length()));
                        }
                        catch (Throwable e) {
                            System.out.println((Object)("ERROR in query #" + count + ": " + e.getMessage()));
                            e.printStackTrace();
                            CefQueryCallback cefQueryCallback = callback;
                            if (cefQueryCallback == null) break block5;
                            cefQueryCallback.failure(500, "Error: " + e.getMessage());
                        }
                    }
                    return true;
                }
            };
            this.registerMessageHandler();
            String htmlContent = this.createMassiveTestHTML();
            JBCefBrowser jBCefBrowser2 = this.browser;
            if (jBCefBrowser2 != null) {
                jBCefBrowser2.loadHTML(htmlContent);
            }
            if ((object = this.browser) != null && (object = object.getComponent()) != null) {
                Object it = object;
                boolean bl = false;
                this.add((Component)it, "Center");
            }
        }
        catch (Throwable e) {
            System.out.println((Object)("ERROR in initializeBrowser: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private final void registerMessageHandler() {
        try {
            JBCefBrowser jBCefBrowser = this.browser;
            CefClient client = jBCefBrowser != null && (jBCefBrowser = jBCefBrowser.getCefBrowser()) != null ? jBCefBrowser.getClient() : null;
            System.out.println((Object)"Creating and registering FIRST message router...");
            this.msgRouter = CefMessageRouter.create((CefMessageRouterHandler)((CefMessageRouterHandler)this.msgHandler));
            CefClient cefClient = client;
            if (cefClient != null) {
                cefClient.addMessageRouter(this.msgRouter);
            }
            System.out.println((Object)"First router registered successfully");
        }
        catch (Throwable e) {
            System.out.println((Object)("ERROR registering first router: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private final void startRouterChurn() {
        SwingUtilities.invokeLater(() -> JCEFAggressiveRouterTest.startRouterChurn$lambda$0(this));
    }

    private final void startBrowserRecreation() {
        block0: {
            Timer timer = this.browserRecreateTimer = new Timer(10000, arg_0 -> JCEFAggressiveRouterTest.startBrowserRecreation$lambda$0(this, arg_0));
            if (timer == null) break block0;
            timer.start();
        }
    }

    private final void disposeBrowserOnly() {
        try {
            CefClient client;
            JBCefBrowser jBCefBrowser = this.browser;
            CefClient cefClient = jBCefBrowser != null && (jBCefBrowser = jBCefBrowser.getCefBrowser()) != null ? jBCefBrowser.getClient() : (client = null);
            if (this.msgRouter != null && client != null) {
                client.removeMessageRouter(this.msgRouter);
                CefMessageRouter cefMessageRouter = this.msgRouter;
                if (cefMessageRouter != null) {
                    cefMessageRouter.dispose();
                }
                this.msgRouter = null;
            }
            if (this.msgRouter2 != null && client != null) {
                client.removeMessageRouter(this.msgRouter2);
                CefMessageRouter cefMessageRouter = this.msgRouter2;
                if (cefMessageRouter != null) {
                    cefMessageRouter.dispose();
                }
                this.msgRouter2 = null;
            }
            this.msgHandler = null;
            JBCefBrowser jBCefBrowser2 = this.browser;
            if (jBCefBrowser2 != null) {
                jBCefBrowser2.dispose();
            }
            this.browser = null;
            this.removeAll();
        }
        catch (Throwable e) {
            System.out.println((Object)("ERROR during browser disposal: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private final String createMassiveTestHTML() {
        System.out.println((Object)"Generating massive HTML with 1000 auto-firing queries...");
        String largePayloadTemplate = StringsKt.repeat((CharSequence)"Y", (int)500000);
        return StringsKt.trimIndent((String)("\n        <!DOCTYPE html>\n        <html>\n        <head>\n            <title>JCEF Router Stress Test - 1000 Queries</title>\n            <style>\n                body { font-family: monospace; padding: 20px; background: #1e1e1e; color: #00ff00; }\n                .container { max-width: 1200px; margin: 0 auto; }\n                #stats { \n                    position: fixed; \n                    top: 10px; \n                    right: 10px; \n                    background: rgba(0,0,0,0.8); \n                    padding: 15px; \n                    border: 2px solid #ff0000;\n                    font-size: 14px;\n                }\n                #log {\n                    height: 400px;\n                    overflow-y: auto;\n                    background: #000;\n                    padding: 10px;\n                    margin-top: 20px;\n                    border: 1px solid #00ff00;\n                }\n                .error { color: #ff0000; font-weight: bold; }\n                .success { color: #00ff00; }\n                " + this.generateMassiveCSS() + "\n            </style>\n        </head>\n        <body>\n            <div class=\"container\">\n                <h1>\ud83d\udd25 NPE REPRODUCTION STRESS TEST \ud83d\udd25</h1>\n                <div id=\"stats\">\n                    <div>Queries Sent: <span id=\"sent\">0</span></div>\n                    <div>Success: <span id=\"success\">0</span></div>\n                    <div>Errors: <span id=\"errors\">0</span></div>\n                    <div>In Flight: <span id=\"inflight\">0</span></div>\n                </div>\n                <div id=\"log\"></div>\n            </div>\n            \n            " + this.generateMassiveDOMStructure() + "\n            \n            <script>\n                let sentCount = 0;\n                let successCount = 0;\n                let errorCount = 0;\n                let inFlightCount = 0;\n                \n                const largePayload = \"" + largePayloadTemplate + "\";\n                \n                function updateStats() {\n                    document.getElementById('sent').textContent = sentCount;\n                    document.getElementById('success').textContent = successCount;\n                    document.getElementById('errors').textContent = errorCount;\n                    document.getElementById('inflight').textContent = inFlightCount;\n                }\n                \n                function log(message, isError) {\n                    const logDiv = document.getElementById('log');\n                    const entry = document.createElement('div');\n                    entry.className = isError ? 'error' : 'success';\n                    entry.textContent = new Date().toISOString() + ' - ' + message;\n                    logDiv.insertBefore(entry, logDiv.firstChild);\n                    if (logDiv.children.length > 50) {\n                        logDiv.removeChild(logDiv.lastChild);\n                    }\n                }\n                \n                function fireQuery(index) {\n                    // Vary payload size between 0.5MB and 1MB\n                    const payloadSize = 500000 + Math.floor(Math.random() * 500000);\n                    const payload = largePayload.substring(0, payloadSize);\n                    const request = JSON.stringify({\n                        queryIndex: index,\n                        timestamp: Date.now(),\n                        payload: payload,\n                        size: payloadSize\n                    });\n                    \n                    sentCount++;\n                    inFlightCount++;\n                    updateStats();\n                    \n                    log('Sending query #' + index + ' (size: ' + Math.round(request.length/1024) + ' KB)', false);\n                    \n                    window.cefQuery({\n                        request: request,\n                        onSuccess: function(response) {\n                            inFlightCount--;\n                            successCount++;\n                            updateStats();\n                            log('\u2713 Query #' + index + ' succeeded', false);\n                        },\n                        onFailure: function(error_code, error_message) {\n                            inFlightCount--;\n                            errorCount++;\n                            updateStats();\n                            log('\u2717 Query #' + index + ' FAILED: ' + error_message + ' (code: ' + error_code + ')', true);\n                        }\n                    });\n                }\n                \n                // FIRE 1000 QUERIES as soon as DOM is ready\n                document.addEventListener('DOMContentLoaded', function() {\n                    log('\ud83d\ude80 Starting 1000-query flood attack...', false);\n                    \n                    // Fire queries in rapid succession to maximize race conditions\n                    for (let i = 1; i <= 1000; i++) {\n                        setTimeout(function() { fireQuery(i); }, i * 5); // 5ms between queries\n                    }\n                    \n                    log('All 1000 queries scheduled!', false);\n                });\n                \n                " + this.generateMassiveJavaScript() + "\n            </script>\n        </body>\n        </html>\n    "));
    }

    private final String generateMassiveCSS() {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < 2001; ++i) {
            sb.append(StringsKt.trimIndent((String)("\n            .stress-class-" + i + " { \n                color: rgb(" + i % 255 + ", " + i * 2 % 255 + ", " + i * 3 % 255 + "); \n                margin: " + i % 20 + "px; \n                padding: " + i * 2 % 20 + "px;\n                font-size: " + (12 + i % 10) + "px;\n            }\n        ")));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String generateMassiveJavaScript() {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < 1501; ++i) {
            sb.append(StringsKt.trimIndent((String)("\n            function stressFn" + i + "(a, b) {\n                const x = " + i + " + a * " + i % 100 + ";\n                const y = b - " + i * 2 % 1000 + ";\n                return x + y + Math.random() * " + i + ";\n            }\n        ")));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String generateMassiveDOMStructure() {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < 301; ++i) {
            sb.append(StringsKt.trimIndent((String)("\n            <div class=\"stress-section-" + i + "\" style=\"display:none;\">\n                <table>\n                    <tr>\n                        " + CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, 5)), (CharSequence)"", null, null, (int)0, null, arg_0 -> JCEFAggressiveRouterTest.generateMassiveDOMStructure$lambda$0(i, arg_0), (int)30, null) + "\n                    </tr>\n                </table>\n            </div>\n        ")));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void close() {
        block13: {
            try {
                CefClient client;
                if (this.isDisposed) break block13;
                this.isDisposed = true;
                System.out.println((Object)"Disposing CustomJCEFWebView...");
                Timer timer = this.routerChurnTimer;
                if (timer != null) {
                    timer.stop();
                }
                this.routerChurnTimer = null;
                Timer timer2 = this.browserRecreateTimer;
                if (timer2 != null) {
                    timer2.stop();
                }
                this.browserRecreateTimer = null;
                JBCefBrowser jBCefBrowser = this.browser;
                CefClient cefClient = jBCefBrowser != null && (jBCefBrowser = jBCefBrowser.getCefBrowser()) != null ? jBCefBrowser.getClient() : (client = null);
                if (this.msgRouter != null && client != null) {
                    try {
                        System.out.println((Object)"Removing first router...");
                        client.removeMessageRouter(this.msgRouter);
                        CefMessageRouter cefMessageRouter = this.msgRouter;
                        if (cefMessageRouter != null) {
                            cefMessageRouter.dispose();
                        }
                    }
                    catch (Throwable e) {
                        System.out.println((Object)("ERROR DURING FIRST ROUTER REMOVAL? *** " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
                if (this.msgRouter2 != null && client != null) {
                    try {
                        System.out.println((Object)"Removing second router...");
                        client.removeMessageRouter(this.msgRouter2);
                        CefMessageRouter cefMessageRouter = this.msgRouter2;
                        if (cefMessageRouter != null) {
                            cefMessageRouter.dispose();
                        }
                    }
                    catch (Throwable e) {
                        System.out.println((Object)("ERROR DURING SECOND ROUTER REMOVAL? *** " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
                this.msgHandler = null;
                this.msgRouter = null;
                this.msgRouter2 = null;
                JBCefBrowser jBCefBrowser2 = this.browser;
                if (jBCefBrowser2 != null) {
                    jBCefBrowser2.dispose();
                }
                this.browser = null;
                System.out.println((Object)"Dispose complete");
            }
            catch (Throwable e) {
                System.out.println((Object)("ERROR DURING DISPOSE? *** " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    private static final void startRouterChurn$lambda$0$0(JCEFAggressiveRouterTest this$0, ActionEvent event) {
        try {
            CefClient client;
            JBCefBrowser jBCefBrowser = this$0.browser;
            CefClient cefClient = jBCefBrowser != null && (jBCefBrowser = jBCefBrowser.getCefBrowser()) != null ? jBCefBrowser.getClient() : (client = null);
            if (client != null && this$0.msgRouter != null && !this$0.isDisposed) {
                System.out.println((Object)"*** CHURNING ROUTERS - removing first, adding second ***");
                client.removeMessageRouter(this$0.msgRouter);
                CefMessageRouter cefMessageRouter = this$0.msgRouter;
                if (cefMessageRouter != null) {
                    cefMessageRouter.dispose();
                }
                this$0.msgRouter = null;
                this$0.msgRouter2 = CefMessageRouter.create((CefMessageRouterHandler)((CefMessageRouterHandler)this$0.msgHandler));
                client.addMessageRouter(this$0.msgRouter2);
                System.out.println((Object)"Router churn complete - second router active");
            }
        }
        catch (Throwable e) {
            System.out.println((Object)("ERROR DURING ROUTER CHURN? *** " + e.getMessage()));
            e.printStackTrace();
        }
        Object object = event.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.Timer");
        ((Timer)object).stop();
    }

    private static final void startRouterChurn$lambda$0(JCEFAggressiveRouterTest this$0) {
        block1: {
            Timer timer = this$0.routerChurnTimer = new Timer(300, arg_0 -> JCEFAggressiveRouterTest.startRouterChurn$lambda$0$0(this$0, arg_0));
            if (timer != null) {
                timer.setRepeats(false);
            }
            Timer timer2 = this$0.routerChurnTimer;
            if (timer2 == null) break block1;
            timer2.start();
        }
    }

    private static final void startBrowserRecreation$lambda$0$0(JCEFAggressiveRouterTest this$0) {
        try {
            this$0.disposeBrowserOnly();
            Thread.sleep(50L);
            this$0.initializeBrowser();
            this$0.revalidate();
            this$0.repaint();
            System.out.println((Object)"Browser recreated successfully");
        }
        catch (Throwable e) {
            System.out.println((Object)("ERROR DURING BROWSER RECREATION? *** " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private static final void startBrowserRecreation$lambda$0(JCEFAggressiveRouterTest this$0, ActionEvent it) {
        block1: {
            block0: {
                if (this$0.recreationCycles >= 10 || this$0.isDisposed) break block0;
                int n = this$0.recreationCycles;
                this$0.recreationCycles = n + 1;
                System.out.println((Object)("*** BROWSER RECREATION CYCLE " + this$0.recreationCycles + "/10 ***"));
                SwingUtilities.invokeLater(() -> JCEFAggressiveRouterTest.startBrowserRecreation$lambda$0$0(this$0));
                break block1;
            }
            Timer timer = this$0.browserRecreateTimer;
            if (timer == null) break block1;
            timer.stop();
        }
    }

    private static final CharSequence generateMassiveDOMStructure$lambda$0(int $i, int it) {
        return "<td>Data " + $i + "-" + it + "-" + ((Object)StringsKt.reversed((CharSequence)String.valueOf($i * it))).toString() + "</td>";
    }

    public static final /* synthetic */ AtomicInteger access$getQueryCounter$p(JCEFAggressiveRouterTest $this) {
        return $this.queryCounter;
    }
}

