/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.cases;

import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0004"}, d2={"createSimpleTestBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "doFailCallback", "", "intellij.platform.ide.internal"})
public final class MessageRouterTestsKt {
    private static final JBCefBrowser createSimpleTestBrowser(boolean doFailCallback) {
        JBCefBrowser jBCefBrowser = new JBCefBrowserBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        JBCefBrowser browser2 = jBCefBrowser;
        browser2.setProperty("JBCefBrowserBase.noContextMenu", (Object)true);
        CefMessageRouterHandlerAdapter msgHandler2 = new CefMessageRouterHandlerAdapter(doFailCallback){
            final /* synthetic */ boolean $doFailCallback;
            {
                this.$doFailCallback = $doFailCallback;
            }

            public boolean onQuery(CefBrowser browser2, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                block1: {
                    block0: {
                        if (!this.$doFailCallback) break block0;
                        CefQueryCallback cefQueryCallback = callback;
                        if (cefQueryCallback == null) break block1;
                        cefQueryCallback.failure(500, "Failure response [simple test]: " + request);
                        break block1;
                    }
                    CefQueryCallback cefQueryCallback = callback;
                    if (cefQueryCallback == null) break block1;
                    cefQueryCallback.success("Success response [simple test]: " + request);
                }
                return true;
            }
        };
        CefMessageRouter msgRouter = CefMessageRouter.create((CefMessageRouterHandler)((CefMessageRouterHandler)msgHandler2));
        browser2.getCefBrowser().getClient().addMessageRouter(msgRouter);
        String html = "\n            <!DOCTYPE html>\n            <html lang=\\\"en\\\">\n            <head>\n                <meta charset=\\\"UTF-8\\\">\n                <title>JCEF Simple JS Test Window</title>\n                <style>\n                    body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }\n                    .container { max-width: 600px; margin: 0 auto; }\n                    button { padding: 12px 24px; margin: 8px; background: #007acc; color: white; border: none; border-radius: 4px; cursor: pointer; }\n                    button:hover { background: #005a99; }\n                    #result { margin-top: 20px; padding: 10px; background: white; border-radius: 4px; border: 1px solid #ddd; }\n                    #cefQueryStatus { color: red; font-weight: bold; margin-bottom: 10px; }\n                </style>\n            </head>\n            <body>\n                <div class=\\\"container\\\">\n                    <h1>JCEF Simple Message Router Test</h1>\n                    <div id=\\\"cefQueryStatus\\\"></div>\n                    <button onclick=\"testQuery('simple_test_message')\">Send Test Query</button>\n                    <div id=\"result\">Click the button to test the message router...</div>\n                </div>\n                <script>\n                    function testQuery(message) {\n                        const result = document.getElementById('result');\n                        if (!window.cefQuery) {\n                            result.innerHTML = '<strong>Error:</strong> window.cefQuery is not available!';\n                            return;\n                        }\n                        result.innerHTML = 'Sending query: ' + message + '...';\n                        window.cefQuery({\n                            request: message,\n                            onSuccess: function(response) {\n                                result.innerHTML = '<strong>Success:</strong> ' + response;\n                            },\n                            onFailure: function(error_code, error_message) {\n                                result.innerHTML = '<strong>Error:</strong> ' + error_message + ' (Code: ' + error_code + ')';\n                            }\n                        });\n                    }\n                    // Show status of cefQuery injection\n                    window.addEventListener('DOMContentLoaded', function() {\n                        var status = document.getElementById('cefQueryStatus');\n                        if (window.cefQuery) {\n                            status.innerHTML = 'window.cefQuery is available.';\n                            status.style.color = 'green';\n                        } else {\n                            status.innerHTML = 'window.cefQuery is NOT available!';\n                            status.style.color = 'red';\n                        }\n                    });\n                </script>\n            </body>\n            </html>\n        ";
        browser2.loadHTML(html);
        return browser2;
    }

    public static final /* synthetic */ JBCefBrowser access$createSimpleTestBrowser(boolean doFailCallback) {
        return MessageRouterTestsKt.createSimpleTestBrowser(doFailCallback);
    }
}

