/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.cases;

import com.intellij.ui.jcef.JBCefBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/jcef/test/cases/MsgRouterTestJCEFPanel;", "Ljavax/swing/JPanel;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "uid", "", "doFailCallback", "", "<init>", "(Ljava/lang/String;Z)V", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "msgRouter", "Lorg/cef/browser/CefMessageRouter;", "msgHandler", "Lorg/cef/handler/CefMessageRouterHandlerAdapter;", "isDisposed", "createTestHTML", "close", "", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nMsgRouterTestSeveralBrowsers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsgRouterTestSeveralBrowsers.kt\ncom/intellij/internal/jcef/test/cases/MsgRouterTestJCEFPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class MsgRouterTestJCEFPanel
extends JPanel
implements AutoCloseable {
    @Nullable
    private JBCefBrowser browser;
    @Nullable
    private CefMessageRouter msgRouter;
    @Nullable
    private CefMessageRouterHandlerAdapter msgHandler;
    private boolean isDisposed;

    public MsgRouterTestJCEFPanel(final @NotNull String uid, final boolean doFailCallback) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            this.setLayout(new BorderLayout());
            JBCefBrowser jBCefBrowser = this.browser = new JBCefBrowser();
            if (jBCefBrowser != null) {
                jBCefBrowser.setProperty("JBCefBrowserBase.noContextMenu", (Object)true);
            }
            this.msgHandler = new CefMessageRouterHandlerAdapter(){

                public boolean onQuery(CefBrowser browser2, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                    block1: {
                        block0: {
                            if (!doFailCallback) break block0;
                            CefQueryCallback cefQueryCallback = callback;
                            if (cefQueryCallback == null) break block1;
                            cefQueryCallback.failure(500, "Failure response [" + uid + "]: " + request);
                            break block1;
                        }
                        CefQueryCallback cefQueryCallback = callback;
                        if (cefQueryCallback == null) break block1;
                        cefQueryCallback.success("Success response [" + uid + "]: " + request);
                    }
                    return true;
                }
            };
            JBCefBrowser jBCefBrowser2 = this.browser;
            CefClient client = jBCefBrowser2 != null && (jBCefBrowser2 = jBCefBrowser2.getCefBrowser()) != null ? jBCefBrowser2.getClient() : null;
            this.msgRouter = CefMessageRouter.create((CefMessageRouterHandler)((CefMessageRouterHandler)this.msgHandler));
            CefClient cefClient = client;
            if (cefClient != null) {
                cefClient.addMessageRouter(this.msgRouter);
            }
            String htmlContent = this.createTestHTML();
            JBCefBrowser jBCefBrowser3 = this.browser;
            if (jBCefBrowser3 != null) {
                jBCefBrowser3.loadHTML(htmlContent);
            }
            if ((object = this.browser) == null || (object = object.getComponent()) == null) break block3;
            Object it = object;
            boolean bl = false;
            this.add((Component)it, "Center");
        }
    }

    private final String createTestHTML() {
        return "<!DOCTYPE html>\n<html>\n<head>\n    <title>JCEF several browsers test</title>\n    <style>\n        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }\n        .container { max-width: 600px; margin: 0 auto; }\n        button { \n            padding: 12px 24px; \n            margin: 8px; \n            background: #007acc; \n            color: white; \n            border: none; \n            border-radius: 4px; \n            cursor: pointer;\n        }\n        button:hover { background: #005a99; }\n        #result { \n            margin-top: 20px; \n            padding: 10px; \n            background: white; \n            border-radius: 4px; \n            border: 1px solid #ddd;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <h1>JCEF Message Router Test</h1>\n        <p>This page tests the JCEF message router.</p>\n        <p><strong>Instructions:</strong> Click the button below, then close and reopen this dialog 2-3 times rapidly.</p>\n        \n        <button onclick=\"testQuery('test_message_1')\">Test Message 1</button>\n        <button onclick=\"testQuery('test_message_2')\">Test Message 2</button>\n        <button onclick=\"rapidTest()\">Rapid Test (Multiple Queries)</button>\n        \n        <div id=\"result\">Click a button to test the message router...</div>\n    </div>\n    \n    <script>\n        let queryCount = 0;\n        \n        function testQuery(message) {\n            queryCount++;\n            const result = document.getElementById('result');\n            result.innerHTML = 'Sending query ' + queryCount + ': ' + message + '...';\n            \n            window.cefQuery({\n                request: message + '_' + queryCount,\n                onSuccess: function(response) {\n                    result.innerHTML = '<strong>Success:</strong> ' + response;\n                },\n                onFailure: function(error_code, error_message) {\n                    result.innerHTML = '<strong>Error:</strong> ' + error_message + ' (Code: ' + error_code + ')';\n                }\n            });\n        }\n        \n        function rapidTest() {\n            // Send multiple rapid queries to stress test the message router\n            for (let i = 0; i < 10; i++) {\n                setTimeout(() => testQuery('rapid_test_' + i), i * 100);\n            }\n        }\n        \n        // Auto-test on load to trigger communication immediately\n        window.addEventListener('load', function() {\n            for (let i = 0; i < 5; i++) {\n                setTimeout(() => testQuery('auto_load_test_' + i), i * 300);\n            }\n        });\n    </script>\n</body>\n</html>";
    }

    @Override
    public void close() {
        if (!this.isDisposed) {
            CefClient client;
            this.isDisposed = true;
            JBCefBrowser jBCefBrowser = this.browser;
            CefClient cefClient = jBCefBrowser != null && (jBCefBrowser = jBCefBrowser.getCefBrowser()) != null ? jBCefBrowser.getClient() : (client = null);
            if (this.msgRouter != null && client != null) {
                try {
                    client.removeMessageRouter(this.msgRouter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.msgHandler = null;
            CefMessageRouter cefMessageRouter = this.msgRouter;
            if (cefMessageRouter != null) {
                cefMessageRouter.dispose();
            }
            this.msgRouter = null;
            JBCefBrowser jBCefBrowser2 = this.browser;
            if (jBCefBrowser2 != null) {
                jBCefBrowser2.dispose();
            }
            this.browser = null;
        }
    }
}

