/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.detailed;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BrowserFrame
extends JFrame {
    private volatile boolean isClosed_ = false;
    private CefBrowser browser_ = null;
    private Runnable afterParentChangedAction_ = null;

    public BrowserFrame() {
        this((String)null);
    }

    public BrowserFrame(String title) {
        super(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (BrowserFrame.this.browser_ == null) {
                    BrowserFrame.this.isClosed_ = true;
                    BrowserFrame.this.dispose();
                    return;
                }
                boolean isClosed = BrowserFrame.this.isClosed_;
                if (isClosed) {
                    BrowserFrame.this.browser_.setCloseAllowed();
                }
                BrowserFrame.this.browser_.close(isClosed);
                if (!BrowserFrame.this.isClosed_) {
                    BrowserFrame.this.isClosed_ = true;
                }
                if (isClosed) {
                    BrowserFrame.this.dispose();
                }
            }
        });
    }

    public void setBrowser(CefBrowser browser2) {
        if (this.browser_ == null) {
            this.browser_ = browser2;
        }
        this.browser_.getClient().removeLifeSpanHandler();
        this.browser_.getClient().addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public void onAfterParentChanged(CefBrowser browser2) {
                if (BrowserFrame.this.afterParentChangedAction_ != null) {
                    SwingUtilities.invokeLater(BrowserFrame.this.afterParentChangedAction_);
                    BrowserFrame.this.afterParentChangedAction_ = null;
                }
            }

            public boolean doClose(CefBrowser browser2) {
                boolean result = browser2.doClose();
                return result;
            }
        });
    }

    public void removeBrowser(Runnable r) {
        this.afterParentChangedAction_ = r;
        this.remove(this.browser_.getUIComponent());
        this.browser_.getUIComponent().removeNotify();
        this.browser_ = null;
    }

    public CefBrowser getBrowser() {
        return this.browser_;
    }
}

