/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.detailed;

import com.intellij.internal.jcef.test.detailed.BrowserFrame;
import com.intellij.internal.jcef.test.detailed.dialog.DownloadDialog;
import com.intellij.internal.jcef.test.detailed.handler.ContextMenuHandler;
import com.intellij.internal.jcef.test.detailed.handler.DragHandler;
import com.intellij.internal.jcef.test.detailed.handler.JSDialogHandler;
import com.intellij.internal.jcef.test.detailed.handler.KeyboardHandler;
import com.intellij.internal.jcef.test.detailed.handler.MessageRouterHandler;
import com.intellij.internal.jcef.test.detailed.handler.MessageRouterHandlerEx;
import com.intellij.internal.jcef.test.detailed.handler.RequestHandler;
import com.intellij.internal.jcef.test.detailed.ui.ControlPanel;
import com.intellij.internal.jcef.test.detailed.ui.MenuBar;
import com.intellij.internal.jcef.test.detailed.ui.StatusPanel;
import com.intellij.internal.jcef.test.detailed.util.DataUri;
import com.intellij.ui.jcef.JBCefOSRHandlerFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRendering;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.network.CefCookieManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class MainFrame
extends BrowserFrame {
    public static int queryCounter;
    private final CefApp cefApp_;
    private String errorMsg_;
    private ControlPanel control_pane_;
    private StatusPanel status_panel_;
    private boolean browserFocus_;
    private final JPanel contentPanel_;
    private JFrame fullscreenFrame_;

    public MainFrame(@NotNull CefApp cefApp) {
        if (cefApp == null) {
            MainFrame.$$$reportNull$$$0(0);
        }
        this(cefApp, false, 0);
    }

    public MainFrame(@NotNull CefApp cefApp, boolean createImmediately, int windowless_frame_rate) {
        CefBrowser browser2;
        if (cefApp == null) {
            MainFrame.$$$reportNull$$$0(1);
        }
        this.errorMsg_ = "";
        this.browserFocus_ = true;
        this.cefApp_ = cefApp;
        CefClient client_ = cefApp.createClient();
        DownloadDialog downloadDialog = new DownloadDialog(this);
        client_.addContextMenuHandler((CefContextMenuHandler)new ContextMenuHandler(this));
        client_.addDownloadHandler((CefDownloadHandler)downloadDialog);
        client_.addDragHandler((CefDragHandler)new DragHandler());
        client_.addJSDialogHandler((CefJSDialogHandler)new JSDialogHandler());
        client_.addKeyboardHandler((CefKeyboardHandler)new KeyboardHandler());
        client_.addRequestHandler((CefRequestHandler)new RequestHandler(this));
        CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig();
        config.jsQueryFunction = "cef_query_" + ++queryCounter;
        config.jsCancelFunction = "cef_query_cancel_" + queryCounter;
        CefMessageRouter msgRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)config);
        msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandler(), true);
        msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandlerEx(client_), false);
        client_.addMessageRouter(msgRouter);
        client_.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onAddressChange(CefBrowser browser2, CefFrame frame, String url) {
                MainFrame.this.control_pane_.setAddress(browser2, url);
            }

            public void onTitleChange(CefBrowser browser2, String title) {
                MainFrame.this.setTitle(title);
            }

            public void onStatusMessage(CefBrowser browser2, String value) {
                MainFrame.this.status_panel_.setStatusText(value);
            }

            public void onFullscreenModeChange(CefBrowser browser2, boolean fullscreen) {
                MainFrame.this.setBrowserFullscreen(fullscreen);
            }
        });
        client_.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser2, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                SwingUtilities.invokeLater(() -> {
                    MainFrame.this.control_pane_.update(browser2, isLoading, canGoBack, canGoForward);
                    MainFrame.this.status_panel_.setIsInProgress(isLoading);
                    if (!isLoading && !MainFrame.this.errorMsg_.isEmpty()) {
                        browser2.loadURL(DataUri.create("text/html", MainFrame.this.errorMsg_));
                        MainFrame.this.errorMsg_ = "";
                    }
                });
            }

            public void onLoadError(CefBrowser browser2, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                if (errorCode != CefLoadHandler.ErrorCode.ERR_NONE && errorCode != CefLoadHandler.ErrorCode.ERR_ABORTED && frame == browser2.getMainFrame()) {
                    MainFrame.this.errorMsg_ = "<html><head>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<title>Error while loading</title>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "</head><body>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<h1>" + String.valueOf(errorCode) + "</h1>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<h3>Failed to load " + failedUrl + "</h3>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<p>" + (errorText == null ? "" : errorText) + "</p>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "</body></html>";
                    browser2.stopLoad();
                }
            }
        });
        CefBrowserSettings browserSettings = new CefBrowserSettings();
        browserSettings.windowless_frame_rate = windowless_frame_rate;
        String startURL = "http://www.google.com";
        if (CefApp.isRemoteEnabled()) {
            Supplier<CefRendering> defaultRenderingFactory = () -> {
                JBCefOSRHandlerFactory osrHandlerFactory = JBCefOSRHandlerFactory.getInstance();
                JComponent component = osrHandlerFactory.createComponent(true);
                CefRenderHandler handler = osrHandlerFactory.createCefRenderHandler(component);
                return new CefRendering.CefRenderingWithHandler(handler, (Component)component);
            };
            browser2 = client_.createBrowser("http://www.google.com", defaultRenderingFactory, false, null, null);
            try {
                Method m = browser2.getUIComponent().getClass().getMethod("setBrowser", CefBrowser.class);
                m.setAccessible(true);
                m.invoke((Object)browser2.getUIComponent(), browser2);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        } else {
            browser2 = client_.createBrowser("http://www.google.com", true, true, null, browserSettings);
        }
        this.setBrowser(browser2);
        this.contentPanel_ = this.createContentPanel();
        this.getContentPane().add((Component)this.contentPanel_, "Center");
        this.control_pane_.getAddressField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = false;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                MainFrame.this.control_pane_.getAddressField().requestFocus();
            }
        });
        client_.addFocusHandler((CefFocusHandler)new CefFocusHandlerAdapter(){

            public void onGotFocus(CefBrowser browser2) {
                if (MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = true;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                browser2.setFocus(true);
            }

            public void onTakeFocus(CefBrowser browser2, boolean next) {
                MainFrame.this.browserFocus_ = false;
            }
        });
        if (createImmediately) {
            browser2.createImmediately();
        }
        this.contentPanel_.add(this.getBrowser().getUIComponent(), "Center");
        MenuBar menuBar = new MenuBar(this, browser2, this.control_pane_, downloadDialog, CefCookieManager.getGlobalManager());
        menuBar.addBookmark("Binding Test", "client://tests/binding_test.html");
        menuBar.addBookmark("Binding Test 2", "client://tests/binding_test2.html");
        menuBar.addBookmark("Download Test", "https://cef-builds.spotifycdn.com/index.html");
        menuBar.addBookmark("Login Test (username:pumpkin, password:pie)", "http://www.colostate.edu/~ric/protect/your.html");
        menuBar.addBookmark("Certificate-error Test", "https://www.k2go.de");
        menuBar.addBookmark("Resource-Handler Test", "http://www.foo.bar/");
        menuBar.addBookmark("Resource-Handler Set Error Test", "http://seterror.test/");
        menuBar.addBookmark("Scheme-Handler Test 1: (scheme \"client\")", "client://tests/handler.html");
        menuBar.addBookmark("Scheme-Handler Test 2: (scheme \"search\")", "search://do a barrel roll/");
        menuBar.addBookmark("Spellcheck Test", "client://tests/spellcheck.html");
        menuBar.addBookmark("LocalStorage Test", "client://tests/localstorage.html");
        menuBar.addBookmark("Transparency Test", "client://tests/transparency.html");
        menuBar.addBookmark("Fullscreen Test", "https://www.w3schools.com/howto/tryit.asp?filename=tryhow_js_fullscreen2");
        menuBar.addBookmarkSeparator();
        menuBar.addBookmark("javachromiumembedded", "https://bitbucket.org/chromiumembedded/java-cef");
        menuBar.addBookmark("chromiumembedded", "https://bitbucket.org/chromiumembedded/cef");
        this.setJMenuBar(menuBar);
    }

    @NotNull
    public CefApp getCefApp() {
        CefApp cefApp = this.cefApp_;
        if (cefApp == null) {
            MainFrame.$$$reportNull$$$0(2);
        }
        return cefApp;
    }

    private JPanel createContentPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.control_pane_ = new ControlPanel(this.getBrowser());
        this.status_panel_ = new StatusPanel();
        contentPanel.add((Component)this.control_pane_, "North");
        contentPanel.add((Component)this.status_panel_, "South");
        return contentPanel;
    }

    public void setBrowserFullscreen(boolean fullscreen) {
        SwingUtilities.invokeLater(() -> {
            Component browserUI = this.getBrowser().getUIComponent();
            if (fullscreen) {
                if (this.fullscreenFrame_ == null) {
                    this.fullscreenFrame_ = new JFrame();
                    this.fullscreenFrame_.setUndecorated(true);
                    this.fullscreenFrame_.setResizable(true);
                }
                GraphicsConfiguration gc = this.getGraphicsConfiguration();
                this.fullscreenFrame_.setBounds(gc.getBounds());
                gc.getDevice().setFullScreenWindow(this.fullscreenFrame_);
                this.contentPanel_.remove(browserUI);
                this.fullscreenFrame_.add(browserUI);
                this.fullscreenFrame_.setVisible(true);
                this.fullscreenFrame_.validate();
            } else {
                this.fullscreenFrame_.remove(browserUI);
                this.fullscreenFrame_.setVisible(false);
                this.contentPanel_.add(browserUI, "Center");
                this.contentPanel_.validate();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefApp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/jcef/test/detailed/MainFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/jcef/test/detailed/MainFrame";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefApp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

