/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.detailed.dialog;

import com.intellij.internal.jcef.test.detailed.dialog.UrlRequestDialogReply;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UrlRequestDialog
extends JDialog {
    private final List<JRadioButton> requestMethods = new ArrayList<JRadioButton>();
    private final Map<JCheckBox, Integer> requestFlags = new HashMap<JCheckBox, Integer>();
    private final TableModel headerTblModel = new TableModel(true);
    private final TableModel postDataModel = new TableModel(false);
    private final JTextField urlField;
    private final JTextField cookieUrl;
    private final Frame owner_;

    private CefRequest createRequest() {
        String url = this.urlField.getText();
        if (url.isEmpty() || url.trim().equalsIgnoreCase("http://")) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.owner_, "Please specify at least an URL. Otherwise the CefRequest is invalid"));
            return null;
        }
        CefRequest request = CefRequest.create();
        if (request == null) {
            return null;
        }
        String firstPartyForCookie = this.cookieUrl.getText();
        if (firstPartyForCookie.isEmpty() || firstPartyForCookie.trim().equalsIgnoreCase("http://")) {
            firstPartyForCookie = url;
        }
        String method = "GET";
        for (int i = 0; i < this.requestMethods.size(); ++i) {
            JRadioButton button2 = this.requestMethods.get(i);
            if (!button2.isSelected()) continue;
            method = button2.getText();
            break;
        }
        CefPostData postData = null;
        int postDataRows = this.postDataModel.getRowCount();
        if (postDataRows > 0) {
            postData = CefPostData.create();
        } else if (method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT")) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.owner_, "The methods POST and PUT require at least one row of data."));
            return null;
        }
        if (postData != null) {
            for (int i = 0; i < postDataRows; ++i) {
                CefPostDataElement elem;
                String value = (String)this.postDataModel.getValueAt(i, 0);
                if (value.trim().isEmpty() || (elem = CefPostDataElement.create()) == null) continue;
                File f = new File(value);
                if (f.isFile()) {
                    elem.setToFile(value);
                } else {
                    byte[] byteStr = value.getBytes();
                    elem.setToBytes(byteStr.length, byteStr);
                }
                postData.addElement(elem);
            }
        }
        HashMap<String, String> headerMap = null;
        int headerRows = this.headerTblModel.getRowCount();
        if (headerRows > 0) {
            headerMap = new HashMap<String, String>();
            for (int i = 0; i < headerRows; ++i) {
                String key = (String)this.headerTblModel.getValueAt(i, 0);
                String value = (String)this.headerTblModel.getValueAt(i, 1);
                if (key.trim().isEmpty()) continue;
                headerMap.put(key, value);
            }
        }
        int flags = 0;
        Set<Map.Entry<JCheckBox, Integer>> entrySet = this.requestFlags.entrySet();
        for (Map.Entry<JCheckBox, Integer> entry : entrySet) {
            if (!entry.getKey().isSelected()) continue;
            flags |= entry.getValue().intValue();
        }
        request.set(url, method, postData, headerMap);
        request.setFirstPartyForCookies(firstPartyForCookie);
        request.setFlags(flags);
        return request;
    }

    public UrlRequestDialog(Frame owner, String title) {
        super(owner, title, false);
        this.setSize(1200, 600);
        this.setLayout(new BorderLayout());
        this.owner_ = owner;
        this.urlField = new JTextField("http://");
        JPanel urlPanel = UrlRequestDialog.createPanelWithTitle("Request URL", 1, 0);
        urlPanel.add(this.urlField);
        this.cookieUrl = new JTextField("http://");
        JPanel cookiePanel = UrlRequestDialog.createPanelWithTitle("Cookie-URL", 1, 0);
        cookiePanel.add(this.cookieUrl);
        ButtonGroup requestModeGrp = new ButtonGroup();
        JPanel requestModePanel = UrlRequestDialog.createPanelWithTitle("HTTP Request Mode", 1, 0);
        this.addRequestMode(requestModePanel, requestModeGrp, "GET", true);
        this.addRequestMode(requestModePanel, requestModeGrp, "HEAD", false);
        this.addRequestMode(requestModePanel, requestModeGrp, "POST", false);
        this.addRequestMode(requestModePanel, requestModeGrp, "PUT", false);
        this.addRequestMode(requestModePanel, requestModeGrp, "DELETE", false);
        JPanel flagsPanel = UrlRequestDialog.createPanelWithTitle("Flags", 0, 1);
        this.addRequestFlag(flagsPanel, "Skip cache", 1, "If set the cache will be skipped when handling the request", false);
        this.addRequestFlag(flagsPanel, "Allow cached credentials", 2, "If set user name, password, and cookies may be sent with the request, and cookies may be saved from the response.", false);
        this.addRequestFlag(flagsPanel, "Report Upload Progress", 8, "If set upload progress events will be generated when a request has a body", false);
        this.addRequestFlag(flagsPanel, "Report RawHeaders", 32, "If set the headers sent and received for the request will be recorded", false);
        this.addRequestFlag(flagsPanel, "No download data", 64, "If set the CefURLRequestClient.onDownloadData method will not be called", false);
        this.addRequestFlag(flagsPanel, "No retry on 5xx", 128, "If set 5XX redirect errors will be propagated to the observer instead of automatically re-tried.", false);
        JPanel headerValues = UrlRequestDialog.createPanelWithTable("Header Values", this.headerTblModel);
        this.headerTblModel.addEntry("User-Agent", "Mozilla/5.0 JCEF Example Agent");
        this.headerTblModel.addEntry("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        JPanel postData = UrlRequestDialog.createPanelWithTable("Post Data", this.postDataModel);
        JPanel headerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        headerPanel.add((Component)urlPanel, c);
        c.gridx = 1;
        headerPanel.add((Component)cookiePanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 0.0;
        headerPanel.add((Component)requestModePanel, c);
        JPanel centerPanel = new JPanel(new GridLayout(2, 0));
        centerPanel.add(headerValues);
        centerPanel.add(postData);
        JButton abortButton = new JButton("Abort");
        abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlRequestDialog.this.setVisible(false);
                UrlRequestDialog.this.dispose();
            }
        });
        JButton sendButton = new JButton("Send");
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CefRequest request = UrlRequestDialog.this.createRequest();
                if (request == null) {
                    return;
                }
                UrlRequestDialogReply handleRequest = new UrlRequestDialogReply(UrlRequestDialog.this.owner_, UrlRequestDialog.this.getTitle() + " - Result");
                handleRequest.send(request);
                handleRequest.setVisible(true);
                UrlRequestDialog.this.setVisible(false);
                UrlRequestDialog.this.dispose();
            }
        });
        JPanel bottomPanel = new JPanel(new GridLayout(0, 2));
        bottomPanel.add(abortButton);
        bottomPanel.add(sendButton);
        this.add((Component)headerPanel, "First");
        this.add((Component)flagsPanel, "Before");
        this.add((Component)centerPanel, "Center");
        this.add((Component)bottomPanel, "Last");
    }

    private void addRequestMode(JPanel panel2, ButtonGroup buttonGrp, String requestMode, boolean selected) {
        JRadioButton button2 = new JRadioButton(requestMode, selected);
        buttonGrp.add(button2);
        panel2.add(button2);
        this.requestMethods.add(button2);
    }

    private void addRequestFlag(JPanel panel2, String flag, int value, String tooltip, boolean selected) {
        JCheckBox checkBox = new JCheckBox(flag, selected);
        checkBox.setToolTipText(tooltip);
        panel2.add(checkBox);
        this.requestFlags.put(checkBox, value);
    }

    private static JPanel createPanelWithTitle(String title, int rows, int cols) {
        JPanel result = new JPanel(new GridLayout(rows, cols));
        result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return result;
    }

    private static JPanel createPanelWithTable(String title, TableModel tblModel) {
        final TableModel localTblModel = tblModel;
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JTable table = new JTable(tblModel);
        table.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(table);
        JPanel buttonPane = new JPanel(new GridLayout(0, 2));
        JButton addButton = new JButton("Add entry");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                localTblModel.newDefaultEntry();
            }
        });
        buttonPane.add(addButton);
        JButton delButton = new JButton("Remove entry");
        delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                localTblModel.removeSelected();
            }
        });
        buttonPane.add(delButton);
        result.add((Component)scrollPane, "Center");
        result.add((Component)buttonPane, "Last");
        return result;
    }

    private static class TableModel
    extends AbstractTableModel {
        private final String[] columnNames;
        private final List<Object[]> rowData = new ArrayList<Object[]>();
        private final boolean hasKeyColumn_;

        TableModel(boolean hasKeyColumn) {
            this.hasKeyColumn_ = hasKeyColumn;
            this.columnNames = hasKeyColumn ? new String[]{"Key", "Value", ""} : new String[]{"Value", ""};
        }

        public void newDefaultEntry() {
            int row = this.rowData.size();
            Object[] rowEntry = this.hasKeyColumn_ ? new Object[]{"key", "value", false} : new Object[]{"value", false};
            this.rowData.add(rowEntry);
            this.fireTableRowsInserted(row, row);
        }

        public void removeSelected() {
            int idx = this.hasKeyColumn_ ? 2 : 1;
            for (int i = 0; i < this.rowData.size(); ++i) {
                if (!((Boolean)this.rowData.get(i)[idx]).booleanValue()) continue;
                this.rowData.remove(i);
                this.fireTableRowsDeleted(i, i);
                --i;
            }
        }

        public void addEntry(String key, String value) {
            int row = this.rowData.size();
            Object[] rowEntry = this.hasKeyColumn_ ? new Object[]{key, value, false} : new Object[]{value, false};
            this.rowData.add(rowEntry);
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public int getRowCount() {
            return this.rowData.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (!this.rowData.isEmpty()) {
                return this.rowData.getFirst()[columnIndex].getClass();
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rowData.get(rowIndex)[columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.rowData.get((int)rowIndex)[columnIndex] = aValue;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

