/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.detailed.handler;

import com.intellij.internal.jcef.test.detailed.dialog.SearchDialog;
import com.intellij.internal.jcef.test.detailed.dialog.ShowTextDialog;
import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ContextMenuHandler
extends CefContextMenuHandlerAdapter {
    private final Frame owner_;
    private final Map<Integer, String> suggestions_ = new HashMap<Integer, String>();

    public ContextMenuHandler(Frame owner) {
        this.owner_ = owner;
    }

    public void onBeforeContextMenu(CefBrowser browser2, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
        model.clear();
        model.addItem(100, "Back");
        model.setEnabled(100, browser2.canGoBack());
        model.addItem(101, "Forward");
        model.setEnabled(101, browser2.canGoForward());
        model.addSeparator();
        model.addItem(130, "Find...");
        if (params.hasImageContents() && params.getSourceUrl() != null) {
            model.addItem(26500, "Download Image...");
        }
        model.addItem(132, "View Source...");
        model.addItem(205, "Suggestions isn't implemented yet.");
        model.setEnabled(205, false);
    }

    public boolean onContextMenuCommand(CefBrowser browser2, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
        String newWord;
        switch (commandId) {
            case 132: {
                ShowTextDialog visitor = new ShowTextDialog(this.owner_, "Source of \"" + browser2.getURL() + "\"");
                browser2.getSource((CefStringVisitor)visitor);
                return true;
            }
            case 130: {
                SearchDialog search = new SearchDialog(this.owner_, browser2);
                search.setVisible(true);
                return true;
            }
            case 26500: {
                browser2.startDownload(params.getSourceUrl());
                return true;
            }
        }
        if (commandId >= 200 && (newWord = this.suggestions_.get(commandId)) != null) {
            browser2.replaceMisspelling(newWord);
            return true;
        }
        return false;
    }

    public void onContextMenuDismissed(CefBrowser browser2, CefFrame frame) {
        this.suggestions_.clear();
    }
}

