/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.detailed.ui;

import com.intellij.internal.jcef.test.detailed.BrowserFrame;
import com.intellij.internal.jcef.test.detailed.MainFrame;
import com.intellij.internal.jcef.test.detailed.dialog.CookieManagerDialog;
import com.intellij.internal.jcef.test.detailed.dialog.DevToolsDialog;
import com.intellij.internal.jcef.test.detailed.dialog.DownloadDialog;
import com.intellij.internal.jcef.test.detailed.dialog.SearchDialog;
import com.intellij.internal.jcef.test.detailed.dialog.ShowTextDialog;
import com.intellij.internal.jcef.test.detailed.dialog.UrlRequestDialog;
import com.intellij.internal.jcef.test.detailed.ui.ControlPanel;
import com.intellij.internal.jcef.test.detailed.util.DataUri;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefDevToolsClient;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.network.CefCookieManager;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MenuBar
extends JMenuBar {
    private final MainFrame owner_;
    private final CefBrowser browser_;
    private String last_selected_file_ = "";
    private final JMenu bookmarkMenu_;
    private final ControlPanel control_pane_;
    private final DownloadDialog downloadDialog_;
    private final CefCookieManager cookieManager_;
    private boolean reparentPending_ = false;
    private CefDevToolsClient devToolsClient_;

    public MenuBar(MainFrame owner, final CefBrowser browser2, ControlPanel control_pane, DownloadDialog downloadDialog, CefCookieManager cookieManager) {
        this.owner_ = owner;
        this.browser_ = browser2;
        this.control_pane_ = control_pane;
        this.downloadDialog_ = downloadDialog;
        this.cookieManager_ = cookieManager;
        this.setEnabled(this.browser_ != null);
        JMenu fileMenu = new JMenu("File");
        JMenuItem openFileItem = new JMenuItem("Open file...");
        openFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser(new File(MenuBar.this.last_selected_file_));
                fc.showOpenDialog(MenuBar.this.owner_);
                File selectedFile = fc.getSelectedFile();
                if (selectedFile != null) {
                    MenuBar.this.last_selected_file_ = selectedFile.getAbsolutePath();
                    MenuBar.this.browser_.loadURL("file:///" + selectedFile.getAbsolutePath());
                }
            }
        });
        fileMenu.add(openFileItem);
        JMenuItem openFileDialog = new JMenuItem("Save as...");
        openFileDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CefRunFileDialogCallback callback = new CefRunFileDialogCallback(){

                    public void onFileDialogDismissed(Vector<String> filePaths) {
                        if (!filePaths.isEmpty()) {
                            try {
                                SaveAs saveContent = new SaveAs(filePaths.get(0));
                                MenuBar.this.browser_.getSource((CefStringVisitor)saveContent);
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException e) {
                                MenuBar.this.browser_.executeJavaScript("alert(\"Can't save file\");", MenuBar.this.control_pane_.getAddress(), 0);
                            }
                        }
                    }
                };
                MenuBar.this.browser_.runFileDialog(CefDialogHandler.FileDialogMode.FILE_DIALOG_SAVE, MenuBar.this.owner_.getTitle(), "index.html", null, callback);
            }
        });
        fileMenu.add(openFileDialog);
        JMenuItem printItem = new JMenuItem("Print...");
        printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.print();
            }
        });
        fileMenu.add(printItem);
        JMenuItem printToPdfItem = new JMenuItem("Print to PDF");
        printToPdfItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.showSaveDialog(MenuBar.this.owner_);
                File selectedFile = fc.getSelectedFile();
                if (selectedFile != null) {
                    CefPdfPrintSettings pdfSettings = new CefPdfPrintSettings();
                    pdfSettings.display_header_footer = true;
                    pdfSettings.paper_width = 8.5;
                    pdfSettings.paper_height = 11.0;
                    browser2.printToPDF(selectedFile.getAbsolutePath(), pdfSettings, new CefPdfPrintCallback(){

                        public void onPdfPrintFinished(String path, boolean ok) {
                            SwingUtilities.invokeLater(() -> {
                                if (ok) {
                                    JOptionPane.showMessageDialog(MenuBar.this.owner_, "PDF saved to " + path, "Success", 1);
                                } else {
                                    JOptionPane.showMessageDialog(MenuBar.this.owner_, "PDF failed", "Failed", 0);
                                }
                            });
                        }
                    });
                }
            }
        });
        fileMenu.add(printToPdfItem);
        JMenuItem searchItem = new JMenuItem("Search...");
        searchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog((Frame)MenuBar.this.owner_, MenuBar.this.browser_).setVisible(true);
            }
        });
        fileMenu.add(searchItem);
        fileMenu.addSeparator();
        JMenuItem viewSource = new JMenuItem("View source");
        viewSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.viewSource();
            }
        });
        fileMenu.add(viewSource);
        JMenuItem getSource = new JMenuItem("Get source...");
        getSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowTextDialog visitor = new ShowTextDialog((Frame)MenuBar.this.owner_, "Source of \"" + MenuBar.this.control_pane_.getAddress() + "\"");
                MenuBar.this.browser_.getSource((CefStringVisitor)visitor);
            }
        });
        fileMenu.add(getSource);
        JMenuItem getText = new JMenuItem("Get text...");
        getText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowTextDialog visitor = new ShowTextDialog((Frame)MenuBar.this.owner_, "Content of \"" + MenuBar.this.control_pane_.getAddress() + "\"");
                MenuBar.this.browser_.getText((CefStringVisitor)visitor);
            }
        });
        fileMenu.add(getText);
        fileMenu.addSeparator();
        JMenuItem showDownloads = new JMenuItem("Show Downloads");
        showDownloads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.downloadDialog_.setVisible(true);
            }
        });
        fileMenu.add(showDownloads);
        JMenuItem showCookies = new JMenuItem("Show Cookies");
        showCookies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CookieManagerDialog cookieManager = new CookieManagerDialog((Frame)MenuBar.this.owner_, "Cookie Manager", MenuBar.this.cookieManager_);
                cookieManager.setVisible(true);
            }
        });
        fileMenu.add(showCookies);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.owner_.dispatchEvent(new WindowEvent(MenuBar.this.owner_, 201));
            }
        });
        fileMenu.add(exitItem);
        this.bookmarkMenu_ = new JMenu("Bookmarks");
        JMenuItem addBookmarkItem = new JMenuItem("Add bookmark");
        addBookmarkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.addBookmark(MenuBar.this.owner_.getTitle(), MenuBar.this.control_pane_.getAddress());
            }
        });
        this.bookmarkMenu_.add(addBookmarkItem);
        this.bookmarkMenu_.addSeparator();
        JMenu testMenu = new JMenu("Tests");
        JMenuItem testJSItem = new JMenuItem("JavaScript alert");
        testJSItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.executeJavaScript("alert('Hello World');", MenuBar.this.control_pane_.getAddress(), 1);
            }
        });
        testMenu.add(testJSItem);
        JMenuItem jsAlertItem = new JMenuItem("JavaScript alert (will be suppressed)");
        jsAlertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.executeJavaScript("alert('Never displayed');", "http://dontshow.me", 1);
            }
        });
        testMenu.add(jsAlertItem);
        JMenuItem testShowText = new JMenuItem("Show Text");
        testShowText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.loadURL(DataUri.create("text/html", "<html><body><h1>Hello World</h1></body></html>"));
            }
        });
        testMenu.add(testShowText);
        JMenuItem showForm = new JMenuItem("RequestHandler Test");
        showForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object form = "<html><head><title>RequestHandler test</title></head>";
                form = (String)form + "<body><h1>RequestHandler test</h1>";
                form = (String)form + "<form action=\"http://www.google.com/\" method=\"post\">";
                form = (String)form + "<input type=\"text\" name=\"searchFor\"/>";
                form = (String)form + "<input type=\"submit\"/><br/>";
                form = (String)form + "<input type=\"checkbox\" name=\"sendAsGet\"> Use GET instead of POST";
                form = (String)form + "<p>This form tries to send the content of the text field as HTTP-POST request to http://www.google.com.</p>";
                form = (String)form + "<h2>Testcase 1</h2>";
                form = (String)form + "Try to enter the word <b>\"ignore\"</b> into the text field and press \"submit\".<br />";
                form = (String)form + "The request will be rejected by the application.";
                form = (String)form + "<p>See implementation of <u>tests.RequestHandler.onBeforeBrowse(CefBrowser, CefRequest, boolean)</u> for details</p>";
                form = (String)form + "<h2>Testcase 2</h2>";
                form = (String)form + "Due Google doesn't allow the POST method, the server replies with a 405 error.</br>";
                form = (String)form + "If you activate the checkbox \"Use GET instead of POST\", the application will change the POST request into a GET request.";
                form = (String)form + "<p>See implementation of <u>tests.RequestHandler.onBeforeResourceLoad(CefBrowser, CefRequest)</u> for details</p>";
                form = (String)form + "</form>";
                form = (String)form + "</body></html>";
                MenuBar.this.browser_.loadURL(DataUri.create("text/html", (String)form));
            }
        });
        testMenu.add(showForm);
        JMenuItem httpRequest = new JMenuItem("Manual HTTP request");
        httpRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchFor = JOptionPane.showInputDialog(MenuBar.this.owner_, (Object)"Search on google:");
                if (searchFor != null && !searchFor.isEmpty()) {
                    CefRequest myRequest = CefRequest.create();
                    myRequest.setMethod("GET");
                    myRequest.setURL("http://www.google.com/#q=" + searchFor);
                    myRequest.setFirstPartyForCookies("http://www.google.com/#q=" + searchFor);
                    MenuBar.this.browser_.loadRequest(myRequest);
                }
            }
        });
        testMenu.add(httpRequest);
        JMenuItem showInfo = new JMenuItem("Show Info");
        showInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object info = "<html><head><title>Browser status</title></head>";
                info = (String)info + "<body><h1>Browser status</h1><table border=\"0\">";
                info = (String)info + "<tr><td>CanGoBack</td><td>" + MenuBar.this.browser_.canGoBack() + "</td></tr>";
                info = (String)info + "<tr><td>CanGoForward</td><td>" + MenuBar.this.browser_.canGoForward() + "</td></tr>";
                info = (String)info + "<tr><td>IsLoading</td><td>" + MenuBar.this.browser_.isLoading() + "</td></tr>";
                info = (String)info + "<tr><td>isPopup</td><td>" + MenuBar.this.browser_.isPopup() + "</td></tr>";
                info = (String)info + "<tr><td>hasDocument</td><td>" + MenuBar.this.browser_.hasDocument() + "</td></tr>";
                info = (String)info + "<tr><td>Url</td><td>" + MenuBar.this.browser_.getURL() + "</td></tr>";
                info = (String)info + "<tr><td>Zoom-Level</td><td>" + MenuBar.this.browser_.getZoomLevel() + "</td></tr>";
                info = (String)info + "</table></body></html>";
                String js = "var x=window.open(); x.document.open(); x.document.write('" + (String)info + "'); x.document.close();";
                MenuBar.this.browser_.executeJavaScript(js, "", 0);
                String jsFunc = "cef_query_" + MainFrame.queryCounter;
                String jsQuery = "window." + jsFunc + "({request: '" + jsFunc + "'});";
                MenuBar.this.browser_.executeJavaScript(jsQuery, "", 0);
            }
        });
        testMenu.add(showInfo);
        final JMenuItem showDevTools = new JMenuItem("Show DevTools");
        showDevTools.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevToolsDialog devToolsDlg = new DevToolsDialog((Frame)MenuBar.this.owner_, "DEV Tools", MenuBar.this.browser_);
                devToolsDlg.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        showDevTools.setEnabled(true);
                    }
                });
                devToolsDlg.setVisible(true);
                showDevTools.setEnabled(false);
            }
        });
        testMenu.add(showDevTools);
        JMenu devToolsProtocolMenu = new JMenu("DevTools Protocol");
        final JMenuItem autoDarkMode = devToolsProtocolMenu.add(new JCheckBoxMenuItem("Auto Dark Mode"));
        autoDarkMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String params = String.format("{ \"enabled\": %s }", autoDarkMode.isSelected());
                MenuBar.this.executeDevToolsMethod("Emulation.setAutoDarkModeOverride", params);
            }
        });
        JMenuItem checkContrast = devToolsProtocolMenu.add(new JMenuItem("Check Contrast"));
        checkContrast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.executeDevToolsMethod("Audits.checkContrast");
            }
        });
        JMenuItem enableCSS = devToolsProtocolMenu.add(new JMenuItem("Enable CSS Agent"));
        enableCSS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.executeDevToolsMethod("DOM.enable").thenCompose(unused -> MenuBar.this.executeDevToolsMethod("CSS.enable"));
            }
        });
        testMenu.add(devToolsProtocolMenu);
        JMenuItem testURLRequest = new JMenuItem("URL Request");
        testURLRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlRequestDialog dlg = new UrlRequestDialog((Frame)MenuBar.this.owner_, "URL Request Test");
                dlg.setVisible(true);
            }
        });
        testMenu.add(testURLRequest);
        JMenuItem reparent = new JMenuItem("Reparent");
        reparent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final BrowserFrame newFrame = new BrowserFrame("New Window");
                newFrame.setLayout(new BorderLayout());
                final JButton reparentButton = new JButton("Reparent <");
                reparentButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MenuBar.this.reparentPending_) {
                            return;
                        }
                        MenuBar.this.reparentPending_ = true;
                        if (reparentButton.getText().equals("Reparent <")) {
                            MenuBar.this.owner_.removeBrowser(() -> {
                                newFrame.add(MenuBar.this.browser_.getUIComponent(), "Center");
                                newFrame.setBrowser(MenuBar.this.browser_);
                                reparentButton.setText("Reparent >");
                                MenuBar.this.reparentPending_ = false;
                            });
                        } else {
                            newFrame.removeBrowser(new Runnable(){

                                @Override
                                public void run() {
                                    JRootPane rootPane = (JRootPane)MenuBar.this.owner_.getComponent(0);
                                    Container container = rootPane.getContentPane();
                                    JPanel panel2 = (JPanel)container.getComponent(0);
                                    panel2.add(MenuBar.this.browser_.getUIComponent());
                                    MenuBar.this.owner_.setBrowser(MenuBar.this.browser_);
                                    MenuBar.this.owner_.revalidate();
                                    reparentButton.setText("Reparent <");
                                    MenuBar.this.reparentPending_ = false;
                                }
                            });
                        }
                    }
                });
                newFrame.add((Component)reparentButton, "North");
                newFrame.setSize(400, 400);
                newFrame.setVisible(true);
            }
        });
        testMenu.add(reparent);
        JMenuItem newwindow = new JMenuItem("New window");
        newwindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame frame = new MainFrame(MenuBar.this.owner_.getCefApp());
                frame.setSize(800, 600);
                frame.setVisible(true);
            }
        });
        testMenu.add(newwindow);
        JMenuItem screenshotSync = new JMenuItem("Screenshot (on AWT thread, native res)");
        screenshotSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompletableFuture shot = browser2.createScreenshot(true);
                try {
                    MenuBar.this.displayScreenshot((BufferedImage)shot.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        });
        screenshotSync.setEnabled(true);
        testMenu.add(screenshotSync);
        JMenuItem screenshotSyncScaled = new JMenuItem("Screenshot (on AWT thread, scaled)");
        screenshotSyncScaled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompletableFuture shot = browser2.createScreenshot(false);
                try {
                    MenuBar.this.displayScreenshot((BufferedImage)shot.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        });
        screenshotSyncScaled.setEnabled(true);
        testMenu.add(screenshotSyncScaled);
        JMenuItem screenshotAsync = new JMenuItem("Screenshot (from other thread, scaled)");
        screenshotAsync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompletableFuture shot = browser2.createScreenshot(false);
                shot.thenAccept(image -> SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ BufferedImage val$image;
                    {
                        this.val$image = bufferedImage;
                    }

                    @Override
                    public void run() {
                        MenuBar.this.displayScreenshot(this.val$image);
                    }
                }));
            }
        });
        screenshotAsync.setEnabled(true);
        testMenu.add(screenshotAsync);
        this.add(fileMenu);
        this.add(this.bookmarkMenu_);
        this.add(testMenu);
    }

    public void addBookmark(String name, String URL2) {
        Component[] entries;
        if (this.bookmarkMenu_ == null) {
            return;
        }
        for (Component itemEntry : entries = this.bookmarkMenu_.getMenuComponents()) {
            JMenuItem item;
            if (!(itemEntry instanceof JMenuItem) || !(item = (JMenuItem)itemEntry).getText().equals(name)) continue;
            item.setActionCommand(URL2);
            return;
        }
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.setActionCommand(URL2);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.loadURL(e.getActionCommand());
            }
        });
        this.bookmarkMenu_.add(menuItem);
        this.validate();
    }

    private void displayScreenshot(BufferedImage aScreenshot) {
        JFrame frame = new JFrame("Screenshot");
        ImageIcon image = new ImageIcon();
        image.setImage(aScreenshot);
        frame.setLayout(new FlowLayout());
        JLabel label = new JLabel(image);
        label.setPreferredSize(new Dimension(aScreenshot.getWidth(), aScreenshot.getHeight()));
        frame.add(label);
        frame.setVisible(true);
        frame.pack();
    }

    private CompletableFuture<String> executeDevToolsMethod(String methodName) {
        return this.executeDevToolsMethod(methodName, null);
    }

    private CompletableFuture<String> executeDevToolsMethod(String methodName, String paramsAsJson) {
        if (this.devToolsClient_ == null) {
            this.devToolsClient_ = this.browser_.getDevToolsClient();
            this.devToolsClient_.addEventListener((method, json) -> {});
        }
        return this.devToolsClient_.executeDevToolsMethod(methodName, paramsAsJson).handle((error, json) -> null);
    }

    public void addBookmarkSeparator() {
        this.bookmarkMenu_.addSeparator();
    }

    static class SaveAs
    implements CefStringVisitor {
        private final PrintWriter fileWriter_;

        SaveAs(String fName) throws FileNotFoundException, UnsupportedEncodingException {
            this.fileWriter_ = new PrintWriter(fName, "UTF-8");
        }

        public void visit(String string) {
            this.fileWriter_.write(string);
            this.fileWriter_.close();
        }
    }
}

