/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.rhtest;

import com.intellij.internal.jcef.test.cases.DetailedFrame;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cef.callback.CefCallback;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\u0012H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/internal/jcef/test/rhtest/MyResourceHandler;", "Lorg/cef/handler/CefResourceHandler;", "<init>", "()V", "inputStream", "Ljava/io/InputStream;", "resourceType", "Lorg/cef/network/CefRequest$ResourceType;", "loadContent", "resName", "", "processRequest", "", "request", "Lorg/cef/network/CefRequest;", "callback", "Lorg/cef/callback/CefCallback;", "getResponseHeaders", "", "response", "Lorg/cef/network/CefResponse;", "responseLength", "Lorg/cef/misc/IntRef;", "redirectUrl", "Lorg/cef/misc/StringRef;", "readResponse", "dataOut", "", "bytesToRead", "", "bytesRead", "getMimeType", "cancel", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nMyResourceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyResourceHandler.kt\ncom/intellij/internal/jcef/test/rhtest/MyResourceHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n23#2:125\n23#2:126\n23#2:127\n*S KotlinDebug\n*F\n+ 1 MyResourceHandler.kt\ncom/intellij/internal/jcef/test/rhtest/MyResourceHandler\n*L\n34#1:125\n39#1:126\n85#1:127\n*E\n"})
public final class MyResourceHandler
implements CefResourceHandler {
    @Nullable
    private InputStream inputStream;
    @Nullable
    private CefRequest.ResourceType resourceType;

    private final InputStream loadContent(String resName) {
        try {
            return DetailedFrame.class.getResourceAsStream("resources/rhtest/" + resName);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean processRequest(@NotNull CefRequest request, @NotNull CefCallback callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        MyResourceHandler $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(MyResourceHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Processing request " + request.getURL());
        this.inputStream = this.loadContent("index.html");
        if (this.inputStream == null) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(MyResourceHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("inputStream is null for " + request.getURL() + " , canceling request " + request.getURL());
            callback.cancel();
            return false;
        }
        this.resourceType = request.getResourceType();
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(@NotNull CefResponse response, @NotNull IntRef responseLength, @NotNull StringRef redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)responseLength, (String)"responseLength");
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        if (this.inputStream == null) {
            response.setError(CefLoadHandler.ErrorCode.ERR_FILE_NOT_FOUND);
            response.setStatusText("file not found");
            response.setStatus(404);
            return;
        }
        response.setStatus(200);
        response.setMimeType(this.getMimeType());
        try {
            InputStream inputStream = this.inputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            responseLength.set(inputStream.available());
        }
        catch (IOException e) {
            response.setError(CefLoadHandler.ErrorCode.ERR_ABORTED);
            response.setStatusText("internal error");
            response.setStatus(500);
        }
    }

    public boolean readResponse(@NotNull byte[] dataOut, int bytesToRead, @NotNull IntRef bytesRead, @NotNull CefCallback callback) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        Intrinsics.checkNotNullParameter((Object)bytesRead, (String)"bytesRead");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            Integer read;
            InputStream inputStream = this.inputStream;
            Integer n = read = inputStream != null ? Integer.valueOf(inputStream.read(dataOut, 0, bytesToRead)) : null;
            if (read == null || read <= 0) {
                bytesRead.set(0);
                InputStream inputStream2 = this.inputStream;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                return false;
            }
            bytesRead.set(read.intValue());
            bl = true;
        }
        catch (Exception e) {
            bytesRead.set(0);
            MyResourceHandler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(MyResourceHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final String getMimeType() {
        CefRequest.ResourceType resourceType = this.resourceType;
        return switch (resourceType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()]) {
            case 1 -> "text/html";
            case 2 -> "text/javascript";
            case 3 -> "text/css";
            case 4 -> "image/png";
            default -> "text/plain";
        };
    }

    public void cancel() {
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CefRequest.ResourceType.values().length];
            try {
                nArray[CefRequest.ResourceType.RT_MAIN_FRAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CefRequest.ResourceType.RT_SCRIPT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CefRequest.ResourceType.RT_STYLESHEET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CefRequest.ResourceType.RT_IMAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

