/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.BagOfWordsFeature;
import com.intellij.internal.ml.Feature;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.UndefinedMapper;
import com.intellij.internal.ml.WordsSplitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u0013\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0003&'(B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J/\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0083\u0004J\n\u0010#\u001a\u00020$H\u00d6\u0081\u0004J\n\u0010%\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/internal/ml/BagOfWordsFeature;", "Lcom/intellij/internal/ml/Feature;", "name", "", "words", "", "splitterDescriptor", "Lcom/intellij/internal/ml/BagOfWordsFeature$SplitterDescriptor;", "<init>", "(Ljava/lang/String;Ljava/util/Set;Lcom/intellij/internal/ml/BagOfWordsFeature$SplitterDescriptor;)V", "getName", "()Ljava/lang/String;", "getWords", "()Ljava/util/Set;", "getSplitterDescriptor", "()Lcom/intellij/internal/ml/BagOfWordsFeature$SplitterDescriptor;", "splitter", "Lcom/intellij/internal/ml/WordsSplitter;", "wordsCache", "com/intellij/internal/ml/BagOfWordsFeature$wordsCache$1", "Lcom/intellij/internal/ml/BagOfWordsFeature$wordsCache$1;", "createMapper", "Lcom/intellij/internal/ml/FeatureMapper;", "suffix", "split", "", "value", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "SplitterDescriptor", "BagOfWordsMapper", "Companion", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Features.kt\ncom/intellij/internal/ml/BagOfWordsFeature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class BagOfWordsFeature
extends Feature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Set<String> words;
    @Nullable
    private final SplitterDescriptor splitterDescriptor;
    @Nullable
    private final WordsSplitter splitter;
    @NotNull
    private final wordsCache.1 wordsCache;
    @NotNull
    public static final String UNDEFINED = "_UNDEFINED_";
    public static final int MAX_CACHE_SIZE = 10;

    /*
     * WARNING - void declaration
     */
    public BagOfWordsFeature(@NotNull String name, @NotNull Set<String> words, @Nullable SplitterDescriptor splitterDescriptor) {
        WordsSplitter wordsSplitter;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(words, (String)"words");
        super(null);
        this.name = name;
        this.words = words;
        this.splitterDescriptor = splitterDescriptor;
        BagOfWordsFeature bagOfWordsFeature = this;
        SplitterDescriptor splitterDescriptor2 = this.splitterDescriptor;
        if (splitterDescriptor2 != null) {
            void descriptor;
            WordsSplitter.Builder builder;
            SplitterDescriptor splitterDescriptor3 = splitterDescriptor2;
            BagOfWordsFeature bagOfWordsFeature2 = bagOfWordsFeature;
            boolean bl = false;
            WordsSplitter.Builder $this$splitter_u24lambda_u240_u240 = builder = new WordsSplitter.Builder();
            boolean bl2 = false;
            if (descriptor.getToLowerCase()) {
                $this$splitter_u24lambda_u240_u240.toLowerCase();
            }
            WordsSplitter.Builder $this$splitter_u24lambda_u240_u241 = builder;
            boolean bl3 = false;
            if (descriptor.getWithStemming()) {
                $this$splitter_u24lambda_u240_u241.withStemming();
            }
            wordsSplitter = builder.build();
            bagOfWordsFeature = bagOfWordsFeature2;
        } else {
            wordsSplitter = null;
        }
        bagOfWordsFeature.splitter = wordsSplitter;
        this.wordsCache = new LinkedHashMap<String, List<? extends String>>(){

            protected boolean removeEldestEntry(Map.Entry<String, ? extends List<String>> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                return this.size() > 10;
            }
        };
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Set<String> getWords() {
        return this.words;
    }

    @Nullable
    public final SplitterDescriptor getSplitterDescriptor() {
        return this.splitterDescriptor;
    }

    @Override
    @NotNull
    public FeatureMapper createMapper(@Nullable String suffix) {
        FeatureMapper featureMapper;
        String string = suffix;
        if (Intrinsics.areEqual((Object)string, (Object)UNDEFINED)) {
            featureMapper = UndefinedMapper.Companion.checkAndCreate(this.getName(), this.words.contains(UNDEFINED));
        } else {
            if (string == null) {
                throw new InconsistentMetadataException("Bag of words feature usage must have suffix");
            }
            if (!this.words.contains(suffix)) {
                throw new InconsistentMetadataException("Unknown word '" + suffix + "' of Bag of words feature '" + this.getName() + "'");
            }
            featureMapper = new BagOfWordsMapper(suffix);
        }
        return featureMapper;
    }

    private final List<String> split(String value) {
        List list = this.wordsCache.computeIfAbsent(value, arg_0 -> BagOfWordsFeature.split$lambda$1(arg_0 -> BagOfWordsFeature.split$lambda$0(this, value, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        return list;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Set<String> component2() {
        return this.words;
    }

    @Nullable
    public final SplitterDescriptor component3() {
        return this.splitterDescriptor;
    }

    @NotNull
    public final BagOfWordsFeature copy(@NotNull String name, @NotNull Set<String> words, @Nullable SplitterDescriptor splitterDescriptor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(words, (String)"words");
        return new BagOfWordsFeature(name, words, splitterDescriptor);
    }

    public static /* synthetic */ BagOfWordsFeature copy$default(BagOfWordsFeature bagOfWordsFeature, String string, Set set, SplitterDescriptor splitterDescriptor, int n, Object object) {
        if ((n & 1) != 0) {
            string = bagOfWordsFeature.name;
        }
        if ((n & 2) != 0) {
            set = bagOfWordsFeature.words;
        }
        if ((n & 4) != 0) {
            splitterDescriptor = bagOfWordsFeature.splitterDescriptor;
        }
        return bagOfWordsFeature.copy(string, set, splitterDescriptor);
    }

    @NotNull
    public String toString() {
        return "BagOfWordsFeature(name=" + this.name + ", words=" + this.words + ", splitterDescriptor=" + this.splitterDescriptor + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.words).hashCode();
        result = result * 31 + (this.splitterDescriptor == null ? 0 : this.splitterDescriptor.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BagOfWordsFeature)) {
            return false;
        }
        BagOfWordsFeature bagOfWordsFeature = (BagOfWordsFeature)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)bagOfWordsFeature.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.words, bagOfWordsFeature.words)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.splitterDescriptor, (Object)bagOfWordsFeature.splitterDescriptor);
    }

    private static final List split$lambda$0(BagOfWordsFeature this$0, String $value, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.splitter;
        if (object == null || (object = ((WordsSplitter)object).split($value)) == null) {
            object = CollectionsKt.listOf((Object)$value);
        }
        return object;
    }

    private static final List split$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/ml/BagOfWordsFeature$BagOfWordsMapper;", "Lcom/intellij/internal/ml/FeatureMapper;", "word", "", "<init>", "(Lcom/intellij/internal/ml/BagOfWordsFeature;Ljava/lang/String;)V", "getFeatureName", "asArrayValue", "", "value", "", "intellij.platform.ide.internal"})
    @SourceDebugExtension(value={"SMAP\nFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Features.kt\ncom/intellij/internal/ml/BagOfWordsFeature$BagOfWordsMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1391#2:176\n1480#2,5:177\n*S KotlinDebug\n*F\n+ 1 Features.kt\ncom/intellij/internal/ml/BagOfWordsFeature$BagOfWordsMapper\n*L\n163#1:176\n163#1:177,5\n*E\n"})
    private final class BagOfWordsMapper
    implements FeatureMapper {
        @NotNull
        private final String word;

        public BagOfWordsMapper(String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            this.word = word;
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return BagOfWordsFeature.this.getName();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double asArrayValue(@Nullable Object value) {
            List list;
            if (value == null) {
                return 0.0;
            }
            Object object = value;
            if (object instanceof String) {
                list = BagOfWordsFeature.this.split((String)value);
            } else if (object instanceof List) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Iterable iterable = CollectionsKt.filterNotNull((Iterable)((Iterable)value));
                BagOfWordsFeature bagOfWordsFeature = BagOfWordsFeature.this;
                boolean $i$f$flatMap = false;
                void var7_6 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv;
                    Object it = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    Iterable list$iv$iv = bagOfWordsFeature.split(it.toString());
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List words = list;
            return words.contains(this.word) ? 1.0 : 0.0;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/ml/BagOfWordsFeature$Companion;", "", "<init>", "()V", "UNDEFINED", "", "MAX_CACHE_SIZE", "", "intellij.platform.ide.internal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/ml/BagOfWordsFeature$SplitterDescriptor;", "", "withStemming", "", "toLowerCase", "<init>", "(ZZ)V", "getWithStemming", "()Z", "getToLowerCase", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ide.internal"})
    public static final class SplitterDescriptor {
        private final boolean withStemming;
        private final boolean toLowerCase;

        public SplitterDescriptor(boolean withStemming, boolean toLowerCase) {
            this.withStemming = withStemming;
            this.toLowerCase = toLowerCase;
        }

        public final boolean getWithStemming() {
            return this.withStemming;
        }

        public final boolean getToLowerCase() {
            return this.toLowerCase;
        }

        public final boolean component1() {
            return this.withStemming;
        }

        public final boolean component2() {
            return this.toLowerCase;
        }

        @NotNull
        public final SplitterDescriptor copy(boolean withStemming, boolean toLowerCase) {
            return new SplitterDescriptor(withStemming, toLowerCase);
        }

        public static /* synthetic */ SplitterDescriptor copy$default(SplitterDescriptor splitterDescriptor, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = splitterDescriptor.withStemming;
            }
            if ((n & 2) != 0) {
                bl2 = splitterDescriptor.toLowerCase;
            }
            return splitterDescriptor.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "SplitterDescriptor(withStemming=" + this.withStemming + ", toLowerCase=" + this.toLowerCase + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.withStemming);
            result = result * 31 + Boolean.hashCode(this.toLowerCase);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SplitterDescriptor)) {
                return false;
            }
            SplitterDescriptor splitterDescriptor = (SplitterDescriptor)other;
            if (this.withStemming != splitterDescriptor.withStemming) {
                return false;
            }
            return this.toLowerCase == splitterDescriptor.toLowerCase;
        }
    }
}

