/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.Feature;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.UndefinedMapper;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001a\u001b\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0002J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/internal/ml/CategoricalFeature;", "Lcom/intellij/internal/ml/Feature;", "name", "", "categories", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "getName", "()Ljava/lang/String;", "getCategories", "()Ljava/util/Set;", "createMapper", "Lcom/intellij/internal/ml/FeatureMapper;", "suffix", "otherCategoryMapper", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "OtherCategoryMapper", "CategoryMapper", "Companion", "intellij.platform.ide.internal"})
public final class CategoricalFeature
extends Feature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Set<String> categories;
    @NotNull
    public static final String OTHER = "OTHER";

    public CategoricalFeature(@NotNull String name, @NotNull Set<String> categories) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        super(null);
        this.name = name;
        this.categories = categories;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Set<String> getCategories() {
        return this.categories;
    }

    @Override
    @NotNull
    public FeatureMapper createMapper(@Nullable String suffix) {
        FeatureMapper featureMapper;
        String string = suffix;
        if (Intrinsics.areEqual((Object)string, (Object)"UNDEFINED")) {
            featureMapper = UndefinedMapper.Companion.checkAndCreate(this.getName(), this.categories.contains("UNDEFINED"));
        } else if (Intrinsics.areEqual((Object)string, (Object)OTHER)) {
            featureMapper = this.otherCategoryMapper();
        } else {
            if (string == null) {
                throw new InconsistentMetadataException("Categorical feature usage must have suffix");
            }
            if (!this.categories.contains(suffix)) {
                throw new InconsistentMetadataException("Unknown category '" + suffix + "' of categorical feature '" + this.getName() + "'");
            }
            String string2 = suffix.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            featureMapper = new CategoryMapper(string2);
        }
        return featureMapper;
    }

    private final FeatureMapper otherCategoryMapper() {
        if (!this.categories.contains(OTHER)) {
            throw new InconsistentMetadataException("Feature " + this.getName() + " does not allow other category");
        }
        Object[] objectArray = new String[]{"UNDEFINED", OTHER};
        return new OtherCategoryMapper(this.getName(), SetsKt.minus(this.categories, (Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Set<String> component2() {
        return this.categories;
    }

    @NotNull
    public final CategoricalFeature copy(@NotNull String name, @NotNull Set<String> categories) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        return new CategoricalFeature(name, categories);
    }

    public static /* synthetic */ CategoricalFeature copy$default(CategoricalFeature categoricalFeature, String string, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string = categoricalFeature.name;
        }
        if ((n & 2) != 0) {
            set = categoricalFeature.categories;
        }
        return categoricalFeature.copy(string, set);
    }

    @NotNull
    public String toString() {
        return "CategoricalFeature(name=" + this.name + ", categories=" + this.categories + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.categories).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CategoricalFeature)) {
            return false;
        }
        CategoricalFeature categoricalFeature = (CategoricalFeature)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)categoricalFeature.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.categories, categoricalFeature.categories);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/ml/CategoricalFeature$CategoryMapper;", "Lcom/intellij/internal/ml/FeatureMapper;", "category", "", "<init>", "(Lcom/intellij/internal/ml/CategoricalFeature;Ljava/lang/String;)V", "getFeatureName", "asArrayValue", "", "value", "", "intellij.platform.ide.internal"})
    private final class CategoryMapper
    implements FeatureMapper {
        @NotNull
        private final String category;

        public CategoryMapper(String category) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.category = category;
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return CategoricalFeature.this.getName();
        }

        @Override
        public double asArrayValue(@Nullable Object value) {
            if (value == null) {
                return 0.0;
            }
            String string = value.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return Intrinsics.areEqual((Object)string, (Object)this.category) ? 1.0 : 0.0;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/ml/CategoricalFeature$Companion;", "", "<init>", "()V", "OTHER", "", "intellij.platform.ide.internal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/ml/CategoricalFeature$OtherCategoryMapper;", "Lcom/intellij/internal/ml/FeatureMapper;", "name", "", "knownCategories", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "getFeatureName", "asArrayValue", "", "value", "", "intellij.platform.ide.internal"})
    private static final class OtherCategoryMapper
    implements FeatureMapper {
        @NotNull
        private final String name;
        @NotNull
        private final Set<String> knownCategories;

        public OtherCategoryMapper(@NotNull String name, @NotNull Set<String> knownCategories) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(knownCategories, (String)"knownCategories");
            this.name = name;
            this.knownCategories = knownCategories;
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return this.name;
        }

        @Override
        public double asArrayValue(@Nullable Object value) {
            return value == null || this.knownCategories.contains(value.toString()) ? 0.0 : 1.0;
        }
    }
}

