/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.ModelMetadataReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/ml/ResourcesModelMetadataReader;", "Lcom/intellij/internal/ml/ModelMetadataReader;", "metadataHolder", "Ljava/lang/Class;", "featuresDirectory", "", "<init>", "(Ljava/lang/Class;Ljava/lang/String;)V", "getMetadataHolder", "()Ljava/lang/Class;", "binaryFeatures", "floatFeatures", "categoricalFeatures", "allKnown", "featureOrderDirect", "", "extractVersion", "resourceContent", "fileName", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nResourcesModelMetadataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesModelMetadataReader.kt\ncom/intellij/internal/ml/ResourcesModelMetadataReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public class ResourcesModelMetadataReader
implements ModelMetadataReader {
    @NotNull
    private final Class<?> metadataHolder;
    @NotNull
    private final String featuresDirectory;

    public ResourcesModelMetadataReader(@NotNull Class<?> metadataHolder, @NotNull String featuresDirectory) {
        Intrinsics.checkNotNullParameter(metadataHolder, (String)"metadataHolder");
        Intrinsics.checkNotNullParameter((Object)featuresDirectory, (String)"featuresDirectory");
        this.metadataHolder = metadataHolder;
        this.featuresDirectory = featuresDirectory;
    }

    @NotNull
    protected final Class<?> getMetadataHolder() {
        return this.metadataHolder;
    }

    @Override
    @NotNull
    public String binaryFeatures() {
        return this.resourceContent("binary.json");
    }

    @Override
    @NotNull
    public String floatFeatures() {
        return this.resourceContent("float.json");
    }

    @Override
    @NotNull
    public String categoricalFeatures() {
        return this.resourceContent("categorical.json");
    }

    @Override
    @NotNull
    public String allKnown() {
        return this.resourceContent("all_features.json");
    }

    @Override
    @NotNull
    public List<String> featureOrderDirect() {
        return StringsKt.lines((CharSequence)this.resourceContent("features_order.txt"));
    }

    @Override
    @Nullable
    public String extractVersion() {
        String versionFile = "version.txt";
        if (this.metadataHolder.getClassLoader().getResource(this.featuresDirectory + "/" + versionFile) != null) {
            return ((Object)StringsKt.trim((CharSequence)this.resourceContent(versionFile))).toString();
        }
        URL uRL = this.metadataHolder.getClassLoader().getResource(this.featuresDirectory + "/binary.json");
        if (uRL == null) {
            return null;
        }
        URL resource = uRL;
        String string = resource.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFile(...)");
        String result = StringsKt.substringAfterLast((String)StringsKt.substringBeforeLast((String)string, (String)".jar!", (String)""), (String)"-", (String)"");
        return StringsKt.isBlank((CharSequence)result) ? null : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resourceContent(String fileName) {
        InputStream fileStream;
        String resource = this.featuresDirectory + "/" + fileName;
        InputStream inputStream = this.metadataHolder.getClassLoader().getResourceAsStream(resource);
        if (inputStream == null) {
            throw new InconsistentMetadataException("Metadata file not found: " + resource + ". Resources holder: " + this.metadataHolder.getName());
        }
        Closeable closeable = fileStream = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }
}

