/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.rulerguide;

import com.intellij.internal.rulerguide.BasePreferences;
import com.intellij.internal.rulerguide.ComponentBounds;
import com.intellij.internal.rulerguide.ComponentBoundsFinder;
import com.intellij.internal.rulerguide.SneakyGraphics2D;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

final class RulerGuidePainter
extends AbstractPainter
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RulerGuidePainter.class);
    private final ComponentBoundsFinder finder = new ComponentBoundsFinder();
    private final AtomicReference<JRootPane> rootPane = new AtomicReference();
    private Disposable disposable;

    RulerGuidePainter(Disposable parent) {
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    private void installPainter(@NotNull JRootPane rootPane) {
        Component glassPane;
        if (rootPane == null) {
            RulerGuidePainter.$$$reportNull$$$0(0);
        }
        if ((glassPane = rootPane.getGlassPane()) instanceof IdeGlassPane) {
            assert (this.disposable == null) : "Disposable is not null";
            this.disposable = Disposer.newDisposable((String)"Ruler Guide");
            Disposer.register((Disposable)this, (Disposable)this.disposable);
            ((IdeGlassPane)glassPane).addPainter(glassPane, (Painter)this, this.disposable);
        } else {
            ThiefGlassPane glass = new ThiefGlassPane(glassPane);
            rootPane.setGlassPane(glass);
            glass.setVisible(true);
            glass.revalidate();
        }
    }

    public void removePainter() {
        this.finder.dispose();
        Optional.ofNullable(this.rootPane.getAndSet(null)).ifPresent(this::removePainter);
    }

    private void removePainter(@NotNull JRootPane rootPane) {
        Component glassPane;
        if (rootPane == null) {
            RulerGuidePainter.$$$reportNull$$$0(1);
        }
        if ((glassPane = rootPane.getGlassPane()) instanceof IdeGlassPane) {
            Disposer.dispose((Disposable)this.disposable);
            this.disposable = null;
            glassPane.repaint();
        } else if (glassPane instanceof ThiefGlassPane) {
            Component realGlassPane = ((ThiefGlassPane)glassPane).getRealGlassPane();
            rootPane.setGlassPane(realGlassPane);
            realGlassPane.revalidate();
        } else {
            Disposer.dispose((Disposable)this.disposable);
            this.disposable = null;
            LOG.warn("GlassPane may be only IdeGlassPane or ThiefGlassPane ancestor but found " + String.valueOf(glassPane));
        }
    }

    public void repaint(Component eventSource, Point eventPoint) {
        JRootPane oldRootPane;
        JRootPane newRootPane = SwingUtilities.getRootPane(eventSource);
        if (newRootPane != (oldRootPane = this.rootPane.getAndSet(newRootPane))) {
            Optional.ofNullable(oldRootPane).ifPresent(this::removePainter);
            Optional.ofNullable(newRootPane).ifPresent(this::installPainter);
        }
        if (newRootPane != null) {
            Point point = SwingUtilities.convertPoint(eventSource, eventPoint, newRootPane);
            this.finder.update(newRootPane, point);
            Component glassPane = newRootPane.getGlassPane();
            if (glassPane instanceof IdeGlassPane) {
                this.setNeedsRepaint(true, glassPane);
            } else if (glassPane instanceof ThiefGlassPane) {
                glassPane.repaint();
            } else {
                throw new IllegalStateException("GlassPane maybe only IdeGlassPane or ThiefGlassPane but found " + String.valueOf(glassPane));
            }
        }
    }

    public boolean needsRepaint() {
        return this.finder.getLastResult() != null;
    }

    public void executePaint(@NotNull Component component, @NotNull Graphics2D g) {
        Window window;
        if (component == null) {
            RulerGuidePainter.$$$reportNull$$$0(2);
        }
        if (g == null) {
            RulerGuidePainter.$$$reportNull$$$0(3);
        }
        int y = 0;
        if (SystemInfoRt.isMac && (window = ComponentUtil.getWindow((Component)component)) != null && window.getType() == Window.Type.NORMAL) {
            JRootPane pane = (JRootPane)ComponentUtil.getParentOfType(JRootPane.class, (Component)component);
            ProjectFrameHelper helper = ProjectFrameHelper.getFrameHelper((Window)window);
            if (!(helper != null && helper.isInFullScreen() || pane == null)) {
                y -= UIUtil.getTransparentTitleBarHeight((JRootPane)pane);
            }
        }
        Graphics2D g2d = (Graphics2D)g.create(0, y, component.getWidth(), component.getHeight() - y);
        GraphicsUtil.setupAntialiasing((Graphics)g2d, (boolean)false, (boolean)false);
        ComponentBoundsFinder.Result result = this.finder.getLastResult();
        ComponentBounds pivot = null;
        for (ComponentBounds bounds : result.getBounds()) {
            if (!bounds.contains(result.getPoint())) continue;
            pivot = bounds;
            g2d.setColor(BasePreferences.BACKGROUND_COLOR);
            g2d.fillRect(pivot.x, pivot.y, pivot.width, pivot.height);
            RulerGuidePainter.paintBaselines(pivot, g2d);
            break;
        }
        for (ComponentBounds bounds : result.getBounds()) {
            g2d.setColor(BasePreferences.BACKGROUND_COLOR);
            if (pivot == null || pivot == bounds) continue;
            Point baselineOtherPoint = new Point(bounds.x + bounds.verticalBaseline, bounds.y + bounds.horizontalBaseline);
            Point baselinePivotPoint = new Point(pivot.x + pivot.verticalBaseline, pivot.y + pivot.horizontalBaseline);
            int verticalOffset = Math.abs(baselineOtherPoint.x - baselinePivotPoint.x);
            int horizontalOffset = Math.abs(baselineOtherPoint.y - baselinePivotPoint.y);
            if (verticalOffset == 0 || horizontalOffset == 0) {
                g2d.setColor(BasePreferences.FINE_COLOR);
            } else {
                if (verticalOffset > BasePreferences.getAllowedGap() && horizontalOffset > BasePreferences.getAllowedGap()) continue;
                g2d.setColor(BasePreferences.ERROR_COLOR);
            }
            g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        g2d.dispose();
    }

    private static void paintBaselines(ComponentBounds bounds, Graphics2D g2d) {
        Rectangle clipBounds = g2d.getClipBounds();
        Point location = bounds.getLocation();
        g2d.setColor(BasePreferences.COMPONENT_COLOR);
        g2d.drawLine(clipBounds.x, location.y + bounds.height, clipBounds.x + clipBounds.width, location.y + bounds.height);
        int hbaseline = bounds.horizontalBaseline;
        if (hbaseline >= 0) {
            g2d.setColor(BasePreferences.BASE_COLOR);
            g2d.drawLine(clipBounds.x, location.y + hbaseline, clipBounds.x + clipBounds.width, location.y + hbaseline);
        }
        g2d.setColor(BasePreferences.COMPONENT_COLOR);
        g2d.drawLine(location.x, clipBounds.y, location.x, clipBounds.y + clipBounds.height);
        int vbaseline = bounds.verticalBaseline;
        if (vbaseline >= 0) {
            g2d.setColor(BasePreferences.BASE_COLOR);
            g2d.drawLine(location.x + vbaseline, clipBounds.y, location.x + vbaseline, clipBounds.y + clipBounds.height);
        }
    }

    public void dispose() {
        this.removePainter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/rulerguide/RulerGuidePainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installPainter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removePainter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executePaint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class ThiefGlassPane
    extends JComponent {
        private final Component realGlassPane;

        private ThiefGlassPane(Component realGlassPane) {
            this.realGlassPane = realGlassPane;
            this.setOpaque(false);
        }

        public Component getRealGlassPane() {
            return this.realGlassPane;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (g instanceof SneakyGraphics2D || this.isJBPopupMenu()) {
                return;
            }
            RulerGuidePainter.this.executePaint(SwingUtilities.getRoot(this), (Graphics2D)g);
        }

        private boolean isJBPopupMenu() {
            Container contentPane = SwingUtilities.getRootPane(this).getContentPane();
            return contentPane.getComponentCount() == 1 && contentPane.getComponent(0) instanceof JBPopupMenu;
        }
    }
}

