/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.l10n.LocalizationUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/LocalizationUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "LOCALES", "", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "selectedLanguage", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "selectedRegion", "Lcom/intellij/ide/Region;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getGroup", "intellij.platform.ide.internal"})
public final class LocalizationUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    private final List<String> LOCALES;
    @NotNull
    private final EventLogGroup GROUP;
    @NotNull
    private final EventId1<String> selectedLanguage;
    @NotNull
    private final EventId1<Region> selectedRegion;

    public LocalizationUsageCollector() {
        Object[] objectArray = new String[]{"am", "ar", "as", "az", "bn", "cs", "da", "de", "el", "en", "es", "fa", "fr", "gu", "ha", "hi", "hu", "ig", "in", "it", "ja", "kk", "kn", "ko", "ml", "mr", "my", "nb", "ne", "nl", "nn", "no", "or", "pa", "pl", "pt", "ro", "ru", "rw", "sd", "si", "so", "sv", "ta", "te", "th", "tr", "uk", "ur", "uz", "vi", "yo", "zh", "zh-CN", "zu", "other"};
        this.LOCALES = CollectionsKt.listOf((Object[])objectArray);
        this.GROUP = new EventLogGroup("localization.info", 5, null, 4, null);
        this.selectedLanguage = this.GROUP.registerEvent("selected.language", (EventField)new StringEventField.ValidatedByAllowedValues("value", this.LOCALES));
        this.selectedRegion = this.GROUP.registerEvent("selected.region", (EventField)EventFields.Enum$default((String)"value", Region.class, null, (int)4, null));
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        Set result = new LinkedHashSet();
        Locale locale = LocalizationUtil.getLocale$default((LocalizationUtil)LocalizationUtil.INSTANCE, (boolean)false, (int)1, null);
        String language = this.LOCALES.contains(locale.toLanguageTag()) ? locale.toLanguageTag() : (this.LOCALES.contains(locale.getLanguage()) ? locale.getLanguage() : "other");
        result.add(this.selectedLanguage.metric((Object)language));
        Region region = RegionSettings.getRegion();
        Intrinsics.checkNotNullExpressionValue((Object)region, (String)"getRegion(...)");
        Region region2 = region;
        result.add(this.selectedRegion.metric((Object)region2));
        return result;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }
}

