/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.project;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/project/IndexableFilesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "ALL_INDEXABLE_FILES", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "ALL_NON_INDEXABLE_FILES", "CONTENT_INDEXABLE_FILES", "getGroup", "collect", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "countNonIndexableFiles", "intellij.platform.ide.internal"})
public final class IndexableFilesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("project.indexable.files", 4, null, 4, null);
    @NotNull
    private final EventId1<Integer> ALL_INDEXABLE_FILES = this.GROUP.registerEvent("all.indexable.files", (EventField)EventFields.Int((String)"count"));
    @NotNull
    private final EventId1<Integer> ALL_NON_INDEXABLE_FILES = this.GROUP.registerEvent("all.non.indexable.files", (EventField)EventFields.Int((String)"count"));
    @NotNull
    private final EventId1<Integer> CONTENT_INDEXABLE_FILES = this.GROUP.registerEvent("content.indexable.files", (EventField)EventFields.Int((String)"count"));

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @Nullable
    public Object collect(@NotNull Project project, @NotNull Continuation<? super Set<MetricEvent>> $completion) {
        CoroutineContext context = $completion.getContext();
        Ref.IntRef allIndexableFiles = new Ref.IntRef();
        Ref.IntRef inContentIndexableFiles = new Ref.IntRef();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        int nonIndexableFiles = this.countNonIndexableFiles(project);
        FileBasedIndex.getInstance().iterateIndexableFiles(arg_0 -> IndexableFilesCollector.collect$lambda$0(context, fileIndex, inContentIndexableFiles, allIndexableFiles, arg_0), project, null);
        Object[] objectArray = new MetricEvent[]{this.ALL_INDEXABLE_FILES.metric((Object)Boxing.boxInt((int)StatisticsUtil.roundToPowerOfTwo((int)allIndexableFiles.element))), this.ALL_NON_INDEXABLE_FILES.metric((Object)Boxing.boxInt((int)StatisticsUtil.roundToPowerOfTwo((int)nonIndexableFiles))), this.CONTENT_INDEXABLE_FILES.metric((Object)Boxing.boxInt((int)StatisticsUtil.roundToPowerOfTwo((int)inContentIndexableFiles.element)))};
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    private final int countNonIndexableFiles(Project project) {
        Ref.IntRef allNonIndexableFiles = new Ref.IntRef();
        FileBasedIndex.getInstance().iterateNonIndexableFiles(project, VirtualFileFilter.ALL, arg_0 -> IndexableFilesCollector.countNonIndexableFiles$lambda$0(allNonIndexableFiles, arg_0));
        return allNonIndexableFiles.element;
    }

    private static final Unit collect$lambda$0$0(VirtualFile $fileOrDir, ProjectFileIndex $fileIndex, Ref.IntRef $inContentIndexableFiles, Ref.IntRef $allIndexableFiles) {
        if ($fileOrDir.isValid() && !$fileOrDir.isDirectory() && !$fileIndex.isExcluded($fileOrDir)) {
            int n;
            if ($fileIndex.isInContent($fileOrDir)) {
                n = $inContentIndexableFiles.element;
                $inContentIndexableFiles.element = n + 1;
            }
            n = $allIndexableFiles.element;
            $allIndexableFiles.element = n + 1;
        }
        return Unit.INSTANCE;
    }

    private static final boolean collect$lambda$0(CoroutineContext $context, ProjectFileIndex $fileIndex, Ref.IntRef $inContentIndexableFiles, Ref.IntRef $allIndexableFiles, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        if (!JobKt.isActive((CoroutineContext)$context)) {
            return false;
        }
        ActionsKt.runReadAction(() -> IndexableFilesCollector.collect$lambda$0$0(fileOrDir, $fileIndex, $inContentIndexableFiles, $allIndexableFiles));
        return true;
    }

    private static final boolean countNonIndexableFiles$lambda$0(Ref.IntRef $allNonIndexableFiles, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = $allNonIndexableFiles.element;
        $allNonIndexableFiles.element = n + 1;
        return true;
    }
}

