/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FloatEventField;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import java.awt.Font;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/FontSizeInfoUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "FONT_NAME", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "FONT_SIZE", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "FONT_SIZE_2D", "Lcom/intellij/internal/statistic/eventLog/events/FloatEventField;", "LINE_SPACING", "FONT_SIZE_STRING", "FONT_VARIANTS", "Lcom/intellij/internal/statistic/eventLog/events/StringListEventField;", "UI_FONT", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "", "PRESENTATION_MODE_FONT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "EDITOR_FONT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "IDE_EDITOR_FONT", "CONSOLE_FONT", "QUICK_DOC_FONT", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "intellij.platform.ide.internal"})
public final class FontSizeInfoUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("ui.fonts", 7, null, 4, null);
    @NotNull
    private final StringEventField FONT_NAME;
    @NotNull
    private final IntEventField FONT_SIZE;
    @NotNull
    private final FloatEventField FONT_SIZE_2D;
    @NotNull
    private final FloatEventField LINE_SPACING;
    @NotNull
    private final StringEventField FONT_SIZE_STRING;
    @NotNull
    private final StringListEventField FONT_VARIANTS;
    @NotNull
    private final EventId3<String, Integer, Float> UI_FONT;
    @NotNull
    private final EventId1<Integer> PRESENTATION_MODE_FONT;
    @NotNull
    private final VarargEventId EDITOR_FONT;
    @NotNull
    private final VarargEventId IDE_EDITOR_FONT;
    @NotNull
    private final VarargEventId CONSOLE_FONT;
    @NotNull
    private final EventId1<String> QUICK_DOC_FONT;

    public FontSizeInfoUsageCollector() {
        Object[] objectArray = new String[]{"Monospaced", "Menlo", "DejaVu_Sans_Mono", ".SFNSText-Regular", "Fira_Code", "Lucida_Grande", "Source_Code_Pro", "Segoe_UI", "Ubuntu", ".SF_NS_Text", "Consolas", "Noto_Sans_Regular", "Microsoft_YaHei", "Fira_Code_Retina", "Cantarell_Regular", "Microsoft_YaHei_UI", "Monaco", "Noto_Sans", "Dialog.plain", "Fira_Code_Medium", "Courier_New", "Tahoma", "Hack", "DejaVu_Sans", "Ubuntu_Mono", "Droid_Sans_Mono", "Dialog", "Inconsolata", "Malgun_Gothic", "Cantarell", "DialogInput", "Yu_Gothic_UI_Regular", "Roboto", "Liberation_Mono", "Lucida_Console", "D2Coding", "Lucida_Sans_Typewriter", "Fira_Code_Light", "Droid_Sans", "Verdana", "Arial", "Roboto_Mono", "Segoe_UI_Semibold", "SF_Mono", "Droid_Sans_Mono_Slashed", "LucidaGrande", "Operator_Mono", "Ayuthaya", "Hasklig", "Iosevka", "Andale_Mono", "Anonymous_Pro", "Anonymous_Pro_for_Powerline", "D2Coding_ligature", "Dank_Mono", "DejaVu_Sans_Mono_for_Powerline", "Fantasque_Sans_Mono", "Fira_Mono_for_Powerline", "Hack_Nerd_Font", "IBM_Plex_Mono", "Meslo_LG_L_DZ_for_Powerline", "Meslo_LG_M_for_Powerline", "Meslo_LG_S_for_Powerline", "Microsoft_YaHei_Mono", "Noto_Mono_for_Powerline", "Noto_Sans_Mono", "PT_Mono", "PragmataPro", "SourceCodePro+Powerline+Awesome_Regular", "Source_Code_Pro_Semibold", "Source_Code_Pro_for_Powerline", "Ubuntu_Mono_derivative_Powerline", "YaHei_Consolas_Hybrid", "mononoki", "Bitstream_Vera_Sans_Mono", "Comic_Sans_MS", "Courier_10_Pitch", "Cousine", "2Coding_ligature", "Droid_Sans_Mono_Dotted", "Inconsolata-dz", "Input", "Input_Mono", "Meslo_LG_M_DZ_for_Powerline", "Migu_2M", "Monoid", "Operator_Mono_Book", "Operator_Mono_Lig", "Operator_Mono_Medium", "Abadi_MT_Condensed_Extra_Bold", "Al_Bayan", "Meiryo", "Microsoft_JhengHei", "Microsoft_Yahei_UI", "SansSerif", "Ubuntu_Light", "JetBrains_Mono", ".AppleSystemUIFont", ".SFNS-Regular", "Inter", "Monaspace_Neon", "Monaspace_Neon_Var", "Cascadia_Code", "Comic_Mono", "Agave", "Monocraft", "CozetteVector"};
        this.FONT_NAME = EventFields.String((String)"font_name", (List)CollectionsKt.arrayListOf((Object[])objectArray));
        this.FONT_SIZE = EventFields.Int((String)"font_size");
        this.FONT_SIZE_2D = EventFields.Float$default((String)"font_size_2d", null, (int)2, null);
        this.LINE_SPACING = EventFields.Float$default((String)"line_spacing", null, (int)2, null);
        objectArray = new String[]{"X_SMALL", "X_LARGE", "XX_SMALL", "XX_LARGE", "SMALL", "MEDIUM", "LARGE"};
        this.FONT_SIZE_STRING = EventFields.String((String)"font_size", (List)CollectionsKt.arrayListOf((Object[])objectArray));
        this.FONT_VARIANTS = EventFields.StringListValidatedByInlineRegexp$default((String)"font_variants", (String)"ss\\d\\d|cv\\d\\d|case|clig|dlig|hlig|onum|salt|zero", null, (int)4, null);
        this.UI_FONT = this.GROUP.registerEvent("UI", (EventField)this.FONT_NAME, (EventField)this.FONT_SIZE, (EventField)this.FONT_SIZE_2D);
        this.PRESENTATION_MODE_FONT = this.GROUP.registerEvent("Presentation.mode", (EventField)this.FONT_SIZE);
        objectArray = new EventField[]{this.FONT_NAME, this.FONT_SIZE, this.FONT_SIZE_2D, this.LINE_SPACING};
        this.EDITOR_FONT = this.GROUP.registerVarargEvent("Editor", (EventField[])objectArray);
        objectArray = new EventField[]{this.FONT_NAME, this.FONT_SIZE, this.FONT_SIZE_2D, this.LINE_SPACING, this.FONT_VARIANTS};
        this.IDE_EDITOR_FONT = this.GROUP.registerVarargEvent("IDE.editor", (EventField[])objectArray);
        objectArray = new EventField[]{this.FONT_NAME, this.FONT_SIZE, this.FONT_SIZE_2D, this.LINE_SPACING};
        this.CONSOLE_FONT = this.GROUP.registerVarargEvent("Console", (EventField[])objectArray);
        this.QUICK_DOC_FONT = this.GROUP.registerEvent("QuickDoc", (EventField)this.FONT_SIZE_STRING);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        String quickDocFontSize;
        Object appPrefs;
        Object object;
        Font font;
        Object object2;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        UISettings ui = UISettings.Companion.getInstance();
        if (!ui.getOverrideLafFonts()) {
            object2 = LafManager.getInstance();
            LafManagerImpl lafManagerImpl = object2 instanceof LafManagerImpl ? (LafManagerImpl)object2 : null;
            font = lafManagerImpl != null ? lafManagerImpl.getDefaultFont() : null;
        } else {
            font = null;
        }
        Font defaultFont = font;
        object2 = new MetricEvent[2];
        Object object3 = defaultFont;
        if (object3 == null || (object3 = ((Font)object3).getFamily()) == null) {
            object3 = ui.getFontFace();
        }
        Font font2 = defaultFont;
        Font font3 = defaultFont;
        object2[0] = this.UI_FONT.metric(object3, (Object)(font2 != null ? font2.getSize() : ui.getFontSize()), (Object)Float.valueOf(font3 != null ? font3.getSize2D() : ui.getFontSize2D()));
        object2[1] = this.PRESENTATION_MODE_FONT.metric((Object)((int)UISettingsUtils.Companion.with(ui).getPresentationModeFontSize()));
        Set usages = SetsKt.mutableSetOf((Object[])object2);
        if (!scheme.isUseAppFontPreferencesInEditor()) {
            object2 = usages;
            object = new EventPair[]{this.FONT_NAME.with((Object)scheme.getEditorFontName()), this.FONT_SIZE.with((Object)scheme.getEditorFontSize()), this.FONT_SIZE_2D.with((Object)Float.valueOf(scheme.getEditorFontSize2D())), this.LINE_SPACING.with((Object)Float.valueOf(scheme.getLineSpacing()))};
            object2.add(this.EDITOR_FONT.metric((EventPair[])object));
        } else {
            FontPreferences fontPreferences = AppEditorFontOptions.getInstance().getFontPreferences();
            Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"getFontPreferences(...)");
            appPrefs = fontPreferences;
            object = usages;
            EventPair[] eventPairArray = new EventPair[5];
            eventPairArray[0] = this.FONT_NAME.with((Object)appPrefs.getFontFamily());
            eventPairArray[1] = this.FONT_SIZE.with((Object)appPrefs.getSize(appPrefs.getFontFamily()));
            eventPairArray[2] = this.FONT_SIZE_2D.with((Object)Float.valueOf(appPrefs.getSize2D(appPrefs.getFontFamily())));
            eventPairArray[3] = this.LINE_SPACING.with((Object)Float.valueOf(appPrefs.getLineSpacing()));
            Set set = appPrefs.getCharacterVariants();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getCharacterVariants(...)");
            eventPairArray[4] = this.FONT_VARIANTS.with((Object)CollectionsKt.toList((Iterable)set));
            object.add(this.IDE_EDITOR_FONT.metric(eventPairArray));
        }
        if (!scheme.isUseEditorFontPreferencesInConsole()) {
            appPrefs = usages;
            object = new EventPair[]{this.FONT_NAME.with((Object)scheme.getConsoleFontName()), this.FONT_SIZE.with((Object)scheme.getConsoleFontSize()), this.FONT_SIZE_2D.with((Object)Float.valueOf(scheme.getConsoleFontSize2D())), this.LINE_SPACING.with((Object)Float.valueOf(scheme.getConsoleLineSpacing()))};
            appPrefs.add(this.CONSOLE_FONT.metric((EventPair[])object));
        }
        if ((quickDocFontSize = PropertiesComponent.getInstance().getValue("quick.doc.font.size.v3")) != null) {
            ((Collection)usages).add(this.QUICK_DOC_FONT.metric((Object)quickDocFontSize));
        }
        return usages;
    }
}

