/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.validation;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

final class TestMacMessagesAction
extends AnAction {
    private int num = 1;
    private String TITLE = "Title";
    private String MESSAGE = "Message";
    private String DONT_ASK_TEXT = "Do not ask me again";

    TestMacMessagesAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TestMacMessagesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            TestMacMessagesAction.$$$reportNull$$$0(1);
        }
        final Project project = e.getProject();
        new DialogWrapper(project){
            {
                super(arg0);
                this.setSize(500, 500);
                this.setTitle("Dialog 1");
                this.init();
            }

            protected JComponent createCenterPanel() {
                JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(5));
                JLabel titleLabel = new JLabel("Title:");
                final JTextField titleField = new JTextField(TestMacMessagesAction.this.TITLE);
                Insets insets = titleField.getBorder().getBorderInsets(titleField);
                titleField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        TestMacMessagesAction.this.TITLE = titleField.getText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/validation/TestMacMessagesAction$1$1", "textChanged"));
                    }
                });
                titleLabel.setLabelFor(titleField);
                BorderLayoutPanel titlePanel = new BorderLayoutPanel(5, 5);
                titlePanel.add((Component)titleLabel, "West");
                titlePanel.add((Component)titleField, "Center");
                panel2.add((Component)titlePanel);
                JLabel messageLabel = new JLabel("Message:");
                final JTextArea messageArea = new JTextArea(TestMacMessagesAction.this.MESSAGE, 3, 30);
                messageArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        TestMacMessagesAction.this.MESSAGE = messageArea.getText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/validation/TestMacMessagesAction$1$2", "textChanged"));
                    }
                });
                messageLabel.setLabelFor(messageArea);
                panel2.add(TestMacMessagesAction.createMessagePanel(insets, messageLabel, messageArea));
                JLabel dontAskLabel = new JLabel("Don't ask text:");
                final JTextArea dontAskArea = new JTextArea(TestMacMessagesAction.this.DONT_ASK_TEXT, 3, 30);
                dontAskArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        TestMacMessagesAction.this.DONT_ASK_TEXT = dontAskArea.getText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/validation/TestMacMessagesAction$1$3", "textChanged"));
                    }
                });
                dontAskLabel.setLabelFor(dontAskArea);
                panel2.add(TestMacMessagesAction.createMessagePanel(insets, dontAskLabel, dontAskArea));
                JButton yesNoCancel = new JButton("Show YesNoCancel Alert");
                yesNoCancel.addActionListener(event -> Messages.showYesNoCancelDialog((String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE, (String)"YesText", (String)"NoText", (String)"CancelText", null));
                panel2.add(yesNoCancel);
                JButton yesNo1 = new JButton("Show YesNo Alert");
                yesNo1.addActionListener(event -> Messages.showYesNoDialog((Project)null, (String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE, (Icon)Messages.getQuestionIcon()));
                panel2.add(yesNo1);
                JButton yesNo2 = new JButton("Show YesNo Alert with DoNotAsk");
                yesNo2.addActionListener(event -> ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)TestMacMessagesAction.this.TITLE, (String)TestMacMessagesAction.this.MESSAGE).icon(Messages.getQuestionIcon())).doNotAsk(TestMacMessagesAction.createDoNotAskOption(TestMacMessagesAction.this.DONT_ASK_TEXT))).ask(project));
                panel2.add(yesNo2);
                JButton ok = new JButton("Show Ok Alert");
                ok.addActionListener(event -> Messages.showInfoMessage((Component)ok, (String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE));
                panel2.add(ok);
                JButton warn = new JButton("Show Warning Alert");
                warn.addActionListener(event -> Messages.showWarningDialog((Project)null, (String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE));
                panel2.add(warn);
                JButton error = new JButton("Show Error Alert");
                error.addActionListener(event -> Messages.showErrorDialog((Project)null, (String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE));
                panel2.add(error);
                JButton help = new JButton("Show Alert with help button");
                help.addActionListener(event -> ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)TestMacMessagesAction.this.TITLE, (String)TestMacMessagesAction.this.MESSAGE).help("my.help.id")).doNotAsk(TestMacMessagesAction.createDoNotAskOption(TestMacMessagesAction.this.DONT_ASK_TEXT))).show(project));
                panel2.add(help);
                TestMacMessagesAction.this.alertWithButtons(panel2, new String[]{"Button1", "Cancel", "Button3", "Button4", "Button5"}, 1);
                TestMacMessagesAction.this.alertWithButtons(panel2, new String[]{"Button1", "Button2", "Button3", "Cancel", "Button5"}, 2);
                TestMacMessagesAction.this.alertWithButtons(panel2, new String[]{"Button1", "Button2", "Button3", "Button4", "Cancel"}, 4);
                JButton dialogAlert = new JButton("Dialog -> YesNo Alert");
                dialogAlert.addActionListener(event -> new DialogWrapper(project){
                    {
                        this.setSize(400, 400);
                        this.setTitle("Dialog 2");
                        this.init();
                    }

                    protected JComponent createCenterPanel() {
                        final JButton b = new JButton("Click me again " + TestMacMessagesAction.this.num);
                        ++TestMacMessagesAction.this.num;
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e1) {
                                this.getWindow().setVisible(false);
                                Messages.showYesNoDialog((Component)b, (String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE, (Icon)Messages.getQuestionIcon());
                            }
                        });
                        return b;
                    }
                }.show());
                panel2.add(dialogAlert);
                JButton changeTitleDialog = new JButton("Dialog(dynamic title) -> Alert");
                changeTitleDialog.addActionListener(event -> new DialogWrapper(project){
                    {
                        this.setSize(400, 400);
                        this.setTitle("Dialog [0]");
                        this.init();
                    }

                    protected JComponent createCenterPanel() {
                        final JButton b = new JButton("Run");
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e1) {
                                this.setTitle("Dialog [0]");
                                Thread thread = new Thread(() -> {
                                    try {
                                        int i = 0;
                                        while (i < 300) {
                                            int ii = i++;
                                            SwingUtilities.invokeLater(() -> this.setTitle("Dialog [" + ii + "]"));
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }, "Dialog [0]");
                                thread.start();
                                Messages.showYesNoDialog((Component)b, (String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE, (Icon)Messages.getQuestionIcon());
                                if (thread.isAlive()) {
                                    thread.interrupt();
                                }
                            }
                        });
                        return b;
                    }
                }.show());
                panel2.add(changeTitleDialog);
                JButton secondDialog = new JButton("Dialog -> Alert || Modal Dialog (~5sec)");
                secondDialog.addActionListener(event -> {
                    new Thread(() -> SwingUtilities.invokeLater(() -> {
                        DialogWrapper dialog2 = new DialogWrapper(this, project){
                            {
                                this.setSize(400, 400);
                                this.setTitle("Dialog");
                                this.init();
                            }

                            protected JComponent createCenterPanel() {
                                return new JCheckBox("Check me!");
                            }
                        };
                        dialog2.setModal(true);
                        dialog2.show();
                    }), secondDialog.getText()).start();
                    Messages.showYesNoDialog((Component)secondDialog, (String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE, (Icon)Messages.getQuestionIcon());
                });
                panel2.add(secondDialog);
                JButton secondAlert = new JButton("Dialog -> Alert || Alert (~5sec)");
                secondAlert.addActionListener(event -> {
                    new Thread(() -> {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(() -> Messages.showInfoMessage((String)"Message", (String)"Title"));
                    }, secondAlert.getText()).start();
                    Messages.showYesNoDialog((Component)secondAlert, (String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE, (Icon)Messages.getQuestionIcon());
                });
                panel2.add(secondAlert);
                JButton html = new JButton("Show Alert with HTML content");
                html.addActionListener(event -> Messages.showDialog((String)"<html>Message <a>message</a> message<br>test <b>test</b> test<br>&nbsp;&nbsp;&nbsp;foo &lt;&gt;&amp;&#39;&quot; foo</html>", (String)"<html>Title <b>AA</b></html>", (String[])new String[]{"Y&es", "<html>Zzz...</html>", "Cancel"}, (int)0, null, (DoNotAskOption)new DoNotAskOption(this){

                    public boolean isToBeShown() {
                        return false;
                    }

                    public void setToBeShown(boolean toBeShown, int exitCode) {
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return false;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        return "<html>Delete branch:</br>EE-F1-0A</html>";
                    }
                }));
                panel2.add(html);
                JButton decompiler = new JButton("Decompiler");
                decompiler.addActionListener(event -> Messages.showDialog((Component)decompiler, (String)"IMPORTANT: BY ACCESSING AND USING JETBRAINS DECOMPILER, YOU AGREE TO THE CERTAIN TERMS AND CONDITIONS SET FORTH IN THE END-USER LICENSE AGREEMENT AND QUOTED BELOW. IF YOU DO NOT AGREE WITH THESE TERMS OR CONDITIONS, DO NOT ACCESS OR USE JETBRAINS DECOMPILER. The Software includes decompiling functionality (\"\"JetBrains Decompiler\"\") that enables reproducing source code from the original binary code. Licensee acknowledges that binary code and source code might be protected by copyright and trademark laws. Before using JetBrains Decompiler, Licensee should make sure that decompilation of binary code is not prohibited by the applicable license agreement (except to the extent that Licensee may be expressly permitted under applicable law) or that Licensee has obtained permission to decompile the binary code from the copyright owner. Using JetBrains Decompiler is entirely optional. Licensor does neither encourage nor condone the use of JetBrains Decompiler, and disclaims any liability for Licensee's use of  JetBrains Decompiler in violation of applicable laws.", (String)"Decompiler Legal Notice \u2014 Accept", (String[])new String[]{"Yes", "No"}, (int)0, (Icon)AllIcons.General.Tip));
                panel2.add(decompiler);
                JButton progress = new JButton("Progress");
                progress.addActionListener(event -> {
                    if (Messages.showYesNoDialog((String)"Continue?", (String)TestMacMessagesAction.this.TITLE, null) != 0) {
                        return;
                    }
                    Runnable runnable = () -> {
                        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                        Semaphore done = new Semaphore();
                        done.down();
                        ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            try {
                                int count = new Random(System.currentTimeMillis()).nextInt(10);
                                indicator.setText("Count: " + count);
                                for (int i = 0; i < count; ++i) {
                                    Thread.sleep(1000L);
                                    indicator.setText("Count: " + i + "/" + count);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                done.up();
                            }
                        });
                        while (!done.waitFor(1000L) && !indicator.isCanceled()) {
                        }
                        ApplicationManager.getApplication().invokeAndWait(() -> Messages.showInfoMessage((String)"Finish11111", (String)"Title"), ModalityState.any());
                    };
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, "Progress", true, null, (JComponent)progress);
                    Messages.showInfoMessage((String)"Finish", (String)TestMacMessagesAction.this.TITLE);
                });
                panel2.add(progress);
                if (project != null) {
                    JButton popupButton = new JButton("Popup");
                    popupButton.addActionListener(event -> {
                        NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel();
                        JTextField nameField = contentPanel.getTextField();
                        JBPopup popup = NewItemPopupUtil.createNewItemPopup((String)IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), (JComponent)contentPanel, (JComponent)nameField);
                        contentPanel.setApplyAction(_event -> Messages.showYesNoCancelDialog((String)TestMacMessagesAction.this.MESSAGE, (String)TestMacMessagesAction.this.TITLE, (String)"YesText", (String)"NoText", (String)"CancelText", null));
                        popup.showCenteredInCurrentWindow(project);
                    });
                    panel2.add(popupButton);
                }
                return panel2;
            }
        }.show();
    }

    @NotNull
    private static JPanel createMessagePanel(Insets insets, JLabel messageLabel, JTextArea messageArea) {
        BorderLayoutPanel messagePanel = new BorderLayoutPanel(5, 5);
        messagePanel.add((Component)messageLabel, "West");
        JBScrollPane scrollPane = new JBScrollPane((Component)messageArea);
        scrollPane.setBorder((Border)new CompoundBorder(new LineBorder(UIUtil.getPanelBackground(), insets.top), scrollPane.getBorder()));
        messagePanel.add((Component)scrollPane, "Center");
        BorderLayoutPanel borderLayoutPanel = messagePanel;
        if (borderLayoutPanel == null) {
            TestMacMessagesAction.$$$reportNull$$$0(2);
        }
        return borderLayoutPanel;
    }

    @NotNull
    private static DoNotAskOption createDoNotAskOption(final @NotNull String text) {
        if (text == null) {
            TestMacMessagesAction.$$$reportNull$$$0(3);
        }
        return new DoNotAskOption(){

            public boolean isToBeShown() {
                return false;
            }

            public void setToBeShown(boolean toBeShown, int exitCode) {
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NlsContexts.Checkbox
            @NotNull
            public String getDoNotShowMessage() {
                String string = text;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/validation/TestMacMessagesAction$2", "getDoNotShowMessage"));
            }
        };
    }

    private void alertWithButtons(JPanel panel2, String[] buttons, int index) {
        JButton button2 = new JButton("Show Buttons with Cancel Alert");
        button2.addActionListener(event -> Messages.showDialog((Component)button2, (String)this.MESSAGE, (String)this.TITLE, (String[])buttons, (int)index, null));
        panel2.add(button2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/validation/TestMacMessagesAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/validation/TestMacMessagesAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessagePanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDoNotAskOption";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

