/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.performance.LatencyDistributionRecord;
import com.intellij.internal.performance.LatencyDistributionRecordKey;
import com.intellij.internal.statistic.collectors.fus.DataContextUtils;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ToolWindowCollector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import com.intellij.internal.statistic.utils.EventsRateWindowThrottle;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TypingEventsLogger
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("editor.typing", 10);
    private static final EnumEventField<EditorKind> EDITOR_KIND = EventFields.Enum((String)"editor_kind", EditorKind.class);
    private static final StringEventField TOOL_WINDOW = EventFields.StringValidatedByCustomRule((String)"toolwindow_id", ToolWindowCollector.ToolWindowUtilValidator.class);
    private static final VarargEventId TYPED = GROUP.registerVarargEvent("typed", new EventField[]{EDITOR_KIND, TOOL_WINDOW, EventFields.Language});
    private static final EventId TOO_MANY_EVENTS = GROUP.registerEvent("too.many.events");
    private static final IntEventField LATENCY_MAX = EventFields.Int((String)"latency_max_ms");
    private static final IntEventField LATENCY_90 = EventFields.Int((String)"latency_90_ms");
    private static final EventId3<Integer, Integer, FileType> LATENCY = GROUP.registerEvent("latency", (EventField)LATENCY_MAX, (EventField)LATENCY_90, (EventField)EventFields.FileType);
    private static final EventId2<Language, Language> TYPED_IN_INJECTED = GROUP.registerEvent("typed.in.injected.language", (EventField)EventFields.Language((String)"original_lang"), (EventField)EventFields.Language((String)"injected_lang"), "Logs typing when the first language is the original language and the second language is injected language. In case of multiple carets, logged for each caret individually");
    private static final EventId TOO_MANY_INJECTED_EVENTS = GROUP.registerEvent("too.many.injected.events");
    private static final EventsRateWindowThrottle ourThrottle = new EventsRateWindowThrottle(8000, 3600000L, System.currentTimeMillis());
    private static final EventsRateWindowThrottle ourInjectedThrottle = new EventsRateWindowThrottle(500, 3600000L, System.currentTimeMillis());

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logTypedInInjected(Project project, PsiFile originalFile, PsiFile injectedFile) {
        if (!StatisticsUploadAssistant.isCollectAllowedOrForced()) {
            return;
        }
        EventRateThrottleResult result = ourInjectedThrottle.tryPass(System.currentTimeMillis());
        if (result == EventRateThrottleResult.ACCEPT) {
            TYPED_IN_INJECTED.log(project, (Object)originalFile.getLanguage(), (Object)injectedFile.getLanguage());
        } else if (result == EventRateThrottleResult.DENY_AND_REPORT) {
            TOO_MANY_INJECTED_EVENTS.log(project);
        }
    }

    public static final class TypingLatencyReporter
    implements FileEditorManagerListener,
    LatencyListener {
        private LatencyDistributionRecord myLatencyRecord;
        private Editor myCurrentEditor;
        private VirtualFile myCurrentFile;

        public TypingLatencyReporter() {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(LatencyListener.TOPIC, (Object)this);
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                TypingLatencyReporter.$$$reportNull$$$0(0);
            }
            this.logCurrentLatency();
            FileEditor editor = event.getNewEditor();
            if (editor instanceof TextEditor) {
                this.myCurrentFile = event.getNewFile();
                this.myCurrentEditor = ((TextEditor)editor).getEditor();
                this.myLatencyRecord = new LatencyDistributionRecord(new LatencyDistributionRecordKey("FUS"));
            } else {
                this.myCurrentEditor = null;
                this.myLatencyRecord = null;
            }
        }

        private void logCurrentLatency() {
            if (this.myLatencyRecord != null && this.myLatencyRecord.getTotalLatency().getTotalLatency() > 0L) {
                LATENCY.log((Object)this.myLatencyRecord.getTotalLatency().getMaxLatency(), (Object)this.myLatencyRecord.getTotalLatency().percentile(90), (Object)this.myCurrentFile.getFileType());
            }
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                TypingLatencyReporter.$$$reportNull$$$0(1);
            }
            if (file == null) {
                TypingLatencyReporter.$$$reportNull$$$0(2);
            }
            if (file.equals(this.myCurrentFile)) {
                this.logCurrentLatency();
                this.myCurrentEditor = null;
                this.myLatencyRecord = null;
            }
        }

        public void recordTypingLatency(@NotNull Editor editor, String action2, long latencyMs) {
            if (editor == null) {
                TypingLatencyReporter.$$$reportNull$$$0(3);
            }
            if (editor == this.myCurrentEditor) {
                this.myLatencyRecord.update(action2, (int)latencyMs);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/TypingEventsLogger$TypingLatencyReporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileClosed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "recordTypingLatency";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class TypingEventsListener
    implements AnActionListener {
        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                TypingEventsListener.$$$reportNull$$$0(0);
            }
            if (!StatisticsUploadAssistant.isCollectAllowedOrForced()) {
                return;
            }
            EventRateThrottleResult result = ourThrottle.tryPass(System.currentTimeMillis());
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (result == EventRateThrottleResult.ACCEPT) {
                Language fileLanguage;
                ToolWindow toolWindow;
                ArrayList<EventPair> pairs = new ArrayList<EventPair>(3);
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                if (editor != null) {
                    try {
                        pairs.add(EDITOR_KIND.with((Object)editor.getEditorKind()));
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                if ((toolWindow = (ToolWindow)PlatformDataKeys.TOOL_WINDOW.getData(dataContext)) != null) {
                    pairs.add(TOOL_WINDOW.with((Object)toolWindow.getId()));
                }
                if ((fileLanguage = DataContextUtils.getFileTypeLanguageByEditor((DataContext)dataContext)) != null) {
                    pairs.add(EventFields.Language.with((Object)fileLanguage));
                }
                TYPED.log(project, pairs);
            } else if (result == EventRateThrottleResult.DENY_AND_REPORT) {
                TOO_MANY_EVENTS.log(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/internal/statistic/collectors/fus/TypingEventsLogger$TypingEventsListener", "beforeEditorTyping"));
        }
    }
}

