/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.icons.AllIcons;
import com.intellij.internal.ui.AnimationPanelTestAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpinnerKt;
import com.intellij.ui.hover.HoverStateListener;
import com.intellij.util.Alarm;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.AnimationContext;
import com.intellij.util.animation.Animations;
import com.intellij.util.animation.CubicBezierEasing;
import com.intellij.util.animation.DoubleArrayFunction;
import com.intellij.util.animation.DoubleColorFunction;
import com.intellij.util.animation.Easing;
import com.intellij.util.animation.JBAnimator;
import com.intellij.util.animation.ShowHideAnimator;
import com.intellij.util.animation.components.BezierPainter;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\b\n\u000b\f\r\u000e\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "DemoPanel", "Options", "AnimationSettings", "FillPanel", "BezierEasingPanel", "SpringButtonPanel", "UpdateColorsOnHover", "RColors", "intellij.platform.ide.internal"})
public final class AnimationPanelTestAction
extends DumbAwareAction {
    public AnimationPanelTestAction() {
        super("Show Animation Panel");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        new DialogWrapper(project){
            private final BezierEasingPanel bezier;
            private final DemoPanel demo;
            {
                this.bezier = new BezierEasingPanel();
                Disposable disposable = this.getDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
                this.demo = new DemoPanel(disposable, (Function0<? extends Easing>)((Function0)new Function0<Easing>((Object)((Object)this.bezier)){

                    public final Easing invoke() {
                        return ((BezierEasingPanel)((Object)this.receiver)).getEasing();
                    }
                }));
                this.setTitle("Animation Panel Test Action");
                this.bezier.setBorder(new CompoundBorder((Border)JBUI.Borders.emptyRight((int)12), this.bezier.getBorder()));
                this.setResizable(true);
                this.init();
                this.getWindow().addWindowListener(new WindowAdapter(this){
                    final /* synthetic */ actionPerformed.1 this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void windowOpened(WindowEvent e) {
                        this.this$0.getDemo().load();
                        this.this$0.getWindow().removeWindowListener(this);
                    }
                });
            }

            public final BezierEasingPanel getBezier() {
                return this.bezier;
            }

            public final DemoPanel getDemo() {
                return this.demo;
            }

            protected OnePixelSplitter createCenterPanel() {
                OnePixelSplitter onePixelSplitter;
                OnePixelSplitter ops = onePixelSplitter = new OnePixelSplitter(false, 0.3f);
                boolean bl = false;
                ops.setFirstComponent((JComponent)((Object)this.bezier));
                ops.setSecondComponent((JComponent)((Object)this.demo));
                return onePixelSplitter;
            }

            protected Action[] createActions() {
                return new Action[0];
            }
        }.show();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001BE\u0012<\u0010\u0002\u001a8\u0012\u0004\u0012\u00020\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\u0004\b\f\u0010\rRG\u0010\u0002\u001a8\u0012\u0004\u0012\u00020\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$AnimationSettings;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "onStart", "Lkotlin/Function3;", "Lcom/intellij/internal/ui/AnimationPanelTestAction$Options;", "Ljavax/swing/JButton;", "Lkotlin/ParameterName;", "name", "customize", "Ljavax/swing/JLabel;", "info", "", "<init>", "(Lkotlin/jvm/functions/Function3;)V", "getOnStart", "()Lkotlin/jvm/functions/Function3;", "options", "intellij.platform.ide.internal"})
    @SourceDebugExtension(value={"SMAP\nAnimationPanelTestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationPanelTestAction.kt\ncom/intellij/internal/ui/AnimationPanelTestAction$AnimationSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,739:1\n1#2:740\n*E\n"})
    private static final class AnimationSettings
    extends BorderLayoutPanel {
        @NotNull
        private final Function3<Options, JButton, JLabel, Unit> onStart;
        @NotNull
        private final Options options;

        public AnimationSettings(@NotNull Function3<? super Options, ? super JButton, ? super JLabel, Unit> onStart) {
            Intrinsics.checkNotNullParameter(onStart, (String)"onStart");
            this.onStart = onStart;
            this.options = new Options();
            DialogPanel panel2 = BuilderKt.panel(arg_0 -> AnimationSettings._init_$lambda$0(this, arg_0));
            this.addToCenter((Component)panel2);
            this.addToBottom((Component)BuilderKt.panel(arg_0 -> AnimationSettings._init_$lambda$1(panel2, this, arg_0)));
        }

        @NotNull
        public final Function3<Options, JButton, JLabel, Unit> getOnStart() {
            return this.onStart;
        }

        private static final Unit _init_$lambda$0(AnimationSettings this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            $this$panel.row("Duration:", arg_0 -> AnimationSettings.lambda$0$0(this$0, arg_0));
            $this$panel.row("Period:", arg_0 -> AnimationSettings.lambda$0$1(this$0, arg_0));
            $this$panel.row("Delay:", arg_0 -> AnimationSettings.lambda$0$2(this$0, arg_0));
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AnimationSettings.lambda$0$3(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AnimationSettings.lambda$0$4(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AnimationSettings.lambda$0$5(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AnimationSettings.lambda$0$6(this$0, arg_0), (int)1, null);
            $this$panel.row("Freeze (%)", arg_0 -> AnimationSettings.lambda$0$7(this$0, arg_0));
            $this$panel.row("Coerce (%)", arg_0 -> AnimationSettings.lambda$0$8(this$0, arg_0));
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AnimationSettings.lambda$0$9(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AnimationSettings.lambda$0$10(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, AnimationSettings::lambda$0$11, (int)1, null).visible(SystemInfoRt.isWindows);
            Panel.row$default((Panel)$this$panel, null, AnimationSettings::lambda$0$12, (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$0(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            SpinnerKt.bindIntValue((Cell)$this$row.spinner(new IntRange(0, 60000), 50), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getDuration();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setDuration(((Number)value).intValue());
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$1(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            SpinnerKt.bindIntValue((Cell)$this$row.spinner(new IntRange(1, 1000), 1), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getPeriod();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setPeriod(((Number)value).intValue());
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$2(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            SpinnerKt.bindIntValue((Cell)$this$row.spinner(new IntRange(0, 10000), 100), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getDelay();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setDelay(((Number)value).intValue());
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$3(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ButtonKt.bindSelected((Cell)$this$row.checkBox("Cyclic"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getCyclic();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setCyclic((Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$4(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ButtonKt.bindSelected((Cell)$this$row.checkBox("Reverse"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getReverse();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setReverse((Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$5(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ButtonKt.bindSelected((Cell)$this$row.checkBox("Inverse"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getInverse();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setInverse((Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$6(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ButtonKt.bindSelected((Cell)$this$row.checkBox("Mirror"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getMirror();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setMirror((Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$7(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            SpinnerKt.bindIntValue((Cell)$this$row.spinner(new IntRange(0, 100), 5), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getFreezeBefore();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setFreezeBefore(((Number)value).intValue());
                }
            }));
            SpinnerKt.bindIntValue((Cell)$this$row.spinner(new IntRange(0, 100), 5), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getFreezeAfter();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setFreezeAfter(((Number)value).intValue());
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$8(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            SpinnerKt.bindIntValue((Cell)$this$row.spinner(new IntRange(0, 100), 5), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getCoerceMin();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setCoerceMin(((Number)value).intValue());
                }
            }));
            SpinnerKt.bindIntValue((Cell)$this$row.spinner(new IntRange(0, 100), 5), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getCoerceMax();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setCoerceMax(((Number)value).intValue());
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$9(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)EntriesMappings.entries$0, (ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> AnimationSettings.lambda$0$9$1(AnimationSettings::lambda$0$9$0, arg_0, arg_1, arg_2))), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.options){

                public Object get() {
                    return ((Options)this.receiver).getType();
                }

                public void set(Object value) {
                    ((Options)this.receiver).setType((JBAnimator.Type)value);
                }
            })));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$9$0(JBLabel label, JBAnimator.Type value, int n) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            String[] stringArray = new String[]{"_"};
            label.setText(CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)value.toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, AnimationSettings::lambda$0$9$0$0, (int)30, null));
            return Unit.INSTANCE;
        }

        private static final CharSequence lambda$0$9$0$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return StringsKt.capitalize((String)string2);
        }

        private static final void lambda$0$9$1(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            $tmp0.invoke((Object)p0, p1, (Object)p2);
        }

        private static final Unit lambda$0$10(AnimationSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.link("Change color", arg_0 -> AnimationSettings.lambda$0$10$0(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$10$0(AnimationSettings this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ColorChooserService.showPopup$default((ColorChooserService)ColorChooserService.Companion.getInstance(), null, (Color)this$0.options.getColor(), (arg_0, arg_1) -> AnimationSettings.lambda$0$10$0$0(this$0, arg_0, arg_1), null, (boolean)false, (boolean)false, null, (int)120, null);
            return Unit.INSTANCE;
        }

        private static final void lambda$0$10$0$0(AnimationSettings this$0, Color color, Object object) {
            block0: {
                Color color2 = color;
                if (color2 == null) break block0;
                Color it = color2;
                boolean bl = false;
                this$0.options.setColor(it);
            }
        }

        private static final Unit lambda$0$11(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ButtonKt.bindSelected((Cell)$this$row.checkBox("Enable high precision timer"), (Function0)panel.1.12.1.INSTANCE, (Function1)panel.1.12.2.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$12(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$1(DialogPanel $panel, AnimationSettings this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AnimationSettings.lambda$1$0($panel, this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit lambda$1$0(DialogPanel $panel, AnimationSettings this$0, Row $this$row) {
            void $this$lambda_u241_u240_u240;
            JButton jButton;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Ref.ObjectRef info = new Ref.ObjectRef();
            JButton jButton2 = jButton = new JButton("Start Animation", AllIcons.Actions.Execute);
            Row row = $this$row;
            boolean bl = false;
            $this$lambda_u241_u240_u240.addActionListener(arg_0 -> AnimationSettings.lambda$1$0$0$0($panel, this$0, (JButton)$this$lambda_u241_u240_u240, info, arg_0));
            row.cell((JComponent)jButton);
            info.element = $this$row.label("");
            return Unit.INSTANCE;
        }

        private static final void lambda$1$0$0$0(DialogPanel $panel, AnimationSettings this$0, JButton $this_apply, Ref.ObjectRef $info, ActionEvent it) {
            Cell cell;
            $panel.apply();
            Function3<Options, JButton, JLabel, Unit> function3 = this$0.onStart;
            Options options = this$0.options;
            if ($info.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"info");
                cell = null;
            } else {
                cell = (Cell)$info.element;
            }
            function3.invoke((Object)options, (Object)$this_apply, (Object)cell.getComponent());
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<JBAnimator.Type> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])JBAnimator.Type.values()));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$BezierEasingPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "<init>", "()V", "painter", "Lcom/intellij/util/animation/components/BezierPainter;", "display", "Lcom/intellij/ui/components/fields/ExpandableTextField;", "getEasing", "Lcom/intellij/util/animation/Easing;", "getControlPoints", "", "", "bezierPainter", "setControlPoints", "", "values", "parseControlPoints", "value", "", "Companion", "intellij.platform.ide.internal"})
    @SourceDebugExtension(value={"SMAP\nAnimationPanelTestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationPanelTestAction.kt\ncom/intellij/internal/ui/AnimationPanelTestAction$BezierEasingPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,739:1\n1#2:740\n1563#3:741\n1634#3,3:742\n*S KotlinDebug\n*F\n+ 1 AnimationPanelTestAction.kt\ncom/intellij/internal/ui/AnimationPanelTestAction$BezierEasingPanel\n*L\n619#1:741\n619#1:742,3\n*E\n"})
    private static final class BezierEasingPanel
    extends BorderLayoutPanel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BezierPainter painter;
        @NotNull
        private final ExpandableTextField display;
        private static final NumberFormat format = NumberFormat.getNumberInstance();

        /*
         * WARNING - void declaration
         */
        public BezierEasingPanel() {
            void $this$display_u24lambda_u240;
            Component $this$painter_u24lambda_u240;
            ExtendableTextComponent.Extension[] p0;
            ExtendableTextComponent.Extension[] extensionArray = new BezierPainter(0.215, 0.61, 0.355, 1.0);
            Component component = (Component)extensionArray;
            BezierEasingPanel bezierEasingPanel = this;
            boolean bl = false;
            this.addToCenter((Component)p0);
            p0 = extensionArray;
            boolean bl2 = false;
            $this$painter_u24lambda_u240.setBorder(JBUI.Borders.empty((int)25));
            bezierEasingPanel.painter = extensionArray;
            extensionArray = new ExpandableTextField();
            $this$painter_u24lambda_u240 = (Component)extensionArray;
            bezierEasingPanel = this;
            boolean bl3 = false;
            this.addToTop((Component)p0);
            p0 = extensionArray;
            boolean bl4 = false;
            $this$display_u24lambda_u240.setEditable(false);
            Iterable iterable = this.getControlPoints(this.painter);
            NumberFormat numberFormat = format;
            Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"format");
            $this$display_u24lambda_u240.setText(CollectionsKt.joinToString$default((Iterable)iterable, null, null, null, (int)0, null, (Function1)((Function1)new Function1<Double, String>((Object)numberFormat){

                public final String invoke(double p0) {
                    return ((NumberFormat)this.receiver).format(p0);
                }
            }), (int)31, null));
            $this$display_u24lambda_u240.setBorder(JBUI.Borders.empty((int)1));
            bezierEasingPanel.display = extensionArray;
            this.setBorder(JBUI.Borders.customLine((Color)NamedColorUtil.getBoundsColor(), (int)1));
            this.painter.addPropertyChangeListener(arg_0 -> BezierEasingPanel._init_$lambda$0(this, arg_0));
            extensionArray = new ExtendableTextComponent.Extension[]{ExtendableTextComponent.Extension.create((Icon)AllIcons.General.Reset, (String)"Reset", () -> BezierEasingPanel._init_$lambda$1(this)), ExtendableTextComponent.Extension.create((Icon)AllIcons.Actions.MenuPaste, (String)"Paste from Clipboard", () -> BezierEasingPanel._init_$lambda$2(this))};
            this.display.setExtensions(extensionArray);
        }

        @NotNull
        public final Easing getEasing() {
            return this.painter.getEasing();
        }

        private final List<Double> getControlPoints(BezierPainter bezierPainter) {
            Object[] objectArray = new Double[]{bezierPainter.getFirstControlPoint().getX(), bezierPainter.getFirstControlPoint().getY(), bezierPainter.getSecondControlPoint().getX(), bezierPainter.getSecondControlPoint().getY()};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final void setControlPoints(BezierPainter bezierPainter, List<Double> values) {
            bezierPainter.setFirstControlPoint((Point2D)new Point2D.Double(((Number)values.get(0)).doubleValue(), ((Number)values.get(1)).doubleValue()));
            bezierPainter.setSecondControlPoint((Point2D)new Point2D.Double(((Number)values.get(2)).doubleValue(), ((Number)values.get(3)).doubleValue()));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Double> parseControlPoints(String value) throws NumberFormatException {
            void $this$mapTo$iv$iv;
            Object object = new String[]{","};
            Object it = object = StringsKt.split$default((CharSequence)value, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$a$-also-AnimationPanelTestAction$BezierEasingPanel$parseControlPoints$22 = false;
            if (it.size() != 4) {
                throw new NumberFormatException("Cannot parse " + value + ";");
            }
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable $i$a$-also-AnimationPanelTestAction$BezierEasingPanel$parseControlPoints$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Double.parseDouble(((Object)StringsKt.trim((CharSequence)((CharSequence)it2))).toString()));
            }
            return (List)destination$iv$iv;
        }

        private static final void _init_$lambda$0(BezierEasingPanel this$0, PropertyChangeEvent e) {
            String string = e.getPropertyName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropertyName(...)");
            if (StringsKt.endsWith$default((String)string, (String)"ControlPoint", (boolean)false, (int)2, null)) {
                ExpandableTextField expandableTextField = this$0.display;
                Iterable iterable = this$0.getControlPoints(this$0.painter);
                NumberFormat numberFormat = format;
                Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"format");
                expandableTextField.setText(CollectionsKt.joinToString$default((Iterable)iterable, null, null, null, (int)0, null, (Function1)((Function1)new Function1<Double, String>((Object)numberFormat){

                    public final String invoke(double p0) {
                        return ((NumberFormat)this.receiver).format(p0);
                    }
                }), (int)31, null));
            }
        }

        private static final void _init_$lambda$1(BezierEasingPanel this$0) {
            Object[] objectArray = new Double[]{0.215, 0.61, 0.355, 1.0};
            this$0.setControlPoints(this$0.painter, CollectionsKt.listOf((Object[])objectArray));
        }

        /*
         * WARNING - void declaration
         */
        private static final void _init_$lambda$2(BezierEasingPanel this$0) {
            try {
                String string = ClipboardUtil.getTextInClipboard();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    this$0.setControlPoints(this$0.painter, this$0.parseControlPoints(it));
                }
            }
            catch (NumberFormatException ignore) {
                void $this$lambda_u242_u241;
                Animation animation;
                JBAnimator jBAnimator = new JBAnimator();
                Animation[] animationArray = new Animation[1];
                Color color = NamedColorUtil.getErrorForeground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getErrorForeground(...)");
                Color color2 = UIUtil.getTextFieldForeground();
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getTextFieldForeground(...)");
                Animation animation2 = animation = Animations.animation((Color)color, (Color)color2, arg_0 -> this$0.display.setForeground(arg_0));
                int n = 0;
                Animation[] animationArray2 = animationArray;
                JBAnimator jBAnimator2 = jBAnimator;
                boolean bl = false;
                $this$lambda_u242_u241.setDuration(800);
                $this$lambda_u242_u241.setEasing(BezierEasingPanel::lambda$2$1$0);
                Unit unit = Unit.INSTANCE;
                animationArray2[n] = animation;
                jBAnimator2.animate(animationArray);
            }
        }

        private static final double lambda$2$1$0(double x) {
            return x * x * x;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$BezierEasingPanel$Companion;", "", "<init>", "()V", "format", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "intellij.platform.ide.internal"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$DemoPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "disposable", "Lcom/intellij/openapi/Disposable;", "bezier", "Lkotlin/Function0;", "Lcom/intellij/util/animation/Easing;", "<init>", "(Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getBezier", "()Lkotlin/jvm/functions/Function0;", "textArea", "Lcom/intellij/ui/components/JBTextArea;", "getTextArea", "()Lcom/intellij/ui/components/JBTextArea;", "load", "", "loadStage1", "loadStage2", "loadStage3", "loadStage4", "loadTestPage", "hideAllComponentsAndRun", "afterFinish", "createScrollPaneWithAnimatedActions", "Lcom/intellij/ui/components/JBScrollPane;", "intellij.platform.ide.internal"})
    @SourceDebugExtension(value={"SMAP\nAnimationPanelTestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationPanelTestAction.kt\ncom/intellij/internal/ui/AnimationPanelTestAction$DemoPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,739:1\n1#2:740\n1#2:742\n2756#3:741\n1869#3,2:745\n1878#3,3:749\n1869#3,2:752\n13805#4,2:743\n37#5,2:747\n*S KotlinDebug\n*F\n+ 1 AnimationPanelTestAction.kt\ncom/intellij/internal/ui/AnimationPanelTestAction$DemoPanel\n*L\n261#1:742\n261#1:741\n401#1:745,2\n267#1:749,3\n335#1:752,2\n377#1:743,2\n266#1:747,2\n*E\n"})
    private static final class DemoPanel
    extends BorderLayoutPanel {
        @NotNull
        private final Disposable disposable;
        @NotNull
        private final Function0<Easing> bezier;
        @NotNull
        private final JBTextArea textArea;

        public DemoPanel(@NotNull Disposable disposable, @NotNull Function0<? extends Easing> bezier) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter(bezier, (String)"bezier");
            this.disposable = disposable;
            this.bezier = bezier;
            this.setPreferredSize(new Dimension(600, 300));
            this.setBorder((Border)JBUI.Borders.emptyLeft((int)12));
            this.textArea = new JBTextArea();
            this.createScrollPaneWithAnimatedActions(this.textArea);
        }

        @NotNull
        public final Disposable getDisposable() {
            return this.disposable;
        }

        @NotNull
        public final Function0<Easing> getBezier() {
            return this.bezier;
        }

        @NotNull
        public final JBTextArea getTextArea() {
            return this.textArea;
        }

        public final void load() {
            this.loadStage1();
        }

        /*
         * WARNING - void declaration
         */
        private final void loadStage1() {
            void $this$loadStage1_u24lambda_u246;
            Animation animation;
            void $this$loadStage1_u24lambda_u243;
            void $this$loadStage1_u24lambda_u241_u240_u240;
            JButton jButton;
            Object[] objectArray;
            Object[] it;
            JButton jButton2;
            Color baseColor = UIUtil.getTextFieldForeground();
            JButton it2 = jButton2 = new JButton("Click to start a demo", AllIcons.Process.Step_1);
            boolean $i$a$-also-AnimationPanelTestAction$DemoPanel$loadStage1$showDemoBtn$22 = false;
            it2.setBorder(JBUI.Borders.customLine((Color)baseColor, (int)1));
            it2.setContentAreaFilled(false);
            it2.setOpaque(true);
            JButton showDemoBtn = jButton2;
            ActionLink showTestPageLnk = new ActionLink("or load the testing page", null, 2, null);
            JButton $i$a$-also-AnimationPanelTestAction$DemoPanel$loadStage1$showDemoBtn$22 = it2 = new OpaquePanel((LayoutManager)new VerticalLayout(15, 0));
            Animation[] animationArray = this;
            boolean $i$a$-also-AnimationPanelTestAction$DemoPanel$loadStage1$22 = false;
            it.add((Component)showDemoBtn, (Object)"CENTER");
            it.add((Component)showTestPageLnk, (Object)"CENTER");
            Object[] $this$loadStage1_u24lambda_u241_u240 = objectArray = new JPanel(new FlowLayout());
            boolean bl = false;
            JButton jButton3 = jButton = new JButton("Guess the value");
            Object[] objectArray2 = $this$loadStage1_u24lambda_u241_u240;
            boolean bl2 = false;
            $this$loadStage1_u24lambda_u241_u240_u240.addActionListener(arg_0 -> DemoPanel.loadStage1$lambda$1$0$0$0((DemoPanel)this, arg_0));
            objectArray2.add(jButton);
            Object[] buttonsPanel = objectArray;
            it.add((Component)buttonsPanel, (Object)"BOTTOM");
            animationArray.addToCenter((Component)it2);
            it = new Icon[]{AllIcons.Process.Step_1, AllIcons.Process.Step_2, AllIcons.Process.Step_3, AllIcons.Process.Step_4, AllIcons.Process.Step_5, AllIcons.Process.Step_6, AllIcons.Process.Step_7, AllIcons.Process.Step_8};
            Object[] icons = it;
            Animation[] $this$loadStage1_u24lambda_u242 = $i$a$-also-AnimationPanelTestAction$DemoPanel$loadStage1$22 = new JBAnimator(this.disposable);
            boolean $i$a$-apply-AnimationPanelTestAction$DemoPanel$loadStage1$iconAnimator$22 = false;
            $this$loadStage1_u24lambda_u242.setPeriod(60);
            $this$loadStage1_u24lambda_u242.setCyclic(true);
            $this$loadStage1_u24lambda_u242.setType(JBAnimator.Type.EACH_FRAME);
            $this$loadStage1_u24lambda_u242.ignorePowerSaveMode();
            Animation[] iconAnimator = $i$a$-also-AnimationPanelTestAction$DemoPanel$loadStage1$22;
            Animation[] $i$a$-also-AnimationPanelTestAction$DemoPanel$loadStage1$22 = new Animation[1];
            Object[] $i$a$-apply-AnimationPanelTestAction$DemoPanel$loadStage1$iconAnimator$22 = objectArray = Animations.animation((Object[])icons, showDemoBtn::setIcon);
            int n = 0;
            Animation[] animationArray2 = $i$a$-also-AnimationPanelTestAction$DemoPanel$loadStage1$22;
            animationArray = iconAnimator;
            boolean $i$a$-apply-AnimationPanelTestAction$DemoPanel$loadStage1$42 = false;
            $this$loadStage1_u24lambda_u243.setDuration(iconAnimator.getPeriod() * icons.length);
            $this$loadStage1_u24lambda_u243.setEasing(Easing.LINEAR);
            Unit unit = Unit.INSTANCE;
            animationArray2[n] = objectArray;
            animationArray.animate($i$a$-also-AnimationPanelTestAction$DemoPanel$loadStage1$22);
            objectArray = new Animation[3];
            Intrinsics.checkNotNull((Object)baseColor);
            objectArray[0] = Animations.transparent((Color)baseColor, arg_0 -> DemoPanel.loadStage1$lambda$4(showDemoBtn, arg_0));
            objectArray[1] = Animations.animation(arg_0 -> DemoPanel.loadStage1$lambda$5(showDemoBtn, arg_0));
            Color color = showTestPageLnk.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
            Animation $i$a$-apply-AnimationPanelTestAction$DemoPanel$loadStage1$42 = animation = Animations.transparent((Color)color, arg_0 -> showTestPageLnk.setForeground(arg_0));
            int n2 = 2;
            animationArray = objectArray;
            boolean bl3 = false;
            $this$loadStage1_u24lambda_u246.runWhenScheduled(() -> DemoPanel.loadStage1$lambda$6$0(showDemoBtn, (JBAnimator)iconAnimator));
            $this$loadStage1_u24lambda_u246.runWhenExpired(() -> DemoPanel.loadStage1$lambda$6$1((DemoPanel)this));
            Unit unit2 = Unit.INSTANCE;
            animationArray[n2] = animation;
            List fadeOutElements = CollectionsKt.listOf((Object[])objectArray);
            showDemoBtn.addActionListener(arg_0 -> DemoPanel.loadStage1$lambda$7(fadeOutElements, (DemoPanel)this, arg_0));
            showTestPageLnk.addActionListener(arg_0 -> DemoPanel.loadStage1$lambda$8(fadeOutElements, (DemoPanel)this, arg_0));
            new UpdateColorsOnHover(showDemoBtn);
        }

        private final void loadStage2() {
            Animation animation;
            int clicks = 2;
            SpringButtonPanel buttonDemo = new SpringButtonPanel("Here!", new Rectangle(this.getWidth() / 2 - 50, 10, 100, 40), clicks, arg_0 -> DemoPanel.loadStage2$lambda$0(this, arg_0));
            this.addToCenter((Component)((Object)buttonDemo));
            JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)((Component)this.textArea));
            if (jScrollPane == null) {
                throw new IllegalStateException("text area has no scroll pane".toString());
            }
            JScrollPane scroller = jScrollPane;
            if (scroller.getParent() == null) {
                this.textArea.setText(StringsKt.trimIndent((String)("\n            Hello! \n            \n            Click the button " + (clicks + 1) + " times.\n          ")));
                scroller.setPreferredSize(new Dimension(this.getWidth(), 0));
                this.addToTop(scroller);
            }
            Animation[] animationArray = new Animation[1];
            DemoPanel demoPanel = this;
            int n = 0;
            Animation[] animationArray2 = animationArray;
            JBAnimator jBAnimator = new JBAnimator();
            boolean bl = false;
            Dimension to = new Dimension(this.getWidth(), 100);
            Dimension dimension = scroller.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            animationArray2[n] = animation = Animations.animation((Dimension)dimension, (Dimension)to, scroller::setPreferredSize).setEasing((Easing)this.bezier.invoke()).runWhenUpdated(() -> DemoPanel.loadStage2$lambda$1$0(this));
            jBAnimator.animate(animationArray);
        }

        /*
         * WARNING - void declaration
         */
        private final void loadStage3() {
            void $this$loadStage3_u24lambda_u240_u243;
            Animation $this$loadStage3_u24lambda_u240_u242;
            Animation $this$loadStage3_u24lambda_u240_u241;
            Animation $this$loadStage3_u24lambda_u240_u240;
            Animation animation;
            JBAnimator jBAnimator;
            JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)((Component)this.textArea));
            if (jScrollPane == null) {
                throw new IllegalStateException("text area has no scroll pane".toString());
            }
            JScrollPane scroller = jScrollPane;
            if (scroller.getParent() == null) {
                this.textArea.setText("Good start!");
                scroller.setPreferredSize(new Dimension(this.getWidth(), 0));
                this.addToTop(scroller);
            }
            String oopsText = "Oops... Everything is gone";
            String sorryText = StringsKt.trimIndent((String)("\n        " + oopsText + "\n        \n        To check page scroll options insert a text\n        and press UP or DOWN key.\n        \n        These values are funny:\n        0.34, 1.56, 0.64, 1\n      "));
            JBAnimator $this$loadStage3_u24lambda_u240 = jBAnimator = new JBAnimator();
            boolean bl = false;
            $this$loadStage3_u24lambda_u240.setType(JBAnimator.Type.EACH_FRAME);
            Animation[] animationArray = new Animation[4];
            Dimension dimension = scroller.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            Dimension dimension2 = this.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
            Animation animation2 = animation = Animations.animation((Dimension)dimension, (Dimension)dimension2, scroller::setPreferredSize);
            int n = 0;
            Animation[] animationArray2 = animationArray;
            JBAnimator jBAnimator2 = $this$loadStage3_u24lambda_u240;
            boolean bl2 = false;
            $this$loadStage3_u24lambda_u240_u240.setDuration(500);
            $this$loadStage3_u24lambda_u240_u240.setDelay(500);
            $this$loadStage3_u24lambda_u240_u240.setEasing((Easing)this.bezier.invoke());
            $this$loadStage3_u24lambda_u240_u240.runWhenUpdated(() -> DemoPanel.loadStage3$lambda$0$0$0(this));
            Unit unit = Unit.INSTANCE;
            animationArray2[n] = animation;
            String string = this.textArea.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            $this$loadStage3_u24lambda_u240_u240 = animation = Animations.animation((String)string, (String)oopsText, arg_0 -> this.textArea.setText(arg_0));
            n = 1;
            animationArray2 = animationArray;
            boolean bl3 = false;
            $this$loadStage3_u24lambda_u240_u241.setDuration(RangesKt.coerceAtMost((int)((this.textArea.getText().length() + oopsText.length()) * 20), (int)5000));
            $this$loadStage3_u24lambda_u240_u241.setDelay(200);
            unit = Unit.INSTANCE;
            animationArray2[n] = animation;
            $this$loadStage3_u24lambda_u240_u241 = animation = Animations.animation((String)oopsText, (String)sorryText, arg_0 -> this.textArea.setText(arg_0));
            n = 2;
            animationArray2 = animationArray;
            boolean bl4 = false;
            $this$loadStage3_u24lambda_u240_u242.setDuration(RangesKt.coerceAtMost((int)((oopsText.length() + sorryText.length()) * 20), (int)7500));
            $this$loadStage3_u24lambda_u240_u242.setDelay(1000);
            unit = Unit.INSTANCE;
            animationArray2[n] = animation;
            Dimension dimension3 = this.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"getSize(...)");
            $this$loadStage3_u24lambda_u240_u242 = animation = Animations.animation((Dimension)dimension3, (Dimension)new Dimension(this.getWidth(), this.getHeight() - 30), scroller::setPreferredSize);
            n = 3;
            animationArray2 = animationArray;
            boolean bl5 = false;
            $this$loadStage3_u24lambda_u240_u243.setDelay(2500);
            $this$loadStage3_u24lambda_u240_u243.setEasing((Easing)this.bezier.invoke());
            $this$loadStage3_u24lambda_u240_u243.runWhenUpdated(() -> DemoPanel.loadStage3$lambda$0$3$0(this));
            $this$loadStage3_u24lambda_u240_u243.runWhenExpired(() -> DemoPanel.loadStage3$lambda$0$3$1(this, $this$loadStage3_u24lambda_u240));
            unit = Unit.INSTANCE;
            animationArray2[n] = animation;
            jBAnimator2.animate(Animations.makeSequent((Animation[])animationArray));
        }

        /*
         * WARNING - void declaration
         */
        private final void loadStage4() {
            void $this$loadStage4_u24lambda_u243;
            void $this$loadStage4_u24lambda_u240;
            Object object;
            Object[] objectArray = new JBLabel[7];
            JBLabel jBLabel = object = new JBLabel();
            int n = 0;
            Object object2 = objectArray;
            boolean bl = false;
            $this$loadStage4_u24lambda_u240.setFont($this$loadStage4_u24lambda_u240.getFont().deriveFont(24.0f));
            Unit unit = Unit.INSTANCE;
            object2[n] = object;
            objectArray[1] = new JBLabel(UIUtil.ComponentStyle.LARGE);
            objectArray[2] = new JBLabel(UIUtil.ComponentStyle.REGULAR);
            objectArray[3] = new JBLabel(UIUtil.ComponentStyle.SMALL);
            objectArray[4] = new JBLabel(UIUtil.ComponentStyle.MINI);
            objectArray[5] = new JBLabel(UIUtil.ComponentStyle.MINI);
            objectArray[6] = new JBLabel(UIUtil.ComponentStyle.MINI);
            List fields = CollectionsKt.listOf((Object[])objectArray);
            JPanel wheel = new JPanel(new GridLayout(fields.size(), 1, 0, 10));
            Iterable $this$onEach$iv = fields;
            boolean $i$f$onEach22 = false;
            Iterable $this$onEach_u24lambda_u240$iv = bl = $this$onEach$iv;
            boolean bl2 = false;
            for (Object element$iv : $this$onEach_u24lambda_u240$iv) {
                JBLabel it = (JBLabel)element$iv;
                boolean bl3 = false;
                it.setHorizontalAlignment(0);
                wheel.add((Component)it);
            }
            DemoPanel.loadStage4$updateColor(fields, RColors.RED);
            this.addToCenter(wheel);
            Object $i$f$onEach22 = object = new JButton("Start");
            object2 = this;
            boolean bl4 = false;
            $this$loadStage4_u24lambda_u243.addActionListener(new ActionListener(this, (JButton)$this$loadStage4_u24lambda_u243, fields){
                private final JBAnimator animator;
                private final AnimationContext<RColors> context;
                private long taskId;
                final /* synthetic */ JButton $this_apply;
                final /* synthetic */ List<JBLabel> $fields;
                {
                    this.$this_apply = $receiver2;
                    this.$fields = $fields;
                    this.animator = new JBAnimator(Alarm.ThreadToUse.POOLED_THREAD, $receiver.getDisposable());
                    this.context = new AnimationContext();
                    this.taskId = -1L;
                }

                public final JBAnimator getAnimator() {
                    return this.animator;
                }

                public final AnimationContext<RColors> getContext() {
                    return this.context;
                }

                public final long getTaskId() {
                    return this.taskId;
                }

                public final void setTaskId(long l) {
                    this.taskId = l;
                }

                /*
                 * WARNING - void declaration
                 */
                public void actionPerformed(ActionEvent e) {
                    if (!this.animator.isRunning(this.taskId)) {
                        void $this$actionPerformed_u24lambda_u240_u240;
                        Animation animation;
                        this.$this_apply.setText("Stop");
                        JBAnimator jBAnimator = this.animator;
                        List<JBLabel> list = this.$fields;
                        JBAnimator $this$actionPerformed_u24lambda_u240 = jBAnimator;
                        boolean bl = false;
                        $this$actionPerformed_u24lambda_u240.setCyclic(true);
                        $this$actionPerformed_u24lambda_u240.setType(JBAnimator.Type.EACH_FRAME);
                        Animation[] animationArray = new Animation[1];
                        Collection $this$toTypedArray$iv = (Collection)RColors.getEntries();
                        boolean $i$f$toTypedArray22 = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Animation $i$f$toTypedArray22 = animation = Animation.withContext(this.context, (DoubleFunction)((DoubleFunction)new DoubleArrayFunction((Object[])thisCollection$iv.toArray(new RColors[0]))));
                        int n = 0;
                        Animation[] animationArray2 = animationArray;
                        JBAnimator jBAnimator2 = $this$actionPerformed_u24lambda_u240;
                        loadStage4.2.1 var13_15 = this;
                        boolean bl2 = false;
                        int oneElementTimeOnScreen = 30;
                        $this$actionPerformed_u24lambda_u240_u240.setEasing(Easing.LINEAR);
                        $this$actionPerformed_u24lambda_u240_u240.setDuration(RColors.getEntries().size() * oneElementTimeOnScreen);
                        $this$actionPerformed_u24lambda_u240_u240.runWhenUpdated(() -> loadStage4.2.1.actionPerformed$lambda$0$0$0(this, list));
                        Unit unit = Unit.INSTANCE;
                        animationArray2[n] = animation;
                        var13_15.taskId = jBAnimator2.animate(animationArray);
                    } else {
                        this.$this_apply.setText("The " + this.context.getValue() + " wins! Try again!");
                        this.animator.stop();
                    }
                }

                private static final void actionPerformed$lambda$0$0$0(loadStage4.2.1 this$0, List $fields) {
                    block0: {
                        RColors rColors = (RColors)((Object)this$0.context.getValue());
                        if (rColors == null) break block0;
                        RColors p0 = rColors;
                        boolean bl = false;
                        DemoPanel.access$loadStage4$updateColor($fields, p0);
                    }
                }
            });
            object2.addToBottom((Component)object);
        }

        private final void loadTestPage() {
            this.hideAllComponentsAndRun((Function0<Unit>)((Function0)() -> DemoPanel.loadTestPage$lambda$0(this)));
        }

        private final void hideAllComponentsAndRun(Function0<Unit> afterFinish) {
            List remover = new ArrayList();
            JScrollPane scroller = ComponentUtil.getScrollPane((Component)((Component)this.textArea));
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object $this$forEach$iv = componentArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection collection;
                Component comp = (Component)element$iv;
                boolean bl = false;
                if (scroller == comp) {
                    Collection collection2 = remover;
                    Dimension dimension = ((JScrollPane)comp).getPreferredSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                    collection = Animations.animation((Dimension)dimension, (Dimension)new Dimension(((JScrollPane)comp).getWidth(), 0), ((JScrollPane)comp)::setPreferredSize).setEasing((Easing)this.bezier.invoke()).runWhenUpdated(() -> DemoPanel.hideAllComponentsAndRun$lambda$0$0(this));
                    collection2.add(collection);
                    collection2 = remover;
                    String string = this.textArea.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    collection2.add(Animations.animation((String)string, (String)"", arg_0 -> this.textArea.setText(arg_0)).setEasing(DemoPanel::hideAllComponentsAndRun$lambda$0$1));
                    collection2 = remover;
                    Color color = this.textArea.getForeground();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
                    collection2.add(Animations.transparent((Color)color, arg_0 -> this.textArea.setForeground(arg_0)));
                    continue;
                }
                if (!(comp instanceof Wrapper) || !(((Wrapper)comp).getTargetComponent() instanceof ActionLink)) continue;
                JComponent jComponent = ((Wrapper)comp).getTargetComponent();
                Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.ui.components.ActionLink");
                ActionLink link = (ActionLink)jComponent;
                collection = remover;
                Color color = link.getForeground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
                collection.add(Animations.transparent((Color)color, arg_0 -> link.setForeground(arg_0)));
            }
            ((Collection)remover).add(Animations.animation().runWhenExpired(() -> DemoPanel.hideAllComponentsAndRun$lambda$1(this, afterFinish)));
            $this$forEach$iv = remover;
            $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Animation it = (Animation)element$iv;
                boolean bl = false;
                it.setDuration(800);
            }
            new JBAnimator().animate((Collection)remover);
        }

        private final JBScrollPane createScrollPaneWithAnimatedActions(JBTextArea textArea) {
            JBScrollPane pane = new JBScrollPane((Component)textArea);
            JBAnimator commonAnimator = new JBAnimator(this.disposable);
            String[] stringArray = new String[]{"DOWN"};
            DumbAwareAction.create((String)"Scroll Down", arg_0 -> DemoPanel.createScrollPaneWithAnimatedActions$lambda$1(arg_0 -> DemoPanel.createScrollPaneWithAnimatedActions$lambda$0(pane, commonAnimator, this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])stringArray), (JComponent)pane);
            stringArray = new String[]{"UP"};
            DumbAwareAction.create((String)"Scroll Up", arg_0 -> DemoPanel.createScrollPaneWithAnimatedActions$lambda$3(arg_0 -> DemoPanel.createScrollPaneWithAnimatedActions$lambda$2(pane, commonAnimator, this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])stringArray), (JComponent)pane);
            return pane;
        }

        private static final void loadStage1$lambda$1$0$0$0(DemoPanel this$0, ActionEvent it) {
            this$0.removeAll();
            this$0.loadStage4();
            this$0.revalidate();
        }

        private static final void loadStage1$lambda$4(JButton $showDemoBtn, Color it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $showDemoBtn.setForeground(it);
            $showDemoBtn.setBorder(JBUI.Borders.customLine((Color)it, (int)1));
        }

        private static final void loadStage1$lambda$5(JButton $showDemoBtn, double it) {
            String string = $showDemoBtn.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] array = cArray;
            ArraysKt.shuffle((char[])array);
            $showDemoBtn.setText(new String(array));
        }

        private static final void loadStage1$lambda$6$0(JButton $showDemoBtn, JBAnimator $iconAnimator) {
            $showDemoBtn.setIcon(EmptyIcon.ICON_16);
            $showDemoBtn.setOpaque(false);
            $showDemoBtn.repaint();
            Disposer.dispose((Disposable)((Disposable)$iconAnimator));
        }

        private static final void loadStage1$lambda$6$1(DemoPanel this$0) {
            this$0.removeAll();
            this$0.revalidate();
            this$0.repaint();
        }

        private static final void loadStage1$lambda$7(List $fadeOutElements, DemoPanel this$0, ActionEvent it) {
            new JBAnimator().animate((Collection)CollectionsKt.plus((Collection)$fadeOutElements, (Object)Animations.animation().runWhenExpired(() -> DemoPanel.loadStage1$lambda$7$0(this$0))));
        }

        private static final void loadStage1$lambda$7$0(DemoPanel this$0) {
            this$0.loadStage2();
        }

        private static final void loadStage1$lambda$8(List $fadeOutElements, DemoPanel this$0, ActionEvent it) {
            new JBAnimator().animate((Collection)CollectionsKt.plus((Collection)$fadeOutElements, (Object)Animations.animation().runWhenExpired(() -> DemoPanel.loadStage1$lambda$8$0(this$0))));
        }

        private static final void loadStage1$lambda$8$0(DemoPanel this$0) {
            this$0.loadTestPage();
        }

        private static final void loadStage2$lambda$0(DemoPanel this$0, SpringButtonPanel it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            this$0.remove((Component)((Object)it));
            this$0.loadStage3();
        }

        private static final void loadStage2$lambda$1$0(DemoPanel this$0) {
            this$0.revalidate();
            this$0.repaint();
        }

        private static final void loadStage3$lambda$0$0$0(DemoPanel this$0) {
            this$0.revalidate();
            this$0.repaint();
        }

        private static final void loadStage3$lambda$0$3$0(DemoPanel this$0) {
            this$0.revalidate();
            this$0.repaint();
        }

        /*
         * WARNING - void declaration
         */
        private static final void loadStage3$lambda$0$3$1(DemoPanel this$0, JBAnimator $this_apply) {
            void $this$loadStage3_u24lambda_u240_u243_u241_u241;
            Animation animation;
            ActionLink link = new ActionLink("Got it! Now, open the test panel", arg_0 -> DemoPanel.loadStage3$lambda$0$3$1$0(this$0, arg_0));
            Color foreground = link.getForeground();
            Color color = ColorUtil.withAlpha((Color)link.getForeground(), (double)0.0);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"withAlpha(...)");
            Color transparent = color;
            link.setForeground(transparent);
            this$0.addToBottom((Component)new Wrapper((LayoutManager)new FlowLayout(), (JComponent)link));
            Animation[] animationArray = new Animation[1];
            Intrinsics.checkNotNull((Object)foreground);
            Animation animation2 = animation = Animations.transparent((Color)foreground, arg_0 -> link.setForeground(arg_0));
            int n = 0;
            Animation[] animationArray2 = animationArray;
            JBAnimator jBAnimator = $this_apply;
            boolean bl = false;
            $this$loadStage3_u24lambda_u240_u243_u241_u241.setEasing($this$loadStage3_u24lambda_u240_u243_u241_u241.getEasing().reverse());
            Unit unit = Unit.INSTANCE;
            animationArray2[n] = animation;
            jBAnimator.animate(animationArray);
        }

        private static final Unit loadStage3$lambda$0$3$1$0(DemoPanel this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.loadTestPage();
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final void loadStage4$updateColor(List<? extends JBLabel> fields, RColors color) {
            Collection $this$toTypedArray$iv = (Collection)RColors.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            RColors[] colors = thisCollection$iv.toArray(new RColors[0]);
            Iterable $this$forEachIndexed$iv = fields;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void label;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JBLabel jBLabel = (JBLabel)item$iv;
                int index = n;
                boolean bl = false;
                label.setText(colors[(color.ordinal() + index) % colors.length].toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit loadTestPage$lambda$0(DemoPanel this$0) {
            void $this$loadTestPage_u24lambda_u240_u244;
            AnimationSettings animationSettings;
            Object[] objectArray;
            FillPanel linear = new FillPanel("Linear");
            FillPanel custom = new FillPanel("Custom");
            Object[] $this$loadTestPage_u24lambda_u240_u240 = objectArray = new Wrapper((LayoutManager)new HorizontalLayout(40, 0, 2, null));
            boolean bl = false;
            $this$loadTestPage_u24lambda_u240_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)40));
            $this$loadTestPage_u24lambda_u240_u240.add((Component)custom, (Object)"CENTER");
            $this$loadTestPage_u24lambda_u240_u240.add((Component)linear, (Object)"CENTER");
            Object[] content = objectArray;
            $this$loadTestPage_u24lambda_u240_u240 = new Animation[]{Animations.animation(arg_0 -> DemoPanel.loadTestPage$lambda$0$set__proxy((KMutableProperty0)new MutablePropertyReference0Impl(custom){

                public Object get() {
                    return ((FillPanel)this.receiver).getValue();
                }

                public void set(Object value) {
                    ((FillPanel)this.receiver).setValue(((Number)value).doubleValue());
                }
            }, arg_0)), Animations.animation(arg_0 -> DemoPanel.loadTestPage$lambda$0$set__proxy$1((KMutableProperty0)new MutablePropertyReference0Impl(linear){

                public Object get() {
                    return ((FillPanel)this.receiver).getValue();
                }

                public void set(Object value) {
                    ((FillPanel)this.receiver).setValue(((Number)value).doubleValue());
                }
            }, arg_0)), Animations.animation(arg_0 -> DemoPanel.loadTestPage$lambda$0$2((Wrapper)content, arg_0))};
            List animations2 = CollectionsKt.listOf((Object[])$this$loadTestPage_u24lambda_u240_u240);
            JBAnimator fillers = new JBAnimator(Alarm.ThreadToUse.POOLED_THREAD, this$0.disposable);
            Ref.LongRef taskId = new Ref.LongRef();
            taskId.element = -1L;
            AnimationSettings animationSettings2 = animationSettings = new AnimationSettings((Function3<? super Options, ? super JButton, ? super JLabel, Unit>)((Function3)(arg_0, arg_1, arg_2) -> DemoPanel.loadTestPage$lambda$0$3(fillers, taskId, linear, custom, animations2, this$0, arg_0, arg_1, arg_2)));
            DemoPanel demoPanel = this$0;
            boolean bl2 = false;
            $this$loadTestPage_u24lambda_u240_u244.addToRight((Component)content);
            demoPanel.addToCenter((Component)((Object)animationSettings));
            this$0.revalidate();
            return Unit.INSTANCE;
        }

        private static final /* synthetic */ void loadTestPage$lambda$0$set__proxy(KMutableProperty0 $tmp_proxy_0, Object p0$value) {
            $tmp_proxy_0.set(p0$value);
        }

        private static final /* synthetic */ void loadTestPage$lambda$0$set__proxy$1(KMutableProperty0 $tmp_proxy_0, Object p0$value) {
            $tmp_proxy_0.set(p0$value);
        }

        private static final void loadTestPage$lambda$0$2(Wrapper $content, double it) {
            $content.repaint();
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit loadTestPage$lambda$0$3(JBAnimator $fillers, Ref.LongRef $taskId, FillPanel $linear, FillPanel $custom, List $animations, DemoPanel this$0, Options options, JButton button2, JLabel info) {
            void $this$loadTestPage_u24lambda_u240_u243_u241;
            Animation animation;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if ($fillers.isRunning($taskId.element)) {
                $fillers.stop();
                return Unit.INSTANCE;
            }
            $linear.setBackground(options.getColor());
            $custom.setBackground(options.getColor());
            $fillers.setPeriod(options.getPeriod());
            $fillers.setCyclic(options.getCyclic());
            $fillers.setType(options.getType());
            ((Animation)$animations.get(0)).setEasing((Easing)this$0.bezier.invoke());
            ((Animation)$animations.get(1)).setEasing(Easing.LINEAR);
            Iterable $this$forEach$iv = $animations;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Animation animation2 = (Animation)element$iv;
                boolean bl = false;
                animation2.setDuration(options.getDuration());
                animation2.setDelay(options.getDelay());
                animation2.setEasing(animation2.getEasing().freeze((double)options.getFreezeBefore() / 100.0, (double)options.getFreezeAfter() / 100.0));
                animation2.setEasing(animation2.getEasing().coerceIn((double)options.getCoerceMin() / 100.0, (double)options.getCoerceMax() / 100.0));
                if (options.getInverse()) {
                    animation2.setEasing(animation2.getEasing().invert());
                }
                if (options.getReverse()) {
                    animation2.setEasing(animation2.getEasing().reverse());
                }
                if (!options.getMirror()) continue;
                animation2.setEasing(animation2.getEasing().mirror());
            }
            Animation $i$f$forEach22 = animation = Animations.animation();
            Collection collection = $animations;
            JBAnimator jBAnimator = $fillers;
            Ref.LongRef longRef = $taskId;
            boolean bl = false;
            $this$loadTestPage_u24lambda_u240_u243_u241.setDelay(((Animation)CollectionsKt.first((List)$animations)).getFinish());
            $this$loadTestPage_u24lambda_u240_u243_u241.setDuration(0);
            $this$loadTestPage_u24lambda_u240_u243_u241.runWhenExpiredOrCancelled(() -> DemoPanel.loadTestPage$lambda$0$3$1$0(button2, info, $fillers));
            Unit unit = Unit.INSTANCE;
            longRef.element = jBAnimator.animate((Collection)CollectionsKt.plus((Collection)collection, (Object)animation));
            button2.setIcon(AllIcons.Actions.Suspend);
            button2.setText("Stop Animation");
            return Unit.INSTANCE;
        }

        private static final void loadTestPage$lambda$0$3$1$0(JButton $button, JLabel $info, JBAnimator $fillers) {
            $button.setIcon(AllIcons.Actions.Execute);
            $button.setText("Start Animation");
            String string = "updates: %d, duration: %d ms";
            Object[] objectArray = new Object[2];
            JBAnimator.Statistic statistic = $fillers.getStatistic();
            Intrinsics.checkNotNull((Object)statistic);
            objectArray[0] = statistic.getCount();
            JBAnimator.Statistic statistic2 = $fillers.getStatistic();
            Intrinsics.checkNotNull((Object)statistic2);
            objectArray[1] = statistic2.getDuration();
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            $info.setText(string2);
        }

        private static final void hideAllComponentsAndRun$lambda$0$0(DemoPanel this$0) {
            this$0.revalidate();
            this$0.repaint();
        }

        private static final double hideAllComponentsAndRun$lambda$0$1(double x) {
            return 1.0 - Math.pow(1.0 - x, 4.0);
        }

        private static final void hideAllComponentsAndRun$lambda$1(DemoPanel this$0, Function0 $afterFinish) {
            this$0.removeAll();
            $afterFinish.invoke();
        }

        private static final Unit createScrollPaneWithAnimatedActions$lambda$0(JBScrollPane $pane, JBAnimator $commonAnimator, DemoPanel this$0, AnActionEvent it) {
            int from = $pane.getVerticalScrollBar().getValue();
            int to = from + $pane.getVisibleRect().height;
            Animation[] animationArray = new Animation[]{Animations.animation((int)from, (int)to, $pane.getVerticalScrollBar()::setValue).setDuration(350).setEasing((Easing)this$0.bezier.invoke())};
            $commonAnimator.animate(animationArray);
            return Unit.INSTANCE;
        }

        private static final void createScrollPaneWithAnimatedActions$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit createScrollPaneWithAnimatedActions$lambda$2(JBScrollPane $pane, JBAnimator $commonAnimator, DemoPanel this$0, AnActionEvent it) {
            int from = $pane.getVerticalScrollBar().getValue();
            int to = from - $pane.getVisibleRect().height;
            Animation[] animationArray = new Animation[]{Animations.animation((int)from, (int)to, $pane.getVerticalScrollBar()::setValue).setDuration(350).setEasing((Easing)this$0.bezier.invoke())};
            $commonAnimator.animate(animationArray);
            return Unit.INSTANCE;
        }

        private static final void createScrollPaneWithAnimatedActions$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$loadStage4$updateColor(List fields, RColors color) {
            DemoPanel.loadStage4$updateColor(fields, color);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$FillPanel;", "Ljavax/swing/JComponent;", "description", "", "<init>", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "value", "", "getValue", "()D", "setValue", "(D)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.internal"})
    private static final class FillPanel
    extends JComponent {
        @NotNull
        private final String description;
        private double value;

        public FillPanel(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.description = description;
            this.value = 1.0;
            this.setPreferredSize(new Dimension(40, 0));
            this.setBorder((Border)JBUI.Borders.empty((int)40, (int)5, (int)40, (int)0));
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final double getValue() {
            return this.value;
        }

        public final void setValue(double d) {
            this.value = d;
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Rectangle rectangle;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Graphics2D g2d = (Graphics2D)g;
            Insets insets = this.getInsets();
            Rectangle $this$paintComponent_u24lambda_u240 = rectangle = g2d.getClipBounds();
            boolean bl = false;
            $this$paintComponent_u24lambda_u240.height -= insets.top + insets.bottom;
            $this$paintComponent_u24lambda_u240.y += insets.top;
            Rectangle bounds = rectangle;
            double fillHeight = (double)bounds.height * this.value;
            double fillY = (double)(bounds.y + bounds.height) - RangesKt.coerceAtLeast((double)fillHeight, (double)0.0);
            Rectangle2D.Double rectangle2 = new Rectangle2D.Double(bounds.x, fillY, bounds.width, Math.abs(fillHeight));
            g2d.setColor(this.getBackground());
            g2d.fill(rectangle2);
            g2d.setColor(UIUtil.getPanelBackground());
            float[] fArray = new float[]{3.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, fArray, 0.0f));
            g2d.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
            g2d.drawLine(bounds.x, bounds.y + bounds.height / 4, bounds.x + bounds.width, bounds.y + bounds.height / 4);
            g2d.drawLine(bounds.x, bounds.y + bounds.height / 2, bounds.x + bounds.width, bounds.y + bounds.height / 2);
            g2d.drawLine(bounds.x, bounds.y + bounds.height * 3 / 4, bounds.x + bounds.width, bounds.y + bounds.height * 3 / 4);
            g2d.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
            int textX = bounds.width;
            int textY = bounds.y + bounds.height;
            g2d.setColor(UIUtil.getPanelBackground());
            g2d.setFont(g2d.getFont().deriveFont(30.0f).deriveFont(1));
            g2d.rotate(-1.5707963267948966, textX, textY);
            g2d.drawString(this.description, textX, textY);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\tR\u001a\u0010%\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0007\"\u0004\b'\u0010\tR\u001a\u0010(\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\tR\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00067"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$Options;", "", "<init>", "()V", "period", "", "getPeriod", "()I", "setPeriod", "(I)V", "duration", "getDuration", "setDuration", "delay", "getDelay", "setDelay", "cyclic", "", "getCyclic", "()Z", "setCyclic", "(Z)V", "reverse", "getReverse", "setReverse", "inverse", "getInverse", "setInverse", "mirror", "getMirror", "setMirror", "freezeBefore", "getFreezeBefore", "setFreezeBefore", "freezeAfter", "getFreezeAfter", "setFreezeAfter", "coerceMin", "getCoerceMin", "setCoerceMin", "coerceMax", "getCoerceMax", "setCoerceMax", "type", "Lcom/intellij/util/animation/JBAnimator$Type;", "getType", "()Lcom/intellij/util/animation/JBAnimator$Type;", "setType", "(Lcom/intellij/util/animation/JBAnimator$Type;)V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "intellij.platform.ide.internal"})
    public static final class Options {
        private int period = 5;
        private int duration = 1000;
        private int delay;
        private boolean cyclic;
        private boolean reverse;
        private boolean inverse;
        private boolean mirror;
        private int freezeBefore;
        private int freezeAfter = 100;
        private int coerceMin;
        private int coerceMax = 100;
        @NotNull
        private JBAnimator.Type type = JBAnimator.Type.IN_TIME;
        @NotNull
        private Color color = (Color)new JBColor(9926313, 13674248);

        public final int getPeriod() {
            return this.period;
        }

        public final void setPeriod(int n) {
            this.period = n;
        }

        public final int getDuration() {
            return this.duration;
        }

        public final void setDuration(int n) {
            this.duration = n;
        }

        public final int getDelay() {
            return this.delay;
        }

        public final void setDelay(int n) {
            this.delay = n;
        }

        public final boolean getCyclic() {
            return this.cyclic;
        }

        public final void setCyclic(boolean bl) {
            this.cyclic = bl;
        }

        public final boolean getReverse() {
            return this.reverse;
        }

        public final void setReverse(boolean bl) {
            this.reverse = bl;
        }

        public final boolean getInverse() {
            return this.inverse;
        }

        public final void setInverse(boolean bl) {
            this.inverse = bl;
        }

        public final boolean getMirror() {
            return this.mirror;
        }

        public final void setMirror(boolean bl) {
            this.mirror = bl;
        }

        public final int getFreezeBefore() {
            return this.freezeBefore;
        }

        public final void setFreezeBefore(int n) {
            this.freezeBefore = n;
        }

        public final int getFreezeAfter() {
            return this.freezeAfter;
        }

        public final void setFreezeAfter(int n) {
            this.freezeAfter = n;
        }

        public final int getCoerceMin() {
            return this.coerceMin;
        }

        public final void setCoerceMin(int n) {
            this.coerceMin = n;
        }

        public final int getCoerceMax() {
            return this.coerceMax;
        }

        public final void setCoerceMax(int n) {
            this.coerceMax = n;
        }

        @NotNull
        public final JBAnimator.Type getType() {
            return this.type;
        }

        public final void setType(@NotNull JBAnimator.Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"<set-?>");
            this.type = type;
        }

        @NotNull
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.color = color;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$RColors;", "", "<init>", "(Ljava/lang/String;I)V", "RED", "ORANGE", "YELLOW", "GREEN", "BLUE", "INDIGO", "VIOLET", "intellij.platform.ide.internal"})
    private static final class RColors
    extends Enum<RColors> {
        public static final /* enum */ RColors RED = new RColors();
        public static final /* enum */ RColors ORANGE = new RColors();
        public static final /* enum */ RColors YELLOW = new RColors();
        public static final /* enum */ RColors GREEN = new RColors();
        public static final /* enum */ RColors BLUE = new RColors();
        public static final /* enum */ RColors INDIGO = new RColors();
        public static final /* enum */ RColors VIOLET = new RColors();
        private static final /* synthetic */ RColors[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RColors[] values() {
            return (RColors[])$VALUES.clone();
        }

        public static RColors valueOf(String value) {
            return Enum.valueOf(RColors.class, value);
        }

        @NotNull
        public static EnumEntries<RColors> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rColorsArray = new RColors[]{RColors.RED, RColors.ORANGE, RColors.YELLOW, RColors.GREEN, RColors.BLUE, RColors.INDIGO, RColors.VIOLET};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020\u0005H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$SpringButtonPanel;", "Lcom/intellij/ui/components/panels/Wrapper;", "text", "", "start", "Ljava/awt/Rectangle;", "until", "", "onFinish", "Ljava/util/function/Consumer;", "<init>", "(Ljava/lang/String;Ljava/awt/Rectangle;ILjava/util/function/Consumer;)V", "getUntil", "()I", "getOnFinish", "()Ljava/util/function/Consumer;", "button", "Ljavax/swing/JButton;", "getButton", "()Ljavax/swing/JButton;", "animator", "Lcom/intellij/util/animation/JBAnimator;", "getAnimator", "()Lcom/intellij/util/animation/JBAnimator;", "easing", "Lcom/intellij/util/animation/Easing;", "getEasing", "()Lcom/intellij/util/animation/Easing;", "turns", "getTurns", "setTurns", "(I)V", "flyAway", "", "jump", "generateBounds", "intellij.platform.ide.internal"})
    private static final class SpringButtonPanel
    extends Wrapper {
        private final int until;
        @NotNull
        private final Consumer<SpringButtonPanel> onFinish;
        @NotNull
        private final JButton button;
        @NotNull
        private final JBAnimator animator;
        @NotNull
        private final Easing easing;
        private int turns;

        /*
         * WARNING - void declaration
         */
        public SpringButtonPanel(@NotNull String text, @NotNull Rectangle start, int until, @NotNull Consumer<SpringButtonPanel> onFinish) {
            void $this$animator_u24lambda_u240;
            JBAnimator jBAnimator;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
            this.until = until;
            this.onFinish = onFinish;
            this.button = new JButton(text);
            JBAnimator jBAnimator2 = jBAnimator = new JBAnimator();
            SpringButtonPanel springButtonPanel = this;
            boolean bl = false;
            $this$animator_u24lambda_u240.setPeriod(5);
            $this$animator_u24lambda_u240.setType(JBAnimator.Type.IN_TIME);
            springButtonPanel.animator = jBAnimator;
            this.easing = SpringButtonPanel::easing$lambda$0;
            this.button.setBounds(start);
            this.button.addActionListener(arg_0 -> SpringButtonPanel._init_$lambda$0(this, arg_0));
            this.setLayout(null);
            this.add(this.button);
        }

        public final int getUntil() {
            return this.until;
        }

        @NotNull
        public final Consumer<SpringButtonPanel> getOnFinish() {
            return this.onFinish;
        }

        @NotNull
        public final JButton getButton() {
            return this.button;
        }

        @NotNull
        public final JBAnimator getAnimator() {
            return this.animator;
        }

        @NotNull
        public final Easing getEasing() {
            return this.easing;
        }

        public final int getTurns() {
            return this.turns;
        }

        public final void setTurns(int n) {
            this.turns = n;
        }

        /*
         * WARNING - void declaration
         */
        private final void flyAway() {
            void $this$flyAway_u24lambda_u240;
            Animation animation;
            Animation[] animationArray = new Animation[1];
            Rectangle rectangle = this.button.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            Animation animation2 = animation = Animations.animation((Rectangle)rectangle, (Rectangle)new Rectangle(this.getWidth() / 2, 0, 0, 0), this.button::setBounds);
            int n = 0;
            Animation[] animationArray2 = animationArray;
            JBAnimator jBAnimator = this.animator;
            boolean bl = false;
            $this$flyAway_u24lambda_u240.setDuration(350);
            $this$flyAway_u24lambda_u240.setEasing(this.easing);
            $this$flyAway_u24lambda_u240.runWhenExpired(() -> SpringButtonPanel.flyAway$lambda$0$0(this));
            Unit unit = Unit.INSTANCE;
            animationArray2[n] = animation;
            jBAnimator.animate(animationArray);
        }

        /*
         * WARNING - void declaration
         */
        private final void jump() {
            void $this$jump_u24lambda_u240;
            Animation animation;
            Animation[] animationArray = new Animation[1];
            Rectangle rectangle = this.button.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            Animation animation2 = animation = Animations.animation((Rectangle)rectangle, (Rectangle)this.generateBounds(), this.button::setBounds);
            int n = 0;
            Animation[] animationArray2 = animationArray;
            JBAnimator jBAnimator = this.animator;
            boolean bl = false;
            $this$jump_u24lambda_u240.setDuration(350);
            $this$jump_u24lambda_u240.setEasing(this.easing);
            Unit unit = Unit.INSTANCE;
            animationArray2[n] = animation;
            jBAnimator.animate(animationArray);
        }

        private final Rectangle generateBounds() {
            Rectangle size = this.getBounds();
            int x = (int)(Math.random() * (double)size.width / (double)2);
            int y = (int)(Math.random() * (double)size.height / (double)2);
            int width = (int)RangesKt.coerceAtLeast((double)(Math.random() * (double)(size.width - x)), (double)100.0);
            int height = (int)RangesKt.coerceAtLeast((double)(Math.random() * (double)(size.height - y)), (double)24.0);
            return new Rectangle(x, y, width, height);
        }

        private static final double easing$lambda$0(double x) {
            return 1.0 + 2.7 * Math.pow(x - 1.0, 3.0) + 1.7 * Math.pow(x - 1.0, 2.0);
        }

        private static final void _init_$lambda$0(SpringButtonPanel this$0, ActionEvent it) {
            if (this$0.turns >= this$0.until) {
                this$0.flyAway();
            } else {
                this$0.jump();
                int n = this$0.turns;
                this$0.turns = n + 1;
            }
        }

        private static final void flyAway$lambda$0$0(SpringButtonPanel this$0) {
            this$0.onFinish.accept(this$0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/ui/AnimationPanelTestAction$UpdateColorsOnHover;", "Lcom/intellij/ui/hover/HoverStateListener;", "component", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "backgroundFunction", "Lcom/intellij/util/animation/DoubleColorFunction;", "foregroundFunction", "helper", "Lcom/intellij/util/animation/ShowHideAnimator;", "hoverChanged", "", "Ljava/awt/Component;", "hovered", "", "intellij.platform.ide.internal"})
    private static final class UpdateColorsOnHover
    extends HoverStateListener {
        @NotNull
        private final JComponent component;
        @NotNull
        private final DoubleColorFunction backgroundFunction;
        @NotNull
        private final DoubleColorFunction foregroundFunction;
        @NotNull
        private final ShowHideAnimator helper;

        public UpdateColorsOnHover(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.component = component;
            Color color = this.component.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            Color color2 = this.component.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getForeground(...)");
            this.backgroundFunction = new DoubleColorFunction(color, color2);
            Color color3 = this.component.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getForeground(...)");
            Color color4 = this.component.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getBackground(...)");
            this.foregroundFunction = new DoubleColorFunction(color3, color4);
            this.helper = new ShowHideAnimator((Easing)new CubicBezierEasing(0.215, 0.61, 0.355, 1.0), arg_0 -> UpdateColorsOnHover.helper$lambda$0(this, arg_0));
            this.addTo(this.component);
        }

        protected void hoverChanged(@NotNull Component component, boolean hovered) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            ShowHideAnimator.setVisible$default((ShowHideAnimator)this.helper, (boolean)hovered, null, UpdateColorsOnHover::hoverChanged$lambda$0, (int)2, null);
        }

        private static final void helper$lambda$0(UpdateColorsOnHover this$0, double it) {
            this$0.component.setBackground(this$0.backgroundFunction.apply(it));
            this$0.component.setForeground(this$0.foregroundFunction.apply(it));
        }

        private static final Unit hoverChanged$lambda$0() {
            return Unit.INSTANCE;
        }
    }
}

