/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.observable.operation.core;

import com.intellij.openapi.observable.operation.OperationExecutionId;
import com.intellij.openapi.observable.operation.OperationExecutionStatus;
import com.intellij.openapi.observable.operation.core.AbstractObservableOperationTrace;
import com.intellij.openapi.observable.operation.core.MutableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationState;
import com.intellij.openapi.observable.operation.core.ObservableOperationStatus;
import com.intellij.openapi.util.text.NaturalComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0002,-B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J(\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100&H\u0002J0\u0010'\u001a\u00020\u001b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020)0(2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001b0&H\u0002J\n\u0010+\u001a\u00020\u0004H\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006."}, d2={"Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace;", "Lcom/intellij/openapi/observable/operation/core/AbstractObservableOperationTrace;", "Lcom/intellij/openapi/observable/operation/core/MutableOperationTrace;", "name", "", "isMerging", "", "<init>", "(Ljava/lang/String;Z)V", "()V", "(Ljava/lang/String;)V", "(Z)V", "getName", "()Ljava/lang/String;", "atomicState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace$State;", "kotlin.jvm.PlatformType", "state", "Lcom/intellij/openapi/observable/operation/core/ObservableOperationState;", "getState", "()Lcom/intellij/openapi/observable/operation/core/ObservableOperationState;", "status", "Lcom/intellij/openapi/observable/operation/core/ObservableOperationStatus;", "getStatus", "()Lcom/intellij/openapi/observable/operation/core/ObservableOperationStatus;", "traceSchedule", "", "id", "Lcom/intellij/openapi/observable/operation/OperationExecutionId;", "traceStart", "traceFinish", "Lcom/intellij/openapi/observable/operation/OperationExecutionStatus;", "detach", "detachAll", "updateState", "Lkotlin/Pair;", "nextState", "Lkotlin/Function1;", "forEachTask", "", "", "action", "toString", "State", "Companion", "intellij.platform.ide.observable"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nAtomicOperationTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomicOperationTrace.kt\ncom/intellij/openapi/observable/operation/core/AtomicOperationTrace\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,195:1\n481#2:196\n427#2:197\n383#2,7:206\n1266#3,4:198\n1525#3:202\n1557#3,3:203\n1560#3,3:213\n129#4:216\n158#4,3:217\n*S KotlinDebug\n*F\n+ 1 AtomicOperationTrace.kt\ncom/intellij/openapi/observable/operation/core/AtomicOperationTrace\n*L\n153#1:196\n153#1:197\n154#1:206,7\n153#1:198,4\n154#1:202\n154#1:203,3\n154#1:213,3\n155#1:216\n155#1:217,3\n*E\n"})
public final class AtomicOperationTrace
extends AbstractObservableOperationTrace
implements MutableOperationTrace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean isMerging;
    @NotNull
    private final AtomicReference<State> atomicState;

    public AtomicOperationTrace(@NotNull String name, boolean isMerging) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.isMerging = isMerging;
        this.atomicState = new AtomicReference<State>(new State(ObservableOperationStatus.COMPLETED, MapsKt.emptyMap(), MapsKt.emptyMap()));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public AtomicOperationTrace() {
        this("UNKNOWN", false);
    }

    public AtomicOperationTrace(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, false);
    }

    public AtomicOperationTrace(boolean isMerging) {
        this("UNKNOWN", isMerging);
    }

    @Override
    @NotNull
    public ObservableOperationState getState() {
        State state = this.atomicState.get();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"get(...)");
        return state;
    }

    @Override
    @NotNull
    public ObservableOperationStatus getStatus() {
        return this.getState().getStatus();
    }

    @Override
    public void traceSchedule(@NotNull OperationExecutionId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Pair<State, State> pair = this.updateState((Function1<? super State, State>)((Function1)arg_0 -> AtomicOperationTrace.traceSchedule$lambda$0(id, arg_0)));
        State old = (State)pair.component1();
        State state = (State)pair.component2();
        this.forEachTask(AtomicOperationTrace.Companion.minus(state.getScheduled(), old.getScheduled()), (Function1<? super OperationExecutionId, Unit>)((Function1)arg_0 -> AtomicOperationTrace.traceSchedule$lambda$1(this, arg_0)));
    }

    @Override
    public void traceStart(@NotNull OperationExecutionId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Pair<State, State> pair = this.updateState((Function1<? super State, State>)((Function1)arg_0 -> AtomicOperationTrace.traceStart$lambda$0(this, id, arg_0)));
        State old = (State)pair.component1();
        State state = (State)pair.component2();
        this.forEachTask(AtomicOperationTrace.Companion.minus(state.getStarted(), old.getStarted()), (Function1<? super OperationExecutionId, Unit>)((Function1)arg_0 -> AtomicOperationTrace.traceStart$lambda$1(this, arg_0)));
    }

    @Override
    public void traceFinish(@NotNull OperationExecutionId id, @NotNull OperationExecutionStatus status) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Pair<State, State> pair = this.updateState((Function1<? super State, State>)((Function1)arg_0 -> AtomicOperationTrace.traceFinish$lambda$0(this, id, arg_0)));
        State old = (State)pair.component1();
        State state = (State)pair.component2();
        this.forEachTask(AtomicOperationTrace.Companion.minus(old.getStarted(), state.getStarted()), (Function1<? super OperationExecutionId, Unit>)((Function1)arg_0 -> AtomicOperationTrace.traceFinish$lambda$1(this, status, arg_0)));
    }

    @Override
    public void detach(@NotNull OperationExecutionId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Pair<State, State> pair = this.updateState((Function1<? super State, State>)((Function1)arg_0 -> AtomicOperationTrace.detach$lambda$0(id, arg_0)));
        State old = (State)pair.component1();
        State state = (State)pair.component2();
        this.forEachTask(AtomicOperationTrace.Companion.minus(old.getScheduled(), state.getScheduled()), (Function1<? super OperationExecutionId, Unit>)((Function1)arg_0 -> AtomicOperationTrace.detach$lambda$1(this, arg_0)));
        this.forEachTask(AtomicOperationTrace.Companion.minus(old.getStarted(), state.getStarted()), (Function1<? super OperationExecutionId, Unit>)((Function1)arg_0 -> AtomicOperationTrace.detach$lambda$2(this, arg_0)));
    }

    @Override
    public void detachAll() {
        Pair<State, State> pair = this.updateState((Function1<? super State, State>)((Function1)AtomicOperationTrace::detachAll$lambda$0));
        State old = (State)pair.component1();
        State state = (State)pair.component2();
        this.forEachTask(AtomicOperationTrace.Companion.minus(old.getScheduled(), state.getScheduled()), (Function1<? super OperationExecutionId, Unit>)((Function1)arg_0 -> AtomicOperationTrace.detachAll$lambda$1(this, arg_0)));
        this.forEachTask(AtomicOperationTrace.Companion.minus(old.getStarted(), state.getStarted()), (Function1<? super OperationExecutionId, Unit>)((Function1)arg_0 -> AtomicOperationTrace.detachAll$lambda$2(this, arg_0)));
    }

    private final Pair<State, State> updateState(Function1<? super State, State> nextState) {
        State state;
        State state2;
        Ref.ObjectRef oldState = new Ref.ObjectRef();
        State state3 = this.atomicState.updateAndGet(arg_0 -> AtomicOperationTrace.updateState$lambda$0(oldState, nextState, arg_0));
        if (oldState.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oldState");
            state2 = null;
        } else {
            state2 = (State)oldState.element;
        }
        if (state2.getStatus() != state3.getStatus()) {
            switch (WhenMappings.$EnumSwitchMapping$0[state3.getStatus().ordinal()]) {
                case 1: {
                    this.fireOperationScheduled();
                    break;
                }
                case 2: {
                    this.fireOperationStarted();
                    break;
                }
                case 3: {
                    this.fireOperationFinished();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (oldState.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oldState");
            state = null;
        } else {
            state = (State)oldState.element;
        }
        return TuplesKt.to((Object)state, (Object)state3);
    }

    private final void forEachTask(Map<OperationExecutionId, Integer> state, Function1<? super OperationExecutionId, Unit> action) {
        for (Map.Entry<OperationExecutionId, Integer> entry : state.entrySet()) {
            OperationExecutionId id = entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            int n = 0;
            while (n < count) {
                int it = n++;
                boolean bl = false;
                action.invoke((Object)id);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Map map;
        Map.Entry it$iv$iv;
        boolean bl;
        Map map2;
        String string;
        Object it;
        Object object;
        Iterable $this$associateByTo$iv$iv$iv;
        Map<OperationExecutionId, Integer> $this$mapKeysTo$iv$iv;
        Object $this$mapKeys$iv;
        ObservableOperationState observableOperationState = this.getState();
        ObservableOperationStatus status = observableOperationState.component1();
        Map<OperationExecutionId, Integer> scheduled = observableOperationState.component2();
        Map<OperationExecutionId, Integer> started = observableOperationState.component3();
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add(this.getName() + ": " + status);
        Map<OperationExecutionId, Integer> map3 = scheduled;
        StringJoiner stringJoiner = joiner;
        boolean $i$f$mapKeys = false;
        void var8_9 = $this$mapKeys$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterator iterator = $this$mapKeysTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            string = "S" + it.getKey();
            map2 = object;
            bl = false;
            it = it$iv$iv.getValue();
            map2.put(string, it);
        }
        $this$mapKeys$iv = started;
        object = destination$iv$iv$iv;
        $i$f$mapKeys = false;
        $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        destination$iv$iv$iv = destination$iv$iv;
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv$iv;
            boolean bl3 = false;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            string = "P" + it.getKey();
            map2 = map;
            bl = false;
            it = it$iv$iv.getValue();
            map2.put(string, it);
        }
        map = destination$iv$iv$iv;
        $this$mapKeys$iv = MapsKt.plus((Map)object, (Map)map).entrySet();
        boolean $i$f$groupBy = false;
        $this$mapKeysTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it2;
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            Map.Entry it3 = (Map.Entry)element$iv$iv;
            boolean $i$a$-groupBy-AtomicOperationTrace$toString$52 = false;
            String key$iv$iv = (String)it3.getKey();
            it = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            Map.Entry $i$a$-groupBy-AtomicOperationTrace$toString$52 = (Map.Entry)element$iv$iv;
            object = list$iv$iv;
            boolean bl5 = false;
            object.add(((Number)it2.getValue()).intValue());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it4;
            Map.Entry item$iv$iv;
            Map.Entry list$iv$iv = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl6 = false;
            object.add("  " + CollectionsKt.sumOfInt((Iterable)((Iterable)it4.getValue())) + it4.getKey());
        }
        Iterable iterable = (List)destination$iv$iv;
        Comparator comparator = NaturalComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"INSTANCE");
        stringJoiner.add(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        String string2 = joiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final State traceSchedule$lambda$0(OperationExecutionId $id, State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new State(switch (WhenMappings.$EnumSwitchMapping$0[it.getStatus().ordinal()]) {
            case 1 -> ObservableOperationStatus.SCHEDULED;
            case 2 -> ObservableOperationStatus.IN_PROGRESS;
            case 3 -> ObservableOperationStatus.SCHEDULED;
            default -> throw new NoWhenBranchMatchedException();
        }, AtomicOperationTrace.Companion.update(it.getScheduled(), $id, 1), it.getStarted());
    }

    private static final Unit traceSchedule$lambda$1(AtomicOperationTrace this$0, OperationExecutionId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fireTaskScheduled(it);
        return Unit.INSTANCE;
    }

    private static final State traceStart$lambda$0(AtomicOperationTrace this$0, OperationExecutionId $id, State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int numStarted = this$0.isMerging ? Math.max(1, AtomicOperationTrace.Companion.count(it.getScheduled(), $id)) : 1;
        return new State(ObservableOperationStatus.IN_PROGRESS, AtomicOperationTrace.Companion.update(it.getScheduled(), $id, -numStarted), AtomicOperationTrace.Companion.update(it.getStarted(), $id, numStarted));
    }

    private static final Unit traceStart$lambda$1(AtomicOperationTrace this$0, OperationExecutionId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fireTaskStarted(it);
        return Unit.INSTANCE;
    }

    private static final State traceFinish$lambda$0(AtomicOperationTrace this$0, OperationExecutionId $id, State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int numFinished = this$0.isMerging ? AtomicOperationTrace.Companion.count(it.getStarted(), $id) : 1;
        Map started = AtomicOperationTrace.Companion.update(it.getStarted(), $id, -numFinished);
        return new State(AtomicOperationTrace.Companion.count(started) > 0 ? ObservableOperationStatus.IN_PROGRESS : (AtomicOperationTrace.Companion.count(it.getScheduled()) > 0 ? ObservableOperationStatus.IN_PROGRESS : ObservableOperationStatus.COMPLETED), it.getScheduled(), started);
    }

    private static final Unit traceFinish$lambda$1(AtomicOperationTrace this$0, OperationExecutionStatus $status, OperationExecutionId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fireTaskFinished(it, $status);
        return Unit.INSTANCE;
    }

    private static final State detach$lambda$0(OperationExecutionId $id, State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map scheduled = AtomicOperationTrace.Companion.remove(it.getScheduled(), $id);
        Map started = AtomicOperationTrace.Companion.remove(it.getStarted(), $id);
        return new State(AtomicOperationTrace.Companion.count(started) > 0 ? ObservableOperationStatus.IN_PROGRESS : (AtomicOperationTrace.Companion.count(scheduled) > 0 ? it.getStatus() : ObservableOperationStatus.COMPLETED), scheduled, started);
    }

    private static final Unit detach$lambda$1(AtomicOperationTrace this$0, OperationExecutionId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fireTaskDetached(it);
        return Unit.INSTANCE;
    }

    private static final Unit detach$lambda$2(AtomicOperationTrace this$0, OperationExecutionId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fireTaskDetached(it);
        return Unit.INSTANCE;
    }

    private static final State detachAll$lambda$0(State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new State(ObservableOperationStatus.COMPLETED, MapsKt.emptyMap(), MapsKt.emptyMap());
    }

    private static final Unit detachAll$lambda$1(AtomicOperationTrace this$0, OperationExecutionId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fireTaskDetached(it);
        return Unit.INSTANCE;
    }

    private static final Unit detachAll$lambda$2(AtomicOperationTrace this$0, OperationExecutionId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fireTaskDetached(it);
        return Unit.INSTANCE;
    }

    private static final State updateState$lambda$0(Ref.ObjectRef $oldState, Function1 $nextState, State it) {
        Intrinsics.checkNotNull((Object)it);
        $oldState.element = it;
        return (State)$nextState.invoke((Object)it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J+\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u0002H\u0006H\u0002\u00a2\u0006\u0002\u0010\tJ?\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u0007\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\fJ>\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u0007\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J7\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u0007\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u0002H\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace$Companion;", "", "<init>", "()V", "count", "", "K", "", "id", "(Ljava/util/Map;Ljava/lang/Object;)I", "update", "value", "(Ljava/util/Map;Ljava/lang/Object;I)Ljava/util/Map;", "minus", "map", "remove", "(Ljava/util/Map;Ljava/lang/Object;)Ljava/util/Map;", "intellij.platform.ide.observable"})
    @SourceDebugExtension(value={"SMAP\nAtomicOperationTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomicOperationTrace.kt\ncom/intellij/openapi/observable/operation/core/AtomicOperationTrace$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,195:1\n1849#2,3:196\n1266#2,4:201\n466#3:199\n415#3:200\n540#3:205\n525#3,6:206\n*S KotlinDebug\n*F\n+ 1 AtomicOperationTrace.kt\ncom/intellij/openapi/observable/operation/core/AtomicOperationTrace$Companion\n*L\n171#1:196,3\n187#1:201,4\n187#1:199\n187#1:200\n188#1:205\n188#1:206,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final <K> int count(Map<K, Integer> $this$count) {
            void $this$fold$iv;
            Iterable iterable = $this$count.entrySet();
            int initial$iv = 0;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void it;
                Map.Entry entry = (Map.Entry)element$iv;
                int acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc + ((Number)it.getValue()).intValue();
            }
            return accumulator$iv;
        }

        private final <K> int count(Map<K, Integer> $this$count, K id) {
            Integer n = $this$count.get(id);
            return n != null ? n : 0;
        }

        private final <K> Map<K, Integer> update(Map<K, Integer> $this$update, K id, int value) {
            int numTasks = this.count($this$update, id) + value;
            if (numTasks > 0) {
                return MapsKt.plus($this$update, (Pair)TuplesKt.to(id, (Object)numTasks));
            }
            return this.remove($this$update, id);
        }

        /*
         * WARNING - void declaration
         */
        private final <K> Map<K, Integer> minus(Map<K, Integer> $this$minus, Map<K, Integer> map) {
            void $this$filterTo$iv$iv;
            void $this$associateByTo$iv$iv$iv;
            Map $this$mapValuesTo$iv$iv;
            Map<K, Integer> $this$mapValues$iv = $this$minus;
            boolean $i$f$mapValues = false;
            Map<K, Integer> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Object object = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                Integer n = ((Number)it.getValue()).intValue() - Companion.count(map, it.getKey());
                map4.put(k, n);
            }
            Map $this$filter$iv = destination$iv$iv$iv;
            boolean $i$f$filter = false;
            $this$mapValuesTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            object = $this$filterTo$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = (Map.Entry)object.next();
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() > 0)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv;
        }

        private final <K> Map<K, Integer> remove(Map<K, Integer> $this$remove, K id) {
            return MapsKt.minus($this$remove, id);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J?\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\u0007H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace$State;", "Lcom/intellij/openapi/observable/operation/core/ObservableOperationState;", "status", "Lcom/intellij/openapi/observable/operation/core/ObservableOperationStatus;", "scheduled", "", "Lcom/intellij/openapi/observable/operation/OperationExecutionId;", "", "started", "<init>", "(Lcom/intellij/openapi/observable/operation/core/ObservableOperationStatus;Ljava/util/Map;Ljava/util/Map;)V", "getStatus", "()Lcom/intellij/openapi/observable/operation/core/ObservableOperationStatus;", "getScheduled", "()Ljava/util/Map;", "getStarted", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.ide.observable"})
    private static final class State
    implements ObservableOperationState {
        @NotNull
        private final ObservableOperationStatus status;
        @NotNull
        private final Map<OperationExecutionId, Integer> scheduled;
        @NotNull
        private final Map<OperationExecutionId, Integer> started;

        public State(@NotNull ObservableOperationStatus status, @NotNull Map<OperationExecutionId, Integer> scheduled, @NotNull Map<OperationExecutionId, Integer> started) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter(scheduled, (String)"scheduled");
            Intrinsics.checkNotNullParameter(started, (String)"started");
            this.status = status;
            this.scheduled = scheduled;
            this.started = started;
        }

        @Override
        @NotNull
        public ObservableOperationStatus getStatus() {
            return this.status;
        }

        @Override
        @NotNull
        public Map<OperationExecutionId, Integer> getScheduled() {
            return this.scheduled;
        }

        @Override
        @NotNull
        public Map<OperationExecutionId, Integer> getStarted() {
            return this.started;
        }

        @Override
        @NotNull
        public final ObservableOperationStatus component1() {
            return this.status;
        }

        @Override
        @NotNull
        public final Map<OperationExecutionId, Integer> component2() {
            return this.scheduled;
        }

        @Override
        @NotNull
        public final Map<OperationExecutionId, Integer> component3() {
            return this.started;
        }

        @NotNull
        public final State copy(@NotNull ObservableOperationStatus status, @NotNull Map<OperationExecutionId, Integer> scheduled, @NotNull Map<OperationExecutionId, Integer> started) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter(scheduled, (String)"scheduled");
            Intrinsics.checkNotNullParameter(started, (String)"started");
            return new State(status, scheduled, started);
        }

        public static /* synthetic */ State copy$default(State state, ObservableOperationStatus observableOperationStatus, Map map, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                observableOperationStatus = state.status;
            }
            if ((n & 2) != 0) {
                map = state.scheduled;
            }
            if ((n & 4) != 0) {
                map2 = state.started;
            }
            return state.copy(observableOperationStatus, map, map2);
        }

        @NotNull
        public String toString() {
            return "State(status=" + this.status + ", scheduled=" + this.scheduled + ", started=" + this.started + ")";
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + ((Object)this.scheduled).hashCode();
            result = result * 31 + ((Object)this.started).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.status != state.status) {
                return false;
            }
            if (!Intrinsics.areEqual(this.scheduled, state.scheduled)) {
                return false;
            }
            return Intrinsics.areEqual(this.started, state.started);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObservableOperationStatus.values().length];
            try {
                nArray[ObservableOperationStatus.SCHEDULED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObservableOperationStatus.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObservableOperationStatus.COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

