/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.observable.properties;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.properties.AbstractObservableBooleanProperty;
import com.intellij.openapi.observable.properties.AtomicMutableBooleanProperty;
import com.intellij.openapi.observable.properties.BooleanProperty;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u000b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0005H\u0016J!\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0016J\u001e\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0016J\u001e\u0010\u001d\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "Lcom/intellij/openapi/observable/properties/AbstractObservableBooleanProperty;", "Lcom/intellij/openapi/observable/properties/AtomicMutableBooleanProperty;", "Lcom/intellij/openapi/observable/properties/BooleanProperty;", "initial", "", "<init>", "(Z)V", "value", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "get", "()Ljava/lang/Boolean;", "set", "", "reset", "updateAndGet", "update", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Boolean;", "getAndSet", "newValue", "compareAndSet", "expect", "afterSet", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "afterReset", "intellij.platform.ide.observable"})
public final class AtomicBooleanProperty
extends AbstractObservableBooleanProperty
implements AtomicMutableBooleanProperty,
BooleanProperty {
    @NotNull
    private final AtomicReference<Boolean> value;

    public AtomicBooleanProperty(boolean initial) {
        this.value = new AtomicReference<Boolean>(initial);
    }

    @Override
    @NotNull
    public Boolean get() {
        Boolean bl = this.value.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        return bl;
    }

    @Override
    public void set() {
        this.set(true);
    }

    @Override
    public void reset() {
        this.set(false);
    }

    @Override
    public void set(boolean value) {
        Boolean oldValue = this.value.getAndSet(value);
        Intrinsics.checkNotNull((Object)oldValue);
        this.fireChangeEvents(oldValue, value);
    }

    @Override
    @NotNull
    public Boolean updateAndGet(@NotNull Function1<? super Boolean, Boolean> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        Ref.ObjectRef oldValue = new Ref.ObjectRef();
        Boolean newValue = this.value.updateAndGet(arg_0 -> AtomicBooleanProperty.updateAndGet$lambda$0(oldValue, update, arg_0));
        Object object = oldValue.element;
        Intrinsics.checkNotNull((Object)object);
        boolean bl = (Boolean)object;
        Intrinsics.checkNotNull((Object)newValue);
        this.fireChangeEvents(bl, newValue);
        return newValue;
    }

    @Override
    public boolean getAndSet(boolean newValue) {
        Boolean oldValue = this.value.getAndSet(newValue);
        Intrinsics.checkNotNull((Object)oldValue);
        this.fireChangeEvents(oldValue, newValue);
        return oldValue;
    }

    public final boolean compareAndSet(boolean expect, boolean update) {
        boolean succeed = this.value.compareAndSet(expect, update);
        if (succeed) {
            this.fireChangeEvents(expect, update);
        }
        return succeed;
    }

    @Override
    public void afterSet(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.afterSet(null, listener);
    }

    @Override
    public void afterSet(@NotNull Function0<Unit> listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.afterSet(parentDisposable, listener);
    }

    @Override
    public void afterReset(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.afterReset(null, listener);
    }

    @Override
    public void afterReset(@NotNull Function0<Unit> listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.afterReset(parentDisposable, listener);
    }

    private static final Boolean updateAndGet$lambda$0(Ref.ObjectRef $oldValue, Function1 $update, Boolean it) {
        $oldValue.element = it;
        Intrinsics.checkNotNull((Object)it);
        return (Boolean)$update.invoke((Object)it);
    }
}

