/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.InternalPluginResults;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

final class UpdatePluginsApp
implements ApplicationStarter {
    private static final Logger LOG = Logger.getInstance(UpdatePluginsApp.class);
    private static final String OLD_CONFIG_DIR_PROPERTY = "idea.plugin.migration.config.dir";

    UpdatePluginsApp() {
    }

    public void premain(@NotNull List<String> args) {
        if (args == null) {
            UpdatePluginsApp.$$$reportNull$$$0(0);
        }
        System.setProperty("idea.skip.indices.initialization", "true");
        String oldConfig = System.getProperty(OLD_CONFIG_DIR_PROPERTY);
        if (oldConfig != null) {
            RepositoryHelper.updatePluginHostsFromConfigDir((Path)Path.of(oldConfig, new String[0]), (Logger)LOG);
        }
    }

    public void main(@NotNull List<String> args) {
        boolean installed;
        Collection<PluginDownloader> pluginsToUpdate;
        Collection<PluginDownloader> availableUpdates;
        InternalPluginResults updateCheckResult;
        if (args == null) {
            UpdatePluginsApp.$$$reportNull$$$0(1);
        }
        if (Boolean.getBoolean("idea.force.plugin.updates")) {
            UpdatePluginsApp.logInfo("Plugin updates are applied");
            System.exit(0);
        }
        try {
            updateCheckResult = (InternalPluginResults)ApplicationManager.getApplication().executeOnPooledThread(() -> UpdateChecker.getInternalPluginUpdates()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Failed to check plugin updates", (Throwable)e);
            System.exit(1);
            return;
        }
        if (!updateCheckResult.getErrors().isEmpty()) {
            LOG.warn("Errors occurred during the update check: " + String.valueOf(ContainerUtil.map(updateCheckResult.getErrors().entrySet(), entry -> "host=" + (String)entry.getKey() + ": " + ((Exception)entry.getValue()).getMessage())));
        }
        if ((availableUpdates = updateCheckResult.getPluginUpdates().getAllEnabled()).isEmpty()) {
            UpdatePluginsApp.logInfo("all plugins up to date");
            System.exit(0);
            return;
        }
        if (args.size() > 1) {
            HashSet<String> filter = new HashSet<String>(args.subList(1, args.size()));
            pluginsToUpdate = availableUpdates.stream().filter(downloader -> filter.contains(downloader.getId().getIdString())).toList();
        } else {
            pluginsToUpdate = availableUpdates;
        }
        pluginsToUpdate = UpdatePluginsApp.hotfix242InstallDependency(pluginsToUpdate, PluginId.getId((String)"Pythonid"), PluginId.getId((String)"PythonCore"));
        pluginsToUpdate = UpdatePluginsApp.hotfix242InstallDependency(pluginsToUpdate, PluginId.getId((String)"intellij.jupyter"), PluginId.getId((String)"com.intellij.notebooks.core"));
        pluginsToUpdate = UpdatePluginsApp.hotfix242InstallDependency(pluginsToUpdate, PluginId.getId((String)"R4Intellij"), PluginId.getId((String)"com.intellij.notebooks.core"));
        UpdatePluginsApp.logInfo("Plugins to update: " + String.valueOf(ContainerUtil.map(pluginsToUpdate, downloader -> downloader.getPluginName() + " version " + downloader.getPluginVersion())));
        try {
            Collection<PluginDownloader> finalPluginsToUpdate = pluginsToUpdate;
            installed = (Boolean)ApplicationManager.getApplication().executeOnPooledThread(() -> UpdateInstaller.installPluginUpdates((Collection)finalPluginsToUpdate, (ProgressIndicator)new EmptyProgressIndicator())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Failed to install plugin updates", (Throwable)e);
            System.exit(1);
            return;
        }
        if (installed) {
            UpdatePluginsApp.logInfo("Plugin updates are prepared to be installed");
            System.exit(0);
        } else {
            LOG.warn("Update failed");
            System.exit(1);
        }
    }

    private static void logInfo(String msg) {
        System.out.println(msg);
        LOG.info(msg);
    }

    @NotNull
    private static Collection<PluginDownloader> hotfix242InstallDependency(@NotNull Collection<PluginDownloader> pluginsToUpdate, PluginId pluginId, PluginId dependencyId) {
        PluginDownloader dependencyDownloader;
        PluginNode dependencyNode;
        if (pluginsToUpdate == null) {
            UpdatePluginsApp.$$$reportNull$$$0(2);
        }
        if (PluginManagerCore.isPluginInstalled((PluginId)dependencyId) || !ContainerUtil.exists(pluginsToUpdate, p -> p.getId().equals((Object)pluginId)) || ContainerUtil.exists(pluginsToUpdate, p -> p.getId().equals((Object)dependencyId))) {
            Collection<PluginDownloader> collection = pluginsToUpdate;
            if (collection == null) {
                UpdatePluginsApp.$$$reportNull$$$0(3);
            }
            return collection;
        }
        @NotNull PluginDownloader pluginDownloader = Objects.requireNonNull((PluginDownloader)ContainerUtil.find(pluginsToUpdate, p -> p.getId().equals((Object)pluginId)));
        if (!ContainerUtil.exists((Iterable)pluginDownloader.getDescriptor().getDependencies(), d -> d.getPluginId().equals((Object)dependencyId))) {
            UpdatePluginsApp.logInfo("Plugin " + String.valueOf(pluginId) + " does not depend on " + String.valueOf(dependencyId));
            Collection<PluginDownloader> collection = pluginsToUpdate;
            if (collection == null) {
                UpdatePluginsApp.$$$reportNull$$$0(4);
            }
            return collection;
        }
        try {
            dependencyNode = (PluginNode)ApplicationManager.getApplication().executeOnPooledThread(() -> MarketplaceRequests.getInstance().getLastCompatiblePluginUpdate(dependencyId)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Failed to process " + String.valueOf(pluginId) + " plugin dependencies");
            Collection<PluginDownloader> collection = pluginsToUpdate;
            if (collection == null) {
                UpdatePluginsApp.$$$reportNull$$$0(5);
            }
            return collection;
        }
        if (dependencyNode == null) {
            UpdatePluginsApp.logInfo("Failed to find a suitable " + String.valueOf(dependencyId) + " plugin");
            Collection<PluginDownloader> collection = pluginsToUpdate;
            if (collection == null) {
                UpdatePluginsApp.$$$reportNull$$$0(6);
            }
            return collection;
        }
        try {
            dependencyDownloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)dependencyNode);
        }
        catch (IOException e) {
            LOG.error("Failed to create a plugin downloader", (Throwable)e);
            Collection<PluginDownloader> collection = pluginsToUpdate;
            if (collection == null) {
                UpdatePluginsApp.$$$reportNull$$$0(7);
            }
            return collection;
        }
        UpdatePluginsApp.logInfo("Added a required dependency for " + String.valueOf(pluginId) + " plugin for installation: " + String.valueOf(dependencyId));
        ArrayList<PluginDownloader> result = new ArrayList<PluginDownloader>(pluginsToUpdate);
        result.add(dependencyDownloader);
        ArrayList<PluginDownloader> arrayList = result;
        if (arrayList == null) {
            UpdatePluginsApp.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToUpdate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/UpdatePluginsApp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/UpdatePluginsApp";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "hotfix242InstallDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "premain";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "main";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hotfix242InstallDependency";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

