/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.execution.CommandLineUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.plugins.newui.PluginModelAsyncOperationsExecutor;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.PlatformUpdates;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInfoPanel;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.Restarter;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import com.intellij.util.ui.JBUI;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PlatformUpdateDialog
extends AbstractUpdateDialog {
    @Nullable
    private final Project myProject;
    private final PlatformUpdates.Loaded myPlatformUpdate;
    @Nullable
    private final Collection<PluginDownloader> myUpdatesForPlugins;
    private final boolean myWriteProtected;
    @Nullable
    private final LicenseInfo myLicenseInfo;
    @Nullable
    private final Path myTestPatch;

    public PlatformUpdateDialog(@Nullable Project project, @NotNull PlatformUpdates.Loaded platformUpdate, boolean addConfigureUpdatesLink, @Nullable Collection<PluginDownloader> updatesForPlugins, @Nullable List<String> incompatiblePluginNames) {
        if (platformUpdate == null) {
            PlatformUpdateDialog.$$$reportNull$$$0(0);
        }
        super(project, addConfigureUpdatesLink);
        this.myProject = project;
        this.myPlatformUpdate = platformUpdate;
        this.myUpdatesForPlugins = updatesForPlugins;
        UpdateChain patches = this.myPlatformUpdate.getPatches();
        this.myWriteProtected = patches != null && OS.CURRENT != OS.Windows && !Files.isWritable(PathManager.getHomeDir());
        this.myLicenseInfo = PlatformUpdateDialog.getLicensingInfo(this.myPlatformUpdate);
        this.myTestPatch = null;
        this.init();
        if (!ContainerUtil.isEmpty(incompatiblePluginNames)) {
            String names = String.join((CharSequence)"<br/>", incompatiblePluginNames);
            this.setErrorText(IdeBundle.message((String)"updates.incompatible.plugins.found", (Object[])new Object[]{incompatiblePluginNames.size(), names}));
        }
        IdeUpdateUsageTriggerCollector.triggerUpdateDialog(patches, ApplicationManager.getApplication().isRestartCapable());
    }

    private PlatformUpdateDialog(@Nullable Project project, PlatformUpdates.Loaded platformUpdate, @Nullable Path patchFile) {
        super(true);
        this.myProject = project;
        this.myPlatformUpdate = platformUpdate;
        this.myUpdatesForPlugins = null;
        this.myWriteProtected = false;
        this.myLicenseInfo = PlatformUpdateDialog.getLicensingInfo(this.myPlatformUpdate);
        this.myTestPatch = patchFile;
        this.init();
        this.setTitle("[TEST] " + this.getTitle());
    }

    public static PlatformUpdateDialog createTestDialog(@Nullable Project project, @NotNull PlatformUpdates.Loaded platformUpdate, @Nullable Path patchFile) {
        if (platformUpdate == null) {
            PlatformUpdateDialog.$$$reportNull$$$0(1);
        }
        return new PlatformUpdateDialog(project, platformUpdate, patchFile);
    }

    @Nullable
    private static LicenseInfo getLicensingInfo(PlatformUpdates.Loaded platformUpdate) {
        LicensingFacade la = LicensingFacade.getInstance();
        if (la == null) {
            return null;
        }
        UpdateChannel channel = platformUpdate.getUpdatedChannel();
        if (channel.getLicensing() == UpdateChannel.Licensing.EAP) {
            return new LicenseInfo(IdeBundle.message((String)"updates.channel.bundled.key", (Object[])new Object[0]), Boolean.FALSE);
        }
        Date releaseDate = platformUpdate.getNewBuild().getReleaseDate();
        if (releaseDate == null) {
            return null;
        }
        if (!la.isApplicableForProduct(releaseDate)) {
            return new LicenseInfo(IdeBundle.message((String)"updates.paid.upgrade", (Object[])new Object[]{channel.getEvalDays()}), Boolean.TRUE);
        }
        if (la.isPerpetualForProduct(releaseDate)) {
            return new LicenseInfo(IdeBundle.message((String)"updates.fallback.build", (Object[])new Object[0]), Boolean.FALSE);
        }
        Date expiration = la.getLicenseExpirationDate();
        if (expiration != null) {
            return new LicenseInfo(IdeBundle.message((String)"updates.interim.build", (Object[])new Object[]{NlsMessages.formatDateLong((Date)expiration)}), Boolean.FALSE);
        }
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        UpdateInfoPanel infoPanel = new UpdateInfoPanel(this.myPlatformUpdate.getNewBuild(), this.myPlatformUpdate.getPatches(), this.myTestPatch, this.myWriteProtected, this.myLicenseInfo != null ? this.myLicenseInfo.licenseNote : null, this.myLicenseInfo != null && this.myLicenseInfo.warning, this.myAddConfigureUpdatesLink, this.myPlatformUpdate.getUpdatedChannel(), this.myDisposable);
        JPanel jPanel = Registry.is((String)"ide.update.dialog.new.ui.enabled") ? infoPanel.createNew() : infoPanel.create();
        if (jPanel == null) {
            PlatformUpdateDialog.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            PlatformUpdateDialog.$$$reportNull$$$0(3);
        }
        return dialogStyle;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent component = super.createSouthPanel();
        component.setBorder(JBUI.Borders.empty((int)8));
        JComponent jComponent = component;
        if (jComponent == null) {
            PlatformUpdateDialog.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = new Action[]{new AbstractAction(IdeBundle.message((String)"updates.ignore.update.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String build = PlatformUpdateDialog.this.myPlatformUpdate.getNewBuild().getNumber().asStringWithoutProductCode();
                UpdateSettings.getInstance().getIgnoredBuildNumbers().add(build);
                PlatformUpdateDialog.this.doCancelAction();
            }
        }};
        if (actionArray == null) {
            PlatformUpdateDialog.$$$reportNull$$$0(5);
        }
        return actionArray;
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getCancelAction());
        AbstractAction updateButton = null;
        if (this.myPlatformUpdate.getPatches() != null || this.myTestPatch != null) {
            boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
            String name = IdeBundle.message((String)(canRestart ? "updates.download.and.restart.button" : "updates.apply.manually.button"), (Object[])new Object[0]);
            updateButton = new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlatformUpdateDialog.this.close(0);
                    Set downloaders = PlatformUpdateDialog.this.myUpdatesForPlugins != null ? PlatformUpdateDialog.this.myUpdatesForPlugins : Set.of();
                    PluginModelAsyncOperationsExecutor.INSTANCE.findPlugins(downloaders, plugins2 -> {
                        PlatformUpdateDialog.this.downloadPatchAndRestart((Map<PluginId, PluginUiModel>)plugins2);
                        return Unit.INSTANCE;
                    });
                }
            };
            updateButton.setEnabled(!this.myWriteProtected);
        } else {
            final String downloadUrl = this.myPlatformUpdate.getNewBuild().getDownloadUrl();
            if (downloadUrl != null) {
                updateButton = new AbstractAction(IdeBundle.message((String)"updates.download.button", (Object[])new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlatformUpdateDialog.this.close(0);
                        BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl(downloadUrl));
                    }
                };
            }
        }
        if (updateButton != null) {
            updateButton.putValue("DefaultAction", Boolean.TRUE);
            actions.add(updateButton);
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            PlatformUpdateDialog.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    @Override
    @NotNull
    protected String getCancelButtonText() {
        String string = IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0]);
        if (string == null) {
            PlatformUpdateDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void downloadPatchAndRestart(Map<PluginId, PluginUiModel> installedPlugins) {
        final ArrayList selectedPluginsToUpdate = new ArrayList();
        if (this.myUpdatesForPlugins != null && !installedPlugins.isEmpty()) {
            PluginUpdateDialog dialog = new PluginUpdateDialog(this.myProject, (Collection)ContainerUtil.map(this.myUpdatesForPlugins, it -> it.getUiModel()), null, installedPlugins);
            if (!dialog.showAndGet()) {
                return;
            }
            selectedPluginsToUpdate.addAll(PluginUpdateDialog.getSelectedDownloaders(this.myUpdatesForPlugins, (PluginUpdateDialog)dialog));
        }
        new Task.Backgroundable(this.myProject, IdeBundle.message((String)"update.preparing", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                String[] command;
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    if (PlatformUpdateDialog.this.myTestPatch != null) {
                        command = UpdateInstaller.preparePatchCommand(List.of(PlatformUpdateDialog.this.myTestPatch), (ProgressIndicator)indicator);
                    } else {
                        List files = UpdateInstaller.downloadPatchChain((List)Objects.requireNonNull(PlatformUpdateDialog.this.myPlatformUpdate.getPatches()).getChain(), (ProgressIndicator)indicator);
                        command = UpdateInstaller.preparePatchCommand((List)files, (ProgressIndicator)indicator);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logger.getInstance(PlatformUpdateDialog.class).warn((Throwable)e);
                    String title = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                    String downloadUrl = UpdateInfoPanel.downloadUrl(PlatformUpdateDialog.this.myPlatformUpdate.getNewBuild(), PlatformUpdateDialog.this.myPlatformUpdate.getUpdatedChannel());
                    String message = IdeBundle.message((String)"update.downloading.patch.error", (Object[])new Object[]{e.getMessage()});
                    UpdateChecker.getNotificationGroupForIdeUpdateResults().createNotification(title, message, NotificationType.ERROR).addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"update.downloading.patch.open", (Object[])new Object[0]), () -> BrowserUtil.browse((String)downloadUrl))).setDisplayId("ide.patch.download.failed").notify(this.myProject);
                    return;
                }
                if (!ContainerUtil.isEmpty((Collection)selectedPluginsToUpdate)) {
                    UpdateInstaller.installPluginUpdates((Collection)selectedPluginsToUpdate, (ProgressIndicator)indicator);
                }
                if (ApplicationManager.getApplication().isRestartCapable()) {
                    if (indicator.isShowing()) {
                        PlatformUpdateDialog.restartLaterAndRunCommand(command);
                    } else {
                        String title = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                        String message = IdeBundle.message((String)"update.ready.message", (Object[])new Object[0]);
                        UpdateChecker.getNotificationGroupForIdeUpdateResults().createNotification(title, message, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"update.ready.restart", (Object[])new Object[0]), () -> PlatformUpdateDialog.restartLaterAndRunCommand(command))).setDisplayId("ide.update.suggest.restart").notify(this.myProject);
                    }
                } else {
                    PlatformUpdateDialog.showPatchInstructions(command);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/PlatformUpdateDialog$4", "run"));
            }
        }.queue();
    }

    private static void restartLaterAndRunCommand(String[] command) {
        IdeUpdateUsageTriggerCollector.UPDATE_STARTED.log();
        PropertiesComponent.getInstance().setValue("ide.self.update.started.for.build", ApplicationInfo.getInstance().getBuild().asString());
        Restarter.setRestarterEnv(Map.of("JB_IMPORT_SETTINGS_FROM", PathManager.getConfigDir().toString()));
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        app.invokeLater(() -> app.restart(6, command));
    }

    private static void showPatchInstructions(String[] command) {
        String product = ApplicationNamesInfo.getInstance().getFullProductName().replace(' ', '-').toLowerCase(Locale.ENGLISH);
        String version = ApplicationInfo.getInstance().getFullVersion();
        Path file = Path.of(SystemProperties.getUserHome(), product + "-" + version + "-patch." + (OS.CURRENT == OS.Windows ? "cmd" : "sh"));
        try {
            String cmdLine = String.join((CharSequence)" ", CommandLineUtil.toCommandLine(Arrays.asList(command)));
            String text = (OS.CURRENT == OS.Windows ? "@echo off\n\n" : "#!/bin/sh\n\n") + cmdLine;
            Files.writeString(file, (CharSequence)text, new OpenOption[0]);
            NioFiles.setExecutable((Path)file);
        }
        catch (Exception e) {
            Logger.getInstance(PlatformUpdateDialog.class).error((Throwable)e);
            return;
        }
        String title = IdeBundle.message((String)"updates.dialog.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String message = IdeBundle.message((String)"update.apply.manually.message", (Object[])new Object[]{file});
        IdeUpdateUsageTriggerCollector.MANUAL_PATCH_PREPARED.log();
        ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)message, (String)title));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformUpdate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PlatformUpdateDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PlatformUpdateDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelButtonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTestDialog";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    private record LicenseInfo(@NlsContexts.Label String licenseNote, boolean warning) {
    }
}

