/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.ProductIcons;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogBackgroundImageProvider;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoPanel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoStatsCollector;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.Url;
import com.intellij.util.system.OS;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 72\u00020\u0001:\u00017BZ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\r\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020.J%\u00100\u001a\u00070\u000b\u00a2\u0006\u0002\b12\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0002J1\u00102\u001a\u00070\u000b\u00a2\u0006\u0002\b32\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00068"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInfoPanel;", "", "newBuild", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "patches", "Lcom/intellij/openapi/updateSettings/impl/UpdateChain;", "testPatch", "Ljava/nio/file/Path;", "writeProtected", "", "licenseInfo", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "licenseWarn", "enableLink", "updatedChannel", "Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/updateSettings/impl/BuildInfo;Lcom/intellij/openapi/updateSettings/impl/UpdateChain;Ljava/nio/file/Path;ZLjava/lang/String;ZZLcom/intellij/openapi/updateSettings/impl/UpdateChannel;Lcom/intellij/openapi/Disposable;)V", "getNewBuild", "()Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "getPatches", "()Lcom/intellij/openapi/updateSettings/impl/UpdateChain;", "getTestPatch", "()Ljava/nio/file/Path;", "getWriteProtected", "()Z", "getLicenseInfo", "()Ljava/lang/String;", "getLicenseWarn", "getEnableLink", "getUpdatedChannel", "()Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "appInfo", "Lcom/intellij/openapi/application/ApplicationInfo;", "getAppInfo", "()Lcom/intellij/openapi/application/ApplicationInfo;", "appNames", "Lcom/intellij/openapi/application/ApplicationNamesInfo;", "getAppNames", "()Lcom/intellij/openapi/application/ApplicationNamesInfo;", "create", "Ljavax/swing/JPanel;", "createNew", "textPaneContent", "Lcom/intellij/openapi/util/NlsSafe;", "infoLabelText", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "smallFont", "Ljava/awt/Font;", "font", "Companion", "intellij.platform.ide.updateChecker"})
public final class UpdateInfoPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BuildInfo newBuild;
    @Nullable
    private final UpdateChain patches;
    @Nullable
    private final Path testPatch;
    private final boolean writeProtected;
    @Nullable
    private final String licenseInfo;
    private final boolean licenseWarn;
    private final boolean enableLink;
    @NotNull
    private final UpdateChannel updatedChannel;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final ApplicationInfo appInfo;
    @NotNull
    private final ApplicationNamesInfo appNames;
    private static final int DEFAULT_MIN_HEIGHT = 300;
    private static final int DEFAULT_MAX_HEIGHT = 600;
    private static final int DEFAULT_WIDTH = 700;
    @NotNull
    private static final JBColor DIVIDER_COLOR = new JBColor(0xD9D9D9, 0x515151);
    @NotNull
    private static final Regex PATCH_SIZE_RANGE = new Regex("from \\d+ to (\\d+)");
    @NotNull
    private static final Companion.REPORTING_LISTENER.1 REPORTING_LISTENER = new BrowserHyperlinkListener(){

        protected void hyperlinkActivated(HyperlinkEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            UpdateInfoStatsCollector.click(e.getDescription());
            super.hyperlinkActivated(e);
        }
    };

    public UpdateInfoPanel(@NotNull BuildInfo newBuild, @Nullable UpdateChain patches, @Nullable Path testPatch, boolean writeProtected, @Nullable String licenseInfo, boolean licenseWarn, boolean enableLink, @NotNull UpdateChannel updatedChannel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)newBuild, (String)"newBuild");
        Intrinsics.checkNotNullParameter((Object)updatedChannel, (String)"updatedChannel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.newBuild = newBuild;
        this.patches = patches;
        this.testPatch = testPatch;
        this.writeProtected = writeProtected;
        this.licenseInfo = licenseInfo;
        this.licenseWarn = licenseWarn;
        this.enableLink = enableLink;
        this.updatedChannel = updatedChannel;
        this.parentDisposable = parentDisposable;
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"getInstance(...)");
        this.appInfo = applicationInfo;
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
        this.appNames = applicationNamesInfo;
    }

    @NotNull
    public final BuildInfo getNewBuild() {
        return this.newBuild;
    }

    @Nullable
    public final UpdateChain getPatches() {
        return this.patches;
    }

    @Nullable
    public final Path getTestPatch() {
        return this.testPatch;
    }

    public final boolean getWriteProtected() {
        return this.writeProtected;
    }

    @Nullable
    public final String getLicenseInfo() {
        return this.licenseInfo;
    }

    public final boolean getLicenseWarn() {
        return this.licenseWarn;
    }

    public final boolean getEnableLink() {
        return this.enableLink;
    }

    @NotNull
    public final UpdateChannel getUpdatedChannel() {
        return this.updatedChannel;
    }

    @NotNull
    public final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @NotNull
    public final ApplicationInfo getAppInfo() {
        return this.appInfo;
    }

    @NotNull
    public final ApplicationNamesInfo getAppNames() {
        return this.appNames;
    }

    @NotNull
    public final JPanel create() {
        JBLabel label;
        JEditorPane textPane = new JEditorPane("text/html", "");
        textPane.setBorder((Border)JBUI.Borders.empty((int)10, (int)16));
        textPane.setEditable(false);
        textPane.setCaretPosition(0);
        textPane.setText(this.textPaneContent(this.newBuild, this.updatedChannel, this.appNames));
        textPane.addHyperlinkListener((HyperlinkListener)((Object)REPORTING_LISTENER));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)textPane, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.setBorder(JBUI.Borders.customLine((Color)((Color)DIVIDER_COLOR), (int)0, (int)0, (int)1, (int)0));
        scrollPane.setPreferredSize(new Dimension(Math.min(scrollPane.getPreferredSize().width, 700), RangesKt.coerceIn((int)scrollPane.getPreferredSize().height, (int)300, (int)600)));
        JPanel infoPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 10));
        infoPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)16));
        if (this.licenseInfo != null) {
            label = new JBLabel(this.licenseInfo);
            label.setForeground(this.licenseWarn ? (Color)JBColor.RED : null);
            Font font = label.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            label.setFont(this.smallFont(font));
            infoPanel.add((Component)label);
        }
        if (this.writeProtected) {
            Object[] objectArray = new Object[]{this.appNames.getProductName(), PathManager.getHomePath()};
            label = new JBLabel(IdeBundle.message((String)"updates.write.protected", (Object[])objectArray));
            label.setForeground((Color)JBColor.RED);
            Font font = label.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            label.setFont(this.smallFont(font));
            infoPanel.add((Component)label);
        }
        JPanel infoRow = new JPanel(new FlowLayout(0, 0, 0));
        JBLabel infoLabel = new JBLabel();
        infoLabel.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        Font font = infoLabel.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        infoLabel.setFont(this.smallFont(font));
        infoLabel.setText(this.infoLabelText(this.newBuild, this.patches, this.testPatch, this.appInfo));
        infoRow.add((Component)infoLabel);
        if (this.enableLink) {
            String string = IdeBundle.message((String)"updates.configure.updates.label", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ActionLink link = new ActionLink(string, arg_0 -> UpdateInfoPanel.create$lambda$0(infoRow, arg_0));
            link.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
            Font font2 = link.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"getFont(...)");
            link.setFont(this.smallFont(font2));
            infoRow.add((Component)link);
        }
        infoPanel.add(infoRow);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)infoPanel, "South");
        return panel;
    }

    @NotNull
    public final JPanel createNew() {
        Icon icon = ProductIcons.getInstance().getProductIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getProductIcon(...)");
        Icon productIcon = icon;
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        Object $this$createNew_u24lambda_u240 = borderLayoutPanel;
        boolean bl = false;
        $this$createNew_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)8, (int)16));
        $this$createNew_u24lambda_u240.setPreferredSize(new Dimension(700, 300));
        BorderLayoutPanel mainPanel = borderLayoutPanel;
        Object $this$createNew_u24lambda_u241 = $this$createNew_u24lambda_u240 = new JEditorPane("text/html", "");
        boolean bl2 = false;
        ((JComponent)$this$createNew_u24lambda_u241).setBorder((Border)JBUI.Borders.empty());
        ((JTextComponent)$this$createNew_u24lambda_u241).setEditable(false);
        ((JTextComponent)$this$createNew_u24lambda_u241).setCaretPosition(0);
        ((JEditorPane)$this$createNew_u24lambda_u241).setText(this.textPaneContent(this.newBuild, this.updatedChannel, this.appNames));
        ((JEditorPane)$this$createNew_u24lambda_u241).addHyperlinkListener((HyperlinkListener)((Object)REPORTING_LISTENER));
        ((JComponent)$this$createNew_u24lambda_u241).setOpaque(false);
        Object textPane = $this$createNew_u24lambda_u240;
        JScrollPane $this$createNew_u24lambda_u242 = bl2 = ScrollPaneFactory.createScrollPane((Component)((Component)textPane), (boolean)true);
        boolean bl3 = false;
        $this$createNew_u24lambda_u242.setBorder(JBUI.Borders.customLine((Color)((Color)DIVIDER_COLOR), (int)0, (int)0, (int)0, (int)0));
        $this$createNew_u24lambda_u242.setOpaque(false);
        $this$createNew_u24lambda_u242.getViewport().setOpaque(false);
        $this$createNew_u24lambda_u242.setPreferredSize(new Dimension(Math.min($this$createNew_u24lambda_u242.getPreferredSize().width, 700), RangesKt.coerceIn((int)$this$createNew_u24lambda_u242.getPreferredSize().height, (int)300, (int)600)));
        JScrollPane jScrollPane = bl2;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"apply(...)");
        JScrollPane scrollPane = jScrollPane;
        DialogPanel infoPanel = BuilderKt.panel(arg_0 -> UpdateInfoPanel.createNew$lambda$3(this, productIcon, scrollPane, arg_0));
        DialogPanel additionalInfoPanel2 = BuilderKt.panel(arg_0 -> UpdateInfoPanel.createNew$lambda$4(this, mainPanel, arg_0));
        mainPanel.addToCenter((Component)infoPanel);
        mainPanel.addToBottom((Component)additionalInfoPanel2);
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        boolean isDark = uIThemeLookAndFeelInfo != null ? uIThemeLookAndFeelInfo.isDark() : true;
        Image bgImage = DialogBackgroundImageProvider.Companion.getInstance().getImage(isDark);
        if (bgImage != null) {
            IdeBackgroundUtil.createTemporaryBackgroundTransform((JComponent)((JComponent)mainPanel), (Image)bgImage, (IdeBackgroundUtil.Fill)IdeBackgroundUtil.Fill.SCALE, (IdeBackgroundUtil.Anchor)IdeBackgroundUtil.Anchor.TOP_RIGHT, (float)1.0f, (Insets)((Insets)JBInsets.emptyInsets()), (Disposable)this.parentDisposable);
        }
        return (JPanel)mainPanel;
    }

    private final String textPaneContent(BuildInfo newBuild, UpdateChannel updatedChannel, ApplicationNamesInfo appNames) {
        String string;
        String string2 = UIUtil.getCssFontDeclaration((Font)StartupUiUtil.getLabelFont());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCssFontDeclaration(...)");
        String style = string2;
        String message = newBuild.getMessage();
        if (!StringsKt.isBlank((CharSequence)message)) {
            string = message;
        } else {
            Object[] objectArray = new Object[]{appNames.getFullProductName(), Companion.downloadUrl(newBuild, updatedChannel)};
            String string3 = IdeBundle.message((String)"updates.new.version.available", (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        String content = string;
        return "<html><head>" + style + "</head><body>" + content + "</body></html>";
    }

    private final String infoLabelText(BuildInfo newBuild, UpdateChain patches, Path testPatch, ApplicationInfo appInfo) {
        String string;
        CharSequence charSequence;
        String string2;
        Path path = testPatch;
        if (path != null) {
            string2 = String.valueOf(Math.max(Files.size(path) >> 20, 1L));
        } else if (patches != null && !((charSequence = (CharSequence)patches.getSize()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            MatchResult match;
            String string3 = patches.getSize();
            Intrinsics.checkNotNull((Object)string3);
            String size = string3;
            MatchResult matchResult = match = PATCH_SIZE_RANGE.matchEntire((CharSequence)size);
            string2 = matchResult != null ? (String)matchResult.getGroupValues().get(1) : size;
        } else {
            string2 = null;
        }
        String patchSize = string2;
        if (patchSize != null) {
            var7_6 = new Object[]{appInfo.getFullVersion(), newBuild.getVersion(), newBuild.getNumber().withoutProductCode(), patchSize};
            String string4 = IdeBundle.message((String)"updates.from.to.size", (Object[])var7_6);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else {
            var7_6 = new Object[]{appInfo.getFullVersion(), newBuild.getVersion(), newBuild.getNumber().withoutProductCode()};
            String string5 = IdeBundle.message((String)"updates.from.to", (Object[])var7_6);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        }
        return string;
    }

    private final Font smallFont(Font font) {
        Font font2;
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                Font font3 = FontUtil.minusOne((Font)font);
                font2 = font3;
                Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"minusOne(...)");
                break;
            }
            case 2: {
                Font font4 = FontUtil.minusOne((Font)FontUtil.minusOne((Font)font));
                font2 = font4;
                Intrinsics.checkNotNullExpressionValue((Object)font4, (String)"minusOne(...)");
                break;
            }
            default: {
                font2 = font;
            }
        }
        return font2;
    }

    private static final Unit create$lambda$0(JPanel $infoRow, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShowSettingsUtil.getInstance().editConfigurable((Component)$infoRow, (Configurable)new UpdateSettingsConfigurable(false));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$3$2$0(UpdateInfoPanel this$0, JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setForeground(this$0.licenseWarn ? (Color)JBColor.RED : null);
        Font font = $this$applyToComponent.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        $this$applyToComponent.setFont(this$0.smallFont(font));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$3$3$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setForeground((Color)JBColor.RED);
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$3$0(Icon $productIcon, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.icon(IconUtil.scale((Icon)$productIcon, null, (float)3.0f));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$3$1(JScrollPane $scrollPane, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$scrollPane).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$3$2(UpdateInfoPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.licenseInfo).applyToComponent(arg_0 -> UpdateInfoPanel.createNew$lambda$3$2$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$3$3(UpdateInfoPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{this$0.appNames.getProductName(), PathManager.getHomePath()};
        String string = IdeBundle.message((String)"updates.write.protected", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).applyToComponent(UpdateInfoPanel::createNew$lambda$3$3$0);
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$4$0$0$0(UpdateInfoPanel this$0, JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        Font font = $this$applyToComponent.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        $this$applyToComponent.setFont(this$0.smallFont(font));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$4$0$1$0(BorderLayoutPanel $mainPanel, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShowSettingsUtil.getInstance().editConfigurable((Component)$mainPanel, (Configurable)new UpdateSettingsConfigurable(false));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$4$0$1$1(UpdateInfoPanel this$0, ActionLink $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        Font font = $this$applyToComponent.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        $this$applyToComponent.setFont(this$0.smallFont(font));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$4$0$0(UpdateInfoPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)this$0.infoLabelText(this$0.newBuild, this$0.patches, this$0.testPatch, this$0.appInfo), (int)0, null, (int)6, null).applyToComponent(arg_0 -> UpdateInfoPanel.createNew$lambda$4$0$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$4$0$1(BorderLayoutPanel $mainPanel, UpdateInfoPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"updates.configure.updates.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, arg_0 -> UpdateInfoPanel.createNew$lambda$4$0$1$0($mainPanel, arg_0)).applyToComponent(arg_0 -> UpdateInfoPanel.createNew$lambda$4$0$1$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$4$0(UpdateInfoPanel this$0, BorderLayoutPanel $mainPanel, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> UpdateInfoPanel.createNew$lambda$4$0$0(this$0, arg_0), (int)1, null).bottomGap(BottomGap.NONE);
        if (this$0.enableLink) {
            Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> UpdateInfoPanel.createNew$lambda$4$0$1($mainPanel, this$0, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$3(UpdateInfoPanel this$0, Icon $productIcon, JScrollPane $scrollPane, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateInfoPanel.createNew$lambda$3$0($productIcon, arg_0), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY((int)0, (int)0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateInfoPanel.createNew$lambda$3$1($scrollPane, arg_0), (int)1, null);
        if (this$0.licenseInfo != null) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateInfoPanel.createNew$lambda$3$2(this$0, arg_0), (int)1, null);
        }
        if (this$0.writeProtected) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateInfoPanel.createNew$lambda$3$3(this$0, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createNew$lambda$4(UpdateInfoPanel this$0, BorderLayoutPanel $mainPanel, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new IntelliJSpacingConfiguration(){

            public int getVerticalComponentGap() {
                return 2;
            }
        }, arg_0 -> UpdateInfoPanel.createNew$lambda$4$0(this$0, $mainPanel, arg_0));
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final String downloadUrl(@NotNull BuildInfo newBuild, @NotNull UpdateChannel updatedChannel) {
        return Companion.downloadUrl(newBuild, updatedChannel);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInfoPanel$Companion;", "", "<init>", "()V", "DEFAULT_MIN_HEIGHT", "", "DEFAULT_MAX_HEIGHT", "DEFAULT_WIDTH", "DIVIDER_COLOR", "Lcom/intellij/ui/JBColor;", "PATCH_SIZE_RANGE", "Lkotlin/text/Regex;", "REPORTING_LISTENER", "com/intellij/openapi/updateSettings/impl/UpdateInfoPanel$Companion$REPORTING_LISTENER$1", "Lcom/intellij/openapi/updateSettings/impl/UpdateInfoPanel$Companion$REPORTING_LISTENER$1;", "downloadUrl", "", "newBuild", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "updatedChannel", "Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "intellij.platform.ide.updateChecker"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String downloadUrl(@NotNull BuildInfo newBuild, @NotNull UpdateChannel updatedChannel) {
            Intrinsics.checkNotNullParameter((Object)newBuild, (String)"newBuild");
            Intrinsics.checkNotNullParameter((Object)updatedChannel, (String)"updatedChannel");
            IdeUrlTrackingParametersProvider ideUrlTrackingParametersProvider = IdeUrlTrackingParametersProvider.getInstance();
            String string = newBuild.getDownloadUrl();
            if (string == null && (string = newBuild.getBlogPost()) == null && (string = updatedChannel.getUrl()) == null) {
                Url url = ExternalProductResourceUrls.Companion.getInstance().getDownloadPageUrl();
                string = url != null ? url.toExternalForm() : null;
                if (string == null && (string = ApplicationInfo.getInstance().getCompanyURL()) == null) {
                    string = "https://www.jetbrains.com";
                }
            }
            String string2 = ideUrlTrackingParametersProvider.augmentUrl(string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"augmentUrl(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.macOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

