/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PreparedPluginUpdates;
import com.intellij.openapi.updateSettings.impl.RemotePluginRepository;
import com.intellij.openapi.updateSettings.impl.UpdateCheckBackendsKt;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/updateSettings/impl/CustomPluginRepository;", "Lcom/intellij/openapi/updateSettings/impl/RemotePluginRepository;", "host", "", "<init>", "(Ljava/lang/String;)V", "findUpdates", "Lcom/intellij/openapi/updateSettings/impl/PreparedPluginUpdates;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "plugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.ide.updateChecker"})
@SourceDebugExtension(value={"SMAP\nUpdateCheckBackends.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateCheckBackends.kt\ncom/intellij/openapi/updateSettings/impl/CustomPluginRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1915#2,2:153\n*S KotlinDebug\n*F\n+ 1 UpdateCheckBackends.kt\ncom/intellij/openapi/updateSettings/impl/CustomPluginRepository\n*L\n110#1:153,2\n*E\n"})
public final class CustomPluginRepository
extends RemotePluginRepository {
    @NotNull
    private final String host;

    public CustomPluginRepository(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(host);
        this.host = host;
    }

    @Override
    @NotNull
    public PreparedPluginUpdates findUpdates(@Nullable BuildNumber buildNumber, @NotNull InstalledPluginsState state, @NotNull Collection<PluginId> plugins2, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(plugins2, (String)"plugins");
        Map toUpdate = new LinkedHashMap();
        Map toUpdateDisabled = new LinkedHashMap();
        HashMap models = new HashMap();
        List list = RepositoryHelper.loadPluginModels((String)this.host, (BuildNumber)buildNumber, (ProgressIndicator)indicator);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadPluginModels(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginUiModel storedDescriptor;
            PluginUiModel model = (PluginUiModel)element$iv;
            boolean bl = false;
            PluginId id = model.getPluginId();
            if (plugins2.contains(id)) {
                Intrinsics.checkNotNull((Object)model);
                UpdateCheckBackendsKt.access$prepareDownloader(state, model, buildNumber, toUpdate, toUpdateDisabled, indicator, this.host);
            }
            if ((storedDescriptor = (PluginUiModel)models.get(id)) != null && (VersionComparatorUtil.compare((String)model.getVersion(), (String)storedDescriptor.getVersion()) <= 0 || !UpdateChecker.allowedUpgrade$intellij_platform_ide_updateChecker(storedDescriptor.getDescriptor(), model.getDescriptor())) && (VersionComparatorUtil.compare((String)model.getVersion(), (String)storedDescriptor.getVersion()) >= 0 || !UpdateChecker.allowedDowngrade$intellij_platform_ide_updateChecker(storedDescriptor.getDescriptor(), model.getDescriptor()))) continue;
            ((Map)models).put(id, model);
        }
        return new PreparedPluginUpdates(toUpdate, toUpdateDisabled, models);
    }
}

