/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PreparedPluginUpdates;
import com.intellij.openapi.updateSettings.impl.RemotePluginRepository;
import com.intellij.openapi.updateSettings.impl.UpdateCheckBackendsKt;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerPluginsFacade;
import com.intellij.openapi.util.BuildNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/updateSettings/impl/MarketplacePluginRepository;", "Lcom/intellij/openapi/updateSettings/impl/RemotePluginRepository;", "<init>", "()V", "findUpdates", "Lcom/intellij/openapi/updateSettings/impl/PreparedPluginUpdates;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "plugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAllInstalledPlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "", "Lcom/intellij/ide/plugins/marketplace/IdeCompatibleUpdate;", "idsToUpdate", "", "intellij.platform.ide.updateChecker"})
@SourceDebugExtension(value={"SMAP\nUpdateCheckBackends.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateCheckBackends.kt\ncom/intellij/openapi/updateSettings/impl/MarketplacePluginRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,152:1\n777#2:153\n873#2,2:154\n1220#2,2:158\n1249#2,4:160\n1#3:156\n23#4:157\n*S KotlinDebug\n*F\n+ 1 UpdateCheckBackends.kt\ncom/intellij/openapi/updateSettings/impl/MarketplacePluginRepository\n*L\n49#1:153\n49#1:154,2\n82#1:158,2\n82#1:160,4\n67#1:157\n*E\n"})
public class MarketplacePluginRepository
extends RemotePluginRepository {
    public MarketplacePluginRepository() {
        super("default-host");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PreparedPluginUpdates findUpdates(@Nullable BuildNumber buildNumber, @NotNull InstalledPluginsState state, @NotNull Collection<PluginId> plugins2, @Nullable ProgressIndicator indicator) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(plugins2, (String)"plugins");
        Set marketplacePluginIds = MarketplaceRequests.Companion.getInstance().getMarketplacePlugins(indicator);
        Iterable $this$filter$iv = plugins2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginId it = (PluginId)element$iv$iv;
            boolean bl = false;
            if (!marketplacePluginIds.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set idsToUpdate = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<IdeCompatibleUpdate> updates = this.findUpdates(idsToUpdate, buildNumber);
        Map toUpdate = new LinkedHashMap();
        Map toUpdateDisabled = new LinkedHashMap();
        HashMap models = new HashMap();
        Map<PluginId, IdeaPluginDescriptor> installedDescriptors = this.getAllInstalledPlugins(state);
        for (PluginId id : plugins2) {
            PluginUiModel it;
            Object $this$findUpdates_u24lambda_u242;
            Object v0;
            Object object;
            block8: {
                object = updates;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    IdeCompatibleUpdate it2 = (IdeCompatibleUpdate)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getPluginId(), (Object)id.getIdString())) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            IdeCompatibleUpdate lastUpdate = v0;
            IdeaPluginDescriptor descriptor = installedDescriptors.get(id);
            if (lastUpdate == null || descriptor != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible((String)lastUpdate.getVersion(), (IdeaPluginDescriptor)descriptor, (BuildNumber)buildNumber) <= 0) continue;
            object = this;
            try {
                $this$findUpdates_u24lambda_u242 = (MarketplacePluginRepository)object;
                boolean bl = false;
                $this$findUpdates_u24lambda_u242 = Result.constructor-impl((Object)MarketplaceRequests.Companion.loadPluginModel(id.getIdString(), lastUpdate, indicator));
            }
            catch (Throwable bl) {
                $this$findUpdates_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$findUpdates_u24lambda_u242;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object it3 = $this$findUpdates_u24lambda_u242 = throwable;
                boolean bl = false;
                if (!UpdateCheckBackendsKt.access$isNetworkError((Throwable)it3)) {
                    throw it3;
                }
                MarketplacePluginRepository $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(MarketplacePluginRepository.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to read update metadata for plugin: " + id + ", " + it3.getClass() + " " + ((Throwable)it3).getMessage());
            }
            if (Result.isSuccess-impl((Object)object)) {
                it = (PluginUiModel)object;
                boolean bl = false;
                it.setExternalPluginIdForScreenShots(lastUpdate.getExternalPluginId());
                ((Map)models).put(id, it);
            }
            if (!Result.isSuccess-impl((Object)object)) continue;
            it = (PluginUiModel)object;
            boolean bl = false;
            UpdateCheckBackendsKt.access$prepareDownloader(state, it, buildNumber, toUpdate, toUpdateDisabled, indicator, null);
        }
        return new PreparedPluginUpdates(toUpdate, toUpdateDisabled, models);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> getAllInstalledPlugins(InstalledPluginsState state) {
        void $this$associateByTo$iv$iv;
        Collection collection = state.getInstalledPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getInstalledPlugins(...)");
        List ids = CollectionsKt.plus((Collection)collection, (Iterable)UpdateCheckerPluginsFacade.Companion.getInstance().getInstalledPlugins());
        Iterable $this$associateBy$iv = ids;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            PluginId pluginId = it.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
            map.put(pluginId, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    protected List<IdeCompatibleUpdate> findUpdates(@NotNull Set<PluginId> idsToUpdate, @Nullable BuildNumber buildNumber) {
        Intrinsics.checkNotNullParameter(idsToUpdate, (String)"idsToUpdate");
        return MarketplaceRequests.Companion.loadLastCompatiblePluginUpdate(idsToUpdate, buildNumber, true);
    }
}

