/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerPluginsFacade;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\u001a^\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0003\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"prepareDownloader", "", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "descriptor", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "toUpdate", "", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "toUpdateDisabled", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "host", "", "isNetworkError", "", "it", "", "intellij.platform.ide.updateChecker"})
public final class UpdateCheckBackendsKt {
    @RequiresBackgroundThread
    private static final void prepareDownloader(InstalledPluginsState state, PluginUiModel descriptor, BuildNumber buildNumber, Map<PluginId, PluginDownloader> toUpdate, Map<PluginId, PluginDownloader> toUpdateDisabled, ProgressIndicator indicator, String host) {
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader((PluginUiModel)descriptor, (String)host, (BuildNumber)buildNumber);
        Intrinsics.checkNotNullExpressionValue((Object)pluginDownloader, (String)"createDownloader(...)");
        PluginDownloader downloader = pluginDownloader;
        state.onDescriptorDownload(descriptor);
        UpdateCheckerPluginsFacade updateCheckerPluginsFacade = UpdateCheckerPluginsFacade.Companion.getInstance();
        PluginId pluginId = downloader.getId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        UpdateChecker.checkAndPrepareToInstall(downloader, state, updateCheckerPluginsFacade.isDisabled(pluginId) ? toUpdateDisabled : toUpdate, buildNumber, indicator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNetworkError(Throwable it) {
        if (it instanceof SocketTimeoutException) return true;
        if (it instanceof UnknownHostException) return true;
        if (it instanceof HttpRequests.HttpStatusException) {
            if (((HttpRequests.HttpStatusException)it).getStatusCode() == 404) return true;
        }
        if (!(it instanceof JsonMappingException)) return false;
        String string = ((JsonMappingException)it).getMessage();
        if (string == null) return false;
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"end-of-input", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isNetworkError(Throwable it) {
        return UpdateCheckBackendsKt.isNetworkError(it);
    }

    public static final /* synthetic */ void access$prepareDownloader(InstalledPluginsState state, PluginUiModel descriptor, BuildNumber buildNumber, Map toUpdate, Map toUpdateDisabled, ProgressIndicator indicator, String host) {
        UpdateCheckBackendsKt.prepareDownloader(state, descriptor, buildNumber, toUpdate, toUpdateDisabled, indicator, host);
    }
}

