/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.ide.plugins.BrokenPluginFileKt;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginStringSetFile;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CustomPluginRepository;
import com.intellij.openapi.updateSettings.impl.ExternalPluginResults;
import com.intellij.openapi.updateSettings.impl.ExternalUpdate;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.InternalPluginResults;
import com.intellij.openapi.updateSettings.impl.MarketplacePluginRepository;
import com.intellij.openapi.updateSettings.impl.MarketplaceUpdateCheckPluginRepository;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PlatformUpdateDialog;
import com.intellij.openapi.updateSettings.impl.PlatformUpdates;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdates;
import com.intellij.openapi.updateSettings.impl.PreparedPluginUpdates;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.RemotePluginRepository;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerHelper;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerKt;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerPluginsFacade;
import com.intellij.openapi.updateSettings.impl.UpdateData;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsEntryPointActionProvider;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001lB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0015H\u0007J\b\u0010\u0017\u001a\u00020\u0015H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0019H\u0007J\u001e\u0010\u0018\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u001e\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u001f2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0001J\u0014\u0010%\u001a\u0004\u0018\u00010\n2\b\u0010#\u001a\u0004\u0018\u00010$H\u0007J\b\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u00020\u001bH\u0007J3\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0000\u00a2\u0006\u0002\b.J \u0010/\u001a\u00020)2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0007J\u0016\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u000202H\u0002J\u0012\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0011H\u0002J<\u00107\u001a\u00020)2\f\u00108\u001a\b\u0012\u0004\u0012\u0002020+2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0016\u00109\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010;0:H\u0002J!\u0010<\u001a\u0002052\b\u0010=\u001a\u0004\u0018\u00010;2\b\u0010>\u001a\u0004\u0018\u00010;H\u0001\u00a2\u0006\u0002\b?J!\u0010@\u001a\u0002052\b\u0010=\u001a\u0004\u0018\u00010;2\b\u0010>\u001a\u0004\u0018\u00010;H\u0001\u00a2\u0006\u0002\bAJ\u001c\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u001f2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0007JD\u0010E\u001a\u00020\u001b2\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020H2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0007J\b\u0010Q\u001a\u00020\u001bH\u0007J\u0010\u0010R\u001a\u0002052\u0006\u0010S\u001a\u00020;H\u0007J\u0016\u0010T\u001a\u00020\u001b2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020;01H\u0001J\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020\u0011012\u0006\u0010^\u001a\u00020\u0011H\u0002J,\u0010_\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010`\u001a\u00020\u00112\b\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010c\u001a\u000205H\u0007J\u0010\u0010(\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010+H\u0007J:\u00107\u001a\u00020)2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\u0018\b\u0002\u0010i\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010;\u0018\u00010\fH\u0007J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020HH\u0007J\u001c\u0010(\u001a\u00020j2\u0006\u0010k\u001a\u00020\r2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R'\u0010J\u001a\b\u0012\u0004\u0012\u00020\r0K8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\bO\u0010P\u0012\u0004\bL\u0010\u0003\u001a\u0004\bM\u0010NR!\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00110W8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bY\u0010P\u001a\u0004\bX\u0010NR\u0018\u0010Z\u001a\u00020\u0011*\u00020;8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0016\u0010d\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\be\u0010\u0003R \u0010f\u001a\b\u0012\u0004\u0012\u00020\u00110K8GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bg\u0010\u0003\u001a\u0004\bh\u0010N\u00a8\u0006m"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker;", "", "<init>", "()V", "productDataLock", "Ljava/util/concurrent/locks/ReentrantLock;", "productDataUrl", "Lcom/intellij/util/Url;", "productDataCache", "Ljava/lang/ref/SoftReference;", "Lcom/intellij/openapi/updateSettings/impl/Product;", "ourUpdatedPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "excludedFromUpdateCheckPlugins", "Ljava/util/HashSet;", "", "getExcludedFromUpdateCheckPlugins", "()Ljava/util/HashSet;", "getNotificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getNotificationGroupForPluginUpdateResults", "getNotificationGroupForIdeUpdateResults", "updateAndShowResult", "Lcom/intellij/openapi/util/ActionCallback;", "getUpdates", "", "project", "Lcom/intellij/openapi/project/Project;", "customSettings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "getPlatformUpdates", "Lcom/intellij/openapi/updateSettings/impl/PlatformUpdates;", "settings", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadProductData", "clearProductDataCache", "updateDescriptorsForInstalledPlugins", "getPluginUpdates", "Lcom/intellij/openapi/updateSettings/impl/InternalPluginResults;", "plugins", "", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getPluginUpdates$intellij_platform_ide_updateChecker", "checkInstalledPluginUpdates", "collectPluginRepositories", "", "Lcom/intellij/openapi/updateSettings/impl/RemotePluginRepository;", "marketplaceBackend", "isMarketplaceBackend", "", "host", "getInternalPluginUpdates", "backends", "collectUpdateablePlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "allowedDowngrade", "localDescriptor", "remoteDescriptor", "allowedDowngrade$intellij_platform_ide_updateChecker", "allowedUpgrade", "allowedUpgrade$intellij_platform_ide_updateChecker", "getExternalPluginUpdates", "Lcom/intellij/openapi/updateSettings/impl/ExternalPluginResults;", "updateSettings", "checkAndPrepareToInstall", "originalDownloader", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "toUpdate", "disabledToUpdate", "", "getDisabledToUpdate$annotations", "getDisabledToUpdate", "()Ljava/util/Set;", "disabledToUpdate$delegate", "Lkotlin/Lazy;", "saveDisabledToUpdatePlugins", "isIgnored", "descriptor", "ignorePlugins", "descriptors", "ignoredPlugins", "", "getIgnoredPlugins", "ignoredPlugins$delegate", "ignoredKey", "getIgnoredKey", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;)Ljava/lang/String;", "readConfigLines", "fileName", "testPlatformUpdate", "updateDataText", "patchFile", "Ljava/nio/file/Path;", "forceUpdate", "NOTIFICATIONS", "getNOTIFICATIONS$annotations", "disabledToUpdatePlugins", "getDisabledToUpdatePlugins$annotations", "getDisabledToUpdatePlugins", "updateablePluginsMap", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$PluginUpdatesInfo;", "pluginId", "PluginUpdatesInfo", "intellij.platform.ide.updateChecker"})
@SourceDebugExtension(value={"SMAP\nUpdateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateChecker.kt\ncom/intellij/openapi/updateSettings/impl/UpdateChecker\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,1010:1\n42#2,3:1011\n42#2,3:1014\n60#3,5:1017\n1#4:1022\n1#4:1038\n129#5:1023\n158#5,3:1024\n129#5:1085\n158#5,3:1086\n1642#6,10:1027\n1915#6:1037\n1916#6:1039\n1652#6:1040\n777#6:1041\n873#6,2:1042\n1249#6,4:1044\n1915#6:1048\n1916#6:1072\n1915#6,2:1073\n777#6:1075\n873#6,2:1076\n1586#6:1078\n1661#6,3:1079\n1661#6,3:1082\n1586#6:1089\n1661#6,3:1090\n1586#6:1093\n1661#6,3:1094\n106#7:1049\n78#7,22:1050\n*S KotlinDebug\n*F\n+ 1 UpdateChecker.kt\ncom/intellij/openapi/updateSettings/impl/UpdateChecker\n*L\n176#1:1011,3\n180#1:1014,3\n254#1:1017,5\n314#1:1038\n307#1:1023\n307#1:1024,3\n623#1:1085\n623#1:1086,3\n314#1:1027,10\n314#1:1037\n314#1:1039\n314#1:1040\n388#1:1041\n388#1:1042,2\n389#1:1044,4\n395#1:1048\n395#1:1072\n410#1:1073,2\n448#1:1075\n448#1:1076,2\n525#1:1078\n525#1:1079,3\n605#1:1082,3\n658#1:1089\n658#1:1090,3\n511#1:1093\n511#1:1094,3\n396#1:1049\n396#1:1050,22\n*E\n"})
public final class UpdateChecker {
    @NotNull
    public static final UpdateChecker INSTANCE = new UpdateChecker();
    @NotNull
    private static final ReentrantLock productDataLock = new ReentrantLock();
    @Nullable
    private static Url productDataUrl;
    @Nullable
    private static SoftReference<Product> productDataCache;
    @NotNull
    private static final Map<PluginId, PluginDownloader> ourUpdatedPlugins;
    @NotNull
    private static final HashSet<String> excludedFromUpdateCheckPlugins;
    @NotNull
    private static final Lazy disabledToUpdate$delegate;
    @NotNull
    private static final Lazy ignoredPlugins$delegate;
    @ApiStatus.ScheduledForRemoval
    @JvmField
    @NotNull
    public static final NotificationGroup NOTIFICATIONS;

    private UpdateChecker() {
    }

    @NotNull
    public final HashSet<String> getExcludedFromUpdateCheckPlugins() {
        return excludedFromUpdateCheckPlugins;
    }

    @JvmStatic
    @NotNull
    public static final NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IDE and Plugin Updates");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @JvmStatic
    @NotNull
    public static final NotificationGroup getNotificationGroupForPluginUpdateResults() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Plugin Update Results");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @JvmStatic
    @NotNull
    public static final NotificationGroup getNotificationGroupForIdeUpdateResults() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IDE Update Results");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @JvmStatic
    @NotNull
    public static final ActionCallback updateAndShowResult() {
        boolean $i$f$service = false;
        Class<UpdateCheckerHelper> serviceClass$iv = UpdateCheckerHelper.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((UpdateCheckerHelper)object).updateAndShowResult(true);
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    @NotNull
    public final ActionCallback getUpdates() {
        boolean $i$f$service = false;
        Class<UpdateCheckerHelper> serviceClass$iv = UpdateCheckerHelper.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((UpdateCheckerHelper)object).updateAndShowResult(false);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateAndShowResult(@Nullable Project project, @Nullable UpdateSettings customSettings) {
        String string = IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, customSettings, string){
            final /* synthetic */ UpdateSettings $customSettings;
            {
                this.$customSettings = $customSettings;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, this.$customSettings, indicator, null){
                    Object L$0;
                    int I$0;
                    int label;
                    final /* synthetic */ updateAndShowResult.1 this$0;
                    final /* synthetic */ UpdateSettings $customSettings;
                    final /* synthetic */ ProgressIndicator $indicator;
                    {
                        this.this$0 = $receiver;
                        this.$customSettings = $customSettings;
                        this.$indicator = $indicator;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        block7: {
                            var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    v0 = UpdateCheckerKt.doUpdateAndShowResult$default(this.this$0.getProject(), this.$customSettings, true, true, this.this$0.isConditionalModal(), this.this$0.shouldStartInBackground(), this.$indicator, null, (Continuation)this, 128, null);
                                    if (v0 == var5_2) {
                                        return var5_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    if ((var2_3 = (Function1)v0) == null) break;
                                    it = var2_3;
                                    $i$a$-let-UpdateChecker$updateAndShowResult$1$run$1$1 = 0;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                    this.I$0 = $i$a$-let-UpdateChecker$updateAndShowResult$1$run$1$1;
                                    this.label = 2;
                                    v1 = BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super Continuation<? super Unit>, ? extends Object>)it, null){
                                        int label;
                                        final /* synthetic */ Function1<Continuation<? super Unit>, Object> $it;
                                        {
                                            this.$it = $it;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    this.label = 1;
                                                    Object object2 = this.$it.invoke((Object)((Object)this));
                                                    if (object2 != object) return Unit.INSTANCE;
                                                    return object;
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object2 = $result;
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)this);
                                    if (v1 == var5_2) {
                                        return var5_2;
                                    }
                                    ** GOTO lbl28
                                }
                                case 2: {
                                    $i$a$-let-UpdateChecker$updateAndShowResult$1$run$1$1 = this.I$0;
                                    it = (Function1)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl28:
                                    // 2 sources

                                    v2 = Unit.INSTANCE;
                                    break block7;
                                }
                            }
                            v2 = null;
                        }
                        return v2;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }

            public boolean isConditionalModal() {
                return this.$customSettings != null;
            }

            public boolean shouldStartInBackground() {
                return !this.isConditionalModal();
            }
        });
    }

    public static /* synthetic */ void updateAndShowResult$default(Project project, UpdateSettings updateSettings, int n, Object object) {
        if ((n & 2) != 0) {
            updateSettings = null;
        }
        UpdateChecker.updateAndShowResult(project, updateSettings);
    }

    @JvmStatic
    @IntellijInternalApi
    @JvmOverloads
    @JvmName(name="getPlatformUpdates")
    @ApiStatus.Internal
    @NotNull
    public static final PlatformUpdates getPlatformUpdates(@NotNull UpdateSettings settings, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        try {
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator != null) {
                progressIndicator.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
            }
            Product productData = UpdateChecker.loadProductData(indicator);
            if (productData == null || !settings.isCheckNeeded() || ExternalUpdateManager.ACTUAL != null) {
                return (PlatformUpdates)PlatformUpdates.Empty.INSTANCE;
            }
            BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
            return new UpdateStrategy(buildNumber, productData, settings, null, 8, null).checkForUpdates();
        }
        catch (Exception e) {
            boolean attachTrace = UpdateCheckerKt.access$getLOG$p().isDebugEnabled() ? true : (e instanceof IOException ? false : !(e instanceof CancellationException));
            UpdateCheckerKt.access$getLOG$p().info("failed to load update data (" + e.getClass().getName() + ": " + e.getMessage() + ")", (Throwable)(attachTrace ? e : null));
            return (PlatformUpdates)new PlatformUpdates.ConnectionError(e);
        }
    }

    public static /* synthetic */ PlatformUpdates getPlatformUpdates$default(UpdateSettings updateSettings, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 1) != 0) {
            UpdateSettings updateSettings2 = UpdateSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)updateSettings2, (String)"getInstance(...)");
            updateSettings = updateSettings2;
        }
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return UpdateChecker.getPlatformUpdates(updateSettings, progressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Product loadProductData(@Nullable ProgressIndicator indicator) throws IOException, JDOMException {
        Product product;
        Url url = ExternalProductResourceUrls.Companion.getInstance().getUpdateMetadataUrl();
        if (url == null) {
            return null;
        }
        Url url2 = url;
        Lock lock = productDataLock;
        lock.lock();
        try {
            Product product2;
            Product cached;
            boolean bl = false;
            SoftReference<Product> softReference = productDataCache;
            Object object = cached = softReference != null ? softReference.get() : null;
            if (cached != null && Intrinsics.areEqual((Object)url2, (Object)productDataUrl)) {
                product2 = cached;
            } else {
                Product product3;
                Logger $this$debug_u24default$iv = UpdateCheckerKt.access$getLOG$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("loading " + url2, t$iv);
                }
                Element it = (Element)HttpRequests.request((Url)url2).productNameAsUserAgent().connect(arg_0 -> UpdateChecker.loadProductData$lambda$0$1(indicator, arg_0));
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                Product product4 = UpdateData.parseUpdateData$default((Element)it, null, (int)2, null);
                if (product4 != null) {
                    Product product5 = product4;
                    it = product5;
                    boolean bl4 = false;
                    if (it.getDisableMachineId()) {
                        PropertiesComponent.getInstance().setValue("machine.id.disabled", true);
                    }
                    product3 = product5;
                } else {
                    product3 = null;
                }
                Product product6 = product3;
                productDataCache = new SoftReference<Object>(product6);
                productDataUrl = url2;
                AppExecutorUtil.getAppScheduledExecutorService().schedule(INSTANCE::clearProductDataCache, 5L, TimeUnit.MINUTES);
                product2 = product6;
            }
            product = product2;
        }
        finally {
            lock.unlock();
        }
        return product;
    }

    private final void clearProductDataCache() {
        if (productDataLock.tryLock(1L, TimeUnit.MILLISECONDS)) {
            productDataCache = null;
            productDataUrl = null;
            productDataLock.unlock();
        }
    }

    @ApiStatus.Internal
    public final void updateDescriptorsForInstalledPlugins() {
        if (ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) {
            ApplicationManager.getApplication().executeOnPooledThread(UpdateChecker::updateDescriptorsForInstalledPlugins$lambda$0);
        }
    }

    @NotNull
    public final InternalPluginResults getPluginUpdates$intellij_platform_ide_updateChecker(@NotNull Collection<PluginId> plugins2, @Nullable ProgressIndicator indicator, @Nullable BuildNumber buildNumber) {
        Intrinsics.checkNotNullParameter(plugins2, (String)"plugins");
        List<RemotePluginRepository> backends = this.collectPluginRepositories(new MarketplacePluginRepository());
        return this.getInternalPluginUpdates((Collection<? extends RemotePluginRepository>)backends, plugins2, indicator, buildNumber);
    }

    public static /* synthetic */ InternalPluginResults getPluginUpdates$intellij_platform_ide_updateChecker$default(UpdateChecker updateChecker, Collection collection, ProgressIndicator progressIndicator, BuildNumber buildNumber, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        if ((n & 4) != 0) {
            buildNumber = null;
        }
        return updateChecker.getPluginUpdates$intellij_platform_ide_updateChecker(collection, progressIndicator, buildNumber);
    }

    /*
     * WARNING - void declaration
     */
    @IntellijInternalApi
    @JvmStatic
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final InternalPluginResults checkInstalledPluginUpdates(@Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator) {
        void $this$mapTo$iv$iv;
        List<RemotePluginRepository> backends = INSTANCE.collectPluginRepositories(new MarketplaceUpdateCheckPluginRepository());
        Map<PluginId, IdeaPluginDescriptor> $this$map$iv = INSTANCE.collectUpdateablePlugins();
        boolean $i$f$map = false;
        Map<PluginId, IdeaPluginDescriptor> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PluginId)it.getKey());
        }
        List pluginIds = (List)destination$iv$iv;
        return INSTANCE.getInternalPluginUpdates((Collection<? extends RemotePluginRepository>)backends, pluginIds, indicator, buildNumber);
    }

    public static /* synthetic */ InternalPluginResults checkInstalledPluginUpdates$default(BuildNumber buildNumber, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 1) != 0) {
            buildNumber = null;
        }
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return UpdateChecker.checkInstalledPluginUpdates(buildNumber, progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    private final List<RemotePluginRepository> collectPluginRepositories(RemotePluginRepository marketplaceBackend) {
        void $this$mapNotNullTo$iv$iv;
        List<String> pluginHosts = UpdateCheckerPluginsFacade.Companion.getInstance().getPluginHosts();
        Iterable $this$mapNotNull$iv = pluginHosts;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RemotePluginRepository it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String host = (String)element$iv$iv;
            boolean bl2 = false;
            if ((INSTANCE.isMarketplaceBackend(host) ? marketplaceBackend : (host != null ? (RemotePluginRepository)new CustomPluginRepository(host) : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isMarketplaceBackend(String host) {
        return host == null && ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository();
    }

    private final InternalPluginResults getInternalPluginUpdates(Collection<? extends RemotePluginRepository> backends, Collection<PluginId> plugins2, ProgressIndicator indicator, BuildNumber buildNumber) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        if (!PluginEnabler.HEADLESS.isIgnoredDisabledPlugins()) {
            BuildNumber buildNumber2 = ApplicationInfo.getInstance().getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"getBuild(...)");
            Map brokenPlugins = MarketplaceRequests.Companion.getBrokenPlugins(buildNumber2);
            Map map = brokenPlugins;
            if (!(map == null || map.isEmpty())) {
                BrokenPluginFileKt.updateBrokenPlugins((Map)brokenPlugins);
            }
        }
        if (plugins2.isEmpty()) {
            return new InternalPluginResults(new PluginUpdates(null, null, null, 7, null), null, null, 6, null);
        }
        Map updateable = new LinkedHashMap();
        for (PluginId id : plugins2) {
            updateable.put(id, UpdateCheckerPluginsFacade.Companion.getInstance().getPlugin(id));
        }
        Map toUpdate = new LinkedHashMap();
        Map toUpdateDisabled = new LinkedHashMap();
        LinkedHashMap errors = new LinkedHashMap();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        Map pluginModels = new LinkedHashMap();
        for (RemotePluginRepository remotePluginRepository : backends) {
            try {
                Intrinsics.checkNotNull((Object)state);
                PreparedPluginUpdates updates = remotePluginRepository.findUpdates(buildNumber, state, updateable.keySet(), indicator);
                pluginModels.putAll(updates.getModels());
                toUpdate.putAll(updates.getToUpdate());
                toUpdateDisabled.putAll(updates.getToUpdateDisabled());
                for (PluginId updatePluginId : SetsKt.plus(updates.getToUpdate().keySet(), (Iterable)updates.getToUpdateDisabled().keySet())) {
                    updateable.remove(updatePluginId);
                }
            }
            catch (Exception e) {
                UpdateCheckerKt.access$getLOG$p().infoWithDebug("Failed to load plugins from " + remotePluginRepository.getId() + ": " + e.getMessage(), (Throwable)e);
                ((Map)errors).put(remotePluginRepository.getId(), e);
            }
        }
        Collection incompatible = UpdateCheckerKt.access$findPluginsWillBecomeIncompatible(buildNumber, updateable);
        return new InternalPluginResults(new PluginUpdates(toUpdate.values(), toUpdateDisabled.values(), incompatible), pluginModels.values(), (Map)errors);
    }

    static /* synthetic */ InternalPluginResults getInternalPluginUpdates$default(UpdateChecker updateChecker, Collection collection, Collection collection2, ProgressIndicator progressIndicator, BuildNumber buildNumber, int n, Object object) {
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        if ((n & 8) != 0) {
            buildNumber = null;
        }
        return updateChecker.getInternalPluginUpdates(collection, collection2, progressIndicator, buildNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> collectUpdateablePlugins() {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        String it;
        void $this$associateByTo$iv;
        Object it2;
        void $this$filterTo$iv$iv;
        HashMap updateable = new HashMap();
        Iterable $this$filter$iv = UpdateCheckerPluginsFacade.Companion.getInstance().getInstalledPlugins();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (IdeaPluginDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (!(!it2.isBundled() || it2.allowBundledUpdate())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Map destination$iv = updateable;
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)element$iv;
            Map map = destination$iv;
            boolean bl = false;
            map.put(it.getPluginId(), element$iv);
        }
        Path onceInstalled = UpdateCheckerPluginsFacade.Companion.getInstance().getOnceInstalledIfExists();
        if (onceInstalled != null) {
            try {
                List<String> list = Files.readAllLines(onceInstalled);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$trim$iv;
                    String line = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)line);
                    it2 = line;
                    PluginId.Companion bl2 = PluginId.Companion;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it3 = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl3 = false;
                        boolean bl4 = match$iv$iv = Intrinsics.compare((int)it3, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    PluginId id = bl2.getId(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    updateable.putIfAbsent(id, null);
                }
            }
            catch (IOException e) {
                UpdateCheckerKt.access$getLOG$p().error(((Object)onceInstalled).toString(), (Throwable)e);
            }
            onceInstalled.toFile().deleteOnExit();
        }
        if (!((Collection)excludedFromUpdateCheckPlugins).isEmpty() && !ApplicationManager.getApplication().isInternal()) {
            $this$forEach$iv = excludedFromUpdateCheckPlugins;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                PluginId id = PluginId.Companion.getId(it);
                IdeaPluginDescriptor plugin = (IdeaPluginDescriptor)updateable.get(id);
                if (plugin == null || !plugin.isBundled()) continue;
                updateable.remove(id);
            }
        }
        return updateable;
    }

    @JvmStatic
    public static final boolean allowedDowngrade$intellij_platform_ide_updateChecker(@Nullable IdeaPluginDescriptor localDescriptor, @Nullable IdeaPluginDescriptor remoteDescriptor) {
        return PluginManagementPolicy.Companion.getInstance().isDowngradeAllowed(localDescriptor, remoteDescriptor);
    }

    @JvmStatic
    public static final boolean allowedUpgrade$intellij_platform_ide_updateChecker(@Nullable IdeaPluginDescriptor localDescriptor, @Nullable IdeaPluginDescriptor remoteDescriptor) {
        return PluginManagementPolicy.Companion.getInstance().isUpgradeAllowed(localDescriptor, remoteDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @IntellijInternalApi
    @JvmOverloads
    @ApiStatus.Internal
    @NotNull
    public static final ExternalPluginResults getExternalPluginUpdates(@NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)updateSettings, (String)"updateSettings");
        ArrayList result = new ArrayList();
        LinkedHashMap errors = new LinkedHashMap();
        ExternalComponentManager externalComponentManager = ExternalComponentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)externalComponentManager, (String)"getInstance(...)");
        ExternalComponentManager manager = externalComponentManager;
        for (ExternalComponentSource source : ExternalComponentManager.getComponentSources()) {
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Collection collection = source.getAvailableVersions(indicator, updateSettings);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAvailableVersions(...)");
                Iterable iterable = collection;
                boolean $i$f$filter = false;
                void var10_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UpdatableExternalComponent it = (UpdatableExternalComponent)element$iv$iv;
                    boolean bl = false;
                    if (!it.isUpdateFor(manager.findExistingComponentMatching(it, source))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List siteResult = (List)destination$iv$iv;
                if (!(!((Collection)siteResult).isEmpty())) continue;
                Collection collection2 = result;
                Intrinsics.checkNotNull((Object)source);
                collection2.add(new ExternalUpdate(source, (Collection)siteResult));
            }
            catch (Exception e) {
                UpdateCheckerKt.access$getLOG$p().info("failed to load updates for " + source + ": " + e.getMessage(), (Throwable)(UpdateCheckerKt.access$getLOG$p().isDebugEnabled() ? e : null));
                ((Map)errors).put(source, e);
            }
        }
        return new ExternalPluginResults((Collection)result, (Map)errors);
    }

    public static /* synthetic */ ExternalPluginResults getExternalPluginUpdates$default(UpdateSettings updateSettings, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return UpdateChecker.getExternalPluginUpdates(updateSettings, progressIndicator);
    }

    @JvmStatic
    @JvmOverloads
    @RequiresBackgroundThread
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader originalDownloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)originalDownloader, (String)"originalDownloader");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(toUpdate, (String)"toUpdate");
        PluginId pluginId = originalDownloader.getId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        PluginId pluginId2 = pluginId;
        String pluginVersion = originalDownloader.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = UpdateCheckerPluginsFacade.Companion.getInstance().getPlugin(pluginId2);
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible((String)pluginVersion, (IdeaPluginDescriptor)installedPlugin, (BuildNumber)buildNumber) > 0 && UpdateChecker.allowedUpgrade$intellij_platform_ide_updateChecker(installedPlugin, originalDownloader.getDescriptor()) || PluginDownloader.compareVersionsSkipBrokenAndIncompatible((String)pluginVersion, (IdeaPluginDescriptor)installedPlugin, (BuildNumber)buildNumber) < 0 && UpdateChecker.allowedDowngrade$intellij_platform_ide_updateChecker(installedPlugin, originalDownloader.getDescriptor())) {
            IdeaPluginDescriptor descriptor;
            PluginDownloader pluginDownloader;
            PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId2);
            if (UpdateCheckerPluginsFacade.Companion.getInstance().isDisabled(pluginId2)) {
                pluginDownloader = originalDownloader;
            } else if (oldDownloader == null || VersionComparatorUtil.compare((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0 && UpdateChecker.allowedUpgrade$intellij_platform_ide_updateChecker(installedPlugin, oldDownloader.getDescriptor()) || VersionComparatorUtil.compare((String)pluginVersion, (String)oldDownloader.getPluginVersion()) < 0 && UpdateChecker.allowedDowngrade$intellij_platform_ide_updateChecker(installedPlugin, oldDownloader.getDescriptor())) {
                IdeaPluginDescriptor ideaPluginDescriptor = originalDownloader.getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"getDescriptor(...)");
                descriptor = ideaPluginDescriptor;
                if (descriptor instanceof PluginNode && ((PluginNode)descriptor).isIncomplete()) {
                    ProgressIndicator progressIndicator = indicator;
                    if (progressIndicator == null) {
                        progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                    }
                    originalDownloader.prepareToInstall(progressIndicator);
                    ourUpdatedPlugins.put(pluginId2, originalDownloader);
                }
                pluginDownloader = originalDownloader;
            } else {
                pluginDownloader = oldDownloader;
            }
            PluginDownloader downloader = pluginDownloader;
            IdeaPluginDescriptor ideaPluginDescriptor = downloader.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"getDescriptor(...)");
            descriptor = ideaPluginDescriptor;
            if (UpdateCheckerPluginsFacade.Companion.getInstance().isCompatible(descriptor, downloader.getBuildNumber()) && !state.wasUpdated(descriptor.getPluginId())) {
                toUpdate.put(pluginId2, downloader);
            }
        }
    }

    public static /* synthetic */ void checkAndPrepareToInstall$default(PluginDownloader pluginDownloader, InstalledPluginsState installedPluginsState, Map map, BuildNumber buildNumber, ProgressIndicator progressIndicator, int n, Object object) throws IOException {
        if ((n & 8) != 0) {
            buildNumber = null;
        }
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        UpdateChecker.checkAndPrepareToInstall(pluginDownloader, installedPluginsState, map, buildNumber, progressIndicator);
    }

    @NotNull
    public static final Set<PluginId> getDisabledToUpdate() {
        Lazy lazy = disabledToUpdate$delegate;
        return (Set)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getDisabledToUpdate$annotations() {
    }

    @JvmStatic
    public static final void saveDisabledToUpdatePlugins() {
        Path path = PathManager.getConfigDir().resolve("disabled_update.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PluginStringSetFile.INSTANCE.writeIdsSafe(path, UpdateChecker.getDisabledToUpdate(), UpdateCheckerKt.access$getLOG$p());
    }

    @JvmStatic
    @JvmName(name="isIgnored")
    @ApiStatus.Internal
    public static final boolean isIgnored(@NotNull IdeaPluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return INSTANCE.getIgnoredPlugins().contains(INSTANCE.getIgnoredKey(descriptor));
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="ignorePlugins")
    public final void ignorePlugins(@NotNull List<? extends IdeaPluginDescriptor> descriptors) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Object object2 = this.getIgnoredPlugins();
        Iterable $this$map$iv = descriptors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.getIgnoredKey((IdeaPluginDescriptor)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)object2, (Iterable)$this$map$iv);
        object2 = this;
        try {
            UpdateChecker $this$ignorePlugins_u24lambda_u241 = (UpdateChecker)object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Files.write(PathManager.getConfigDir().resolve("plugin_disabled_updates.txt"), (Iterable<? extends CharSequence>)$this$ignorePlugins_u24lambda_u241.getIgnoredPlugins(), new OpenOption[0]));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            UpdateCheckerKt.access$getLOG$p().error((Throwable)it);
        }
        UpdateSettingsEntryPointActionProvider.removePluginsUpdate(descriptors);
    }

    private final Set<String> getIgnoredPlugins() {
        Lazy lazy = ignoredPlugins$delegate;
        return (Set)lazy.getValue();
    }

    private final String getIgnoredKey(IdeaPluginDescriptor $this$ignoredKey) {
        return $this$ignoredKey.getPluginId().getIdString() + "+" + $this$ignoredKey.getVersion();
    }

    private final List<String> readConfigLines(String fileName) {
        block4: {
            Object object;
            if (ApplicationManager.getApplication().isUnitTestMode()) break block4;
            Object object2 = this;
            try {
                UpdateChecker $this$readConfigLines_u24lambda_u240 = object2;
                boolean bl = false;
                Path file = PathManager.getConfigDir().resolve(fileName);
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    List<String> list = Files.readAllLines(file);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                    return list;
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                UpdateCheckerKt.access$getLOG$p().error((Throwable)it);
            }
        }
        return CollectionsKt.emptyList();
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    public final void testPlatformUpdate(@Nullable Project project, @NotNull String updateDataText, @Nullable Path patchFile, boolean forceUpdate) {
        PlatformUpdates platformUpdates;
        Intrinsics.checkNotNullParameter((Object)updateDataText, (String)"updateDataText");
        if (!ApplicationManager.getApplication().isInternal()) {
            throw new IllegalStateException();
        }
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber currentBuild = buildNumber;
        String string = currentBuild.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String productCode = string;
        if (forceUpdate) {
            UpdateChain updateChain;
            Element element;
            Element element2 = JDOMUtil.load((CharSequence)updateDataText).getChild("product");
            if (element2 == null || (element = element2.getChild("channel")) == null) {
                throw new IllegalArgumentException("//channel missing");
            }
            Element node = element;
            UpdateChannel channel = new UpdateChannel(node, productCode);
            BuildInfo buildInfo = (BuildInfo)CollectionsKt.firstOrNull((List)channel.getBuilds());
            if (buildInfo == null) {
                throw new IllegalArgumentException("//build missing");
            }
            BuildInfo newBuild = buildInfo;
            PatchInfo patchInfo = (PatchInfo)CollectionsKt.firstOrNull((List)newBuild.getPatches());
            if (patchInfo != null) {
                PatchInfo it = patchInfo;
                boolean bl = false;
                Object[] objectArray = new BuildNumber[]{it.getFromBuild(), newBuild.getNumber()};
                UpdateChain updateChain2 = new UpdateChain(CollectionsKt.listOf((Object[])objectArray), it.getSize());
                updateChain = updateChain2;
            } else {
                updateChain = null;
            }
            UpdateChain patches = updateChain;
            platformUpdates = (PlatformUpdates)new PlatformUpdates.Loaded(newBuild, channel, patches);
        } else {
            platformUpdates = new UpdateStrategy(currentBuild, UpdateData.parseUpdateData((String)updateDataText, (String)productCode), null, null, 12, null).checkForUpdates();
        }
        PlatformUpdates checkForUpdateResult = platformUpdates;
        AbstractUpdateDialog dialog = checkForUpdateResult instanceof PlatformUpdates.Loaded ? (AbstractUpdateDialog)PlatformUpdateDialog.createTestDialog(project, (PlatformUpdates.Loaded)checkForUpdateResult, patchFile) : (AbstractUpdateDialog)new NoUpdatesDialog(true);
        dialog.show();
    }

    @Deprecated(message="Use getNotificationGroup()", replaceWith=@ReplaceWith(expression="getNotificationGroup()", imports={}), level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getNOTIFICATIONS$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use disabledToUpdate", replaceWith=@ReplaceWith(expression="disabledToUpdate", imports={}))
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final Set<String> getDisabledToUpdatePlugins() {
        void var1_1;
        void $this$mapTo$iv;
        Iterable iterable = UpdateChecker.getDisabledToUpdate();
        Collection destination$iv = new TreeSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PluginId pluginId = (PluginId)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getIdString());
        }
        return (Set)var1_1;
    }

    @Deprecated(message="Use disabledToUpdate", replaceWith=@ReplaceWith(expression="disabledToUpdate", imports={}))
    @JvmStatic
    public static /* synthetic */ void getDisabledToUpdatePlugins$annotations() {
    }

    @Deprecated(message="Use PluginUpdateCheckService instead", replaceWith=@ReplaceWith(expression="PluginUpdateCheckService.getInstance().getPluginUpdate(pluginId, indicator)", imports={}))
    @JvmStatic
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static final Collection<PluginDownloader> getPluginUpdates() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @IntellijInternalApi
    @Deprecated(message="Use PluginUpdateCheckService instead", replaceWith=@ReplaceWith(expression="PluginUpdateCheckService.getInstance().getPluginUpdate(pluginId, indicator)", imports={}))
    @JvmOverloads
    @ApiStatus.Internal
    @NotNull
    public static final InternalPluginResults getInternalPluginUpdates(@Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator, @Nullable Map<PluginId, IdeaPluginDescriptor> updateablePluginsMap) {
        Map<PluginId, IdeaPluginDescriptor> map = updateablePluginsMap;
        if (map == null || (map = map.keySet()) == null) {
            void $this$mapTo$iv$iv;
            Map<PluginId, IdeaPluginDescriptor> $this$map$iv = INSTANCE.collectUpdateablePlugins();
            boolean $i$f$map = false;
            Map<PluginId, IdeaPluginDescriptor> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((PluginId)it.getKey());
            }
            map = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        Map<PluginId, IdeaPluginDescriptor> ids = map;
        InternalPluginResults result = INSTANCE.getPluginUpdates$intellij_platform_ide_updateChecker((Collection)((Object)ids), indicator, buildNumber);
        if (updateablePluginsMap != null) {
            for (PluginDownloader update : result.getPluginUpdates().getAll()) {
                updateablePluginsMap.remove(update.getId());
            }
        }
        return result;
    }

    public static /* synthetic */ InternalPluginResults getInternalPluginUpdates$default(BuildNumber buildNumber, ProgressIndicator progressIndicator, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            buildNumber = null;
        }
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        if ((n & 4) != 0) {
            map = null;
        }
        return UpdateChecker.getInternalPluginUpdates(buildNumber, progressIndicator, map);
    }

    @IntellijInternalApi
    @Deprecated(message="Must not be used by plugins, only IDE itself. To remove without replacement!")
    @JvmStatic
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    public static final void updateDescriptorsForInstalledPlugins(@NotNull InstalledPluginsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Migrate to PluginUpdateCheckService")
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final PluginUpdatesInfo getPluginUpdates(@NotNull PluginId pluginId, @Nullable ProgressIndicator indicator) {
        Collection<PluginId> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        InternalPluginResults result = UpdateChecker.getPluginUpdates$intellij_platform_ide_updateChecker$default(this, CollectionsKt.listOf((Object)pluginId), indicator, null, 4, null);
        PluginUpdates updates = result.getPluginUpdates();
        Iterable iterable = updates.getIncompatible();
        Collection collection2 = updates.getAllDisabled();
        Collection collection3 = updates.getAllEnabled();
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPluginId());
        }
        collection = (List)destination$iv$iv;
        Map map = result.getErrors();
        Collection collection4 = collection;
        Collection collection5 = collection2;
        Collection collection6 = collection3;
        return new PluginUpdatesInfo(collection6, collection5, collection4, map);
    }

    public static /* synthetic */ PluginUpdatesInfo getPluginUpdates$default(UpdateChecker updateChecker, PluginId pluginId, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return updateChecker.getPluginUpdates(pluginId, progressIndicator);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateAndShowResult(@Nullable Project project) {
        UpdateChecker.updateAndShowResult$default(project, null, 2, null);
    }

    @JvmStatic
    @IntellijInternalApi
    @JvmOverloads
    @JvmName(name="getPlatformUpdates")
    @ApiStatus.Internal
    @NotNull
    public static final PlatformUpdates getPlatformUpdates(@NotNull UpdateSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return UpdateChecker.getPlatformUpdates$default(settings, null, 2, null);
    }

    @JvmStatic
    @IntellijInternalApi
    @JvmOverloads
    @JvmName(name="getPlatformUpdates")
    @ApiStatus.Internal
    @NotNull
    public static final PlatformUpdates getPlatformUpdates() {
        return UpdateChecker.getPlatformUpdates$default(null, null, 3, null);
    }

    @IntellijInternalApi
    @JvmStatic
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final InternalPluginResults checkInstalledPluginUpdates(@Nullable BuildNumber buildNumber) {
        return UpdateChecker.checkInstalledPluginUpdates$default(buildNumber, null, 2, null);
    }

    @IntellijInternalApi
    @JvmStatic
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final InternalPluginResults checkInstalledPluginUpdates() {
        return UpdateChecker.checkInstalledPluginUpdates$default(null, null, 3, null);
    }

    @JvmStatic
    @IntellijInternalApi
    @JvmOverloads
    @ApiStatus.Internal
    @NotNull
    public static final ExternalPluginResults getExternalPluginUpdates(@NotNull UpdateSettings updateSettings) {
        Intrinsics.checkNotNullParameter((Object)updateSettings, (String)"updateSettings");
        return UpdateChecker.getExternalPluginUpdates$default(updateSettings, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @RequiresBackgroundThread
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader originalDownloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable BuildNumber buildNumber) throws IOException {
        Intrinsics.checkNotNullParameter((Object)originalDownloader, (String)"originalDownloader");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(toUpdate, (String)"toUpdate");
        UpdateChecker.checkAndPrepareToInstall$default(originalDownloader, state, toUpdate, buildNumber, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @RequiresBackgroundThread
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader originalDownloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate) throws IOException {
        Intrinsics.checkNotNullParameter((Object)originalDownloader, (String)"originalDownloader");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(toUpdate, (String)"toUpdate");
        UpdateChecker.checkAndPrepareToInstall$default(originalDownloader, state, toUpdate, null, null, 24, null);
    }

    @JvmStatic
    @IntellijInternalApi
    @Deprecated(message="Use PluginUpdateCheckService instead", replaceWith=@ReplaceWith(expression="PluginUpdateCheckService.getInstance().getPluginUpdate(pluginId, indicator)", imports={}))
    @JvmOverloads
    @ApiStatus.Internal
    @NotNull
    public static final InternalPluginResults getInternalPluginUpdates(@Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator) {
        return UpdateChecker.getInternalPluginUpdates$default(buildNumber, indicator, null, 4, null);
    }

    @JvmStatic
    @IntellijInternalApi
    @Deprecated(message="Use PluginUpdateCheckService instead", replaceWith=@ReplaceWith(expression="PluginUpdateCheckService.getInstance().getPluginUpdate(pluginId, indicator)", imports={}))
    @JvmOverloads
    @ApiStatus.Internal
    @NotNull
    public static final InternalPluginResults getInternalPluginUpdates(@Nullable BuildNumber buildNumber) {
        return UpdateChecker.getInternalPluginUpdates$default(buildNumber, null, null, 6, null);
    }

    @JvmStatic
    @IntellijInternalApi
    @Deprecated(message="Use PluginUpdateCheckService instead", replaceWith=@ReplaceWith(expression="PluginUpdateCheckService.getInstance().getPluginUpdate(pluginId, indicator)", imports={}))
    @JvmOverloads
    @ApiStatus.Internal
    @NotNull
    public static final InternalPluginResults getInternalPluginUpdates() {
        return UpdateChecker.getInternalPluginUpdates$default(null, null, null, 7, null);
    }

    private static final Element loadProductData$lambda$0$1(ProgressIndicator $indicator, HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JDOMUtil.load((Reader)it.getReader($indicator));
    }

    private static final void updateDescriptorsForInstalledPlugins$lambda$0() {
        UpdateChecker.checkInstalledPluginUpdates$default(null, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final TreeSet disabledToUpdate_delegate$lambda$0() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = INSTANCE.readConfigLines("disabled_update.txt");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PluginId.Companion.getId((String)it));
        }
        Collection collection = (List)var3_3;
        return new TreeSet(collection);
    }

    private static final TreeSet ignoredPlugins_delegate$lambda$0() {
        return new TreeSet(INSTANCE.readConfigLines("plugin_disabled_updates.txt"));
    }

    static {
        ourUpdatedPlugins = new HashMap();
        excludedFromUpdateCheckPlugins = new HashSet();
        disabledToUpdate$delegate = LazyKt.lazy(UpdateChecker::disabledToUpdate_delegate$lambda$0);
        ignoredPlugins$delegate = LazyKt.lazy(UpdateChecker::ignoredPlugins_delegate$lambda$0);
        NOTIFICATIONS = new NotificationGroup("IDE and Plugin Updates", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginManagerCore.CORE_ID);
    }

    @Deprecated(message="Migrate to PluginUpdateCheckService")
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BU\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\b\u0012\u00060\u000bj\u0002`\f0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J\u001b\u0010\u001e\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\b\u0012\u00060\u000bj\u0002`\f0\tH\u00c6\u0003JU\u0010\u001f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\b\u0012\u00060\u000bj\u0002`\f0\tH\u00c6\u0001J\u0014\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010#\u001a\u00020$H\u00d6\u0081\u0004J\n\u0010%\u001a\u00020\nH\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R#\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\b\u0012\u00060\u000bj\u0002`\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$PluginUpdatesInfo;", "", "allEnabled", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "allDisabled", "incompatible", "Lcom/intellij/openapi/extensions/PluginId;", "errors", "", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Map;)V", "getAllEnabled", "()Ljava/util/Collection;", "getAllDisabled", "getIncompatible", "getErrors", "()Ljava/util/Map;", "all", "", "getAll", "()Ljava/util/List;", "all$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.updateChecker"})
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    public static final class PluginUpdatesInfo {
        @NotNull
        private final Collection<PluginDownloader> allEnabled;
        @NotNull
        private final Collection<PluginDownloader> allDisabled;
        @NotNull
        private final Collection<PluginId> incompatible;
        @NotNull
        private final Map<String, Exception> errors;
        @NotNull
        private final Lazy all$delegate;

        @ApiStatus.Internal
        public PluginUpdatesInfo(@NotNull Collection<PluginDownloader> allEnabled, @NotNull Collection<PluginDownloader> allDisabled, @NotNull Collection<PluginId> incompatible, @NotNull Map<String, ? extends Exception> errors) {
            Intrinsics.checkNotNullParameter(allEnabled, (String)"allEnabled");
            Intrinsics.checkNotNullParameter(allDisabled, (String)"allDisabled");
            Intrinsics.checkNotNullParameter(incompatible, (String)"incompatible");
            Intrinsics.checkNotNullParameter(errors, (String)"errors");
            this.allEnabled = allEnabled;
            this.allDisabled = allDisabled;
            this.incompatible = incompatible;
            this.errors = errors;
            this.all$delegate = LazyKt.lazy(() -> PluginUpdatesInfo.all_delegate$lambda$0(this));
        }

        public /* synthetic */ PluginUpdatesInfo(Collection collection, Collection collection2, Collection collection3, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                collection3 = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                map = MapsKt.emptyMap();
            }
            this(collection, collection2, collection3, map);
        }

        @NotNull
        public final Collection<PluginDownloader> getAllEnabled() {
            return this.allEnabled;
        }

        @NotNull
        public final Collection<PluginDownloader> getAllDisabled() {
            return this.allDisabled;
        }

        @NotNull
        public final Collection<PluginId> getIncompatible() {
            return this.incompatible;
        }

        @NotNull
        public final Map<String, Exception> getErrors() {
            return this.errors;
        }

        @NotNull
        public final List<PluginDownloader> getAll() {
            Lazy lazy = this.all$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final Collection<PluginDownloader> component1() {
            return this.allEnabled;
        }

        @NotNull
        public final Collection<PluginDownloader> component2() {
            return this.allDisabled;
        }

        @NotNull
        public final Collection<PluginId> component3() {
            return this.incompatible;
        }

        @NotNull
        public final Map<String, Exception> component4() {
            return this.errors;
        }

        @NotNull
        public final PluginUpdatesInfo copy(@NotNull Collection<PluginDownloader> allEnabled, @NotNull Collection<PluginDownloader> allDisabled, @NotNull Collection<PluginId> incompatible, @NotNull Map<String, ? extends Exception> errors) {
            Intrinsics.checkNotNullParameter(allEnabled, (String)"allEnabled");
            Intrinsics.checkNotNullParameter(allDisabled, (String)"allDisabled");
            Intrinsics.checkNotNullParameter(incompatible, (String)"incompatible");
            Intrinsics.checkNotNullParameter(errors, (String)"errors");
            return new PluginUpdatesInfo(allEnabled, allDisabled, incompatible, errors);
        }

        public static /* synthetic */ PluginUpdatesInfo copy$default(PluginUpdatesInfo pluginUpdatesInfo, Collection collection, Collection collection2, Collection collection3, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                collection = pluginUpdatesInfo.allEnabled;
            }
            if ((n & 2) != 0) {
                collection2 = pluginUpdatesInfo.allDisabled;
            }
            if ((n & 4) != 0) {
                collection3 = pluginUpdatesInfo.incompatible;
            }
            if ((n & 8) != 0) {
                map = pluginUpdatesInfo.errors;
            }
            return pluginUpdatesInfo.copy(collection, collection2, collection3, map);
        }

        @NotNull
        public String toString() {
            return "PluginUpdatesInfo(allEnabled=" + this.allEnabled + ", allDisabled=" + this.allDisabled + ", incompatible=" + this.incompatible + ", errors=" + this.errors + ")";
        }

        public int hashCode() {
            int result = ((Object)this.allEnabled).hashCode();
            result = result * 31 + ((Object)this.allDisabled).hashCode();
            result = result * 31 + ((Object)this.incompatible).hashCode();
            result = result * 31 + ((Object)this.errors).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PluginUpdatesInfo)) {
                return false;
            }
            PluginUpdatesInfo pluginUpdatesInfo = (PluginUpdatesInfo)other;
            if (!Intrinsics.areEqual(this.allEnabled, pluginUpdatesInfo.allEnabled)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allDisabled, pluginUpdatesInfo.allDisabled)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.incompatible, pluginUpdatesInfo.incompatible)) {
                return false;
            }
            return Intrinsics.areEqual(this.errors, pluginUpdatesInfo.errors);
        }

        private static final List all_delegate$lambda$0(PluginUpdatesInfo this$0) {
            return CollectionsKt.plus(this$0.allEnabled, (Iterable)this$0.allDisabled);
        }

        @ApiStatus.Internal
        public PluginUpdatesInfo() {
            this(null, null, null, null, 15, null);
        }
    }
}

