/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.LocalProcessService;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.RawCommandLineString;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SystemProperties;
import com.pty4j.Command;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import com.pty4j.windows.conpty.WinConPtyProcess;
import com.pty4j.windows.winpty.WinPtyProcess;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.function.LongConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.winp.WinProcess;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00112\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/execution/process/LocalProcessServiceImpl;", "Lcom/intellij/execution/process/LocalProcessService;", "<init>", "()V", "startPtyProcess", "Lcom/pty4j/PtyProcess;", "command", "", "", "directory", "env", "", "options", "Lcom/intellij/execution/process/LocalPtyOptions;", "redirectErrorStream", "", "Lcom/intellij/execution/process/RawCommandLineString;", "Lcom/pty4j/Command;", "sendWinProcessCtrlC", "process", "Ljava/lang/Process;", "pid", "", "processOutputStream", "Ljava/io/OutputStream;", "killWinProcessRecursively", "", "isLocalPtyProcess", "winPtyChildProcessId", "(Ljava/lang/Process;)Ljava/lang/Integer;", "hasControllingTerminal", "createWinProcess", "Lorg/jvnet/winp/WinProcess;", "killWinProcess", "getCommand", "intellij.platform.ide.util.io.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalProcessServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalProcessServiceImpl.kt\ncom/intellij/execution/process/LocalProcessServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,142:1\n13#2:143\n13#2:144\n*S KotlinDebug\n*F\n+ 1 LocalProcessServiceImpl.kt\ncom/intellij/execution/process/LocalProcessServiceImpl\n*L\n62#1:143\n131#1:144\n*E\n"})
public final class LocalProcessServiceImpl
implements LocalProcessService {
    @NotNull
    public PtyProcess startPtyProcess(@NotNull List<String> command, @Nullable String directory, @NotNull Map<String, String> env, @NotNull LocalPtyOptions options, boolean redirectErrorStream) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.startPtyProcess((Command)new Command.CommandList(command), directory, env, options, redirectErrorStream);
    }

    @NotNull
    public PtyProcess startPtyProcess(@NotNull RawCommandLineString command, @Nullable String directory, @NotNull Map<String, String> env, @NotNull LocalPtyOptions options, boolean redirectErrorStream) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.startPtyProcess((Command)new Command.RawCommandString(command.getCommandLine()), directory, env, options, redirectErrorStream);
    }

    private final PtyProcess startPtyProcess(Command command, String directory, Map<String, String> env, LocalPtyOptions options, boolean redirectErrorStream) {
        PtyProcessBuilder ptyProcessBuilder = new PtyProcessBuilder(command).setEnvironment(env).setDirectory(directory).setInitialColumns(options.getInitialColumns() > 0 ? Integer.valueOf(options.getInitialColumns()) : null).setInitialRows(options.getInitialRows() > 0 ? Integer.valueOf(options.getInitialRows()) : null).setConsole(options.getConsoleMode()).setCygwin(options.getUseCygwinLaunch() && SystemInfo.isWindows).setUseWinConPty(options.getUseWinConPty()).setRedirectErrorStream(redirectErrorStream).setWindowsAnsiColorEnabled(!SystemProperties.getBooleanProperty((String)"pty4j.win.disable.ansi.in.console.mode", (boolean)false)).setUnixOpenTtyToPreserveOutputAfterTermination(SystemProperties.getBooleanProperty((String)"pty4j.open.child.tty", (boolean)SystemInfo.isMac)).setSpawnProcessUsingJdkOnMacIntel(Registry.Companion.is("run.processes.using.pty.helper.on.mac.intel", true));
        Intrinsics.checkNotNullExpressionValue((Object)ptyProcessBuilder, (String)"setSpawnProcessUsingJdkOnMacIntel(...)");
        PtyProcessBuilder builder = ptyProcessBuilder;
        if (options.getWinSuspendedProcessCallback() != null) {
            LongConsumer longConsumer = options.getWinSuspendedProcessCallback();
            Intrinsics.checkNotNull((Object)longConsumer);
            builder.setWindowsSuspendedProcessCallback(longConsumer);
        }
        PtyProcess ptyProcess = builder.start();
        Intrinsics.checkNotNullExpressionValue((Object)ptyProcess, (String)"start(...)");
        PtyProcess process = ptyProcess;
        if (options.getWinSuspendedProcessCallback() != null && !(process instanceof WinConPtyProcess)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LocalProcessServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Windows suspended process callback is only applicable for a WinConPtyProcess instance");
        }
        return process;
    }

    public boolean sendWinProcessCtrlC(@NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        return this.sendWinProcessCtrlC((int)process.pid(), process.getOutputStream());
    }

    public boolean sendWinProcessCtrlC(int pid) {
        return this.sendWinProcessCtrlC(pid, null);
    }

    public boolean sendWinProcessCtrlC(int pid, @Nullable OutputStream processOutputStream) {
        boolean r = this.createWinProcess(pid).sendCtrlC();
        try {
            OutputStream outputStream = processOutputStream;
            if (outputStream != null) {
                OutputStream outputStream2;
                OutputStream $this$sendWinProcessCtrlC_u24lambda_u240 = outputStream2 = outputStream;
                boolean bl = false;
                $this$sendWinProcessCtrlC_u24lambda_u240.write(-1);
                $this$sendWinProcessCtrlC_u24lambda_u240.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public void killWinProcessRecursively(@NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        this.createWinProcess(process).killRecursively();
    }

    public boolean isLocalPtyProcess(@NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        return process instanceof PtyProcess;
    }

    @Nullable
    public Integer winPtyChildProcessId(@NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        if (process instanceof WinPtyProcess) {
            return (int)((WinPtyProcess)process).pid();
        }
        return null;
    }

    public boolean hasControllingTerminal(@NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        return process instanceof PtyProcess && !((PtyProcess)process).isConsoleMode();
    }

    private final WinProcess createWinProcess(Process process) {
        return new WinProcess((int)process.pid());
    }

    private final WinProcess createWinProcess(int pid) {
        return new WinProcess(pid);
    }

    public void killWinProcess(int pid) {
        this.createWinProcess(pid).kill();
    }

    @NotNull
    public List<String> getCommand(@NotNull Process process) {
        List list;
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Process process2 = process;
        if (process2 instanceof WinConPtyProcess) {
            list = ((WinConPtyProcess)process).getCommandWrapper().toList();
        } else if (process2 instanceof WinPtyProcess) {
            list = ((WinPtyProcess)process).getCommandWrapper().toList();
        } else {
            Object object;
            try {
                object = process.info();
                Intrinsics.checkNotNull((Object)object);
            }
            catch (UnsupportedOperationException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(LocalProcessServiceImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Cannot find command line for " + process.getClass(), (Throwable)e);
                return CollectionsKt.emptyList();
            }
            ProcessHandle.Info processInfo = object;
            object = processInfo.command().orElse(null);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add(it);
                spreadBuilder.addSpread((Object)processInfo.arguments().orElse(new String[0]));
                return CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
            }
            return CollectionsKt.emptyList();
        }
        return list;
    }
}

