/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.io.NettyKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H&J0\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/ide/HttpRequestHandler;", "", "<init>", "()V", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "isSupported", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "sendData", "content", "", "name", "", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "OriginCheckResult", "Companion", "intellij.platform.ide.util.netty"})
public abstract class HttpRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ExtensionPointName<HttpRequestHandler> EP_NAME = new ExtensionPointName("com.intellij.httpRequestHandler");

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String hostName = NettyKt.getHostName(request);
        return hostName != null && this.isOriginAllowed(request) != OriginCheckResult.FORBID && NettyKt.isLocalHost$default(hostName, false, false, 6, null);
    }

    @NotNull
    protected OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return NettyKt.isLocalOrigin$default(request, false, false, 3, null) ? OriginCheckResult.ALLOW : OriginCheckResult.FORBID;
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return request.method() == HttpMethod.GET || request.method() == HttpMethod.HEAD;
    }

    public abstract boolean process(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;

    protected final boolean sendData(@NotNull byte[] content, @NotNull String name, @NotNull FullHttpRequest request, @NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)FileResponses.INSTANCE.getContentType(name));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(Calendar.getInstance().getTimeInMillis()));
        response.headers().add(extraHeaders);
        boolean keepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)request);
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD)) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)content.length);
        }
        channel.write((Object)response);
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD)) {
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            channel.write((Object)new ChunkedStream((InputStream)stream));
            stream.close();
        }
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return true;
    }

    @JvmStatic
    public static final boolean checkPrefix(@NotNull String uri, @NotNull String prefix) {
        return Companion.checkPrefix(uri, prefix);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/ide/HttpRequestHandler$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/ide/HttpRequestHandler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "checkPrefix", "", "uri", "", "prefix", "intellij.platform.ide.util.netty"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<HttpRequestHandler> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        public final boolean checkPrefix(@NotNull String uri, @NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            if (uri.length() > prefix.length() && uri.charAt(0) == '/' && StringsKt.regionMatches((String)uri, (int)1, (String)prefix, (int)0, (int)prefix.length(), (boolean)true)) {
                if (uri.length() - prefix.length() == 1) {
                    return true;
                }
                char c = uri.charAt(prefix.length() + 1);
                return c == '/' || c == '?';
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "", "<init>", "(Ljava/lang/String;I)V", "ALLOW", "FORBID", "ASK_CONFIRMATION", "intellij.platform.ide.util.netty"})
    public static final class OriginCheckResult
    extends Enum<OriginCheckResult> {
        public static final /* enum */ OriginCheckResult ALLOW = new OriginCheckResult();
        public static final /* enum */ OriginCheckResult FORBID = new OriginCheckResult();
        public static final /* enum */ OriginCheckResult ASK_CONFIRMATION = new OriginCheckResult();
        private static final /* synthetic */ OriginCheckResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OriginCheckResult[] values() {
            return (OriginCheckResult[])$VALUES.clone();
        }

        public static OriginCheckResult valueOf(String value) {
            return Enum.valueOf(OriginCheckResult.class, value);
        }

        @NotNull
        public static EnumEntries<OriginCheckResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = originCheckResultArray = new OriginCheckResult[]{OriginCheckResult.ALLOW, OriginCheckResult.FORBID, OriginCheckResult.ASK_CONFIRMATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

