/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedNioFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ByteRange;
import org.jetbrains.io.FileResponsesKt;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J6\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J6\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/io/FileResponses;", "", "<init>", "()V", "getContentType", "", "path", "checkCache", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "lastModified", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "prepareSend", "Lio/netty/handler/codec/http/HttpResponse;", "filename", "doPrepareResponse", "Lio/netty/handler/codec/http/DefaultHttpResponse;", "response", "sendFile", "", "file", "Ljava/nio/file/Path;", "extraSuffix", "", "intellij.platform.ide.util.netty"})
@SourceDebugExtension(value={"SMAP\nFileResponses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileResponses.kt\norg/jetbrains/io/FileResponses\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class FileResponses {
    @NotNull
    public static final FileResponses INSTANCE = new FileResponses();

    private FileResponses() {
    }

    @NotNull
    public final String getContentType(@NotNull String path) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                string = PathUtilRt.getFileExtension((String)path);
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = (String)FileResponsesKt.access$getFileExtToMimeType().get(it);
                string = string2;
                if (string2 != null) break block3;
            }
            string = "application/octet-stream";
        }
        return string;
    }

    @JvmOverloads
    public final boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Long ifModified = request.headers().getTimeMillis((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModified != null && ifModified >= lastModified) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_MODIFIED;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_MODIFIED");
            Responses.send$default(httpResponseStatus, channel, request, null, extraHeaders, 4, null);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean checkCache$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, long l, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        return fileResponses.checkCache(httpRequest, channel, l, httpHeaders);
    }

    @JvmOverloads
    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (request.headers().get((CharSequence)HttpHeaderNames.RANGE) == null && this.checkCache(request, channel, lastModified, extraHeaders)) {
            return null;
        }
        return (HttpResponse)this.doPrepareResponse(new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), filename, lastModified, extraHeaders);
    }

    public static /* synthetic */ HttpResponse prepareSend$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, long l, String string, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 0x10) != 0) {
            httpHeaders = null;
        }
        return fileResponses.prepareSend(httpRequest, channel, l, string, httpHeaders);
    }

    private final DefaultHttpResponse doPrepareResponse(DefaultHttpResponse response, String filename, long lastModified, HttpHeaders extraHeaders) {
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.getContentType(filename));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)HttpHeaderValues.NO_CACHE);
        if (!Intrinsics.areEqual((Object)response.status(), (Object)HttpResponseStatus.PARTIAL_CONTENT)) {
            response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
        }
        if (extraHeaders != null) {
            response.headers().add(extraHeaders);
        }
        return response;
    }

    public final void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Path file, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.sendFile(request, channel, file, extraHeaders, null);
    }

    public static /* synthetic */ void sendFile$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, Path path, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        fileResponses.sendFile(httpRequest, channel, path, httpHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Path file, @Nullable HttpHeaders extraHeaders, @Nullable byte[] extraSuffix) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileChannel fileChannel = null;
        String rangeHeader = request.headers().get((CharSequence)HttpHeaderNames.RANGE);
        long lastModified = 0L;
        try {
            lastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
            if (rangeHeader == null && (extraSuffix == null || extraSuffix.length == 0) && this.checkCache(request, channel, lastModified, extraHeaders)) {
                return;
            }
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
            FileChannel fileChannel2 = FileChannel.open(file, openOptionArray);
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel2, (String)"open(...)");
            fileChannel = fileChannel2;
        }
        catch (NoSuchFileException ignored) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Responses.send$default(httpResponseStatus, channel, request, null, null, 12, null);
            return;
        }
        boolean isKeepAlive = false;
        boolean fileWillBeClosed = false;
        try {
            ByteRange range;
            long fileSize = fileChannel.size();
            long responseLength = fileSize + (long)(extraSuffix != null ? extraSuffix.length : 0);
            ByteRange byteRange = FileResponsesKt.access$parseRange(rangeHeader, responseLength);
            if (byteRange == null) {
                byteRange = new ByteRange(0L, responseLength);
            }
            boolean isPartialContent = (range = byteRange).getStart() != 0L || range.getEnd() != responseLength;
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, isPartialContent ? HttpResponseStatus.PARTIAL_CONTENT : HttpResponseStatus.OK);
            isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, request);
            this.doPrepareResponse(response, ((Object)file.getFileName()).toString(), lastModified, extraHeaders);
            if (isPartialContent) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_RANGE, (Object)("bytes " + range.getStart() + "-" + (range.getEnd() - 1L) + "/" + responseLength));
            }
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)range.getLength());
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                ByteRange suffixRange;
                ByteRange fileRange = range.intersect(0L, fileSize);
                if (fileRange != null && fileRange.getLength() > 0L) {
                    ChannelFuture channelFuture = channel.pipeline().get(SslHandler.class) == null ? channel.write((Object)new DefaultFileRegion(fileChannel, range.getStart(), fileRange.getLength())) : channel.write((Object)new ChunkedNioFile(fileChannel, range.getStart(), fileRange.getLength(), 8192));
                }
                if (extraSuffix != null && (suffixRange = range.intersect(fileSize, fileSize + (long)extraSuffix.length)) != null && suffixRange.getLength() > 0L) {
                    ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])extraSuffix, (int)((int)(suffixRange.getStart() - fileSize)), (int)((int)suffixRange.getLength()));
                    channel.write((Object)byteBuf);
                }
            }
            fileWillBeClosed = true;
        }
        catch (Throwable throwable) {
            fileChannel.close();
            throw throwable;
        }
        FileResponsesKt.flushChunkedResponse(channel, isKeepAlive);
    }

    public static /* synthetic */ void sendFile$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, Path path, HttpHeaders httpHeaders, byte[] byArray, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        if ((n & 0x10) != 0) {
            byArray = null;
        }
        fileResponses.sendFile(httpRequest, channel, path, httpHeaders, byArray);
    }

    @JvmOverloads
    public final boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return FileResponses.checkCache$default(this, request, channel, lastModified, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return FileResponses.prepareSend$default(this, request, channel, lastModified, filename, null, 16, null);
    }
}

