/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.text.CharSequenceBackedByChars;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BufferToCharsKt;
import org.jetbrains.io.Decoder;

public abstract class MessageDecoder
extends Decoder {
    protected int contentLength;
    protected final StringBuilder builder = new StringBuilder(64);
    private CharBuffer chunkedContent;
    private int consumedContentByteCount = 0;

    protected final int parseContentLength() {
        return MessageDecoder.parseInt(this.builder, 0, false, 10);
    }

    @Nullable
    protected final CharSequence readChars(@NotNull ByteBuf input) {
        String result;
        int readableBytes;
        if (input == null) {
            MessageDecoder.$$$reportNull$$$0(0);
        }
        if ((readableBytes = input.readableBytes()) == 0) {
            input.release();
            return null;
        }
        int required = this.contentLength - this.consumedContentByteCount;
        if (readableBytes < required) {
            if (this.chunkedContent == null) {
                this.chunkedContent = CharBuffer.allocate(this.contentLength);
            }
            BufferToCharsKt.readIntoCharBuffer(input, readableBytes, this.chunkedContent);
            this.consumedContentByteCount += readableBytes;
            input.release();
            return null;
        }
        CharBuffer charBuffer = this.chunkedContent;
        if (charBuffer != null) {
            this.chunkedContent = null;
            this.consumedContentByteCount = 0;
            BufferToCharsKt.readIntoCharBuffer(input, required, charBuffer);
            result = new CharSequenceBackedByChars(charBuffer);
        } else {
            result = input.toString(input.readerIndex(), required, StandardCharsets.UTF_8);
        }
        input.readerIndex(input.readerIndex() + required);
        return result;
    }

    @Override
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        try {
            this.chunkedContent = null;
        }
        finally {
            super.channelInactive(context);
        }
    }

    public static boolean readUntil(char what, @NotNull ByteBuf buffer, @NotNull StringBuilder builder) {
        int i;
        if (buffer == null) {
            MessageDecoder.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            MessageDecoder.$$$reportNull$$$0(2);
        }
        int n = buffer.writerIndex();
        for (i = buffer.readerIndex(); i < n; ++i) {
            char c = (char)buffer.getByte(i);
            if (c == what) {
                buffer.readerIndex(i + 1);
                return true;
            }
            builder.append(c);
        }
        buffer.readerIndex(i);
        return false;
    }

    public static void skipWhitespace(@NotNull ByteBuf buffer) {
        if (buffer == null) {
            MessageDecoder.$$$reportNull$$$0(3);
        }
        int n = buffer.writerIndex();
        for (int i = buffer.readerIndex(); i < n; ++i) {
            char c = (char)buffer.getByte(i);
            if (c == ' ') continue;
            buffer.readerIndex(i);
            return;
        }
        buffer.readerIndex(n);
    }

    public static int parseInt(@NotNull CharSequence value, int start, boolean isNegative, int radix) {
        int i;
        if (value == null) {
            MessageDecoder.$$$reportNull$$$0(4);
        }
        int end = value.length();
        int result = 0;
        for (i = start; i < end; ++i) {
            int digit;
            char c = value.charAt(i);
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (digit < 0 || digit >= radix) break;
            int newResult = result * radix - digit;
            if (newResult > result) {
                throw new NumberFormatException("Overflow parsing " + String.valueOf(value.subSequence(start, end)));
            }
            result = newResult;
        }
        if (result == 0 && (end == 0 || value.charAt(i - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + String.valueOf(value.subSequence(start, end)));
        }
        if (result == Integer.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + String.valueOf(value.subSequence(start, end)));
        }
        return isNegative ? result : -result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/io/MessageDecoder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readChars";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readUntil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhitespace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

