/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.CachedIconPresentation;
import com.intellij.ide.util.treeView.CachedPresentationData;
import com.intellij.ide.util.treeView.CachedTreePathElement;
import com.intellij.ide.util.treeView.CachedTreePresentationData;
import com.intellij.ide.util.treeView.CachedTreePresentationSupport;
import com.intellij.ide.util.treeView.PathElementIdProvider;
import com.intellij.ide.util.treeView.SerializablePathElement;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.CachingTreePath;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class TreeState
implements JDOMExternalizable {
    private static final Interner<String> INTERNER = Interner.createStringInterner();
    private static final Logger LOG = Logger.getInstance(TreeState.class);
    public static final Key<WeakReference<ActionCallback>> CALLBACK = Key.create((String)"Callback");
    private static final Key<Promise<Void>> EXPANDING = Key.create((String)"TreeExpanding");
    @NotNull
    private static final String EXPAND_TAG = "expand";
    @NotNull
    private static final String SELECT_TAG = "select";
    @NotNull
    private static final String PRESENTATION_TAG = "presentation";
    @NotNull
    private static final String PATH_TAG = "path";
    @XCollection(style=XCollection.Style.v2)
    private final List<PathElement[]> myExpandedPaths;
    @XCollection(style=XCollection.Style.v2)
    private final List<PathElement[]> mySelectedPaths;
    @Nullable
    private CachedTreePresentationData myPresentationData;
    private boolean myScrollToSelection;

    TreeState() {
        this((List<PathElement[]>)new SmartList(), (List<PathElement[]>)new SmartList(), null);
    }

    private TreeState(List<PathElement[]> expandedPaths, List<PathElement[]> selectedPaths, @Nullable CachedTreePresentationData presentationData) {
        this.myExpandedPaths = expandedPaths;
        this.mySelectedPaths = selectedPaths;
        this.myPresentationData = presentationData;
        this.myScrollToSelection = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("TreeState created: " + String.valueOf(this));
        }
    }

    public boolean isEmpty() {
        return this.myExpandedPaths.isEmpty() && this.mySelectedPaths.isEmpty();
    }

    public void readExternal(Element element) throws InvalidDataException {
        TreeState.readExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.readExternal(element, this.mySelectedPaths, SELECT_TAG);
        try {
            this.myPresentationData = TreeState.readExternalPresentation(element);
        }
        catch (CancellationException cancellationException) {
        }
        catch (Exception e) {
            LOG.warn("An error occurred while trying to read a cached tree presentation", (Throwable)e);
        }
    }

    private static void readExternal(@NotNull Element root, List<PathElement[]> list, @NotNull String name) {
        if (root == null) {
            TreeState.$$$reportNull$$$0(0);
        }
        if (name == null) {
            TreeState.$$$reportNull$$$0(1);
        }
        list.clear();
        for (Element element : root.getChildren(name)) {
            for (Element child : element.getChildren(PATH_TAG)) {
                PathElement[] path = (PathElement[])XmlSerializer.deserialize((Element)child, PathElement[].class);
                list.add(path);
            }
        }
    }

    @Nullable
    private static CachedTreePresentationData readExternalPresentation(Element element) {
        List presentationChildren = element.getChildren(PRESENTATION_TAG);
        if (presentationChildren.size() != 1) {
            return null;
        }
        SmartList presentations = new SmartList();
        TreeState.readExternalPresentation((Element)presentationChildren.get(0), (List<CachedTreePresentationData>)presentations);
        return presentations.size() == 1 ? (CachedTreePresentationData)presentations.get(0) : null;
    }

    private static void readExternalPresentation(Element element, List<CachedTreePresentationData> result2) {
        SerializableCachedPresentation deserialized = (SerializableCachedPresentation)XmlSerializer.deserialize((Element)element, SerializableCachedPresentation.class);
        if (!deserialized.isValid()) {
            return;
        }
        PathElement item = deserialized.getItem();
        CachedPresentationDataImpl presentationData = deserialized.getData();
        Map<String, String> attributes = deserialized.getAttributes();
        SmartList children = new SmartList();
        CachedTreePresentationData data = new CachedTreePresentationData(item, presentationData, attributes, (List<CachedTreePresentationData>)children);
        for (Element child : element.getChildren(PRESENTATION_TAG)) {
            TreeState.readExternalPresentation(child, (List<CachedTreePresentationData>)children);
        }
        if (!children.isEmpty()) {
            presentationData.setLeaf(false);
        }
        result2.add(data);
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree, @NotNull DefaultMutableTreeNode treeNode) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(2);
        }
        if (treeNode == null) {
            TreeState.$$$reportNull$$$0(3);
        }
        return TreeState.createOn(tree, new CachingTreePath(treeNode.getPath()));
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree, @NotNull TreePath rootPath) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(4);
        }
        if (rootPath == null) {
            TreeState.$$$reportNull$$$0(5);
        }
        return new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree, rootPath)), TreeState.createPaths(tree, TreeUtil.collectSelectedPaths(tree, rootPath)), null);
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(6);
        }
        return TreeState.createOn(tree, true, false);
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree, boolean persistExpand, boolean persistSelect) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(7);
        }
        return TreeState.createOn(tree, persistExpand, persistSelect, false);
    }

    @ApiStatus.Internal
    @NotNull
    public static TreeState createOn(@NotNull JTree tree, boolean persistExpand, boolean persistSelect, boolean persistPresentation) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(8);
        }
        List<TreePath> expanded = persistExpand ? TreeUtil.collectExpandedPaths(tree) : Collections.emptyList();
        List<TreePath> selected2 = persistSelect ? TreeUtil.collectSelectedPaths(tree) : Collections.emptyList();
        return TreeState.createOn(tree, expanded, selected2, persistPresentation);
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree, @NotNull List<TreePath> expandedPaths, @NotNull List<TreePath> selectedPaths) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(9);
        }
        if (expandedPaths == null) {
            TreeState.$$$reportNull$$$0(10);
        }
        if (selectedPaths == null) {
            TreeState.$$$reportNull$$$0(11);
        }
        return TreeState.createOn(tree, expandedPaths, selectedPaths, false);
    }

    @ApiStatus.Internal
    @NotNull
    public static TreeState createOn(@NotNull JTree tree, @NotNull List<TreePath> expandedPaths, @NotNull List<TreePath> selectedPaths, boolean persistPresentation) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(12);
        }
        if (expandedPaths == null) {
            TreeState.$$$reportNull$$$0(13);
        }
        if (selectedPaths == null) {
            TreeState.$$$reportNull$$$0(14);
        }
        ArrayList<PathElement[]> expandedPathElements = !expandedPaths.isEmpty() ? TreeState.createPaths(tree, expandedPaths) : new ArrayList();
        ArrayList<PathElement[]> selectedPathElements = !selectedPaths.isEmpty() ? TreeState.createPaths(tree, selectedPaths) : new ArrayList();
        return new TreeState(expandedPathElements, selectedPathElements, persistPresentation ? CachedTreePresentationData.createFromTree(tree) : null);
    }

    @NotNull
    public static TreeState createFrom(@Nullable Element element) {
        TreeState state = new TreeState();
        try {
            if (element != null) {
                state.readExternal(element);
            }
        }
        catch (InvalidDataException e) {
            LOG.warn((Throwable)e);
        }
        TreeState treeState = state;
        if (treeState == null) {
            TreeState.$$$reportNull$$$0(15);
        }
        return treeState;
    }

    public void writeExternal(Element element) {
        TreeState.writeExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.writeExternal(element, this.mySelectedPaths, SELECT_TAG);
        TreeState.writeExternal(element, this.myPresentationData);
    }

    private static void writeExternal(Element element, @Nullable CachedTreePresentationData data) {
        if (data == null) {
            return;
        }
        Element root = XmlSerializer.serialize((Object)new SerializableCachedPresentation(data));
        for (CachedTreePresentationData child : data.getChildren()) {
            TreeState.writeExternal(root, child);
        }
        element.addContent(root);
    }

    private static void writeExternal(Element element, List<PathElement[]> list, String name) {
        Element root = new Element(name);
        for (PathElement[] path : list) {
            Element e = XmlSerializer.serialize((Object)path);
            e.setName(PATH_TAG);
            root.addContent(e);
        }
        element.addContent(root);
    }

    private static List<PathElement[]> createPaths(@NotNull JTree tree, @NotNull @Unmodifiable List<? extends TreePath> paths) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(16);
        }
        if (paths == null) {
            TreeState.$$$reportNull$$$0(17);
        }
        ArrayList<PathElement[]> list = new ArrayList<PathElement[]>();
        for (TreePath treePath : paths) {
            if (treePath.getPathCount() <= 1 && !tree.isRootVisible()) continue;
            list.add(TreeState.createPath(tree.getModel(), treePath));
        }
        return list;
    }

    private static PathElement[] createPath(@NotNull TreeModel model, @NotNull TreePath treePath) {
        if (model == null) {
            TreeState.$$$reportNull$$$0(18);
        }
        if (treePath == null) {
            TreeState.$$$reportNull$$$0(19);
        }
        Object prev = null;
        int count = treePath.getPathCount();
        ArrayList<PathElement> result2 = new ArrayList<PathElement>(count);
        for (int i = 0; i < count; ++i) {
            List flattened;
            Object cur = treePath.getPathComponent(i);
            Object userObject = TreeUtil.getUserObject(cur);
            int childIndex = prev == null ? 0 : model.getIndexOfChild(prev, cur);
            boolean isFlattened = false;
            String id = null;
            String type = null;
            PathElementIdProvider provider = TreeState.getProvider(cur);
            if (provider != null && (flattened = provider.getFlattenedElements()) != null && !flattened.isEmpty()) {
                if (flattened.size() == 1) {
                    id = ((SerializablePathElement)flattened.get(0)).id();
                    type = ((SerializablePathElement)flattened.get(0)).type();
                } else {
                    isFlattened = true;
                    for (SerializablePathElement element : flattened) {
                        result2.add(new PathElement(element.id(), element.type(), childIndex, null));
                        childIndex = 0;
                    }
                }
            }
            if (!isFlattened) {
                if (id == null) {
                    id = TreeState.calcId(cur);
                }
                if (type == null) {
                    type = TreeState.calcType(cur);
                }
                result2.add(new PathElement(id, type, childIndex, userObject));
            }
            prev = cur;
        }
        return (PathElement[])result2.toArray(PathElement[]::new);
    }

    @Nullable
    private static PathElementIdProvider getProvider(@Nullable Object node) {
        if (node == null) {
            return null;
        }
        if (node instanceof PathElementIdProvider) {
            PathElementIdProvider provider = (PathElementIdProvider)node;
            return provider;
        }
        Object userObject = TreeUtil.getUserObject(node);
        if (userObject instanceof PathElementIdProvider) {
            PathElementIdProvider provider = (PathElementIdProvider)userObject;
            return provider;
        }
        return null;
    }

    @NotNull
    static String calcId(@Nullable Object node) {
        if (node == null) {
            return "";
        }
        PathElementIdProvider provider = TreeState.getProvider(node);
        if (provider != null) {
            String string = provider.getPathElementId();
            if (string == null) {
                TreeState.$$$reportNull$$$0(20);
            }
            return string;
        }
        return TreeState.defaultPathElementId(node);
    }

    @NotNull
    public static String defaultPathElementId(@NotNull Object node) {
        Object userObject;
        if (node == null) {
            TreeState.$$$reportNull$$$0(21);
        }
        if ((userObject = TreeUtil.getUserObject(node)) == null) {
            return "";
        }
        String string = StringUtil.notNullize((String)userObject.toString());
        if (string == null) {
            TreeState.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    static String calcType(@Nullable Object node) {
        String providedType;
        if (node == null) {
            return "";
        }
        PathElementIdProvider provider = TreeState.getProvider(node);
        if (provider != null && (providedType = provider.getPathElementType()) != null) {
            String string = providedType;
            if (string == null) {
                TreeState.$$$reportNull$$$0(23);
            }
            return string;
        }
        return TreeState.defaultPathElementType(node);
    }

    @NotNull
    public static String defaultPathElementType(@NotNull Object node) {
        Object userObject;
        if (node == null) {
            TreeState.$$$reportNull$$$0(24);
        }
        if ((userObject = TreeUtil.getUserObject(node)) == null) {
            return "";
        }
        String name = userObject.getClass().getName();
        String string = Integer.toHexString(StringHash.murmur((CharSequence)name, (int)31)) + ":" + StringUtil.getShortName((String)name);
        if (string == null) {
            TreeState.$$$reportNull$$$0(25);
        }
        return string;
    }

    public void applyTo(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(26);
        }
        this.applyTo(tree, tree.getModel().getRoot());
    }

    public void applyTo(final @NotNull JTree tree, final @Nullable Object root) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(27);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("TreeState.applyTo: " + String.valueOf(tree) + "\n" + String.valueOf(this));
        }
        if (tree instanceof Tree) {
            @NotNull Tree jbTree = (Tree)tree;
            jbTree.fireTreeStateRestoreStarted();
        }
        this.applyCachedPresentation(tree);
        if (this.visit(tree)) {
            return;
        }
        if (root == null) {
            return;
        }
        final PathMatcherCache cache = new PathMatcherCache();
        final TreeFacade facade = TreeFacade.getFacade(tree);
        ActionCallback callback = facade.getInitialized().doWhenDone((Runnable)new TreeRunnable("TreeState.applyTo: on done facade init"){

            @Override
            public void perform() {
                facade.batch(indicator -> TreeState.this.applyExpandedTo(facade, new CachingTreePath(root), indicator, cache));
            }
        });
        if (tree.getSelectionCount() == 0) {
            callback.doWhenDone((Runnable)new TreeRunnable("TreeState.applyTo: on done"){

                @Override
                public void perform() {
                    if (tree.getSelectionCount() == 0) {
                        TreeState.this.applySelectedTo(tree, cache);
                    }
                }
            });
        }
    }

    private void applyCachedPresentation(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(28);
        }
        if (this.myPresentationData != null && tree instanceof CachedTreePresentationSupport) {
            CachedTreePresentationSupport cps = (CachedTreePresentationSupport)((Object)tree);
            cps.setCachedPresentation(this.myPresentationData.createTree());
            if (tree instanceof Tree) {
                @NotNull Tree jbTree = (Tree)tree;
                jbTree.fireTreeStateCachedStateRestored();
            }
        }
    }

    private static void clearCachedPresentation(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(29);
        }
        if (tree instanceof CachedTreePresentationSupport) {
            CachedTreePresentationSupport jbTree = (CachedTreePresentationSupport)((Object)tree);
            jbTree.setCachedPresentation(null);
        }
    }

    private void applyExpandedTo(@NotNull TreeFacade tree, @NotNull TreePath rootPath, @NotNull ProgressIndicator indicator, PathMatcherCache cache) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(30);
        }
        if (rootPath == null) {
            TreeState.$$$reportNull$$$0(31);
        }
        if (indicator == null) {
            TreeState.$$$reportNull$$$0(32);
        }
        indicator.checkCanceled();
        for (PathElement[] path : this.myExpandedPaths) {
            PathMatcher matcher;
            if (path.length == 0 || (matcher = PathMatcher.tryStart(path, rootPath, cache)) == null) continue;
            TreeState.expandImpl(matcher, tree, indicator);
        }
        tree.finishExpanding();
    }

    private void applySelectedTo(@NotNull JTree tree, PathMatcherCache cache) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(33);
        }
        TreeModel model = tree.getModel();
        ArrayList selection = new ArrayList();
        for (PathElement[] path : this.mySelectedPaths) {
            ContainerUtil.addIfNotNull(selection, (Object)TreeState.findPathToSelect(model, path, cache));
        }
        if (selection.isEmpty()) {
            return;
        }
        tree.setSelectionPaths(selection.toArray(TreeUtil.EMPTY_TREE_PATH));
        if (this.myScrollToSelection) {
            TreeUtil.showRowCentered(tree, tree.getRowForPath((TreePath)selection.get(0)), true, true);
        }
    }

    @Nullable
    private static TreePath findPathToSelect(@NotNull TreeModel model, PathElement @NotNull [] path, @NotNull PathMatcherCache cache) {
        Object root;
        if (model == null) {
            TreeState.$$$reportNull$$$0(34);
        }
        if (cache == null) {
            TreeState.$$$reportNull$$$0(35);
        }
        if (path == null) {
            TreeState.$$$reportNull$$$0(36);
        }
        if ((root = model.getRoot()) == null) {
            return null;
        }
        PathMatcher matcher = PathMatcher.tryStart(path, new CachingTreePath(root), cache);
        if (matcher == null) {
            return null;
        }
        return TreeState.findPathToSelect(matcher, model, cache);
    }

    @Nullable
    private static TreePath findPathToSelect(@NotNull PathMatcher matcher, @NotNull TreeModel model, @NotNull PathMatcherCache cache) {
        int i;
        if (matcher == null) {
            TreeState.$$$reportNull$$$0(37);
        }
        if (model == null) {
            TreeState.$$$reportNull$$$0(38);
        }
        if (cache == null) {
            TreeState.$$$reportNull$$$0(39);
        }
        TreePath currentlyMatchedPath = matcher.matchedPath();
        assert (currentlyMatchedPath != null);
        if (matcher.fullyMatched()) {
            return currentlyMatchedPath;
        }
        Object parent = currentlyMatchedPath.getLastPathComponent();
        PathMatcherCache.Node cacheNode = cache.getNode(parent);
        @NotNull PathMatcher.State initialState = matcher.stateSnapshot();
        PathMatcher.State serializedMatch = null;
        if (cacheNode != null) {
            Match cachedMatch = matcher.tryAdvanceUsingCache(cacheNode);
            if (cachedMatch == Match.OBJECT) {
                return TreeState.findPathToSelect(matcher, model, cache);
            }
            if (cachedMatch == Match.ID_TYPE) {
                serializedMatch = matcher.stateSnapshot();
                matcher.restoreState(initialState);
            }
        }
        int childCount = model.getChildCount(parent);
        int n = i = cacheNode == null ? 0 : cacheNode.getMaxCachedIndex() + 1;
        while (i < childCount) {
            Object childNode = model.getChild(parent, i);
            Match match = matcher.tryAdvanceWithParent(parent, childNode, i);
            if (match == Match.OBJECT) {
                return TreeState.findPathToSelect(matcher, model, cache);
            }
            if (match == Match.ID_TYPE) {
                if (serializedMatch == null) {
                    serializedMatch = matcher.stateSnapshot();
                }
                matcher.restoreState(initialState);
            }
            ++i;
        }
        if (serializedMatch != null) {
            matcher.restoreState(serializedMatch);
            return TreeState.findPathToSelect(matcher, model, cache);
        }
        if (matcher.tryAdvanceUsingIndex(model, parent)) {
            return TreeState.findPathToSelect(matcher, model, cache);
        }
        return matcher.matchedPath();
    }

    private static void expandImpl(final @NotNull PathMatcher matcher, final TreeFacade tree, final ProgressIndicator indicator) {
        if (matcher == null) {
            TreeState.$$$reportNull$$$0(40);
        }
        final TreePath parentPath = matcher.matchedPath();
        assert (parentPath != null);
        tree.expand(parentPath).doWhenDone((Runnable)new TreeRunnable("TreeState.applyTo"){

            @Override
            public void perform() {
                int j;
                indicator.checkCanceled();
                if (matcher.fullyMatched()) {
                    return;
                }
                Object parent = parentPath.getLastPathComponent();
                TreeModel model = tree.tree.getModel();
                PathMatcherCache.Node cachedMatches = matcher.getCachedMatches(parent);
                if (cachedMatches != null && matcher.tryAdvanceUsingCache(cachedMatches) != null) {
                    TreeState.expandImpl(matcher, tree, indicator);
                    return;
                }
                int childCount = model.getChildCount(parent);
                int n = j = cachedMatches == null ? 0 : cachedMatches.getMaxCachedIndex() + 1;
                while (j < childCount) {
                    Object child = tree.tree.getModel().getChild(parent, j);
                    if (matcher.tryAdvanceWithParent(parent, child, j) != null) {
                        TreeState.expandImpl(matcher, tree, indicator);
                        break;
                    }
                    ++j;
                }
            }
        });
    }

    public void setScrollToSelection(boolean scrollToSelection) {
        this.myScrollToSelection = scrollToSelection;
    }

    public String toString() {
        String content;
        Element st = new Element("TreeState");
        try {
            this.writeExternal(st);
            content = JDOMUtil.writeChildren((Element)st, (String)"\n");
        }
        catch (IOException e) {
            content = ExceptionUtil.getThrowableText((Throwable)e);
        }
        return "TreeState(" + this.myScrollToSelection + ")\n" + content;
    }

    @Deprecated
    public static void expand(@NotNull JTree tree, @NotNull Consumer<? super AsyncPromise<Void>> consumer) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(41);
        }
        if (consumer == null) {
            TreeState.$$$reportNull$$$0(42);
        }
        Promise expanding = (Promise)ComponentUtil.getClientProperty((JComponent)tree, EXPANDING);
        LOG.debug("EXPANDING: ", new Object[]{expanding});
        if (expanding == null) {
            expanding = Promises.resolvedPromise();
        }
        expanding.onProcessed(value2 -> {
            AsyncPromise promise = new AsyncPromise();
            ComponentUtil.putClientProperty((JComponent)tree, EXPANDING, (Object)promise);
            consumer.accept((AsyncPromise<Void>)promise);
        });
    }

    private static boolean isSelectionNeeded(List<TreePath> list, @NotNull JTree tree, AsyncPromise<Void> promise) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(43);
        }
        if (list != null && tree.isSelectionEmpty()) {
            return true;
        }
        if (promise != null) {
            promise.setResult(null);
        }
        return false;
    }

    private Promise<List<TreePath>> expand(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(44);
        }
        if (this.myPresentationData == null) {
            LOG.debug("Restoring the expanded paths");
            return TreeUtil.promiseExpand(tree, this.myExpandedPaths.stream().map(elements -> new SinglePathVisitor((PathElement[])elements)));
        }
        LOG.debug("Loading the expanded paths to replace the cached presentation");
        AsyncPromise promise = new AsyncPromise();
        MultiplePathsVisitor visitor = new MultiplePathsVisitor(this.myExpandedPaths);
        TreeUtil.promiseVisit(tree, visitor).onProcessed(lastPathFound -> promise.setResult(visitor.pathsFound));
        return promise;
    }

    private Promise<List<TreePath>> select(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(45);
        }
        return TreeUtil.promiseSelect(tree, this.mySelectedPaths.stream().map(elements -> new SinglePathVisitor((PathElement[])elements)));
    }

    private boolean visit(@NotNull JTree tree) {
        TreeModel model;
        if (tree == null) {
            TreeState.$$$reportNull$$$0(46);
        }
        if (!((model = tree.getModel()) instanceof TreeVisitor.Acceptor)) {
            return false;
        }
        long started = System.currentTimeMillis();
        TreeState.expand(tree, promise -> this.expand(tree).onProcessed(expanded -> {
            if (LOG.isDebugEnabled() && expanded != null) {
                LOG.debug("Expanded " + expanded.size() + " paths in " + (System.currentTimeMillis() - started) + " ms");
            }
            if (tree instanceof Tree) {
                @NotNull Tree jbTree = (Tree)tree;
                jbTree.fireTreeStateRestoreFinished();
            }
            TreeState.clearCachedPresentation(tree);
            if (TreeState.isSelectionNeeded(expanded, tree, (AsyncPromise<Void>)promise)) {
                this.select(tree).onProcessed(selected2 -> promise.setResult(null));
            }
        }));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 20, 22, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNode";
                break;
            }
            case 5: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedPaths";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPaths";
                break;
            }
            case 15: 
            case 20: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/TreeState";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 18: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePath";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATH_TAG;
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/TreeState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrom";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calcId";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultPathElementId";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "calcType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultPathElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createOn";
                break;
            }
            case 15: 
            case 20: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPaths";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "defaultPathElementId";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "defaultPathElementType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applyCachedPresentation";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "clearCachedPresentation";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "applyExpandedTo";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "applySelectedTo";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findPathToSelect";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "expandImpl";
                break;
            }
            case 41: 
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = EXPAND_TAG;
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionNeeded";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = SELECT_TAG;
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 20, 22, 23, 25 -> new IllegalStateException(string);
        };
    }

    @Tag(value="item")
    static final class PathElement
    implements CachedTreePathElement {
        String id;
        String type;
        transient Object userObject;
        final transient int index;

        PathElement() {
            this(null, null, -1, null);
        }

        PathElement(String itemId, String itemType, int itemIndex, Object userObject) {
            Object object;
            this.setId(itemId);
            this.setType(itemType);
            this.index = itemIndex;
            if (userObject instanceof String) {
                String stringObject = (String)userObject;
                object = INTERNER.intern((Object)stringObject);
            } else {
                object = userObject;
            }
            this.userObject = object;
        }

        public String toString() {
            return this.id + ": " + this.type;
        }

        @Override
        public boolean matches(@NotNull Object node) {
            if (node == null) {
                PathElement.$$$reportNull$$$0(0);
            }
            return this.isMatchTo(node);
        }

        private boolean isMatchTo(Object object) {
            return this.getMatchTo(object) != null;
        }

        private Match getMatchTo(Object object) {
            Object userObject = TreeUtil.getUserObject(object);
            if (this.userObject != null && this.userObject.equals(userObject)) {
                return Match.OBJECT;
            }
            return Objects.equals(this.id, TreeState.calcId(object)) && Objects.equals(this.type, TreeState.calcType(object)) ? Match.ID_TYPE : null;
        }

        @Attribute(value="name")
        public void setId(String id) {
            this.id = id == null ? null : (String)INTERNER.intern((Object)id);
        }

        @Override
        @Attribute(value="name")
        public String getId() {
            return this.id;
        }

        @Attribute(value="type")
        public void setType(String type) {
            this.type = type == null ? null : (String)INTERNER.intern((Object)type);
        }

        @Override
        @Attribute(value="type")
        public String getType() {
            return this.type;
        }

        @Nullable
        SerializablePathElement getSerializablePart() {
            return this.id == null || this.type == null ? null : new SerializablePathElement(this.id, this.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/util/treeView/TreeState$PathElement", "matches"));
        }
    }

    @Tag(value="presentation")
    static final class SerializableCachedPresentation {
        PathElement item;
        CachedPresentationDataImpl data;
        Map<String, String> attributes;

        SerializableCachedPresentation() {
            this.item = new PathElement();
            this.data = new CachedPresentationDataImpl();
        }

        SerializableCachedPresentation(@NotNull CachedTreePresentationData data) {
            if (data == null) {
                SerializableCachedPresentation.$$$reportNull$$$0(0);
            }
            this.item = (PathElement)data.getPathElement();
            this.data = (CachedPresentationDataImpl)data.getPresentation();
            this.attributes = data.getExtraAttributes();
        }

        boolean isValid() {
            return this.item != null && this.data != null && this.data.isValid();
        }

        @Property(surroundWithTag=false)
        @NotNull
        public PathElement getItem() {
            PathElement pathElement = this.item;
            if (pathElement == null) {
                SerializableCachedPresentation.$$$reportNull$$$0(1);
            }
            return pathElement;
        }

        @Property(surroundWithTag=false)
        public void setItem(@NotNull PathElement item) {
            if (item == null) {
                SerializableCachedPresentation.$$$reportNull$$$0(2);
            }
            this.item = item;
        }

        @Property(surroundWithTag=false)
        @NotNull
        public CachedPresentationDataImpl getData() {
            CachedPresentationDataImpl cachedPresentationDataImpl = this.data;
            if (cachedPresentationDataImpl == null) {
                SerializableCachedPresentation.$$$reportNull$$$0(3);
            }
            return cachedPresentationDataImpl;
        }

        @Property(surroundWithTag=false)
        public void setData(@NotNull CachedPresentationDataImpl data) {
            if (data == null) {
                SerializableCachedPresentation.$$$reportNull$$$0(4);
            }
            this.data = data;
        }

        @XCollection(style=XCollection.Style.v2)
        @Nullable
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @XCollection(style=XCollection.Style.v2)
        public void setAttributes(@Nullable Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public String toString() {
            return "SerializableCachedPresentation{item=" + String.valueOf(this.item) + ", data=" + String.valueOf(this.data) + ", attributes=" + String.valueOf(this.attributes) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$SerializableCachedPresentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$SerializableCachedPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setItem";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    @Tag(value="data")
    static final class CachedPresentationDataImpl
    implements CachedPresentationData {
        String text;
        String iconPath;
        String iconPlugin;
        String iconModule;
        boolean isLeaf;

        CachedPresentationDataImpl() {
            this.isLeaf = true;
        }

        CachedPresentationDataImpl(@NotNull String text, @Nullable CachedIconPresentation iconPresentation, boolean isLeaf) {
            if (text == null) {
                CachedPresentationDataImpl.$$$reportNull$$$0(0);
            }
            this.isLeaf = true;
            this.text = text;
            if (iconPresentation != null) {
                this.iconPath = iconPresentation.getPath();
                this.iconPlugin = iconPresentation.getPlugin();
                this.iconModule = iconPresentation.getModule();
            }
            this.isLeaf = isLeaf;
        }

        boolean isValid() {
            return this.text != null;
        }

        @Override
        @Attribute(value="text")
        @NotNull
        public String getText() {
            String string = this.text;
            if (string == null) {
                CachedPresentationDataImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Attribute(value="text")
        public void setText(String text) {
            this.text = text;
        }

        @Attribute(value="iconPath")
        @Nullable
        public String getIconPath() {
            return this.iconPath;
        }

        @Attribute(value="iconPath")
        public void setIconPath(String iconPath) {
            this.iconPath = iconPath;
        }

        @Attribute(value="iconPlugin")
        @Nullable
        public String getIconPlugin() {
            return this.iconPlugin;
        }

        @Attribute(value="iconPlugin")
        public void setIconPlugin(String iconPlugin) {
            this.iconPlugin = iconPlugin;
        }

        @Attribute(value="iconModule")
        @Nullable
        public String getIconModule() {
            return this.iconModule;
        }

        @Attribute(value="iconModule")
        public void setIconModule(String iconModule) {
            this.iconModule = iconModule;
        }

        @Override
        @Nullable
        public CachedIconPresentation getIconData() {
            if (this.iconPath == null || this.iconPlugin == null) {
                return null;
            }
            return new CachedIconPresentation(this.iconPath, this.iconPlugin, this.iconModule);
        }

        @Override
        @Attribute(value="isLeaf")
        public boolean isLeaf() {
            return this.isLeaf;
        }

        @Attribute(value="isLeaf")
        public void setLeaf(boolean leaf) {
            this.isLeaf = leaf;
        }

        public String toString() {
            return "'" + this.text + "' icon=" + this.iconPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$CachedPresentationDataImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$CachedPresentationDataImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PathMatcherCache {
        private final Map<Object, Node> cachedNodes = new HashMap<Object, Node>();

        private PathMatcherCache() {
        }

        @Nullable
        Node getNode(@NotNull Object parent) {
            if (parent == null) {
                PathMatcherCache.$$$reportNull$$$0(0);
            }
            return this.cachedNodes.get(parent);
        }

        @NotNull
        Node getOrCreateNode(@NotNull Object parent) {
            Node result2;
            if (parent == null) {
                PathMatcherCache.$$$reportNull$$$0(1);
            }
            if ((result2 = this.getNode(parent)) != null) {
                Node node = result2;
                if (node == null) {
                    PathMatcherCache.$$$reportNull$$$0(2);
                }
                return node;
            }
            result2 = new Node();
            this.cachedNodes.put(parent, result2);
            Node node = result2;
            if (node == null) {
                PathMatcherCache.$$$reportNull$$$0(3);
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$PathMatcherCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$PathMatcherCache";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateNode";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }

        private static final class Node {
            private final Map<@NotNull SerializablePathElement, @NotNull SerializedMatch> serializedMatches = new HashMap<SerializablePathElement, SerializedMatch>();
            private final Map<@NotNull Object, @NotNull UserObjectMatch> userObjectMatches = new HashMap<Object, UserObjectMatch>();
            private int maxCachedIndex;

            private Node() {
            }

            void cacheSerializedMatch(@NotNull Object node, int nodeIndex, @NotNull @NotNull List<@NotNull SerializablePathElement> matchedElements) {
                if (node == null) {
                    Node.$$$reportNull$$$0(0);
                }
                if (matchedElements == null) {
                    Node.$$$reportNull$$$0(1);
                }
                this.maxCachedIndex = Math.max(this.maxCachedIndex, nodeIndex);
                this.serializedMatches.put(matchedElements.get(0), new SerializedMatch(node, matchedElements));
            }

            void cacheUserObjectMatch(@NotNull Object node, int nodeIndex) {
                if (node == null) {
                    Node.$$$reportNull$$$0(2);
                }
                this.maxCachedIndex = Math.max(this.maxCachedIndex, nodeIndex);
                this.userObjectMatches.put(new SerializablePathElement(TreeState.calcId(node), TreeState.calcType(node)), new UserObjectMatch(node));
            }

            int getMaxCachedIndex() {
                return this.maxCachedIndex;
            }

            @Nullable
            SerializedMatch getSerializedMatch(@NotNull PathElement element) {
                SerializablePathElement serializablePart;
                if (element == null) {
                    Node.$$$reportNull$$$0(3);
                }
                return (serializablePart = element.getSerializablePart()) == null ? null : this.serializedMatches.get(serializablePart);
            }

            @Nullable
            UserObjectMatch getUserObjectMatch(@NotNull PathElement element) {
                Object userObject;
                if (element == null) {
                    Node.$$$reportNull$$$0(4);
                }
                return (userObject = element.userObject) == null ? null : this.userObjectMatches.get(userObject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "matchedElements";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$PathMatcherCache$Node";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "cacheSerializedMatch";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "cacheUserObjectMatch";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSerializedMatch";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getUserObjectMatch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private record UserObjectMatch(@NotNull Object node) implements CachedMatch
        {
            @NotNull
            private final Object node;

            private UserObjectMatch(@NotNull Object node) {
                if (node == null) {
                    UserObjectMatch.$$$reportNull$$$0(0);
                }
            }

            @Override
            @NotNull
            public Object getNode() {
                Object object = this.node;
                if (object == null) {
                    UserObjectMatch.$$$reportNull$$$0(1);
                }
                return object;
            }

            @Override
            public int getLength() {
                return 1;
            }

            @Override
            @NotNull
            public Match getType() {
                Match match = Match.OBJECT;
                if (match == null) {
                    UserObjectMatch.$$$reportNull$$$0(2);
                }
                return match;
            }

            @NotNull
            public Object node() {
                Object object = this.node;
                if (object == null) {
                    UserObjectMatch.$$$reportNull$$$0(3);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$PathMatcherCache$UserObjectMatch";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$PathMatcherCache$UserObjectMatch";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "node";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        }

        private record SerializedMatch(@NotNull Object node, @NotNull @NotNull List<@NotNull SerializablePathElement> matchedElements) implements CachedMatch
        {
            @NotNull
            private final Object node;
            @NotNull
            private final @NotNull List<@NotNull SerializablePathElement> matchedElements;

            private SerializedMatch(@NotNull Object node, @NotNull @NotNull List<@NotNull SerializablePathElement> matchedElements) {
                if (node == null) {
                    SerializedMatch.$$$reportNull$$$0(0);
                }
                if (matchedElements == null) {
                    SerializedMatch.$$$reportNull$$$0(1);
                }
            }

            @Override
            @NotNull
            public Object getNode() {
                Object object = this.node;
                if (object == null) {
                    SerializedMatch.$$$reportNull$$$0(2);
                }
                return object;
            }

            @Override
            public int getLength() {
                return this.matchedElements.size();
            }

            @Override
            @NotNull
            public Match getType() {
                Match match = Match.ID_TYPE;
                if (match == null) {
                    SerializedMatch.$$$reportNull$$$0(3);
                }
                return match;
            }

            @NotNull
            public Object node() {
                Object object = this.node;
                if (object == null) {
                    SerializedMatch.$$$reportNull$$$0(4);
                }
                return object;
            }

            @NotNull
            public @NotNull List<@NotNull SerializablePathElement> matchedElements() {
                List<SerializablePathElement> list = this.matchedElements;
                if (list == null) {
                    SerializedMatch.$$$reportNull$$$0(5);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "matchedElements";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$PathMatcherCache$SerializedMatch";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$PathMatcherCache$SerializedMatch";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "node";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "matchedElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        }

        private static interface CachedMatch {
            @NotNull
            public Object getNode();

            public int getLength();

            @NotNull
            public Match getType();
        }
    }

    static abstract class TreeFacade {
        final JTree tree;

        TreeFacade(@NotNull JTree tree) {
            if (tree == null) {
                TreeFacade.$$$reportNull$$$0(0);
            }
            this.tree = tree;
        }

        abstract ActionCallback getInitialized();

        abstract ActionCallback expand(TreePath var1);

        abstract void finishExpanding();

        abstract void batch(Progressive var1);

        static TreeFacade getFacade(JTree tree) {
            return new JTreeFacade(tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState$TreeFacade", "<init>"));
        }
    }

    private static final class PathMatcher {
        @NotNull
        private final @NotNull PathElement @NotNull [] serializedPath;
        @Nullable
        private final PathMatcherCache cache;
        private int matchedSoFar;
        @Nullable
        private TreePath matchedPath;

        @Nullable
        static PathMatcher tryStart(@NotNull @NotNull PathElement @NotNull [] serializedPath, @NotNull TreePath rootPath, @Nullable PathMatcherCache cache) {
            if (rootPath == null) {
                PathMatcher.$$$reportNull$$$0(0);
            }
            if (serializedPath == null) {
                PathMatcher.$$$reportNull$$$0(1);
            }
            if (serializedPath.length == 0) {
                return null;
            }
            if (!serializedPath[0].matches(rootPath.getLastPathComponent())) {
                return null;
            }
            PathMatcher attempt = new PathMatcher(serializedPath, rootPath.getParentPath(), cache);
            return attempt.tryAdvance(rootPath.getLastPathComponent()) ? attempt : null;
        }

        private PathMatcher(@NotNull @NotNull PathElement @NotNull [] serializedPath, @Nullable TreePath parentPath, @Nullable PathMatcherCache cache) {
            if (serializedPath == null) {
                PathMatcher.$$$reportNull$$$0(2);
            }
            this.matchedSoFar = 0;
            this.serializedPath = serializedPath;
            this.matchedPath = parentPath;
            this.cache = cache;
        }

        @NotNull
        State stateSnapshot() {
            return new State(this.matchedSoFar, this.matchedPath);
        }

        void restoreState(@NotNull State state) {
            if (state == null) {
                PathMatcher.$$$reportNull$$$0(3);
            }
            this.matchedSoFar = state.matchedSoFar;
            this.matchedPath = state.matchedPath;
        }

        @Nullable
        PathMatcherCache.Node getCachedMatches(@NotNull Object parent) {
            if (parent == null) {
                PathMatcher.$$$reportNull$$$0(4);
            }
            if (this.cache == null) {
                return null;
            }
            return this.cache.getNode(parent);
        }

        @Nullable
        PathMatcherCache.Node getOrCreateCachedMatches(@NotNull Object parent) {
            if (parent == null) {
                PathMatcher.$$$reportNull$$$0(5);
            }
            if (this.cache == null) {
                return null;
            }
            return this.cache.getOrCreateNode(parent);
        }

        @Nullable
        TreePath matchedPath() {
            return this.matchedPath;
        }

        boolean fullyMatched() {
            return this.matchedSoFar == this.serializedPath.length;
        }

        boolean isParentOf(@NotNull TreePath path) {
            TreePath parent;
            if (path == null) {
                PathMatcher.$$$reportNull$$$0(6);
            }
            if ((parent = path.getParentPath()) == null) {
                return false;
            }
            return Objects.equals(this.matchedPath, parent);
        }

        boolean tryAdvance(@NotNull Object node) {
            if (node == null) {
                PathMatcher.$$$reportNull$$$0(7);
            }
            return this.tryAdvanceWithParent(null, node, -1) != null;
        }

        @Nullable
        Match tryAdvanceWithParent(@Nullable Object parent, @NotNull Object node, int index) {
            if (node == null) {
                PathMatcher.$$$reportNull$$$0(8);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Trying to advance a matcher using " + String.valueOf(node));
                LOG.trace("The node's parent is " + String.valueOf(parent));
                this.logCurrentMatchedPath();
            }
            assert (this.matchedSoFar <= this.serializedPath.length);
            if (this.matchedSoFar == this.serializedPath.length) {
                throw new IllegalStateException("Already matched all the path");
            }
            PathMatcherCache.Node cacheNode = index >= 0 && parent != null ? this.getOrCreateCachedMatches(parent) : null;
            boolean userObjectSucceeded = false;
            boolean flattenedSucceeded = false;
            boolean plainSucceeded = false;
            List<SerializablePathElement> serializableElements = null;
            Object userObject = TreeUtil.getUserObject(node);
            if (userObject != null && Objects.equals(userObject, this.serializedPath[this.matchedSoFar].userObject)) {
                userObjectSucceeded = true;
                ++this.matchedSoFar;
            }
            String id = null;
            String type = null;
            PathElementIdProvider provider = TreeState.getProvider(node);
            if (provider != null && !userObjectSucceeded) {
                List<SerializablePathElement> flattened = provider.getFlattenedElements();
                if (flattened != null && !flattened.isEmpty()) {
                    serializableElements = flattened;
                    if (flattened.size() == 1) {
                        id = flattened.get(0).id();
                        type = flattened.get(0).type();
                    }
                }
                if (flattened != null && flattened.size() > 1 && this.matchedSoFar + flattened.size() <= this.serializedPath.length) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Unflattened elements: " + String.valueOf(flattened));
                    }
                    boolean allMatch = true;
                    for (int i = 0; i < flattened.size(); ++i) {
                        SerializablePathElement actualElement = flattened.get(i);
                        PathElement serializedElement = this.serializedPath[this.matchedSoFar + i];
                        if (serializedElement.id.equals(actualElement.id()) && serializedElement.type.equals(actualElement.type())) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Mismatched element at " + i + ": " + String.valueOf(actualElement) + " != " + String.valueOf(serializedElement));
                        }
                        allMatch = false;
                        break;
                    }
                    if (allMatch) {
                        flattenedSucceeded = true;
                        this.matchedSoFar += flattened.size();
                    }
                }
            }
            if (id == null) {
                id = TreeState.calcId(node);
            }
            if (type == null) {
                type = TreeState.calcType(node);
            }
            if (serializableElements == null) {
                serializableElements = List.of(new SerializablePathElement(id, type));
            }
            if (cacheNode != null) {
                cacheNode.cacheSerializedMatch(node, index, serializableElements);
                if (userObject != null) {
                    cacheNode.cacheUserObjectMatch(node, index);
                }
            }
            if (!userObjectSucceeded && !flattenedSucceeded && id.equals(this.serializedPath[this.matchedSoFar].id) && type.equals(this.serializedPath[this.matchedSoFar].type)) {
                plainSucceeded = true;
                ++this.matchedSoFar;
            }
            if (userObjectSucceeded || flattenedSucceeded || plainSucceeded) {
                this.addNodeToMatchedPath(node);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Advanced successfully to " + this.matchedSoFar + " elements corresponding to " + String.valueOf(this.matchedPath));
                }
                return userObjectSucceeded ? Match.OBJECT : Match.ID_TYPE;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failed to advance");
            }
            return null;
        }

        boolean tryAdvanceUsingIndex(@NotNull TreeModel model, @NotNull Object parent) {
            if (model == null) {
                PathMatcher.$$$reportNull$$$0(9);
            }
            if (parent == null) {
                PathMatcher.$$$reportNull$$$0(10);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Trying to advance a matcher using the previously saved index");
                this.logCurrentMatchedPath();
            }
            assert (this.matchedSoFar <= this.serializedPath.length);
            if (this.matchedSoFar == this.serializedPath.length) {
                throw new IllegalStateException("Already matched all the path");
            }
            PathElement nextSerializedElement = this.serializedPath[this.matchedSoFar];
            int index = nextSerializedElement.index;
            int count = model.getChildCount(parent);
            if (index < 0 || count == 0) {
                return false;
            }
            index = Math.min(index, count - 1);
            Object child = model.getChild(parent, index);
            ++this.matchedSoFar;
            this.addNodeToMatchedPath(child);
            return true;
        }

        @Nullable
        Match tryAdvanceUsingCache(@NotNull PathMatcherCache.Node cacheNode) {
            if (cacheNode == null) {
                PathMatcher.$$$reportNull$$$0(11);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Trying to advance a matcher using the cache");
                this.logCurrentMatchedPath();
            }
            assert (this.matchedSoFar <= this.serializedPath.length);
            if (this.matchedSoFar == this.serializedPath.length) {
                throw new IllegalStateException("Already matched all the path");
            }
            @Nullable Record match = null;
            PathMatcherCache.UserObjectMatch cachedUserObjectMatch = cacheNode.getUserObjectMatch(this.serializedPath[this.matchedSoFar]);
            if (cachedUserObjectMatch != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Advancing using the user object match: " + String.valueOf(cachedUserObjectMatch));
                }
                match = cachedUserObjectMatch;
            }
            if (match == null) {
                LOG.trace("Failed to advance using the cached user object match");
                PathMatcherCache.SerializedMatch serializedMatch = cacheNode.getSerializedMatch(this.serializedPath[this.matchedSoFar]);
                if (serializedMatch != null) {
                    List<SerializablePathElement> cachedElements = serializedMatch.matchedElements();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Trying to use the cached serialized elements: " + String.valueOf(cachedElements));
                    }
                    if (this.matchedSoFar + cachedElements.size() <= this.serializedPath.length) {
                        for (int i = 0; i < cachedElements.size(); ++i) {
                            SerializablePathElement cachedElement = cachedElements.get(i);
                            PathElement serializedElement = this.serializedPath[this.matchedSoFar + i];
                            if (serializedElement.id.equals(cachedElement.id()) && serializedElement.type.equals(cachedElement.type())) continue;
                            if (!LOG.isTraceEnabled()) break;
                            LOG.trace("Mismatched cached element at " + i + ": " + String.valueOf(cachedElement) + " != " + String.valueOf(serializedElement));
                            break;
                        }
                        match = serializedMatch;
                    }
                }
            }
            if (match != null) {
                Object node = match.getNode();
                this.addNodeToMatchedPath(node);
                this.matchedSoFar += match.getLength();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Advanced successfully to " + this.matchedSoFar + " elements corresponding to " + String.valueOf(this.matchedPath) + " using " + String.valueOf(match));
                }
                return match.getType();
            }
            return null;
        }

        private void addNodeToMatchedPath(@NotNull Object node) {
            if (node == null) {
                PathMatcher.$$$reportNull$$$0(12);
            }
            this.matchedPath = this.matchedPath == null ? new CachingTreePath(node) : this.matchedPath.pathByAddingChild(node);
        }

        private void logCurrentMatchedPath() {
            LOG.trace("The serialized path: " + Arrays.toString(this.serializedPath));
            LOG.trace("Matched so far: " + this.matchedSoFar + " elements corresponding to " + String.valueOf(this.matchedPath));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serializedPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 4: 
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TreeState.PATH_TAG;
                    break;
                }
                case 7: 
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cacheNode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$PathMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryStart";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCachedMatches";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrCreateCachedMatches";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isParentOf";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryAdvance";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryAdvanceWithParent";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryAdvanceUsingIndex";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryAdvanceUsingCache";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addNodeToMatchedPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        record State(int matchedSoFar, @Nullable TreePath matchedPath) {
        }
    }

    private static enum Match {
        OBJECT,
        ID_TYPE;

    }

    private static final class MultiplePathsVisitor
    implements TreeVisitor {
        private final List<Set<PathMatchState>> matchStatesPerLevel = new ArrayList<Set<PathMatchState>>();
        private final List<TreePath> pathsFound = new ArrayList<TreePath>();

        MultiplePathsVisitor(List<PathElement[]> paths) {
            this.matchStatesPerLevel.add(new HashSet());
            for (PathElement[] path : paths) {
                this.matchStatesPerLevel.getFirst().add(new PathMatchState(path));
            }
            this.push(1, new HashSet<PathMatchState>((Collection)this.matchStatesPerLevel.getFirst()));
        }

        @NotNull
        public TreeVisitor.VisitThread visitThread() {
            TreeVisitor.VisitThread visitThread = TreeVisitor.VisitThread.BGT;
            if (visitThread == null) {
                MultiplePathsVisitor.$$$reportNull$$$0(0);
            }
            return visitThread;
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            if (path == null) {
                MultiplePathsVisitor.$$$reportNull$$$0(1);
            }
            int level = path.getPathCount();
            this.pop(level);
            Set<PathMatchState> matchStates = this.matchStatesPerLevel.get(level);
            HashSet<PathMatchState> matchStatesForNextLevel = null;
            Iterator<PathMatchState> iterator = matchStates.iterator();
            while (iterator.hasNext()) {
                PathMatchState state = iterator.next();
                boolean needToGoDeeper = false;
                switch (state.match(path).ordinal()) {
                    case 0: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found a path using a multi-path visitor: " + String.valueOf(path));
                        }
                        this.pathsFound.add(path);
                        needToGoDeeper = true;
                        break;
                    }
                    case 1: {
                        needToGoDeeper = true;
                        break;
                    }
                    case 2: {
                        iterator.remove();
                        this.removeFromUpperLevels(level, state);
                    }
                }
                if (!needToGoDeeper) continue;
                if (matchStatesForNextLevel == null) {
                    matchStatesForNextLevel = new HashSet<PathMatchState>();
                }
                matchStatesForNextLevel.add(state);
            }
            if (matchStates.isEmpty()) {
                TreeVisitor.Action action = TreeVisitor.Action.SKIP_SIBLINGS;
                if (action == null) {
                    MultiplePathsVisitor.$$$reportNull$$$0(2);
                }
                return action;
            }
            if (matchStatesForNextLevel != null) {
                this.push(level + 1, matchStatesForNextLevel);
                TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    MultiplePathsVisitor.$$$reportNull$$$0(3);
                }
                return action;
            }
            TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
            if (action == null) {
                MultiplePathsVisitor.$$$reportNull$$$0(4);
            }
            return action;
        }

        private void push(int level, @NotNull Set<PathMatchState> matchStates) {
            if (matchStates == null) {
                MultiplePathsVisitor.$$$reportNull$$$0(5);
            }
            assert (level == this.matchStatesPerLevel.size());
            this.matchStatesPerLevel.add(matchStates);
        }

        private void pop(int level) {
            while (level < this.matchStatesPerLevel.size() - 1) {
                this.matchStatesPerLevel.removeLast();
            }
        }

        private void removeFromUpperLevels(int level, PathMatchState state) {
            for (int i = 0; i < level; ++i) {
                this.matchStatesPerLevel.get(i).remove(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$MultiplePathsVisitor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TreeState.PATH_TAG;
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchStates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitThread";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$MultiplePathsVisitor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "push";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 5 -> new IllegalArgumentException(string);
            };
        }

        private static final class PathMatchState {
            @NotNull
            private final PathMatcher matcher;

            private PathMatchState(PathElement[] elements) {
                this.matcher = new PathMatcher(elements, null, null);
            }

            @NotNull
            PathMatch match(@NotNull TreePath path) {
                if (path == null) {
                    PathMatchState.$$$reportNull$$$0(0);
                }
                if (this.matcher.fullyMatched()) {
                    PathMatch pathMatch = this.matcher.isParentOf(path) ? PathMatch.CHILD : PathMatch.NONE;
                    if (pathMatch == null) {
                        PathMatchState.$$$reportNull$$$0(1);
                    }
                    return pathMatch;
                }
                if (Objects.equals(path.getParentPath(), this.matcher.matchedPath())) {
                    if (this.matcher.tryAdvance(path.getLastPathComponent())) {
                        PathMatch pathMatch = this.matcher.fullyMatched() ? PathMatch.FULL : PathMatch.ANCESTOR;
                        if (pathMatch == null) {
                            PathMatchState.$$$reportNull$$$0(2);
                        }
                        return pathMatch;
                    }
                    PathMatch pathMatch = PathMatch.NONE;
                    if (pathMatch == null) {
                        PathMatchState.$$$reportNull$$$0(3);
                    }
                    return pathMatch;
                }
                PathMatch pathMatch = PathMatch.NONE;
                if (pathMatch == null) {
                    PathMatchState.$$$reportNull$$$0(4);
                }
                return pathMatch;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = TreeState.PATH_TAG;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$MultiplePathsVisitor$PathMatchState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$MultiplePathsVisitor$PathMatchState";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "match";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "match";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 4 -> new IllegalStateException(string);
                };
            }
        }

        private static enum PathMatch {
            FULL,
            ANCESTOR,
            CHILD,
            NONE;

        }
    }

    private static final class SinglePathVisitor
    implements TreeVisitor {
        @NotNull
        private final PathMatcher matcher;

        SinglePathVisitor(PathElement[] elements) {
            this.matcher = new PathMatcher(elements, null, null);
        }

        @NotNull
        public TreeVisitor.VisitThread visitThread() {
            TreeVisitor.VisitThread visitThread = TreeVisitor.VisitThread.BGT;
            if (visitThread == null) {
                SinglePathVisitor.$$$reportNull$$$0(0);
            }
            return visitThread;
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            if (path == null) {
                SinglePathVisitor.$$$reportNull$$$0(1);
            }
            if (this.matcher.tryAdvance(path.getLastPathComponent())) {
                boolean found = this.matcher.fullyMatched();
                if (found && LOG.isDebugEnabled()) {
                    LOG.debug("Found a path using a single-path visitor: " + String.valueOf(path));
                }
                TreeVisitor.Action action = found ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    SinglePathVisitor.$$$reportNull$$$0(2);
                }
                return action;
            }
            TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
            if (action == null) {
                SinglePathVisitor.$$$reportNull$$$0(3);
            }
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$SinglePathVisitor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TreeState.PATH_TAG;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$SinglePathVisitor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    static class JTreeFacade
    extends TreeFacade {
        private final boolean useBulkExpand;
        @NotNull
        private final @NotNull List<@NotNull TreePath> pathsToExpand = new ArrayList<TreePath>();

        JTreeFacade(JTree tree) {
            super(tree);
            this.useBulkExpand = TreeUtil.isBulkExpandCollapseSupported(tree);
        }

        @Override
        public ActionCallback expand(@NotNull TreePath treePath) {
            if (treePath == null) {
                JTreeFacade.$$$reportNull$$$0(0);
            }
            if (this.useBulkExpand) {
                this.pathsToExpand.add(treePath);
            } else {
                this.tree.expandPath(treePath);
            }
            return ActionCallback.DONE;
        }

        @Override
        void finishExpanding() {
            TreeState.clearCachedPresentation(this.tree);
            if (this.useBulkExpand) {
                TreeUtil.expandPaths(this.tree, this.pathsToExpand);
            }
        }

        @Override
        public ActionCallback getInitialized() {
            WeakReference ref = (WeakReference)ComponentUtil.getClientProperty((JComponent)this.tree, CALLBACK);
            ActionCallback callback = (ActionCallback)SoftReference.dereference((Reference)ref);
            if (callback != null) {
                return callback;
            }
            return ActionCallback.DONE;
        }

        @Override
        public void batch(Progressive progressive) {
            progressive.run((ProgressIndicator)new EmptyProgressIndicator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treePath", "com/intellij/ide/util/treeView/TreeState$JTreeFacade", TreeState.EXPAND_TAG));
        }
    }
}

