/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IdeaLoggingEvent {
    private final String myMessage;
    private final Throwable myThrowable;
    private final List<Attachment> myAttachments;
    @Nullable
    private final IdeaPluginDescriptor myPlugin;
    @Nullable
    private final Object myData;

    public IdeaLoggingEvent(String message, Throwable throwable) {
        this(message, throwable, null);
    }

    public IdeaLoggingEvent(String message, Throwable throwable, @Nullable Object data) {
        this.myMessage = message;
        this.myThrowable = throwable;
        this.myAttachments = List.of();
        this.myPlugin = null;
        this.myData = data;
    }

    public IdeaLoggingEvent(@Nullable String message, @NotNull Throwable throwable, @NotNull List<Attachment> attachments, @Nullable IdeaPluginDescriptor plugin, @Nullable Object data) {
        if (throwable == null) {
            IdeaLoggingEvent.$$$reportNull$$$0(0);
        }
        if (attachments == null) {
            IdeaLoggingEvent.$$$reportNull$$$0(1);
        }
        this.myMessage = message;
        this.myThrowable = throwable;
        this.myAttachments = Collections.unmodifiableList(attachments);
        this.myPlugin = plugin;
        this.myData = data;
    }

    @Nullable
    public String getMessage() {
        return this.myMessage;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    @NotNull
    public String getThrowableText() {
        return this.myThrowable != null ? StringUtil.getThrowableText((Throwable)this.myThrowable) : "";
    }

    public @Unmodifiable @NotNull List<Attachment> getAttachments() {
        List<Attachment> list = this.myAttachments;
        if (list == null) {
            IdeaLoggingEvent.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public IdeaPluginDescriptor getPlugin() {
        return this.myPlugin;
    }

    @Nullable
    public Object getData() {
        return this.myData;
    }

    public String toString() {
        return "IdeaLoggingEvent[message=" + this.myMessage + ", throwable=" + this.getThrowableText() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/IdeaLoggingEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/IdeaLoggingEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

