/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabeledComponent<Comp extends JComponent>
extends JPanel
implements PanelWithAnchor {
    @NonNls
    private static final String[] LABEL_BORDER_CONSTRAINS = new String[]{"North", "East", "South", "West"};
    private final JBLabel myLabel = new JBLabel();
    private Comp myComponent;
    @NonNls
    private String myLabelConstraints = "North";
    private JComponent myAnchor;

    public LabeledComponent() {
        super(new BorderLayout(10, 2));
        this.insertLabel();
    }

    @NotNull
    public static <Comp extends JComponent> LabeledComponent<Comp> create(@NotNull Comp component, @NlsContexts.Label @NotNull String text) {
        if (component == null) {
            LabeledComponent.$$$reportNull$$$0(0);
        }
        if (text == null) {
            LabeledComponent.$$$reportNull$$$0(1);
        }
        return LabeledComponent.create(component, text, "North");
    }

    @NotNull
    public static <Comp extends JComponent> LabeledComponent<Comp> create(@NotNull Comp component, @NlsContexts.Label @NotNull String text, @NonNls String labelConstraint) {
        if (component == null) {
            LabeledComponent.$$$reportNull$$$0(2);
        }
        if (text == null) {
            LabeledComponent.$$$reportNull$$$0(3);
        }
        LabeledComponent<Comp> labeledComponent = new LabeledComponent<Comp>();
        labeledComponent.setComponent(component);
        labeledComponent.setText(text);
        labeledComponent.setLabelLocation(labelConstraint);
        LabeledComponent<Comp> labeledComponent2 = labeledComponent;
        if (labeledComponent2 == null) {
            LabeledComponent.$$$reportNull$$$0(4);
        }
        return labeledComponent2;
    }

    private void insertLabel() {
        this.remove(this.myLabel);
        this.add((Component)this.myLabel, this.myLabelConstraints);
        this.setAnchor(this.myLabel);
    }

    public void setText(@NlsContexts.Label String text) {
        text = LabeledComponent.handleSemicolon(text);
        TextWithMnemonic.fromTextWithMnemonic(text).setToLabel(this.myLabel);
    }

    @NlsContexts.Label
    private static String handleSemicolon(@NlsContexts.Label String text) {
        return StringUtil.isEmpty((String)text) || StringUtil.endsWithChar((CharSequence)text, (char)':') || StringUtil.endsWithChar((CharSequence)text, (char)'\uff1a') ? text : text + ":";
    }

    public String getText() {
        String text = TextWithMnemonic.fromLabel(this.myLabel).getTextWithMnemonic();
        return StringUtil.endsWithChar((CharSequence)text, (char)':') ? text.substring(0, text.length() - 1) : text;
    }

    public void setComponentClass(@NonNls String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (className != null) {
            Class<?> aClass = this.getClass().getClassLoader().loadClass(className);
            this.setComponent((JComponent)aClass.newInstance());
        } else {
            this.setComponent(null);
        }
    }

    public void setComponent(Comp component) {
        if (this.myComponent != null) {
            this.remove((Component)this.myComponent);
        }
        this.myComponent = component;
        if (this.myComponent != null) {
            this.add((Component)this.myComponent, "Center");
        }
        if (this.myComponent instanceof ComponentWithBrowseButton && !(this.myComponent instanceof TextFieldWithBrowseButton)) {
            this.myLabel.setLabelFor((Component)((ComponentWithBrowseButton)this.myComponent).getChildComponent());
        } else {
            this.myLabel.setLabelFor((Component)this.myComponent);
        }
    }

    @NonNls
    public String getComponentClass() {
        return this.myComponent == null ? null : this.getComponent().getClass().getName();
    }

    public Comp getComponent() {
        return this.myComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myComponent != null) {
            ((JComponent)this.myComponent).setEnabled(enabled);
        }
        this.myLabel.setEnabled(enabled);
    }

    public void setLabelLocation(@NonNls String borderConstrains) {
        if (ArrayUtil.indexOf((Object[])LABEL_BORDER_CONSTRAINS, (Object)borderConstrains) >= 0 && !borderConstrains.equals(this.myLabelConstraints)) {
            this.myLabelConstraints = borderConstrains;
            this.insertLabel();
        }
    }

    @NonNls
    public String getLabelLocation() {
        return this.myLabelConstraints;
    }

    public Insets getLabelInsets() {
        return this.myLabel.getInsets();
    }

    public void setLabelInsets(Insets insets) {
        if (!Objects.equals(insets, this.getLabelInsets())) {
            this.myLabel.setBorder(IdeBorderFactory.createEmptyBorder(insets));
        }
    }

    public String getRawText() {
        return this.myLabel.getText().replace("\u001b", "");
    }

    public JBLabel getLabel() {
        return this.myLabel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent labelAnchor) {
        this.myAnchor = labelAnchor;
        this.myLabel.setAnchor(labelAnchor);
    }

    @Nullable
    public JComponent getOwnAnchor() {
        return this.myLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/LabeledComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/LabeledComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    public static class TextWithMnemonic {
        private final @NlsContexts.Label String myText;
        private final int myMnemonicIndex;

        public TextWithMnemonic(@NlsContexts.Label String text, int mnemonicIndex) {
            this.myText = text;
            this.myMnemonicIndex = mnemonicIndex;
        }

        public void setToLabel(JLabel label2) {
            label2.setText(this.myText);
            if (this.myMnemonicIndex != -1) {
                label2.setDisplayedMnemonic(this.myText.charAt(this.myMnemonicIndex));
            } else {
                label2.setDisplayedMnemonic(0);
            }
            label2.setDisplayedMnemonicIndex(this.myMnemonicIndex);
        }

        public String getTextWithMnemonic() {
            return this.myMnemonicIndex != -1 ? this.myText.substring(0, this.myMnemonicIndex) + "&" + this.myText.substring(this.myMnemonicIndex) : this.myText;
        }

        public static TextWithMnemonic fromTextWithMnemonic(String text) {
            int mnemonicIndex = UIUtil.getDisplayMnemonicIndex((String)text);
            return mnemonicIndex != -1 ? new TextWithMnemonic(text.substring(0, mnemonicIndex) + text.substring(mnemonicIndex + 1), mnemonicIndex) : new TextWithMnemonic(text, -1);
        }

        public static TextWithMnemonic fromLabel(JLabel label2) {
            return new TextWithMnemonic(label2.getText(), label2.getDisplayedMnemonicIndex());
        }
    }
}

