/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.ui.components.panels.HorizontalLayoutKt;
import com.intellij.ui.components.panels.LayoutUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 92\u00020\u0001:\u000289B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020 H\u0016J\u0010\u0010,\u001a\u00020\r2\u0006\u0010+\u001a\u00020 H\u0016J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020 H\u0016J.\u0010.\u001a\u00020\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\f002\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u0004\u0018\u00010\r2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\f00H\u0002J\u0018\u00105\u001a\u00020\r2\u0006\u0010+\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0013j\b\u0012\u0004\u0012\u00020\f`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0013j\b\u0012\u0004\u0012\u00020\f`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0013j\b\u0012\u0004\u0012\u00020\f`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/ui/components/panels/HorizontalLayout;", "Ljava/awt/LayoutManager2;", "gap", "Lcom/intellij/util/ui/JBValue;", "verticalAlignment", "", "<init>", "(Lcom/intellij/util/ui/JBValue;I)V", "alignment", "(II)V", "preferredSizeFunction", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljava/awt/Dimension;", "getPreferredSizeFunction", "()Lkotlin/jvm/functions/Function1;", "setPreferredSizeFunction", "(Lkotlin/jvm/functions/Function1;)V", "leftGroup", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "centerGroup", "rightGroup", "components", "Lkotlin/sequences/Sequence;", "addLayoutComponent", "", "component", "constraints", "", "maximumLayoutSize", "target", "Ljava/awt/Container;", "getLayoutAlignmentX", "", "getLayoutAlignmentY", "invalidateLayout", "name", "", "group", "Lcom/intellij/ui/components/panels/HorizontalLayout$Group;", "removeLayoutComponent", "preferredLayoutSize", "container", "minimumLayoutSize", "layoutContainer", "layout", "list", "", "startX", "height", "insets", "Ljava/awt/Insets;", "getPreferredSize", "aligned", "", "Group", "Companion", "intellij.platform.ide"})
public final class HorizontalLayout
implements LayoutManager2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JBValue gap;
    private final int verticalAlignment;
    @ApiStatus.Internal
    @NotNull
    private Function1<? super Component, ? extends Dimension> preferredSizeFunction;
    @NotNull
    private final ArrayList<Component> leftGroup;
    @NotNull
    private final ArrayList<Component> centerGroup;
    @NotNull
    private final ArrayList<Component> rightGroup;
    public static final int FILL = -1;
    @NotNull
    public static final String LEFT = "LEFT";
    @NotNull
    public static final String RIGHT = "RIGHT";
    @NotNull
    public static final String CENTER = "CENTER";

    private HorizontalLayout(JBValue gap, int verticalAlignment) {
        this.gap = gap;
        this.verticalAlignment = verticalAlignment;
        this.preferredSizeFunction = HorizontalLayout::preferredSizeFunction$lambda$0;
        this.leftGroup = new ArrayList();
        this.centerGroup = new ArrayList();
        this.rightGroup = new ArrayList();
        if (!(this.verticalAlignment == -1 || this.verticalAlignment == 1 || this.verticalAlignment == 3 || this.verticalAlignment == 0)) {
            boolean bl = false;
            String string = "unsupported alignment: " + this.verticalAlignment;
            throw new IllegalStateException(string.toString());
        }
    }

    /* synthetic */ HorizontalLayout(JBValue jBValue, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        this(jBValue, n);
    }

    @NotNull
    public final Function1<Component, Dimension> getPreferredSizeFunction() {
        return this.preferredSizeFunction;
    }

    public final void setPreferredSizeFunction(@NotNull Function1<? super Component, ? extends Dimension> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.preferredSizeFunction = function1;
    }

    @JvmOverloads
    public HorizontalLayout(int gap, int alignment) {
        JBValue jBValue = gap <= 0 ? JBValue.Float.EMPTY : (JBValue)new JBValue.Float((float)gap);
        Intrinsics.checkNotNull((Object)jBValue);
        this(jBValue, alignment);
    }

    public /* synthetic */ HorizontalLayout(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        this(n, n2);
    }

    @NotNull
    public final Sequence<Component> components() {
        Object[] objectArray = new ArrayList[]{this.leftGroup, this.centerGroup, this.rightGroup};
        return SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.sequenceOf((Object[])objectArray));
    }

    @Override
    public void addLayoutComponent(@NotNull Component component, @Nullable Object constraints) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Object object = constraints;
        if (object instanceof Group) {
            this.addLayoutComponent(component, (Group)((Object)constraints));
        } else if (object == null) {
            this.addLayoutComponent(LEFT, component);
        } else if (object instanceof String) {
            Object object2 = constraints;
            this.addLayoutComponent(object2 instanceof String ? (String)object2 : null, component);
        } else {
            throw new IllegalArgumentException("unsupported constraints: " + constraints);
        }
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return 0.5f;
    }

    @Override
    public void invalidateLayout(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
    }

    @Override
    public void addLayoutComponent(@Nullable String name, @NotNull Component component) {
        Group group;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (name == null || StringsKt.equals((String)LEFT, (String)name, (boolean)true)) {
            group = Group.LEFT;
        } else if (StringsKt.equals((String)CENTER, (String)name, (boolean)true)) {
            group = Group.CENTER;
        } else if (StringsKt.equals((String)RIGHT, (String)name, (boolean)true)) {
            group = Group.RIGHT;
        } else {
            throw new IllegalArgumentException("unsupported name: " + name);
        }
        this.addLayoutComponent(component, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addLayoutComponent(Component component, Group group) {
        Object object = component.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            boolean bl2 = (switch (WhenMappings.$EnumSwitchMapping$0[group.ordinal()]) {
                case 1 -> this.leftGroup;
                case 2 -> this.centerGroup;
                case 3 -> this.rightGroup;
                default -> throw new NoWhenBranchMatchedException();
            }).add(component);
        }
    }

    @Override
    public void removeLayoutComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.leftGroup.remove(component);
        this.rightGroup.remove(component);
        this.centerGroup.remove(component);
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return this.getPreferredSize(container, true);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return this.getPreferredSize(container, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        int gap = this.gap.get();
        Object object = container.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Dimension left = this.getPreferredSize((List<? extends Component>)this.leftGroup);
            Dimension right = this.getPreferredSize((List<? extends Component>)this.rightGroup);
            Dimension center = this.getPreferredSize((List<? extends Component>)this.centerGroup);
            Insets insets = container.getInsets();
            int width = container.getWidth() - insets.left - insets.right;
            int height = container.getHeight() - insets.top - insets.bottom;
            int leftX = 0;
            if (left != null) {
                List list = this.leftGroup;
                Intrinsics.checkNotNull((Object)insets);
                leftX = gap + this.layout(list, 0, height, insets);
            }
            int rightX = width;
            if (right != null) {
                rightX -= right.width;
            }
            if (rightX < leftX) {
                rightX = leftX;
            }
            if (center != null) {
                int centerRightX;
                int centerX = (width - center.width) / 2;
                if (centerX > leftX && (centerRightX = centerX + center.width + gap + gap) > rightX) {
                    centerX = rightX - center.width - gap - gap;
                }
                if (centerX < leftX) {
                    centerX = leftX;
                }
                List list = this.centerGroup;
                Intrinsics.checkNotNull((Object)insets);
                centerX = gap + this.layout(list, centerX, height, insets);
                if (rightX < centerX) {
                    rightX = centerX;
                }
            }
            if (right != null) {
                List list = this.rightGroup;
                Intrinsics.checkNotNull((Object)insets);
                this.layout(list, rightX, height, insets);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final int layout(List<? extends Component> list, int startX, int height, Insets insets) {
        int x = startX;
        int gap = this.gap.get();
        for (Component component : list) {
            if (!component.isVisible()) continue;
            Dimension size = (Dimension)this.preferredSizeFunction.invoke((Object)component);
            int y = 0;
            if (this.verticalAlignment == -1) {
                size.height = height;
            } else if (this.verticalAlignment != 1) {
                y = height - size.height;
                if (this.verticalAlignment == 0) {
                    y /= 2;
                }
            }
            int width = size.width;
            component.setBounds(x + insets.left, y + insets.top, width, size.height);
            x += width + gap;
        }
        return x;
    }

    private final Dimension getPreferredSize(List<? extends Component> list) {
        int gap = this.gap.get();
        Dimension result2 = null;
        for (Component component : list) {
            if (!component.isVisible()) continue;
            result2 = HorizontalLayoutKt.access$joinDimension(result2, gap, (Dimension)this.preferredSizeFunction.invoke((Object)component));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Dimension getPreferredSize(Container container, boolean aligned) {
        int gap2 = 2 * this.gap.get();
        Object object = container.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Dimension left = this.getPreferredSize((List<? extends Component>)this.leftGroup);
            Dimension right = this.getPreferredSize((List<? extends Component>)this.rightGroup);
            Dimension center = this.getPreferredSize((List<? extends Component>)this.centerGroup);
            Dimension result2 = HorizontalLayoutKt.access$joinDimension(HorizontalLayoutKt.access$joinDimension(HorizontalLayoutKt.access$joinDimension(null, gap2, left), gap2, center), gap2, right);
            if (result2 == null) {
                result2 = new Dimension();
            } else if (aligned && center != null) {
                Dimension dimension = left;
                int leftWidth = dimension != null ? dimension.width : 0;
                Dimension dimension2 = right;
                int rightWidth = dimension2 != null ? dimension2.width : 0;
                Dimension dimension3 = result2;
                dimension3.width += Math.abs(leftWidth - rightWidth);
            }
            JBInsets.addTo((Dimension)result2, (Insets)container.getInsets());
            Dimension dimension = result2;
            return dimension;
        }
    }

    @JvmOverloads
    public HorizontalLayout(int gap) {
        this(gap, 0, 2, null);
    }

    private static final Dimension preferredSizeFunction$lambda$0(Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LayoutUtil.getPreferredSize(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ui/components/panels/HorizontalLayout$Companion;", "", "<init>", "()V", "FILL", "", "LEFT", "", "RIGHT", "CENTER", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ui/components/panels/HorizontalLayout$Group;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT", "CENTER", "RIGHT", "intellij.platform.ide"})
    public static final class Group
    extends Enum<Group> {
        public static final /* enum */ Group LEFT = new Group();
        public static final /* enum */ Group CENTER = new Group();
        public static final /* enum */ Group RIGHT = new Group();
        private static final /* synthetic */ Group[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String value2) {
            return Enum.valueOf(Group.class, value2);
        }

        @NotNull
        public static EnumEntries<Group> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = groupArray = new Group[]{Group.LEFT, Group.CENTER, Group.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Group.values().length];
            try {
                nArray[Group.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Group.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Group.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

