/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWrapperUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.ActionPanel;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLabelKt;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.Centerizer;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0004rstuB\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010!\u001a\u00020\u0015H\u0016J\u001a\u0010\"\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0015H\u0016J\u0018\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0004J\u000e\u00104\u001a\u00020/2\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020/2\u0006\u00105\u001a\u000206J\b\u00108\u001a\u00020\u0015H\u0014J\u0010\u00109\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0004J\u0010\u0010:\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020@H\u0014J\u0010\u0010A\u001a\u00020/2\b\u0010B\u001a\u0004\u0018\u00010CJ\b\u0010D\u001a\u00020/H\u0002J\u0010\u0010E\u001a\u00020/2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0011J\b\u0010F\u001a\u00020\u0015H\u0002J\u001a\u0010E\u001a\u00020/2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00112\u0006\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020\u000fH\u0004J\u000e\u0010J\u001a\u00020/2\u0006\u0010K\u001a\u00020LJ\u0012\u0010M\u001a\u00020/2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\b\u0010V\u001a\u00020/H\u0002J\u0006\u0010W\u001a\u00020\u0015J\u0012\u0010X\u001a\u00020/2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0011H\u0002J\u0006\u0010Y\u001a\u00020\u0015J\u0010\u0010Z\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0004J\u0010\u0010[\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010_\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0004J\u000e\u0010`\u001a\u00020/2\u0006\u0010a\u001a\u00020\u0015J\u000e\u0010b\u001a\u00020/2\u0006\u0010c\u001a\u00020\u0015J\u0006\u0010d\u001a\u00020eJ\u000e\u0010f\u001a\u00020/2\u0006\u0010g\u001a\u00020\u0015J\u0010\u0010k\u001a\u0004\u0018\u00010e2\u0006\u0010l\u001a\u00020@J\u000e\u0010m\u001a\u00020/2\u0006\u0010n\u001a\u00020oJ\u0006\u0010p\u001a\u00020qR\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\r8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00158\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00158V@TX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010\u001aR\u0014\u0010 \u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0018R\u0011\u0010(\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0018R\u0011\u0010+\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010;\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0018R\u0011\u0010<\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0018R\u0011\u0010=\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0018R\u0014\u0010P\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u0018R\u0014\u0010Q\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u0018R\u0011\u0010R\u001a\u00020S8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR\u0014\u0010\\\u001a\u00020$8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R\u0011\u0010h\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\bi\u0010j\u00a8\u0006v"}, d2={"Lcom/intellij/ui/tabs/impl/TabLabel;", "Ljavax/swing/JPanel;", "Ljavax/accessibility/Accessible;", "Lcom/intellij/openapi/actionSystem/UiCompatibleDataProvider;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "<init>", "(Lcom/intellij/ui/tabs/impl/JBTabsImpl;Lcom/intellij/ui/tabs/TabInfo;)V", "getInfo", "()Lcom/intellij/ui/tabs/TabInfo;", "label", "Lcom/intellij/ui/SimpleColoredComponent;", "icon", "Lcom/intellij/ui/LayeredIcon;", "overlaidIcon", "Ljavax/swing/Icon;", "actionPanel", "Lcom/intellij/ui/tabs/impl/ActionPanel;", "isCentered", "", "isCompressionEnabled", "isForcePaintBorders", "()Z", "setForcePaintBorders", "(Z)V", "labelPlaceholder", "Lcom/intellij/ui/components/panels/Wrapper;", "value", "isHovered", "setHovered", "isSelected", "isFocusable", "createLabel", "editLabelForeground", "Ljava/awt/Color;", "baseForeground", "getIconAlpha", "", "isPinned", "getPreferredSize", "Ljava/awt/Dimension;", "notStrictPreferredSize", "getNotStrictPreferredSize", "()Ljava/awt/Dimension;", "setAlignmentToCenter", "", "toCenter", "setPlaceholderContent", "component", "Ljavax/swing/JComponent;", "paintOffscreen", "g", "Ljava/awt/Graphics;", "paint", "shouldPaintFadeout", "paintFadeout", "doPaint", "isLastPinned", "isNextToLastPinned", "isLastInRow", "handlePopup", "e", "Ljava/awt/event/MouseEvent;", "setText", "text", "Lcom/intellij/ui/SimpleColoredText;", "invalidateIfNeeded", "setIcon", "hasIcons", "layer", "", "createLayeredIcon", "apply", "decoration", "Lcom/intellij/ui/tabs/UiDecorator$UiDecoration;", "setTabActions", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "isShowTabActions", "isTabActionsOnTheRight", "actionsPosition", "Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;", "getActionsPosition", "()Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;", "removeOldActionPanel", "updateTabActions", "setAttractionIcon", "repaintAttraction", "paintComponent", "paintBackground", "effectiveBackground", "getEffectiveBackground", "()Ljava/awt/Color;", "paintChildren", "setTabActionsAutoHide", "autoHide", "toggleShowActions", "show", "toString", "", "setTabEnabled", "enabled", "labelComponent", "getLabelComponent", "()Ljavax/swing/JComponent;", "getToolTipText", "event", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "ActionsPosition", "MergedUiDecoration", "AccessibleTabLabel", "TabLabelLayout", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nTabLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabLabel.kt\ncom/intellij/ui/tabs/impl/TabLabel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,855:1\n1#2:856\n*E\n"})
public class TabLabel
extends JPanel
implements Accessible,
UiCompatibleDataProvider {
    @JvmField
    @ApiStatus.Internal
    @NotNull
    protected final JBTabsImpl tabs;
    @NotNull
    private final TabInfo info;
    @JvmField
    @NotNull
    protected final SimpleColoredComponent label;
    @NotNull
    private final LayeredIcon icon;
    @Nullable
    private Icon overlaidIcon;
    @JvmField
    @ApiStatus.Internal
    @Nullable
    protected ActionPanel actionPanel;
    private boolean isCentered;
    @JvmField
    public boolean isCompressionEnabled;
    private boolean isForcePaintBorders;
    @NotNull
    private final Wrapper labelPlaceholder;

    @ApiStatus.Internal
    public TabLabel(@NotNull JBTabsImpl tabs, @NotNull TabInfo info) {
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super(false);
        this.tabs = tabs;
        this.info = info;
        this.labelPlaceholder = new Wrapper(false);
        this.label = this.createLabel(this.tabs, this.info);
        this.setFocusable(ScreenReader.isActive());
        this.setOpaque(false);
        this.setLayout(new TabLabelLayout());
        this.labelPlaceholder.setOpaque(false);
        this.labelPlaceholder.setFocusable(false);
        this.label.setFocusable(false);
        this.add((Component)this.labelPlaceholder, "Center");
        this.setAlignmentToCenter(true);
        this.icon = this.createLayeredIcon();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isCloseClick((MouseEvent)e, (int)501)) {
                    return;
                }
                if (JBTabsImpl.Companion.isSelectionClick(e) && this.getInfo().isEnabled()) {
                    Component c;
                    TabInfo selectedInfo = tabs.getSelectedInfo();
                    if (!Intrinsics.areEqual((Object)selectedInfo, (Object)this.getInfo())) {
                        this.getInfo().setPreviousSelection(selectedInfo);
                    }
                    if ((c = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY())) instanceof InplaceButton) {
                        return;
                    }
                    tabs.select(this.getInfo(), true);
                    JBPopup container = PopupUtil.getPopupContainerFor(this);
                    if (container != null && ClientProperty.isTrue((Component)container.getContent(), MorePopupAware.class)) {
                        container.cancel();
                    }
                } else {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getInfo().setPreviousSelection(null);
                this.handlePopup(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setHovered(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setHovered(false);
            }
        });
        if (this.isFocusable()) {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int index;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getKeyCode() == 37) {
                        int index2 = tabs.getIndexOf(this.getInfo());
                        if (index2 >= 0) {
                            e.consume();
                            TabInfo previous = tabs.findEnabledBackward(index2, true);
                            if (previous != null) {
                                tabs.select(previous, false).doWhenDone(() -> 2.keyPressed$lambda$0(this));
                            }
                        }
                    } else if (e.getKeyCode() == 39 && (index = tabs.getIndexOf(this.getInfo())) >= 0) {
                        e.consume();
                        TabInfo next = tabs.findEnabledForward(index, true);
                        if (next != null) {
                            tabs.select(next, false).doWhenDone(() -> 2.keyPressed$lambda$1(this));
                        }
                    }
                }

                private static final void keyPressed$lambda$0(TabLabel this$0) {
                    TabLabel tabLabel = this$0.tabs.getSelectedLabel();
                    Intrinsics.checkNotNull((Object)tabLabel);
                    tabLabel.requestFocusInWindow();
                }

                private static final void keyPressed$lambda$1(TabLabel this$0) {
                    TabLabel tabLabel = this$0.tabs.getSelectedLabel();
                    Intrinsics.checkNotNull((Object)tabLabel);
                    tabLabel.requestFocusInWindow();
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.repaint();
                }
            });
        }
    }

    @NotNull
    public final TabInfo getInfo() {
        return this.info;
    }

    public final boolean isForcePaintBorders() {
        return this.isForcePaintBorders;
    }

    public final void setForcePaintBorders(boolean bl) {
        this.isForcePaintBorders = bl;
    }

    public boolean isHovered() {
        return this.tabs.isHoveredTab(this);
    }

    protected void setHovered(boolean value2) {
        if (this.isHovered() == value2) {
            return;
        }
        if (value2) {
            this.tabs.setHovered(this);
        } else {
            this.tabs.unHover(this);
        }
    }

    private final boolean isSelected() {
        return this.tabs.getSelectedLabel() == this;
    }

    @Override
    public boolean isFocusable() {
        return this.tabs.getSelectedLabel() == this && super.isFocusable();
    }

    private final SimpleColoredComponent createLabel(JBTabsImpl tabs, TabInfo info) {
        SimpleColoredComponent label2 = new SimpleColoredComponent(tabs, info, this){
            final /* synthetic */ JBTabsImpl $tabs;
            final /* synthetic */ TabInfo $info;
            final /* synthetic */ TabLabel this$0;
            {
                this.$tabs = $tabs;
                this.$info = $info;
                this.this$0 = $receiver;
            }

            public Font getFont() {
                Font font = super.getFont();
                if (this.isFontSet() || !this.$tabs.useSmallLabels()) {
                    Intrinsics.checkNotNull((Object)font);
                    return font;
                }
                Font font2 = RelativeFont.NORMAL.fromResource("EditorTabs.fontSizeOffset", -2, JBUIScale.scale((float)11.0f)).derive(StartupUiUtil.getLabelFont());
                Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"derive(...)");
                return font2;
            }

            protected Color getActiveTextColor(Color attributesColor) {
                TabPainterAdapter painterAdapter = this.$tabs.tabPainterAdapter;
                TabTheme theme = painterAdapter.getTabTheme();
                Color foreground = Intrinsics.areEqual((Object)this.$tabs.getSelectedInfo(), (Object)this.$info) && (attributesColor == null || Intrinsics.areEqual((Object)UIUtil.getLabelForeground(), (Object)attributesColor)) ? (this.$tabs.isActiveTabs(this.$info) ? theme.getUnderlinedTabForeground() : theme.getUnderlinedTabInactiveForeground()) : super.getActiveTextColor(attributesColor);
                return this.this$0.editLabelForeground(foreground);
            }

            protected void paintIcon(Graphics g, Icon icon, int offset) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
                float iconAlpha = this.this$0.getIconAlpha();
                if (iconAlpha == 1.0f) {
                    super.paintIcon(g, icon, offset);
                } else {
                    GraphicsUtil.paintWithAlpha((Graphics)g, (float)iconAlpha, () -> createLabel.label.1.paintIcon$lambda$0(this, g, icon, offset));
                }
            }

            private static final void paintIcon$lambda$0(createLabel.label.1 this$0, Graphics $g, Icon $icon, int $offset) {
                super.paintIcon($g, $icon, $offset);
            }
        };
        label2.setOpaque(false);
        label2.setBorder(null);
        label2.setIconOpaque(false);
        label2.setIpad((Insets)JBInsets.emptyInsets());
        return label2;
    }

    @Nullable
    public Color editLabelForeground(@Nullable Color baseForeground) {
        return baseForeground;
    }

    public float getIconAlpha() {
        return 1.0f;
    }

    public final boolean isPinned() {
        return this.info.isPinned();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = this.getNotStrictPreferredSize();
        if (this.isPinned()) {
            size.width = Math.min(TabLayout.getMaxPinnedTabWidth(), size.width);
        }
        return size;
    }

    @NotNull
    public final Dimension getNotStrictPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    public void setAlignmentToCenter(boolean toCenter) {
        if (this.isCentered != toCenter || this.getLabelComponent().getParent() == null) {
            this.setPlaceholderContent(toCenter, this.getLabelComponent());
        }
    }

    protected final void setPlaceholderContent(boolean toCenter, @NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.labelPlaceholder.removeAll();
        JComponent content = toCenter ? (JComponent)new Centerizer(component, Centerizer.TYPE.BOTH) : (JComponent)new Centerizer(component, Centerizer.TYPE.VERTICAL);
        this.labelPlaceholder.setContent(content);
        this.isCentered = toCenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintOffscreen(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Object object = this.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            this.validateTree();
            Unit unit = Unit.INSTANCE;
        }
        this.doPaint(g);
    }

    @Override
    public final void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.tabs.isDropTarget(this.info)) {
            if (this.tabs.getDropSide() == -1) {
                g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            return;
        }
        this.doPaint(g);
        if (this.shouldPaintFadeout()) {
            this.paintFadeout(g);
        }
    }

    protected boolean shouldPaintFadeout() {
        return !Registry.Companion.is("ui.no.bangs.and.whistles", false) && this.tabs.isSingleRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void paintFadeout(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            Color tabBg = this.getEffectiveBackground();
            Color color = ColorUtil.withAlpha((Color)tabBg, (double)0.0);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"withAlpha(...)");
            Color transparent = color;
            int borderThickness = this.tabs.getBorderThickness();
            int width = JBUI.scale((int)MathUtil.clamp((int)Registry.Companion.intValue("ide.editor.tabs.fadeout.width", 10), (int)1, (int)200));
            Rectangle rect = this.getBounds();
            rect.height = rect.height - (borderThickness + (this.isSelected() ? this.tabs.getTabPainter().getTabTheme().getUnderlineHeight() : borderThickness));
            if (rect.x < 0) {
                Rectangle leftRect = new Rectangle(-rect.x, borderThickness, width, rect.height - 2 * borderThickness);
                TabLabelKt.access$paintGradientRect(g2d, leftRect, tabBg, transparent);
            }
            Rectangle contentRect = this.labelPlaceholder.getBounds();
            if (contentRect.width < this.labelPlaceholder.getPreferredSize().width + this.tabs.getTabHGap()) {
                Rectangle rightRect = new Rectangle(contentRect.x + contentRect.width - width, borderThickness, width, rect.height - 2 * borderThickness);
                TabLabelKt.access$paintGradientRect(g2d, rightRect, transparent, tabBg);
            } else if (this.tabs.effectiveLayout.isScrollable() && rect.width < this.getPreferredSize().width + this.tabs.getTabHGap()) {
                Rectangle rightRect = new Rectangle(rect.width - width, borderThickness, width, rect.height - 2 * borderThickness);
                TabLabelKt.access$paintGradientRect(g2d, rightRect, transparent, tabBg);
            }
        }
        finally {
            g2d.dispose();
        }
    }

    private final void doPaint(Graphics g) {
        super.paint(g);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLastPinned() {
        if (!this.info.isPinned()) return false;
        if (!AdvancedSettings.Companion.getBoolean("editor.keep.pinned.tabs.on.left")) return false;
        List<TabInfo> tabs = this.tabs.getTabs();
        int i = 0;
        int n = ((Collection)tabs).size();
        while (i < n) {
            TabInfo cur = tabs.get(i);
            if (Intrinsics.areEqual((Object)cur, (Object)this.info) && i < tabs.size() - 1) {
                TabInfo next = tabs.get(i + 1);
                if (next.isPinned()) return false;
                TabLabel tabLabel = this.tabs.getTabLabel(next);
                Intrinsics.checkNotNull((Object)tabLabel);
                if (tabLabel.getY() != this.getY()) return false;
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean isNextToLastPinned() {
        if (!this.info.isPinned() && AdvancedSettings.Companion.getBoolean("editor.keep.pinned.tabs.on.left")) {
            List<TabInfo> tabs = this.tabs.getVisibleInfos();
            boolean wasPinned = false;
            for (TabInfo info : tabs) {
                if (wasPinned && Intrinsics.areEqual((Object)info, (Object)this.info)) {
                    return true;
                }
                wasPinned = info.isPinned();
            }
        }
        return false;
    }

    public final boolean isLastInRow() {
        List<TabInfo> infos = this.tabs.getVisibleInfos();
        int n = infos.size() - 1;
        for (int ind = 0; ind < n; ++ind) {
            TabLabel cur = this.tabs.getTabLabel(infos.get(ind));
            if (cur != this) continue;
            TabLabel next = this.tabs.getTabLabel(infos.get(ind + 1));
            int n2 = cur.getY();
            TabLabel tabLabel = next;
            Intrinsics.checkNotNull((Object)tabLabel);
            return n2 != tabLabel.getY();
        }
        return !infos.isEmpty() && Intrinsics.areEqual((Object)infos.get(infos.size() - 1), (Object)this.info);
    }

    protected void handlePopup(@NotNull MouseEvent e) {
        ActionGroup actionGroup;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getClickCount() != 1 || !e.isPopupTrigger() || PopupUtil.getPopupContainerFor(this) != null) {
            return;
        }
        if (e.getX() < 0 || e.getX() >= e.getComponent().getWidth() || e.getY() < 0 || e.getY() >= e.getComponent().getHeight()) {
            return;
        }
        String place = this.tabs.getPopupPlace();
        String string = place;
        if (string == null) {
            string = "unknown";
        }
        place = string;
        this.tabs.setPopupInfo(this.info);
        ActionGroup tabsPopupGroup = this.tabs.getPopupGroup();
        JBTabsImpl thisTabs = this.tabs;
        JBTabsImpl $this$handlePopup_u24lambda_u240 = this.tabs;
        boolean bl = false;
        ActionGroup it = actionGroup = $this$handlePopup_u24lambda_u240.getNavigationActions();
        boolean bl2 = false;
        ActionGroup tabNavigationGroup = $this$handlePopup_u24lambda_u240.getAddNavigationGroup() ? actionGroup : null;
        DumbAware toShow2 = new DumbAware(tabsPopupGroup, tabNavigationGroup, thisTabs){
            final /* synthetic */ ActionGroup $tabsPopupGroup;
            final /* synthetic */ ActionGroup $tabNavigationGroup;
            final /* synthetic */ JBTabsImpl $thisTabs;
            {
                this.$tabsPopupGroup = $tabsPopupGroup;
                this.$tabNavigationGroup = $tabNavigationGroup;
                this.$thisTabs = $thisTabs;
            }

            public AnAction[] getChildren(AnActionEvent e) {
                Object object;
                Object[] objectArray;
                block7: {
                    block6: {
                        Object[] it;
                        Object[] objectArray2;
                        JBTabsImpl tabs;
                        block5: {
                            block4: {
                                AnActionEvent anActionEvent = e;
                                JBTabsEx jBTabsEx = anActionEvent != null ? (JBTabsEx)anActionEvent.getData(JBTabsEx.NAVIGATION_ACTIONS_KEY) : null;
                                tabs = jBTabsEx instanceof JBTabsImpl ? (JBTabsImpl)jBTabsEx : null;
                                objectArray2 = this.$tabsPopupGroup;
                                if (this.$tabsPopupGroup == null) break block4;
                                it = objectArray2;
                                boolean bl = false;
                                AnAction[] anActionArray = (AnAction[])ArraysKt.plus((Object[])ActionWrapperUtil.getChildren(e, this, (ActionGroup)it), (Object)((Object)new Separator()));
                                objectArray2 = anActionArray;
                                if (anActionArray != null) break block5;
                            }
                            objectArray2 = new Object[]{};
                        }
                        Object[] objectArray3 = this.$tabNavigationGroup;
                        JBTabsImpl jBTabsImpl = this.$thisTabs;
                        it = objectArray3;
                        Object[] objectArray4 = objectArray2;
                        boolean bl = false;
                        boolean bl2 = tabs == jBTabsImpl;
                        objectArray = objectArray4;
                        object = bl2 ? objectArray3 : null;
                        if (object == null) break block6;
                        it = object;
                        objectArray4 = objectArray;
                        boolean bl3 = false;
                        AnAction[] anActionArray = ActionWrapperUtil.getChildren(e, this, (ActionGroup)it);
                        objectArray = objectArray4;
                        object = anActionArray;
                        if (anActionArray != null) break block7;
                    }
                    object = new AnAction[]{};
                }
                return (AnAction[])ArraysKt.plus((Object[])objectArray, (Object[])object);
            }
        };
        this.tabs.setActivePopup(ActionManager.getInstance().createActionPopupMenu(place, (ActionGroup)toShow2).getComponent());
        JPopupMenu jPopupMenu = this.tabs.getActivePopup();
        Intrinsics.checkNotNull((Object)jPopupMenu);
        jPopupMenu.addPopupMenuListener(this.tabs.getPopupListener());
        JPopupMenu jPopupMenu2 = this.tabs.getActivePopup();
        Intrinsics.checkNotNull((Object)jPopupMenu2);
        jPopupMenu2.addPopupMenuListener(this.tabs);
        JPopupMenu jPopupMenu3 = this.tabs.getActivePopup();
        Intrinsics.checkNotNull((Object)jPopupMenu3);
        JBPopupMenu.showByEvent(e, jPopupMenu3);
    }

    public final void setText(@Nullable SimpleColoredText text) {
        this.label.change(() -> TabLabel.setText$lambda$0(this, text), false);
        this.invalidateIfNeeded();
    }

    private final void invalidateIfNeeded() {
        if (this.label.getRootPane() == null) {
            return;
        }
        Dimension d = this.label.getSize();
        Dimension dimension = this.label.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        Dimension pref = dimension;
        if (d != null && Intrinsics.areEqual((Object)d, (Object)pref)) {
            return;
        }
        this.label.invalidate();
        if (this.actionPanel != null) {
            ActionPanel actionPanel = this.actionPanel;
            Intrinsics.checkNotNull((Object)actionPanel);
            actionPanel.invalidate();
        }
        this.tabs.revalidateAndRepaint(false);
    }

    public final void setIcon(@Nullable Icon icon) {
        this.setIcon(icon, 0);
    }

    private final boolean hasIcons() {
        for (Icon layer1 : this.icon.getAllLayers()) {
            if (layer1 == null) continue;
            return true;
        }
        return false;
    }

    private final void setIcon(Icon icon, int layer) {
        LayeredIcon layeredIcon = this.icon;
        layeredIcon.setIcon(icon, layer);
        if (this.hasIcons()) {
            this.label.setIcon((Icon)layeredIcon);
        } else {
            this.label.setIcon(null);
        }
        this.invalidateIfNeeded();
    }

    @NotNull
    protected final LayeredIcon createLayeredIcon() {
        return new LayeredIcon(this){
            final /* synthetic */ TabLabel this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public int getIconWidth() {
                int iconWidth = super.getIconWidth();
                int tabWidth = this.this$0.getWidth();
                int minTabWidth = JBUI.scale((int)39);
                return this.this$0.isCompressionEnabled && tabWidth < minTabWidth ? Math.max(iconWidth - (minTabWidth - tabWidth), iconWidth / 2) : iconWidth;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Graphics g2 = g.create(x, y, this.getIconWidth(), this.getIconHeight());
                try {
                    Intrinsics.checkNotNull((Object)g2);
                    super.paintIcon(c, g2, 0, 0);
                }
                finally {
                    g2.dispose();
                }
            }
        };
    }

    public final void apply(@NotNull UiDecorator.UiDecoration decoration) {
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        if (decoration.getLabelFont() != null) {
            this.setFont(decoration.getLabelFont());
            this.getLabelComponent().setFont(decoration.getLabelFont());
        }
        MergedUiDecoration resultDec = TabLabelKt.mergeUiDecorations(decoration, JBTabsImpl.defaultDecorator.getDecoration());
        this.setBorder(new EmptyBorder(resultDec.labelInsets));
        this.label.setIconTextGap(resultDec.iconTextGap);
        Insets insets = resultDec.contentInsetsSupplier.apply(this.getActionsPosition());
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"apply(...)");
        Insets contentInsets = insets;
        this.labelPlaceholder.setBorder(new EmptyBorder(contentInsets));
    }

    public void setTabActions(@Nullable ActionGroup group) {
        this.removeOldActionPanel();
        if (group == null) {
            return;
        }
        this.actionPanel = new ActionPanel(this.tabs, this.info, arg_0 -> TabLabel.setTabActions$lambda$1(arg_0 -> TabLabel.setTabActions$lambda$0(this, arg_0), arg_0), arg_0 -> TabLabel.setTabActions$lambda$3(arg_0 -> TabLabel.setTabActions$lambda$2(this, arg_0), arg_0));
        this.toggleShowActions(false);
        ActionPanel actionPanel = this.actionPanel;
        Intrinsics.checkNotNull((Object)actionPanel);
        this.add((Component)actionPanel, this.isTabActionsOnTheRight() ? "East" : "West");
        this.tabs.revalidateAndRepaint(false);
    }

    protected boolean isShowTabActions() {
        return true;
    }

    protected boolean isTabActionsOnTheRight() {
        return true;
    }

    @NotNull
    public final ActionsPosition getActionsPosition() {
        return this.isShowTabActions() && this.actionPanel != null ? (this.isTabActionsOnTheRight() ? ActionsPosition.RIGHT : ActionsPosition.LEFT) : ActionsPosition.NONE;
    }

    private final void removeOldActionPanel() {
        block0: {
            ActionPanel actionPanel = this.actionPanel;
            if (actionPanel == null) break block0;
            ActionPanel it = actionPanel;
            boolean bl = false;
            it.getParent().remove(this.actionPanel);
            this.actionPanel = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean updateTabActions() {
        if (this.actionPanel == null) return false;
        ActionPanel actionPanel = this.actionPanel;
        Intrinsics.checkNotNull((Object)actionPanel);
        if (!actionPanel.update()) return false;
        return true;
    }

    private final void setAttractionIcon(Icon icon) {
        if (this.icon.getIcon(0) == null) {
            this.setIcon(null, 1);
            this.overlaidIcon = icon;
        } else {
            this.setIcon(icon, 1);
            this.overlaidIcon = null;
        }
    }

    public final boolean repaintAttraction() {
        if (!this.tabs.attractions.contains(this.info)) {
            if (this.icon.isLayerEnabled(1)) {
                this.icon.setLayerEnabled(1, false);
                this.setAttractionIcon(null);
                this.invalidateIfNeeded();
                return true;
            }
            return false;
        }
        boolean needsUpdate = false;
        if (this.icon.getIcon(1) != this.info.getAlertIcon()) {
            this.setAttractionIcon((Icon)this.info.getAlertIcon());
            needsUpdate = true;
        }
        int maxInitialBlinkCount = 5;
        int maxReFireBlinkCount = maxInitialBlinkCount + 2;
        if (this.info.getBlinkCount() < maxInitialBlinkCount && this.info.isAlertRequested()) {
            this.icon.setLayerEnabled(1, !this.icon.isLayerEnabled(1));
            if (this.info.getBlinkCount() == 0) {
                needsUpdate = true;
            }
            TabInfo tabInfo = this.info;
            tabInfo.setBlinkCount(tabInfo.getBlinkCount() + 1);
            if (this.info.getBlinkCount() == maxInitialBlinkCount) {
                this.info.resetAlertRequest();
            }
            this.repaint();
        } else if (this.info.getBlinkCount() < maxReFireBlinkCount && this.info.isAlertRequested()) {
            this.icon.setLayerEnabled(1, !this.icon.isLayerEnabled(1));
            TabInfo tabInfo = this.info;
            tabInfo.setBlinkCount(tabInfo.getBlinkCount() + 1);
            if (this.info.getBlinkCount() == maxReFireBlinkCount) {
                this.info.setBlinkCount(maxInitialBlinkCount);
                this.info.resetAlertRequest();
            }
            this.repaint();
        } else {
            needsUpdate = !this.icon.isLayerEnabled(1);
            this.icon.setLayerEnabled(1, true);
        }
        this.invalidateIfNeeded();
        return needsUpdate;
    }

    @Override
    protected final void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        this.paintBackground(g);
    }

    private final void paintBackground(Graphics g) {
        this.tabs.tabPainterAdapter.paintBackground(this, g, this.tabs);
    }

    @NotNull
    protected final Color getEffectiveBackground() {
        Color color;
        Color customBg;
        Color bg = this.tabs.getTabPainter().getBackgroundColor();
        Color color2 = customBg = this.tabs.getTabPainter().getCustomBackground(this.info.getTabColor(), this.isSelected(), this.tabs.isActiveTabs(this.info), this.isHovered());
        if (color2 != null) {
            Color color3 = ColorUtil.alphaBlending((Color)color2, (Color)bg);
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"alphaBlending(...)");
        } else {
            color = bg;
        }
        return color;
    }

    @Override
    protected final void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintChildren(g);
        if (this.getLabelComponent().getParent() == null) {
            return;
        }
        Rectangle textBounds = SwingUtilities.convertRectangle(this.getLabelComponent().getParent(), this.getLabelComponent().getBounds(), this);
        if (this.isFocusOwner()) {
            g.setColor(UIUtil.getTreeSelectionBorderColor());
            UIUtil.drawDottedRectangle((Graphics)g, (int)textBounds.x, (int)textBounds.y, (int)(textBounds.x + textBounds.width - 1), (int)(textBounds.y + textBounds.height - 1));
        }
        if (this.overlaidIcon == null) {
            return;
        }
        if (this.icon.isLayerEnabled(1)) {
            int n = this.getSize().height;
            Icon icon = this.overlaidIcon;
            Intrinsics.checkNotNull((Object)icon);
            int top = (n - icon.getIconHeight()) / 2;
            Icon icon2 = this.overlaidIcon;
            Intrinsics.checkNotNull((Object)icon2);
            Component component = this;
            int n2 = textBounds.x;
            Icon icon3 = this.overlaidIcon;
            Intrinsics.checkNotNull((Object)icon3);
            icon2.paintIcon(component, g, n2 - icon3.getIconWidth() / 2, top);
        }
    }

    public final void setTabActionsAutoHide(boolean autoHide) {
        block3: {
            block2: {
                if (this.actionPanel == null) break block2;
                ActionPanel actionPanel = this.actionPanel;
                Intrinsics.checkNotNull((Object)actionPanel);
                if (actionPanel.isAutoHide() != autoHide) break block3;
            }
            return;
        }
        ActionPanel actionPanel = this.actionPanel;
        Intrinsics.checkNotNull((Object)actionPanel);
        actionPanel.setAutoHide(autoHide);
    }

    public final void toggleShowActions(boolean show) {
        block0: {
            ActionPanel actionPanel = this.actionPanel;
            if (actionPanel == null) break block0;
            actionPanel.toggleShowActions(show);
        }
    }

    @Override
    @NotNull
    public final String toString() {
        return this.info.getText();
    }

    public final void setTabEnabled(boolean enabled) {
        this.getLabelComponent().setEnabled(enabled);
    }

    @NotNull
    public final JComponent getLabelComponent() {
        return this.label;
    }

    @Override
    @Nullable
    public final String getToolTipText(@NotNull MouseEvent event) {
        String string;
        int iconWidth;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Icon icon = this.label.getIcon();
        int n = iconWidth = icon != null ? icon.getIconWidth() : JBUI.scale((int)16);
        if (!(this.label.getVisibleRect().width < iconWidth * 2 && UISettings.Companion.getInstance().getShowTabsTooltips() || this.label.findFragmentAt(new RelativePoint((MouseEvent)event).getPoint((Component)((Component)this.label)).x) != -2 || (string = this.icon.getToolTip(false)) == null)) {
            String it = string;
            boolean bl = false;
            return Strings.capitalize((String)it);
        }
        return super.getToolTipText(event);
    }

    public final void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataSink.Companion.uiDataSnapshot(sink, (Object)this.info.getComponent());
    }

    @Override
    @NotNull
    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTabLabel();
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    private static final void setText$lambda$0(TabLabel this$0, SimpleColoredText $text) {
        block0: {
            this$0.label.clear();
            this$0.label.setIcon(this$0.hasIcons() ? (Icon)this$0.icon : null);
            SimpleColoredText simpleColoredText = $text;
            if (simpleColoredText == null) break block0;
            simpleColoredText.appendToComponent((ColoredTextContainer)this$0.label);
        }
    }

    private static final Unit setTabActions$lambda$0(TabLabel this$0, MouseEvent it) {
        this$0.processMouseEvent(SwingUtilities.convertMouseEvent(it.getComponent(), it, this$0));
        return Unit.INSTANCE;
    }

    private static final void setTabActions$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setTabActions$lambda$2(TabLabel this$0, Boolean it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.setHovered(it);
        return Unit.INSTANCE;
    }

    private static final void setTabActions$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ui/tabs/impl/TabLabel$AccessibleTabLabel;", "Ljavax/swing/JPanel$AccessibleJPanel;", "Ljavax/swing/JPanel;", "<init>", "(Lcom/intellij/ui/tabs/impl/TabLabel;)V", "getAccessibleName", "", "getAccessibleDescription", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "intellij.platform.ide"})
    protected final class AccessibleTabLabel
    extends JPanel.AccessibleJPanel {
        public AccessibleTabLabel() {
            super(TabLabel.this);
        }

        @Override
        @Nullable
        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null) {
                string = TabLabel.this.label.getAccessibleContext().getAccessibleName();
            }
            return string;
        }

        @Override
        @Nullable
        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                string = TabLabel.this.label.getAccessibleContext().getAccessibleDescription();
            }
            return string;
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.PAGE_TAB;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"PAGE_TAB");
            return accessibleRole;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;", "", "<init>", "(Ljava/lang/String;I)V", "RIGHT", "LEFT", "NONE", "intellij.platform.ide"})
    public static final class ActionsPosition
    extends Enum<ActionsPosition> {
        public static final /* enum */ ActionsPosition RIGHT = new ActionsPosition();
        public static final /* enum */ ActionsPosition LEFT = new ActionsPosition();
        public static final /* enum */ ActionsPosition NONE = new ActionsPosition();
        private static final /* synthetic */ ActionsPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ActionsPosition[] values() {
            return (ActionsPosition[])$VALUES.clone();
        }

        public static ActionsPosition valueOf(String value2) {
            return Enum.valueOf(ActionsPosition.class, value2);
        }

        @NotNull
        public static EnumEntries<ActionsPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = actionsPositionArray = new ActionsPosition[]{ActionsPosition.RIGHT, ActionsPosition.LEFT, ActionsPosition.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\r\u001a\u00020\bH\u00c6\u0003J3\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/tabs/impl/TabLabel$MergedUiDecoration;", "", "labelInsets", "Ljava/awt/Insets;", "contentInsetsSupplier", "Ljava/util/function/Function;", "Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;", "iconTextGap", "", "<init>", "(Ljava/awt/Insets;Ljava/util/function/Function;I)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide"})
    public static final class MergedUiDecoration {
        @JvmField
        @NotNull
        public final Insets labelInsets;
        @JvmField
        @NotNull
        public final Function<ActionsPosition, Insets> contentInsetsSupplier;
        @JvmField
        public final int iconTextGap;

        public MergedUiDecoration(@NotNull Insets labelInsets, @NotNull Function<ActionsPosition, Insets> contentInsetsSupplier, int iconTextGap) {
            Intrinsics.checkNotNullParameter((Object)labelInsets, (String)"labelInsets");
            Intrinsics.checkNotNullParameter(contentInsetsSupplier, (String)"contentInsetsSupplier");
            this.labelInsets = labelInsets;
            this.contentInsetsSupplier = contentInsetsSupplier;
            this.iconTextGap = iconTextGap;
        }

        @NotNull
        public final Insets component1() {
            return this.labelInsets;
        }

        @NotNull
        public final Function<ActionsPosition, Insets> component2() {
            return this.contentInsetsSupplier;
        }

        public final int component3() {
            return this.iconTextGap;
        }

        @NotNull
        public final MergedUiDecoration copy(@NotNull Insets labelInsets, @NotNull Function<ActionsPosition, Insets> contentInsetsSupplier, int iconTextGap) {
            Intrinsics.checkNotNullParameter((Object)labelInsets, (String)"labelInsets");
            Intrinsics.checkNotNullParameter(contentInsetsSupplier, (String)"contentInsetsSupplier");
            return new MergedUiDecoration(labelInsets, contentInsetsSupplier, iconTextGap);
        }

        public static /* synthetic */ MergedUiDecoration copy$default(MergedUiDecoration mergedUiDecoration, Insets insets, Function function, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                insets = mergedUiDecoration.labelInsets;
            }
            if ((n2 & 2) != 0) {
                function = mergedUiDecoration.contentInsetsSupplier;
            }
            if ((n2 & 4) != 0) {
                n = mergedUiDecoration.iconTextGap;
            }
            return mergedUiDecoration.copy(insets, function, n);
        }

        @NotNull
        public String toString() {
            return "MergedUiDecoration(labelInsets=" + this.labelInsets + ", contentInsetsSupplier=" + this.contentInsetsSupplier + ", iconTextGap=" + this.iconTextGap + ")";
        }

        public int hashCode() {
            int result2 = this.labelInsets.hashCode();
            result2 = result2 * 31 + this.contentInsetsSupplier.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.iconTextGap);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MergedUiDecoration)) {
                return false;
            }
            MergedUiDecoration mergedUiDecoration = (MergedUiDecoration)other;
            if (!Intrinsics.areEqual((Object)this.labelInsets, (Object)mergedUiDecoration.labelInsets)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.contentInsetsSupplier, mergedUiDecoration.contentInsetsSupplier)) {
                return false;
            }
            return this.iconTextGap == mergedUiDecoration.iconTextGap;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ui/tabs/impl/TabLabel$TabLabelLayout;", "Ljava/awt/BorderLayout;", "<init>", "(Lcom/intellij/ui/tabs/impl/TabLabel;)V", "isRightAlignment", "", "setRightAlignment", "", "rightAlignment", "addLayoutComponent", "comp", "Ljava/awt/Component;", "constraints", "", "layoutContainer", "parent", "Ljava/awt/Container;", "layoutScrollable", "getShift", "", "layoutComponent", "xOffset", "component", "spaceTop", "spaceHeight", "layoutCompressible", "intellij.platform.ide"})
    public final class TabLabelLayout
    extends BorderLayout {
        private boolean isRightAlignment;

        public final void setRightAlignment(boolean rightAlignment) {
            this.isRightAlignment = rightAlignment;
        }

        @Override
        public void addLayoutComponent(@NotNull Component comp, @NotNull Object constraints) {
            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
            Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
            TabLabelKt.access$checkConstraints(constraints);
            super.addLayoutComponent(comp, constraints);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(@NotNull Container parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            int prefWidth = parent.getPreferredSize().width;
            Object object = parent.getTreeLock();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
            Object object2 = object;
            TabLabel tabLabel = TabLabel.this;
            Object object3 = object2;
            synchronized (object3) {
                boolean bl = false;
                if (!tabLabel.getInfo().isPinned() && tabLabel.tabs.effectiveLayout.isScrollable() && (ExperimentalUI.Companion.isNewUI() && !tabLabel.isHovered() || tabLabel.tabs.isHorizontalTabs()) && tabLabel.isShowTabActions() && tabLabel.isTabActionsOnTheRight() && parent.getWidth() < prefWidth) {
                    this.layoutScrollable(parent);
                } else if (!tabLabel.getInfo().isPinned() && tabLabel.isCompressionEnabled && !tabLabel.isHovered() && !tabLabel.isSelected() && parent.getWidth() < prefWidth) {
                    this.layoutCompressible(parent);
                } else {
                    super.layoutContainer(parent);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private final void layoutScrollable(Container parent) {
            int spaceTop = parent.getInsets().top;
            int spaceLeft = parent.getInsets().left;
            int spaceBottom = parent.getHeight() - parent.getInsets().bottom;
            int spaceHeight = spaceBottom - spaceTop;
            int xOffset = spaceLeft;
            xOffset = this.layoutComponent(xOffset, this.getLayoutComponent("West"), spaceTop, spaceHeight);
            xOffset -= this.getShift(parent);
            xOffset = this.layoutComponent(xOffset, this.getLayoutComponent("Center"), spaceTop, spaceHeight);
            this.layoutComponent(xOffset, this.getLayoutComponent("East"), spaceTop, spaceHeight);
        }

        private final int getShift(Container parent) {
            int shift;
            int width;
            if (this.isRightAlignment && (width = parent.getBounds().width) > 0 && (shift = parent.getPreferredSize().width - width) > 0) {
                return shift;
            }
            return 0;
        }

        private final int layoutComponent(int xOffset, Component component, int spaceTop, int spaceHeight) {
            int xOffset2 = xOffset;
            if (component != null) {
                int prefWestWidth = component.getPreferredSize().width;
                component.setBounds(xOffset2, spaceTop, prefWestWidth, spaceHeight);
                xOffset2 += prefWestWidth + this.getHgap();
            }
            return xOffset2;
        }

        private final void layoutCompressible(Container parent) {
            block2: {
                Insets insets = parent.getInsets();
                int height = parent.getHeight() - insets.bottom - insets.top;
                int curX = insets.left;
                int maxX = parent.getWidth() - insets.right;
                Component left = this.getLayoutComponent("West");
                Component center = this.getLayoutComponent("Center");
                Component right = this.getLayoutComponent("East");
                if (left != null) {
                    left.setBounds(0, 0, 0, 0);
                    int decreasedLen = parent.getPreferredSize().width - parent.getWidth();
                    int width = (int)Math.max((double)(left.getPreferredSize().width - decreasedLen), 0.0);
                    curX += width;
                }
                if (center != null) {
                    int width = Math.min(center.getPreferredSize().width, maxX - curX);
                    center.setBounds(curX, insets.top, width, height);
                }
                Component component = right;
                if (component == null) break block2;
                component.setBounds(0, 0, 0, 0);
            }
        }
    }
}

