/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00150\rj\b\u0012\u0004\u0012\u00020\u0015`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/ui/RangeBlinker;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "timeToLive", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/TextAttributes;ILcom/intellij/openapi/Disposable;)V", "markers", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/util/Segment;", "Lkotlin/collections/ArrayList;", "show", "", "blinkingAlarm", "Lcom/intellij/util/SingleAlarm;", "addedHighlighters", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "resetMarkers", "", "", "removeHighlights", "startBlinking", "stopBlinking", "intellij.platform.ide"})
@ApiStatus.Internal
public final class RangeBlinker {
    @NotNull
    private final Editor editor;
    @NotNull
    private final TextAttributes attributes;
    private int timeToLive;
    @NotNull
    private final ArrayList<Segment> markers;
    private boolean show;
    @NotNull
    private final SingleAlarm blinkingAlarm;
    @NotNull
    private final ArrayList<RangeHighlighter> addedHighlighters;

    public RangeBlinker(@NotNull Editor editor, @NotNull TextAttributes attributes, int timeToLive, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.editor = editor;
        this.attributes = attributes;
        this.timeToLive = timeToLive;
        this.markers = new ArrayList();
        this.show = true;
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        Runnable runnable = () -> RangeBlinker.blinkingAlarm$lambda$0(this);
        this.blinkingAlarm = new SingleAlarm(runnable, 400, parentDisposable, threadToUse, null, null, 48, null);
        this.addedHighlighters = new ArrayList();
    }

    public final void resetMarkers(@NotNull List<? extends Segment> markers) {
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        this.removeHighlights();
        this.markers.clear();
        this.stopBlinking();
        this.markers.addAll((Collection<Segment>)markers);
        this.show = true;
    }

    private final void removeHighlights() {
        MarkupModel markupModel = this.editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        Object[] objectArray = markupModel2.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllHighlighters(...)");
        Object[] allHighlighters = objectArray;
        Iterator<RangeHighlighter> iterator = this.addedHighlighters.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RangeHighlighter> iterator2 = iterator;
        while (iterator2.hasNext()) {
            RangeHighlighter highlighter;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (ArraysKt.indexOf((Object[])allHighlighters, (Object)highlighter) == -1) continue;
            highlighter.dispose();
        }
        this.addedHighlighters.clear();
    }

    public final void startBlinking() {
        Project project = this.editor.getProject();
        if (ApplicationManager.getApplication().isDisposed() || this.editor.isDisposed() || project != null && project.isDisposed()) {
            return;
        }
        MarkupModel markupModel = this.editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        if (this.show) {
            Iterator<Segment> iterator = this.markers.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Segment> iterator2 = iterator;
            while (iterator2.hasNext()) {
                RangeHighlighter highlighter;
                Segment segment;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (segment.getEndOffset() > this.editor.getDocument().getTextLength()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)markupModel2.addRangeHighlighter(segment.getStartOffset(), segment.getEndOffset(), 3000, this.attributes, HighlighterTargetArea.EXACT_RANGE), (String)"addRangeHighlighter(...)");
                this.addedHighlighters.add(highlighter);
            }
        } else {
            this.removeHighlights();
        }
        this.blinkingAlarm.scheduleCancelAndRequest();
    }

    public final void stopBlinking() {
        this.blinkingAlarm.cancel();
    }

    private static final void blinkingAlarm$lambda$0(RangeBlinker this$0) {
        if (this$0.timeToLive > 0 || this$0.show) {
            int n = this$0.timeToLive;
            this$0.timeToLive = n + -1;
            this$0.show = !this$0.show;
            this$0.startBlinking();
        }
    }
}

