/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.Painter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPainter
implements Painter {
    private boolean isRepaintNeeded;
    private final List<Painter.Listener> listeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    public boolean needsRepaint() {
        return this.isRepaintNeeded;
    }

    public void setNeedsRepaint(boolean needsRepaint) {
        this.setNeedsRepaint(needsRepaint, null);
    }

    public void setNeedsRepaint(boolean value2, @Nullable JComponent dirtyComponent) {
        this.isRepaintNeeded = value2;
        if (this.isRepaintNeeded) {
            this.fireNeedsRepaint(dirtyComponent);
        }
    }

    @Override
    public void addListener(@NotNull Painter.Listener listener2) {
        if (listener2 == null) {
            AbstractPainter.$$$reportNull$$$0(0);
        }
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull Painter.Listener listener2) {
        if (listener2 == null) {
            AbstractPainter.$$$reportNull$$$0(1);
        }
        this.listeners.remove(listener2);
    }

    @Nullable
    public <T> T setNeedsRepaint(T oldValue, T newValue) {
        if (!this.isRepaintNeeded) {
            if (oldValue == null) {
                this.setNeedsRepaint(newValue != null);
            } else {
                this.setNeedsRepaint(!oldValue.equals(newValue));
            }
        }
        return newValue;
    }

    protected void fireNeedsRepaint(JComponent dirtyComponent) {
        for (Painter.Listener each : this.listeners) {
            each.onNeedsRepaint(this, dirtyComponent);
        }
    }

    @Override
    public final void paint(@NotNull Component component, @NotNull Graphics2D g) {
        if (component == null) {
            AbstractPainter.$$$reportNull$$$0(2);
        }
        if (g == null) {
            AbstractPainter.$$$reportNull$$$0(3);
        }
        this.isRepaintNeeded = false;
        this.executePaint(component, g);
    }

    public abstract void executePaint(@NotNull Component var1, @NotNull Graphics2D var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/AbstractPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

