/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public final class ExpandedItemListCellRendererWrapper<T>
implements ListCellRenderer<T> {
    @NotNull
    private final ListCellRenderer<? super T> myWrappee;
    @NotNull
    private final ExpandableItemsHandler<Integer> myHandler;

    public ExpandedItemListCellRendererWrapper(@NotNull ListCellRenderer<? super T> wrappee, @NotNull ExpandableItemsHandler<Integer> handler) {
        if (wrappee == null) {
            ExpandedItemListCellRendererWrapper.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            ExpandedItemListCellRendererWrapper.$$$reportNull$$$0(1);
        }
        this.myWrappee = wrappee;
        this.myHandler = handler;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value2, int index, boolean isSelected, boolean cellHasFocus) {
        GraphicsUtil.setAntialiasingType(list, (Object)AntialiasingType.getAATextInfoForSwingComponent());
        Component result2 = this.myWrappee.getListCellRendererComponent(list, UIUtil.htmlInjectionGuard(value2), index, isSelected, cellHasFocus);
        if (!this.myHandler.getExpandedItems().contains(index)) {
            return result2;
        }
        Rectangle bounds = result2.getBounds();
        ExpandedItemRendererComponentWrapper wrapper = ExpandedItemRendererComponentWrapper.wrap(result2);
        if (ClientProperty.isTrue(list, ExpandableItemsHandler.EXPANDED_RENDERER) && ClientProperty.isTrue((Component)result2, ExpandableItemsHandler.USE_RENDERER_BOUNDS)) {
            wrapper.setBounds(bounds);
            wrapper.putClientProperty(ExpandableItemsHandler.USE_RENDERER_BOUNDS, true);
        }
        wrapper.owner = list;
        return wrapper;
    }

    public String toString() {
        return "ExpandedItemListCellRendererWrapper[" + this.getWrappee().getClass().getName() + "]";
    }

    @NotNull
    public ListCellRenderer getWrappee() {
        ListCellRenderer<? super T> listCellRenderer2 = this.myWrappee;
        if (listCellRenderer2 == null) {
            ExpandedItemListCellRendererWrapper.$$$reportNull$$$0(2);
        }
        return listCellRenderer2;
    }

    public static <T> ListCellRenderer<T> unwrap(ListCellRenderer<T> renderer) {
        if (renderer instanceof ExpandedItemListCellRendererWrapper) {
            ExpandedItemListCellRendererWrapper wrapper = (ExpandedItemListCellRendererWrapper)renderer;
            return wrapper.getWrappee();
        }
        return renderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappee";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ExpandedItemListCellRendererWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ExpandedItemListCellRendererWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappee";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

