/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.JdkProxyProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/util/net/HttpConnectionUtils;", "", "<init>", "()V", "prepareUrl", "", "url", "", "openConnection", "Ljava/net/URLConnection;", "location", "openHttpConnection", "Ljava/net/HttpURLConnection;", "intellij.platform.ide"})
public final class HttpConnectionUtils {
    @NotNull
    public static final HttpConnectionUtils INSTANCE = new HttpConnectionUtils();

    private HttpConnectionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void prepareUrl(@NotNull String url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection connection = HttpConnectionUtils.openConnection(url);
        try {
            connection.connect();
            connection.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final URLConnection openConnection(@NotNull String location) throws IOException {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        URL url = new URL(location);
        URLConnection urlConnection = null;
        List<Proxy> proxies = JdkProxyProvider.Companion.getInstance().getProxySelector().select(VfsUtil.toUri((String)url.toString()));
        if (proxies.isEmpty()) {
            urlConnection = url.openConnection();
        } else {
            IOException exception = null;
            for (Proxy proxy : proxies) {
                try {
                    urlConnection = url.openConnection(proxy);
                    break;
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            if (urlConnection == null && exception != null) {
                throw exception;
            }
        }
        if (!(urlConnection != null)) {
            throw new IllegalStateException("Check failed.");
        }
        urlConnection.setReadTimeout(HttpRequests.READ_TIMEOUT);
        urlConnection.setConnectTimeout(HttpRequests.CONNECTION_TIMEOUT);
        return urlConnection;
    }

    @JvmStatic
    @NotNull
    public static final HttpURLConnection openHttpConnection(@NotNull String location) throws IOException {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        URLConnection urlConnection = HttpConnectionUtils.openConnection(location);
        if (urlConnection instanceof HttpURLConnection) {
            return (HttpURLConnection)urlConnection;
        }
        throw new IOException("Expected " + Reflection.getOrCreateKotlinClass(HttpURLConnection.class) + ", but got " + Reflection.getOrCreateKotlinClass(urlConnection.getClass()));
    }
}

