/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentedSettings;
import com.intellij.execution.ui.FragmentedSettingsBuilder;
import com.intellij.execution.ui.NestedGroupFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class FragmentedSettingsEditor<Settings extends FragmentedSettings>
extends CompositeSettingsEditor<Settings> {
    private final NotNullLazyValue<Collection<SettingsEditorFragment<Settings, ?>>> myFragments = NotNullLazyValue.createValue(() -> {
        Collection<SettingsEditorFragment<Settings, ?>> fragments2 = this.createFragments();
        this.initFragments(fragments2);
        return fragments2;
    });
    protected final Settings mySettings;

    protected FragmentedSettingsEditor(Settings settings) {
        this.mySettings = settings;
    }

    protected boolean isDefaultSettings() {
        return false;
    }

    protected abstract Collection<SettingsEditorFragment<Settings, ?>> createFragments();

    @NotNull
    protected final Collection<SettingsEditorFragment<Settings, ?>> getFragments() {
        Collection collection = (Collection)this.myFragments.getValue();
        if (collection == null) {
            FragmentedSettingsEditor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private Stream<SettingsEditorFragment<Settings, ?>> getAllFragments() {
        return this.getFragments().stream().flatMap(fragment -> Stream.concat(fragment.getChildren().stream(), Stream.of(fragment)));
    }

    public void resetEditorFrom(@NotNull Settings settings) {
        if (settings == null) {
            FragmentedSettingsEditor.$$$reportNull$$$0(1);
        }
        super.resetEditorFrom(settings);
        List options = settings.getSelectedOptions();
        Iterator<SettingsEditorFragment<Settings, ?>> iterator = this.getAllFragments().toList().iterator();
        while (iterator.hasNext()) {
            SettingsEditorFragment<Settings, ?> fragment;
            FragmentedSettings.Option option = (FragmentedSettings.Option)ContainerUtil.find((Iterable)options, arg_0 -> FragmentedSettingsEditor.lambda$resetEditorFrom$2(fragment = iterator.next(), arg_0));
            fragment.setSelected(option == null ? fragment.isInitiallyVisible(settings) : option.getVisible());
        }
    }

    public void applyEditorTo(@NotNull Settings settings) throws ConfigurationException {
        if (settings == null) {
            FragmentedSettingsEditor.$$$reportNull$$$0(2);
        }
        super.applyEditorTo(settings);
        List<SettingsEditorFragment<Settings, ?>> fragments2 = this.getAllFragments().toList();
        fragments2.forEach(f -> f.validate(settings));
        List options = fragments2.stream().filter(fragment -> (this.isDefaultSettings() || fragment.isCanBeHidden()) && fragment.isSelected() != fragment.isInitiallyVisible(settings)).map(fragment -> new FragmentedSettings.Option(fragment.getId(), fragment.isSelected())).collect(Collectors.toList());
        if (!this.isDefaultSettings()) {
            for (FragmentedSettings.Option option : settings.getSelectedOptions()) {
                if (ContainerUtil.or(options, o -> o.getName().equals(option.getName()))) continue;
                SettingsEditorFragment fragment2 = (SettingsEditorFragment)((Object)ContainerUtil.find(fragments2, f -> f.getId().equals(option.getName())));
                if (fragment2 != null) {
                    if (fragment2.isSelected() == fragment2.isInitiallyVisible(settings)) continue;
                    FragmentedSettings.Option updatedOption = new FragmentedSettings.Option(fragment2.getId(), fragment2.isSelected());
                    options.add(updatedOption);
                    continue;
                }
                options.add(option);
            }
        }
        settings.setSelectedOptions(options);
    }

    @NotNull
    public FragmentedSettingsBuilder<Settings> getBuilder() {
        return new FragmentedSettingsBuilder<Settings>(this.getFragments(), null, (Disposable)this);
    }

    public void installWatcher(JComponent c) {
        super.installWatcher(c);
        this.addSettingsEditorListener(editor -> SwingUtilities.invokeLater(() -> UIUtil.setupEnclosingDialogBounds((JComponent)c)));
        this.installFragmentsAligner();
    }

    protected void initFragments(Collection<? extends SettingsEditorFragment<Settings, ?>> fragments2) {
    }

    public boolean isReadyForApply() {
        return ContainerUtil.all(this.getFragments(), fragment -> fragment.isReadyForApply());
    }

    private void installFragmentsAligner() {
        FragmentedSettingsEditor.installFragmentsAligner(this);
        for (SettingsEditorFragment<Settings, ?> fragment : this.getFragments()) {
            if (!(fragment instanceof NestedGroupFragment)) continue;
            FragmentedSettingsEditor.installFragmentsAligner(fragment);
        }
    }

    private static void installFragmentsAligner(@NotNull SettingsEditor<?> fragment) {
        if (fragment == null) {
            FragmentedSettingsEditor.$$$reportNull$$$0(3);
        }
        JComponent component = fragment.getComponent();
        for (Component childComponent : component.getComponents()) {
            if (!(childComponent instanceof PanelWithAnchor)) continue;
            UIUtil.runWhenVisibilityChanged((Component)childComponent, () -> SwingUtilities.invokeLater(() -> FragmentedSettingsEditor.alignPanels(component)));
        }
    }

    private static void alignPanels(@NotNull JComponent container) {
        if (container == null) {
            FragmentedSettingsEditor.$$$reportNull$$$0(4);
        }
        List panels = Arrays.stream(container.getComponents()).filter(component -> component.isVisible()).filter(component -> component instanceof PanelWithAnchor).map(component -> (PanelWithAnchor)component).collect(Collectors.toList());
        UIUtil.mergeComponentsWithAnchor(panels, (boolean)true);
    }

    private static /* synthetic */ boolean lambda$resetEditorFrom$2(SettingsEditorFragment fragment, FragmentedSettings.Option o) {
        return fragment.getId().equals(o.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/FragmentedSettingsEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragments";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/FragmentedSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installFragmentsAligner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "alignPanels";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

