/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.CachedTreePresentationData;
import com.intellij.ide.util.treeView.PathElementIdProvider;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeIconCachingKt;
import com.intellij.ide.util.treeView.TreeNodeWithCacheableAttributes;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0002H\u0016J\u0016\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0014H\u0016R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\f\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/util/treeView/CachedTreePresentationNode;", "Lcom/intellij/ide/util/treeView/PresentableNodeDescriptor;", "Lcom/intellij/ide/util/treeView/CachedTreePresentationData;", "Lcom/intellij/ide/util/treeView/PathElementIdProvider;", "Lcom/intellij/ide/util/treeView/TreeNodeWithCacheableAttributes;", "data", "<init>", "(Lcom/intellij/ide/util/treeView/CachedTreePresentationData;)V", "getData", "()Lcom/intellij/ide/util/treeView/CachedTreePresentationData;", "isLeaf", "", "()Z", "isExpanded", "setExpanded", "(Z)V", "matches", "node", "", "getPathElementType", "", "getPathElementId", "getElement", "getCacheableAttributes", "", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "toString", "intellij.platform.ide"})
@ApiStatus.Internal
public final class CachedTreePresentationNode
extends PresentableNodeDescriptor<CachedTreePresentationData>
implements PathElementIdProvider,
TreeNodeWithCacheableAttributes {
    @NotNull
    private final CachedTreePresentationData data;
    private boolean isExpanded;

    public CachedTreePresentationNode(@NotNull CachedTreePresentationData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(null, null);
        this.data = data;
        this.isExpanded = !((Collection)this.data.getChildren()).isEmpty();
        this.update();
    }

    @NotNull
    public final CachedTreePresentationData getData() {
        return this.data;
    }

    public final boolean isLeaf() {
        return this.data.getPresentation().isLeaf();
    }

    public final boolean isExpanded() {
        return this.isExpanded;
    }

    public final void setExpanded(boolean bl) {
        this.isExpanded = bl;
    }

    public final boolean matches(@NotNull Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.data.getPathElement().matches(node);
    }

    @NotNull
    public String getPathElementType() {
        String string = this.data.getPathElement().getType();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public String getPathElementId() {
        String string = this.data.getPathElement().getId();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public CachedTreePresentationData getElement() {
        return this.data;
    }

    @Override
    @Nullable
    public Map<String, String> getCacheableAttributes() {
        return this.data.getExtraAttributes();
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setPresentableText(this.data.getPresentation().getText());
        presentation.setIcon(TreeIconCachingKt.getIcon(this.data.getPresentation()));
    }

    @NotNull
    public String toString() {
        return "(cached) " + super.toString();
    }
}

