/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.openapi.util.NlsContexts;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseListPopupStep<T>
extends BaseStep<T>
implements ListPopupStep<T> {
    private @NlsContexts.PopupTitle String myTitle;
    private List<T> myValues;
    private List<? extends Icon> myIcons;
    private int myDefaultOptionIndex;

    @SafeVarargs
    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, T ... values) {
        if (values == null) {
            BaseListPopupStep.$$$reportNull$$$0(0);
        }
        this(title, values, new Icon[0]);
    }

    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, List<? extends T> values) {
        this(title, values, new ArrayList());
    }

    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, T[] values, Icon[] icons) {
        this(title, Arrays.asList(values), Arrays.asList(icons));
    }

    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, @NotNull List<? extends T> aValues, Icon aSameIcon) {
        if (aValues == null) {
            BaseListPopupStep.$$$reportNull$$$0(1);
        }
        this.myDefaultOptionIndex = -1;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (int i = 0; i < aValues.size(); ++i) {
            icons.add(aSameIcon);
        }
        this.init(title, aValues, icons);
    }

    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, @NotNull List<? extends T> values, List<? extends Icon> icons) {
        if (values == null) {
            BaseListPopupStep.$$$reportNull$$$0(2);
        }
        this.myDefaultOptionIndex = -1;
        this.init(title, values, icons);
    }

    protected BaseListPopupStep() {
        this.myDefaultOptionIndex = -1;
    }

    protected final void init(@NlsContexts.PopupTitle @Nullable String title, @NotNull List<? extends T> values, @Nullable List<? extends Icon> icons) {
        if (values == null) {
            BaseListPopupStep.$$$reportNull$$$0(3);
        }
        this.myTitle = title;
        this.myValues = new ArrayList<T>(values);
        this.myIcons = icons;
    }

    @Nullable
    public final String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public final List<T> getValues() {
        List<T> list = this.myValues;
        if (list == null) {
            BaseListPopupStep.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public PopupStep<?> onChosen(T selectedValue, boolean finalChoice) {
        return FINAL_CHOICE;
    }

    public Icon getIconFor(T value2) {
        int index = this.myValues.indexOf(value2);
        if (index != -1 && this.myIcons != null && index < this.myIcons.size()) {
            return this.myIcons.get(index);
        }
        return null;
    }

    @Nullable
    public Color getBackgroundFor(T value2) {
        return null;
    }

    @Nullable
    public Color getForegroundFor(T value2) {
        return null;
    }

    @NotNull
    public String getTextFor(T value2) {
        String string = value2.toString();
        if (string == null) {
            BaseListPopupStep.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(T value2) {
        return null;
    }

    public boolean isSelectable(T value2) {
        return true;
    }

    public boolean hasSubstep(T selectedValue) {
        return false;
    }

    public void canceled() {
    }

    public void setDefaultOptionIndex(int aDefaultOptionIndex) {
        this.myDefaultOptionIndex = aDefaultOptionIndex;
    }

    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }

    @ApiStatus.Internal
    public boolean isLazyUiSnapshot() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aValues";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/popup/util/BaseListPopupStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/popup/util/BaseListPopupStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

