/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCardLayout
extends CardLayout {
    private final Map<String, Component> myMap = new LinkedHashMap<String, Component>();
    private static final int mySwipeTime = 200;
    private static final int mySwipeSteps = 20;
    private final Timer myTimer = TimerUtil.createNamedTimer((String)"CardLayoutTimer", (int)Math.max(1, 10));
    private Component mySwipeFrom = null;
    private Component mySwipeTo = null;

    public JBCardLayout() {
        this(0, 0);
    }

    public JBCardLayout(int hgap, int vgap) {
        super(hgap, vgap);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        super.addLayoutComponent(name, comp);
        this.myMap.put(name, comp);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.stopSwipeIfNeeded();
        super.removeLayoutComponent(comp);
        Iterator<Map.Entry<String, Component>> iterator = this.myMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Component> entry = iterator.next();
            if (entry.getValue() != comp) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!this.myTimer.isRunning()) {
            super.layoutContainer(parent);
        }
    }

    public void swipe(@NotNull Container parent, @NotNull String name, @NotNull SwipeDirection direction) {
        if (parent == null) {
            JBCardLayout.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JBCardLayout.$$$reportNull$$$0(1);
        }
        if (direction == null) {
            JBCardLayout.$$$reportNull$$$0(2);
        }
        this.swipe(parent, name, direction, null);
    }

    public void swipe(final @NotNull Container parent, final @NotNull String name, @NotNull SwipeDirection direction, final @Nullable Runnable onDone) {
        boolean isForward;
        if (parent == null) {
            JBCardLayout.$$$reportNull$$$0(3);
        }
        if (name == null) {
            JBCardLayout.$$$reportNull$$$0(4);
        }
        if (direction == null) {
            JBCardLayout.$$$reportNull$$$0(5);
        }
        this.stopSwipeIfNeeded();
        this.mySwipeFrom = JBCardLayout.findVisible(parent);
        this.mySwipeTo = this.myMap.get(name);
        if (this.mySwipeTo == null) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (this.mySwipeFrom == null || this.mySwipeFrom == this.mySwipeTo || app != null && app.isUnitTestMode()) {
            super.show(parent, name);
            if (onDone != null) {
                onDone.run();
            }
            return;
        }
        if (direction == SwipeDirection.AUTO) {
            boolean b = true;
            for (Component component : this.myMap.values()) {
                if (component != this.mySwipeFrom && component != this.mySwipeTo) continue;
                b = component == this.mySwipeFrom;
                break;
            }
            isForward = b;
        } else {
            isForward = direction == SwipeDirection.FORWARD;
        }
        final double[] linearProgress = new double[]{0.0};
        final long startTime = System.currentTimeMillis();
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long timePassed = System.currentTimeMillis() - startTime;
                if (timePassed >= 200L) {
                    Component currentFocusComponent = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)parent);
                    JBCardLayout.this.show(parent, name);
                    if (currentFocusComponent != null) {
                        currentFocusComponent.requestFocusInWindow();
                    }
                    if (onDone != null) {
                        onDone.run();
                    }
                    return;
                }
                linearProgress[0] = MathUtil.clamp((float)((float)timePassed / 200.0f), (float)0.0f, (float)1.0f);
                double naturalProgress = (1.0 - Math.cos(Math.PI * linearProgress[0])) / 2.0;
                Rectangle bounds = new Rectangle(parent.getWidth(), parent.getHeight());
                JBInsets.removeFrom((Rectangle)bounds, (Insets)parent.getInsets());
                Rectangle r = new Rectangle(bounds);
                int x = (int)(naturalProgress * (double)r.width);
                r.translate(isForward ? -x : x, 0);
                JBCardLayout.this.mySwipeFrom.setBounds(r);
                Rectangle r2 = new Rectangle(bounds);
                r2.translate(isForward ? r2.width - x : x - r2.width, 0);
                JBCardLayout.this.mySwipeTo.setVisible(true);
                JBCardLayout.this.mySwipeTo.setBounds(r2);
                parent.repaint();
            }
        };
        for (ActionListener actionListener : this.myTimer.getActionListeners()) {
            this.myTimer.removeActionListener(actionListener);
        }
        this.myTimer.addActionListener(listener2);
        this.myTimer.start();
    }

    private void stopSwipeIfNeeded() {
        if (this.myTimer.isRunning()) {
            this.myTimer.stop();
            this.mySwipeFrom = null;
            if (this.mySwipeTo != null) {
                this.mySwipeTo.setVisible(false);
                this.mySwipeTo = null;
            }
        }
    }

    @Nullable
    private static Component findVisible(Container parent) {
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component component = parent.getComponent(i);
            if (!component.isVisible()) continue;
            return component;
        }
        return null;
    }

    @Override
    public void first(Container parent) {
        this.stopSwipeIfNeeded();
        super.first(parent);
    }

    @Override
    public void next(Container parent) {
        this.stopSwipeIfNeeded();
        super.next(parent);
    }

    @Override
    public void previous(Container parent) {
        this.stopSwipeIfNeeded();
        super.previous(parent);
    }

    @Override
    public void last(Container parent) {
        this.stopSwipeIfNeeded();
        super.last(parent);
    }

    @Override
    public void show(Container parent, String name) {
        this.stopSwipeIfNeeded();
        super.show(parent, name);
    }

    public static void main(String[] args) throws IOException {
        final JBCardLayout cardLayout = new JBCardLayout();
        JFrame f = new JFrame();
        JPanel p = new JPanel(new BorderLayout());
        final JPanel centerPanel = new JPanel(cardLayout);
        for (int i = 0; i < 10; ++i) {
            JLabel l = new JLabel("Page #" + (i + 1), 0);
            l.setOpaque(true);
            int red = 50 + (int)(Math.random() * 100.0);
            int green = 50 + (int)(Math.random() * 100.0);
            int blue = 50 + (int)(Math.random() * 100.0);
            l.setForeground(new Color(red, green, blue));
            red = 255 - (int)(Math.random() * 55.0);
            green = 255 - (int)(Math.random() * 55.0);
            blue = 255 - (int)(Math.random() * 55.0);
            l.setBackground(new Color(red, green, blue));
            l.setFont(l.getFont().deriveFont(40.0f));
            centerPanel.add((Component)l, "page" + i);
        }
        final int[] cursor = new int[1];
        JButton prevButton = new JButton("<<");
        JButton nextButton = new JButton(">>");
        prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cursor[0] = cursor[0] - 1;
                if (cursor[0] < 0) {
                    cursor[0] = 9;
                }
                cardLayout.swipe(centerPanel, "page" + cursor[0], SwipeDirection.BACKWARD);
            }
        });
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cursor[0] = (cursor[0] + 1) % 10;
                cardLayout.swipe(centerPanel, "page" + cursor[0], SwipeDirection.FORWARD);
            }
        });
        p.setLayout(new BorderLayout());
        p.add((Component)prevButton, "West");
        p.add((Component)centerPanel, "Center");
        p.add((Component)nextButton, "East");
        f.setContentPane(p);
        f.setSize((Dimension)JBUI.size((int)600, (int)800));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public Component findComponentById(String id) {
        return this.myMap.get(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "direction";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/JBCardLayout";
        objectArray[2] = "swipe";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum SwipeDirection {
        FORWARD,
        BACKWARD,
        AUTO;

    }
}

