/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RelativeFont
implements PropertyChangeListener {
    private static final float MULTIPLIER = 1.09f;
    private static final float MINIMUM_FONT_SIZE = 1.0f;
    public static final RelativeFont NORMAL = new RelativeFont(null, null, null);
    public static final RelativeFont PLAIN = NORMAL.style(0);
    public static final RelativeFont BOLD = NORMAL.style(1);
    public static final RelativeFont ITALIC = NORMAL.style(2);
    public static final RelativeFont LARGE = NORMAL.large();
    public static final RelativeFont SMALL = NORMAL.small();
    public static final RelativeFont HUGE = LARGE.large();
    public static final RelativeFont TINY = SMALL.small();
    private static final String PROPERTY = "font";
    private final String myFamily;
    private final Integer myStyle;
    private final Float mySize;
    private final float myMinimumSize;

    private RelativeFont(String family, Integer style, Float size, Float minimumSize) {
        this.myFamily = family;
        this.myStyle = style;
        this.mySize = size;
        this.myMinimumSize = minimumSize.floatValue();
    }

    private RelativeFont(String family, Integer style, Float size) {
        this(family, style, size, Float.valueOf(1.0f));
    }

    public RelativeFont family(String family) {
        return family.equals(this.myFamily) ? this : new RelativeFont(family, this.myStyle, this.mySize);
    }

    public RelativeFont style(int style) {
        return null != this.myStyle && this.myStyle == style ? this : new RelativeFont(this.myFamily, style, this.mySize);
    }

    public RelativeFont large() {
        float size = this.mySize == null ? 1.0f : this.mySize.floatValue();
        return new RelativeFont(this.myFamily, this.myStyle, Float.valueOf(size * 1.09f));
    }

    public RelativeFont small() {
        float size = this.mySize == null ? 1.0f : this.mySize.floatValue();
        return new RelativeFont(this.myFamily, this.myStyle, Float.valueOf(size / 1.09f));
    }

    @NotNull
    public RelativeFont fromResource(@NonNls @NotNull String propertyName, int defaultOffset) {
        if (propertyName == null) {
            RelativeFont.$$$reportNull$$$0(0);
        }
        RelativeFont relativeFont = this.fromResource(propertyName, defaultOffset, 1.0f);
        if (relativeFont == null) {
            RelativeFont.$$$reportNull$$$0(1);
        }
        return relativeFont;
    }

    @NotNull
    public RelativeFont fromResource(@NonNls @NotNull String propertyName, int defaultOffset, float minSize) {
        int offset;
        if (propertyName == null) {
            RelativeFont.$$$reportNull$$$0(2);
        }
        RelativeFont relativeFont = (offset = JBUI.getInt((String)propertyName, (int)defaultOffset)) == 0 ? this : this.scale(offset, minSize);
        if (relativeFont == null) {
            RelativeFont.$$$reportNull$$$0(3);
        }
        return relativeFont;
    }

    @NotNull
    public RelativeFont scale(int offset) {
        RelativeFont relativeFont = this.scale(offset, 1.0f);
        if (relativeFont == null) {
            RelativeFont.$$$reportNull$$$0(4);
        }
        return relativeFont;
    }

    @NotNull
    public RelativeFont scale(int offset, float minSize) {
        float multiplier = (float)Math.pow(1.09f, offset);
        return new RelativeFont(this.myFamily, this.myStyle, Float.valueOf(this.mySize != null ? this.mySize.floatValue() * multiplier : multiplier), Float.valueOf(minSize));
    }

    public <T extends Component> T install(T component) {
        Font font = this.derive(component.getFont());
        if (font != null) {
            component.setFont(new MyFont(font));
        }
        RelativeFont.uninstallFrom(component);
        component.addPropertyChangeListener(PROPERTY, this);
        return component;
    }

    public static <T extends Component> T uninstallFrom(T component) {
        for (PropertyChangeListener listener2 : component.getPropertyChangeListeners(PROPERTY)) {
            if (!(listener2 instanceof RelativeFont)) continue;
            component.removePropertyChangeListener(PROPERTY, listener2);
        }
        return component;
    }

    public Font derive(Font font) {
        if (font == null) {
            return null;
        }
        boolean isSizeConsidered = false;
        boolean isOriginalFontUIResource = font instanceof UIResource;
        if (null != this.myFamily && !this.myFamily.equals(font.getFamily(Locale.ENGLISH))) {
            int style = null != this.myStyle ? this.myStyle.intValue() : font.getStyle();
            font = new Font(this.myFamily, style, font.getSize());
        } else if (null != this.myStyle && this.myStyle.intValue() != font.getStyle()) {
            isSizeConsidered = true;
            Font font2 = font = this.mySize != null ? font.deriveFont((int)this.myStyle, Math.max(this.mySize.floatValue() * font.getSize2D(), this.myMinimumSize)) : font.deriveFont(this.myStyle);
        }
        if (this.mySize != null && !isSizeConsidered) {
            font = font.deriveFont(Math.max(this.mySize.floatValue() * font.getSize2D(), this.myMinimumSize));
        }
        if (font != null && isOriginalFontUIResource && !(font instanceof UIResource)) {
            font = new FontUIResource(font);
        }
        return font;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object object;
        if (!(event.getNewValue() instanceof MyFont) && (object = event.getSource()) instanceof Component) {
            Font font;
            Component component = (Component)object;
            if (PROPERTY.equals(event.getPropertyName()) && (font = this.derive(event.getNewValue() instanceof Font ? (Font)event.getNewValue() : component.getFont())) != null) {
                component.setFont(new MyFont(font));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/RelativeFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/RelativeFont";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromResource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromResource";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyFont
    extends FontUIResource {
        private MyFont(Font font) {
            super(font);
        }
    }
}

