/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegateWithContextMenu;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColoredTreeCellRenderer
extends SimpleColoredComponent
implements TreeCellRenderer {
    private static final Logger LOG = Logger.getInstance(ColoredTreeCellRenderer.class);
    private static final Icon LOADING_NODE_ICON = JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)8, (int)16));
    protected boolean mySelected;
    private boolean myFocused;
    private boolean myFocusedCalculated;
    protected boolean myUsedCustomSpeedSearchHighlighting;
    protected JTree myTree;
    private boolean myOpaque = true;
    @Nullable
    @Nls
    private String myAccessibleStatusText = null;

    @Override
    public final Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        try {
            this.rendererComponentInner(tree, value2, selected2, expanded, leaf, row, hasFocus);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                LOG.error((Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    private void rendererComponentInner(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.myTree = tree;
        this.clear();
        this.mySelected = selected2;
        this.myFocusedCalculated = false;
        if (UIUtil.isFullRowSelectionLAF()) {
            this.setBackground(selected2 ? UIUtil.getTreeSelectionBackground((boolean)true) : null);
        } else if (WideSelectionTreeUI.isWideSelection((JTree)tree)) {
            this.setPaintFocusBorder(false);
            if (selected2) {
                this.setBackground(RenderingUtil.getSelectionBackground((JTree)tree));
            } else {
                this.setBackground(null);
            }
        } else if (selected2) {
            this.setPaintFocusBorder(true);
            if (this.isFocused()) {
                this.setBackground(UIUtil.getTreeSelectionBackground((boolean)true));
            } else {
                this.setBackground(null);
            }
        } else {
            this.setBackground(null);
        }
        if (value2 instanceof LoadingNode) {
            this.setForeground((Color)JBColor.GRAY);
            this.setIcon(LOADING_NODE_ICON);
        } else {
            this.setForeground(RenderingUtil.getForeground((JTree)tree, (boolean)selected2));
            this.setIcon(null);
        }
        if (WideSelectionTreeUI.isWideSelection((JTree)tree)) {
            super.setOpaque(false);
            super.setIconOpaque(false);
        } else {
            super.setOpaque(this.myOpaque || selected2 && hasFocus || selected2 && this.isFocused());
        }
        this.customizeCellRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
        if (!this.myUsedCustomSpeedSearchHighlighting && !(value2 instanceof LoadingNode)) {
            SpeedSearchUtil.applySpeedSearchHighlightingFiltered(tree, value2, this, true, selected2);
        }
    }

    public JTree getTree() {
        return this.myTree;
    }

    protected final boolean isFocused() {
        if (!this.myFocusedCalculated) {
            this.myFocused = this.calcFocusedState();
            this.myFocusedCalculated = true;
        }
        return this.myFocused;
    }

    protected boolean calcFocusedState() {
        return this.myTree.hasFocus();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        this.myOpaque = isOpaque;
        super.setOpaque(isOpaque);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font != null) {
            return font;
        }
        JTree tree = this.getTree();
        return tree != null ? tree.getFont() : null;
    }

    @Override
    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            ColoredTreeCellRenderer.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            ColoredTreeCellRenderer.$$$reportNull$$$0(1);
        }
        if (this.mySelected && this.isFocused() && JBUI.CurrentTheme.Tree.Selection.forceFocusedSelectionForeground()) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), UIUtil.getTreeSelectionForeground((boolean)true)), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }

    @Override
    protected void revalidateAndRepaint() {
    }

    public abstract void customizeCellRenderer(@NotNull JTree var1, Object var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

    @ApiStatus.Experimental
    public void setAccessibleStatusText(@Nullable @Nls String accessibleStatusText) {
        this.myAccessibleStatusText = accessibleStatusText;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleColoredTreeCellRendererWithContextMenu();
        }
        return this.accessibleContext;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fragment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "attributes";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/ColoredTreeCellRenderer";
        objectArray[2] = "append";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class AccessibleColoredTreeCellRendererWithContextMenu
    extends AccessibleContextDelegateWithContextMenu {
        public AccessibleColoredTreeCellRendererWithContextMenu(AccessibleColoredTreeCellRenderer context) {
            super((AccessibleContext)context);
        }

        public AccessibleColoredTreeCellRendererWithContextMenu() {
            super((AccessibleContext)new AccessibleColoredTreeCellRenderer());
        }

        protected void doShowContextMenu() {
            ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("ShowPopupMenu"), null, null, null, true);
        }

        protected Container getDelegateParent() {
            return ColoredTreeCellRenderer.this.getParent();
        }
    }

    protected class AccessibleColoredTreeCellRenderer
    extends SimpleColoredComponent.AccessibleSimpleColoredComponent {
        protected AccessibleColoredTreeCellRenderer() {
            super(ColoredTreeCellRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            Object name = this.getOriginalAccessibleName();
            if (ColoredTreeCellRenderer.this.myAccessibleStatusText != null && !ColoredTreeCellRenderer.this.myAccessibleStatusText.isEmpty()) {
                if (name == null) {
                    name = ColoredTreeCellRenderer.this.myAccessibleStatusText;
                } else {
                    if (!((String)name).endsWith(",")) {
                        name = (String)name + ",";
                    }
                    name = (String)name + " " + ColoredTreeCellRenderer.this.myAccessibleStatusText + ".";
                }
            }
            return name;
        }

        @Nullable
        @Nls
        protected String getOriginalAccessibleName() {
            return super.getAccessibleName();
        }
    }
}

