/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HighlightableComponent;
import com.intellij.ui.HighlightedRegion;
import com.intellij.ui.HighlightedText;
import com.intellij.ui.JBColor;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperlinkLabel
extends HighlightableComponent {
    private static final TextAttributes BOLD_ATTRIBUTES = new TextAttributes((Color)JBColor.lazy(() -> {
        Color foreground1 = UIUtil.getLabelTextForeground();
        return foreground1 == null ? UIUtil.getLabelForeground() : foreground1;
    }), null, null, null, 1);
    private static final Logger LOG = Logger.getInstance((String)HyperlinkLabel.class.getName());
    private static final String startTag = "<hyperlink>";
    private static final String finishTag = "</hyperlink>";
    private UIUtil.FontSize myFontSize;
    private HighlightedText myHighlightedText;
    private final List<HyperlinkListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myUseIconAsLink;
    private final TextAttributes myAnchorAttributes;
    private HyperlinkListener myHyperlinkListener;
    private boolean myMouseHover;
    private boolean myMousePressed;

    public HyperlinkLabel() {
        this("");
    }

    public HyperlinkLabel(@NlsContexts.LinkLabel String text) {
        this(text, UIUtil.getLabelBackground());
    }

    public HyperlinkLabel(@NlsContexts.LinkLabel String text, Color background) {
        this(text, PlatformColors.BLUE, background, PlatformColors.BLUE);
    }

    public HyperlinkLabel(@NlsContexts.LinkLabel String text, Color textForegroundColor, Color textBackgroundColor, Color textEffectColor) {
        this.myAnchorAttributes = StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() ? new CustomTextAttributes(textBackgroundColor) : new TextAttributes(textForegroundColor, textBackgroundColor, textEffectColor, EffectType.LINE_UNDERSCORE, 0);
        this.enforceBackgroundOutsideText(textBackgroundColor);
        this.setHyperlinkText(text);
        this.enableEvents(48L);
        this.setOpaque(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.adjustSize();
    }

    public void setFontSize(@Nullable UIUtil.FontSize fontSize) {
        this.myFontSize = fontSize;
    }

    public void setHyperlinkText(@NlsContexts.LinkLabel String text) {
        this.doSetHyperLinkText("", text, "");
    }

    @Deprecated
    public void setHyperlinkText(@NlsContexts.LinkLabel String beforeLinkText, @NlsContexts.LinkLabel String linkText, @NlsContexts.LinkLabel String afterLinkText) {
        this.doSetHyperLinkText(beforeLinkText, linkText, afterLinkText);
    }

    public void setTextWithHyperlink(@NlsContexts.LinkLabel @NotNull String text) {
        int startTagOffset;
        if (text == null) {
            HyperlinkLabel.$$$reportNull$$$0(0);
        }
        if ((startTagOffset = text.indexOf(startTag)) == -1) {
            LOG.error("Text \"" + text + "\" doesn't contain <hyperlink> tag");
            return;
        }
        int finishTagOffset = text.indexOf(finishTag);
        if (finishTagOffset == -1) {
            LOG.error("Text \"" + text + "\" doesn't contain </hyperlink> tag");
            return;
        }
        String beforeLinkText = StringUtil.unescapeXmlEntities((String)text.substring(0, startTagOffset));
        String linkText = StringUtil.unescapeXmlEntities((String)text.substring(startTagOffset + startTag.length(), finishTagOffset));
        String afterLinkText = StringUtil.unescapeXmlEntities((String)text.substring(finishTagOffset + finishTag.length()));
        this.doSetHyperLinkText(beforeLinkText, linkText, afterLinkText);
    }

    private void doSetHyperLinkText(@NlsContexts.LinkLabel @NotNull String beforeLinkText, @NlsContexts.LinkLabel @NotNull String linkText, @NlsContexts.LinkLabel @NotNull String afterLinkText) {
        if (beforeLinkText == null) {
            HyperlinkLabel.$$$reportNull$$$0(1);
        }
        if (linkText == null) {
            HyperlinkLabel.$$$reportNull$$$0(2);
        }
        if (afterLinkText == null) {
            HyperlinkLabel.$$$reportNull$$$0(3);
        }
        this.myUseIconAsLink = beforeLinkText.isEmpty();
        this.prepareText(beforeLinkText, linkText, afterLinkText);
    }

    public void setUseIconAsLink(boolean useIconAsLink) {
        this.myUseIconAsLink = useIconAsLink;
    }

    protected void adjustSize() {
        Dimension preferredSize = this.getPreferredSize();
        this.setMinimumSize(preferredSize);
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent event) {
        if (event.getModifiers() == 0 && event.getKeyCode() == 32) {
            event.consume();
            this.fireHyperlinkEvent(event);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 504 && this.isOnLink(e.getX())) {
            this.myMouseHover = true;
            this.repaint();
        } else if (e.getID() == 505) {
            this.setCursor(null);
            this.myMouseHover = false;
            this.myMousePressed = false;
            this.repaint();
        } else if (UIUtil.isActionClick((MouseEvent)e, (int)501) && this.isOnLink(e.getX())) {
            this.myMousePressed = true;
            this.repaint();
        } else if (e.getID() == 502) {
            if (this.myMousePressed && this.isOnLink(e.getX())) {
                this.fireHyperlinkEvent(e);
            }
            this.myMousePressed = false;
            this.repaint();
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 503) {
            boolean onLink = this.isOnLink(e.getX());
            boolean needRepaint = this.myMouseHover != onLink;
            this.myMouseHover = onLink;
            this.setCursor(this.myMouseHover ? Cursor.getPredefinedCursor(12) : null);
            if (needRepaint) {
                this.repaint();
            }
        }
        super.processMouseMotionEvent(e);
    }

    private boolean isOnLink(int x) {
        int offset;
        if (this.myUseIconAsLink && this.myIcon != null && x >= (offset = this.getIconOffset()) && x < offset + this.myIcon.getIconWidth()) {
            return true;
        }
        HighlightedRegion region = this.findRegionByX(x);
        return region != null && region.textAttributes == this.myAnchorAttributes;
    }

    private void prepareText(@Nls String beforeLinkText, @Nls String linkText, @Nls String afterLinkText) {
        this.applyFont();
        this.myHighlightedText = new HighlightedText();
        this.myHighlightedText.appendText(beforeLinkText, null);
        this.myHighlightedText.appendText(linkText, this.myAnchorAttributes);
        this.myHighlightedText.appendText(afterLinkText, null);
        this.myHighlightedText.applyToComponent(this);
        this.updateOnTextChange();
    }

    @Override
    public void setText(@Nullable @Nls String text) {
        this.applyFont();
        this.myUseIconAsLink = false;
        super.setText(text);
        this.updateOnTextChange();
    }

    public void setHyperlinkTarget(@NonNls @Nullable String url) {
        if (this.myHyperlinkListener != null) {
            this.removeHyperlinkListener(this.myHyperlinkListener);
        }
        if (url != null) {
            this.myHyperlinkListener = e -> BrowserUtil.browse(url);
            this.addHyperlinkListener(this.myHyperlinkListener);
            this.setIcon(AllIcons.Ide.External_link_arrow);
            this.setIconAtRight(true);
        }
    }

    public void addHyperlinkListener(HyperlinkListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeHyperlinkListener(HyperlinkListener listener2) {
        this.myListeners.remove(listener2);
    }

    @Override
    @NlsContexts.LinkLabel
    @NotNull
    public String getText() {
        String string = this.myHighlightedText.getText();
        if (string == null) {
            HyperlinkLabel.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void fireHyperlinkEvent(@Nullable InputEvent inputEvent) {
        HyperlinkEvent e = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, null, null, inputEvent);
        try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
            for (HyperlinkListener listener2 : this.myListeners) {
                listener2.hyperlinkUpdate(e);
            }
        }
    }

    public void doClick() {
        this.fireHyperlinkEvent(null);
    }

    public void setHtmlText(@NlsContexts.LinkLabel String text) {
        ParserDelegator parse = new ParserDelegator();
        final HighlightedText highlightedText = new HighlightedText();
        try {
            ((HTMLEditorKit.Parser)parse).parse(new StringReader(text), new HTMLEditorKit.ParserCallback(){
                private TextAttributes currentAttributes;

                @Override
                public void handleText(char[] data, int pos) {
                    highlightedText.appendText(data, this.currentAttributes);
                }

                @Override
                public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                    if (t == HTML.Tag.B) {
                        this.currentAttributes = BOLD_ATTRIBUTES;
                    } else if (t == HTML.Tag.A) {
                        this.currentAttributes = HyperlinkLabel.this.myAnchorAttributes;
                    }
                }

                @Override
                public void handleEndTag(HTML.Tag t, int pos) {
                    this.currentAttributes = null;
                }
            }, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        highlightedText.applyToComponent(this);
        this.updateOnTextChange();
    }

    private void updateOnTextChange() {
        JComponent parent = (JComponent)this.getParent();
        if (parent != null) {
            parent.revalidate();
            parent.repaint();
        }
        this.adjustSize();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.applyFont();
    }

    private void applyFont() {
        this.setFont(this.myFontSize == null ? StartupUiUtil.getLabelFont() : UIUtil.getLabelFont((UIUtil.FontSize)this.myFontSize));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHyperlinkLabel();
        }
        return this.accessibleContext;
    }

    @Override
    public void removeNotify() {
        this.myMouseHover = false;
        super.removeNotify();
    }

    @Override
    public void setForeground(Color fg) {
        this.myAnchorAttributes.setForegroundColor(fg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeLinkText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterLinkText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/HyperlinkLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/HyperlinkLabel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTextWithHyperlink";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSetHyperLinkText";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private final class CustomTextAttributes
    extends TextAttributes {
        private Color customColor;

        private CustomTextAttributes(Color textBackgroundColor) {
            super(null, textBackgroundColor, null, null, 0);
            this.customColor = null;
        }

        public Color getForegroundColor() {
            if (this.customColor != null) {
                return this.customColor;
            }
            return !HyperlinkLabel.this.isEnabled() ? UIManager.getColor("Label.disabledForeground") : (HyperlinkLabel.this.myMousePressed ? JBUI.CurrentTheme.Link.Foreground.PRESSED : (HyperlinkLabel.this.myMouseHover ? JBUI.CurrentTheme.Link.Foreground.HOVERED : JBUI.CurrentTheme.Link.Foreground.ENABLED));
        }

        public Color getEffectColor() {
            return this.getForegroundColor();
        }

        public EffectType getEffectType() {
            return HyperlinkLabel.this.isEnabled() && (HyperlinkLabel.this.myMouseHover || HyperlinkLabel.this.myMousePressed) ? EffectType.LINE_UNDERSCORE : null;
        }

        public void setForegroundColor(Color color) {
            this.customColor = color;
        }

        public void setEffectColor(Color color) {
            throw new UnsupportedOperationException();
        }

        public void setEffectType(EffectType effectType) {
            throw new UnsupportedOperationException();
        }
    }

    protected class AccessibleHyperlinkLabel
    extends HighlightableComponent.AccessibleHighlightable
    implements AccessibleAction {
        protected AccessibleHyperlinkLabel() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.HYPERLINK;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (i == 0) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i == 0) {
                HyperlinkLabel.this.doClick();
                return true;
            }
            return false;
        }
    }
}

