/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpeedSearchUtil {
    private SpeedSearchUtil() {
    }

    @NotNull
    public static String getDefaultHardSeparators() {
        return "\u001f";
    }

    public static void applySpeedSearchHighlighting(@NotNull JComponent speedSearchEnabledComponent, @NotNull SimpleColoredComponent coloredComponent, boolean mainTextOnly, boolean selected2) {
        SpeedSearchSupply speedSearch;
        if (speedSearchEnabledComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(0);
        }
        if (coloredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(1);
        }
        if ((speedSearch = SpeedSearchSupply.getSupply(speedSearchEnabledComponent)) == null) {
            return;
        }
        SpeedSearchUtil.applySpeedSearchHighlighting(speedSearch, coloredComponent, mainTextOnly, selected2);
    }

    public static void applySpeedSearchHighlighting(@NotNull SpeedSearchSupply speedSearch, @NotNull SimpleColoredComponent coloredComponent, boolean mainTextOnly, boolean selected2) {
        if (speedSearch == null) {
            SpeedSearchUtil.$$$reportNull$$$0(2);
        }
        if (coloredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(3);
        }
        String textFromUi = coloredComponent.getCharSequence(mainTextOnly).toString();
        Iterable<TextRange> ranges = speedSearch.matchingFragments(textFromUi);
        SpeedSearchUtil.applySpeedSearchHighlighting(coloredComponent, ranges, selected2);
    }

    public static void applySpeedSearchHighlighting(@NotNull SimpleColoredComponent coloredComponent, @Nullable Iterable<? extends TextRange> ranges, boolean selected2) {
        Iterator<? extends TextRange> rangesIterator;
        if (coloredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(4);
        }
        Iterator<? extends TextRange> iterator = rangesIterator = ranges != null ? ranges.iterator() : null;
        if (rangesIterator == null || !rangesIterator.hasNext()) {
            return;
        }
        Color bg = UIUtil.getTreeBackground((boolean)selected2, (boolean)true);
        SimpleColoredComponent.ColoredIterator coloredIterator = coloredComponent.iterator();
        TextRange range = rangesIterator.next();
        block0: while (coloredIterator.hasNext()) {
            coloredIterator.next();
            int offset = coloredIterator.getOffset();
            int endOffset = coloredIterator.getEndOffset();
            if (!range.intersectsStrict(offset, endOffset)) continue;
            SimpleTextAttributes attributes = coloredIterator.getTextAttributes();
            SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, attributes.getFgColor(), null, attributes.getStyle() | 0x40);
            do {
                if (range.getStartOffset() > offset) {
                    offset = coloredIterator.split(range.getStartOffset() - offset, attributes);
                }
                if (range.getEndOffset() <= endOffset) {
                    offset = coloredIterator.split(range.getEndOffset() - offset, highlighted);
                    if (!rangesIterator.hasNext()) break block0;
                } else {
                    coloredIterator.split(endOffset - offset, highlighted);
                    continue block0;
                }
                range = rangesIterator.next();
            } while (range.intersectsStrict(offset, endOffset));
        }
    }

    public static void appendFragmentsForSpeedSearch(@NotNull JComponent speedSearchEnabledComponent, @NlsContexts.Label @NotNull String text, @NotNull SimpleTextAttributes attributes, boolean selected2, @NotNull SimpleColoredComponent simpleColoredComponent) {
        Iterable<TextRange> fragments;
        SpeedSearchSupply speedSearch;
        if (speedSearchEnabledComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(5);
        }
        if (text == null) {
            SpeedSearchUtil.$$$reportNull$$$0(6);
        }
        if (attributes == null) {
            SpeedSearchUtil.$$$reportNull$$$0(7);
        }
        if (simpleColoredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(8);
        }
        if ((speedSearch = SpeedSearchSupply.getSupply(speedSearchEnabledComponent)) != null && (fragments = speedSearch.matchingFragments(text)) != null) {
            SpeedSearchUtil.appendSpeedSearchColoredFragments(simpleColoredComponent, text, fragments, attributes, selected2);
            return;
        }
        simpleColoredComponent.append(text, attributes);
    }

    public static void appendColoredFragmentForMatcher(@NlsContexts.Label @NotNull String text, SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, @Nullable Matcher matcher, Color selectedBg, boolean selected2) {
        if (text == null) {
            SpeedSearchUtil.$$$reportNull$$$0(9);
        }
        if (attributes == null) {
            SpeedSearchUtil.$$$reportNull$$$0(10);
        }
        if (!(matcher instanceof MinusculeMatcher) || Registry.is((String)"ide.highlight.match.in.selected.only") && !selected2) {
            component.append(text, attributes);
            return;
        }
        List iterable = ((MinusculeMatcher)matcher).match(text);
        component.setDynamicSearchMatchHighlighting(iterable != null);
        if (iterable != null) {
            Color fg = attributes.getFgColor();
            int style = attributes.getStyle();
            SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(selectedBg, fg, null, style | 0x40);
            SpeedSearchUtil.appendColoredFragments(component, text, iterable, plain, highlighted);
        } else {
            component.append(text, attributes);
        }
    }

    public static void appendSpeedSearchColoredFragments(@NotNull SimpleColoredComponent simpleColoredComponent, @NlsContexts.Label @NotNull String text, @NotNull Iterable<? extends TextRange> colored, @NotNull SimpleTextAttributes attributes, boolean selected2) {
        if (simpleColoredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(11);
        }
        if (text == null) {
            SpeedSearchUtil.$$$reportNull$$$0(12);
        }
        if (colored == null) {
            SpeedSearchUtil.$$$reportNull$$$0(13);
        }
        if (attributes == null) {
            SpeedSearchUtil.$$$reportNull$$$0(14);
        }
        Color fg = attributes.getFgColor();
        Color bg = UIUtil.getTreeBackground((boolean)selected2, (boolean)true);
        int style = attributes.getStyle();
        SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
        SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, fg, null, style | 0x40);
        SpeedSearchUtil.appendColoredFragments(simpleColoredComponent, text, colored, plain, highlighted);
    }

    public static void appendColoredFragments(SimpleColoredComponent simpleColoredComponent, @Nls String text, Iterable<? extends TextRange> colored, SimpleTextAttributes plain, SimpleTextAttributes highlighted) {
        ArrayList<Pair> searchTerms = new ArrayList<Pair>();
        for (TextRange textRange : colored) {
            searchTerms.add(Pair.create((Object)textRange.substring(text), (Object)textRange.getStartOffset()));
        }
        int lastOffset = 0;
        for (Pair pair : searchTerms) {
            if ((Integer)pair.second > lastOffset) {
                simpleColoredComponent.append(text.substring(lastOffset, (Integer)pair.second), plain);
            }
            simpleColoredComponent.append(text.substring((Integer)pair.second, (Integer)pair.second + ((String)pair.first).length()), highlighted);
            lastOffset = (Integer)pair.second + ((String)pair.first).length();
        }
        if (lastOffset < text.length()) {
            simpleColoredComponent.append(text.substring(lastOffset), plain);
        }
    }

    public static void applySpeedSearchHighlightingFiltered(@NotNull JTree tree, @NotNull Object value2, @NotNull SimpleColoredComponent coloredComponent, boolean mainTextOnly, boolean selected2) {
        SpeedSearchSupply speedSearch;
        if (tree == null) {
            SpeedSearchUtil.$$$reportNull$$$0(15);
        }
        if (value2 == null) {
            SpeedSearchUtil.$$$reportNull$$$0(16);
        }
        if (coloredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(17);
        }
        if ((speedSearch = SpeedSearchSupply.getSupply(tree)) != null && !speedSearch.isObjectFilteredOut(value2)) {
            SpeedSearchUtil.applySpeedSearchHighlighting(tree, coloredComponent, mainTextOnly, selected2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "speedSearchEnabledComponent";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "speedSearch";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleColoredComponent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colored";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/speedSearch/SpeedSearchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applySpeedSearchHighlighting";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "appendFragmentsForSpeedSearch";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "appendColoredFragmentForMatcher";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpeedSearchColoredFragments";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "applySpeedSearchHighlightingFiltered";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

