// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.util.net

import com.intellij.credentialStore.Credentials
import org.jetbrains.annotations.Nls
import java.net.Authenticator
import java.net.ProxySelector

internal object PlatformJdkProxyProvider {
  val proxySelector: ProxySelector = IdeProxySelector {
    ProxySettings.getInstance().getProxyConfiguration()
  }

  val authenticator: Authenticator = IdeProxyAuthenticator(object : ProxyAuthentication {
    private val proxyAuthentication: ProxyAuthentication
      get() = ProxyAuthentication.getInstance()

    override fun getKnownAuthentication(host: String, port: Int): Credentials? =
      proxyAuthentication.getKnownAuthentication(host, port)

    override fun getPromptedAuthentication(prompt: @Nls String, host: String, port: Int): Credentials? =
      proxyAuthentication.getPromptedAuthentication(prompt, host, port)

    override fun isPromptedAuthenticationCancelled(host: String, port: Int): Boolean =
      proxyAuthentication.isPromptedAuthenticationCancelled(host, port)

    override fun enablePromptedAuthentication(host: String, port: Int) =
      proxyAuthentication.enablePromptedAuthentication(host, port)
  })
}
